/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.commons.springextensions.jcr;

import com.sas.svcs.content.commons.springextensions.jcr.SessionFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.rmi.client.ClientAdapterFactory;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.repository.URLRemoteRepositoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JcrSessionFactory
implements InitializingBean,
DisposableBean,
SessionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JcrSessionFactory.class);
    private Repository repository;
    private String rmiUrl;
    private String workspaceName;
    private Credentials credentials;
    private Properties namespaces;
    private Map<String, String> overwrittenNamespaces;
    private boolean forceNamespacesRegistration = false;
    private boolean keepNewNamespaces = true;
    private boolean skipExistingNamespaces = true;

    public JcrSessionFactory(Repository repository, String workspaceName, Credentials credentials) {
        this.repository = repository;
        this.workspaceName = workspaceName;
        this.credentials = credentials;
    }

    public JcrSessionFactory() {
    }

    public void afterPropertiesSet() throws Exception {
        this.registerNodeTypes();
    }

    protected void registerNodeTypes() throws Exception {
    }

    protected void unregisterNodeTypes() throws Exception {
    }

    protected void registerNamespaces() throws Exception {
        if (this.namespaces == null || this.namespaces.isEmpty()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("registering custom namespaces " + this.namespaces);
        }
        Session session = this.getBareSession();
        NamespaceRegistry registry = session.getWorkspace().getNamespaceRegistry();
        Object[] prefixes = registry.getPrefixes();
        Arrays.sort(prefixes);
        if (this.forceNamespacesRegistration) {
            if (!this.keepNewNamespaces) {
                this.overwrittenNamespaces = new HashMap<String, String>(this.namespaces.size());
            }
            for (Object key : this.namespaces.keySet()) {
                String prefix = (String)key;
                int position = Arrays.binarySearch(prefixes, prefix);
                if (position < 0) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("prefix " + prefix + " was already registered; unregistering it");
                }
                if (!this.keepNewNamespaces) {
                    this.overwrittenNamespaces.put(prefix, registry.getURI(prefix));
                }
                registry.unregisterNamespace(prefix);
            }
        }
        Iterator<Object> iterator = this.namespaces.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry namespace = entry = (Map.Entry)iterator.next();
            String prefix = (String)namespace.getKey();
            String ns = (String)namespace.getValue();
            int position = Arrays.binarySearch(prefixes, prefix);
            if (this.skipExistingNamespaces && position >= 0) {
                LOG.debug("namespace already registered under [" + prefix + "]; skipping registration");
                continue;
            }
            LOG.debug("registering namespace [" + ns + "] under [" + prefix + "]");
            registry.registerNamespace(prefix, ns);
        }
        session.logout();
    }

    public void destroy() throws Exception {
        this.unregisterNodeTypes();
    }

    protected void unregisterNamespaces() throws Exception {
        if (this.namespaces == null || this.namespaces.isEmpty() || this.keepNewNamespaces) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("unregistering custom namespaces " + this.namespaces);
        }
        NamespaceRegistry registry = this.getSession().getWorkspace().getNamespaceRegistry();
        for (Object key : this.namespaces.keySet()) {
            String prefix = (String)key;
            registry.unregisterNamespace(prefix);
        }
        if (this.forceNamespacesRegistration) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("reverting back overwritten namespaces " + this.overwrittenNamespaces);
            }
            if (this.overwrittenNamespaces != null) {
                Iterator<Object> iterator = this.overwrittenNamespaces.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry namespace = entry = (Map.Entry)iterator.next();
                    registry.registerNamespace((String)namespace.getKey(), (String)namespace.getValue());
                }
            }
        }
    }

    protected Session getBareSession() throws RepositoryException {
        Session session = this.getRepository().login(this.credentials, this.workspaceName);
        session.refresh(false);
        return session;
    }

    @Override
    public Session getSession() throws RepositoryException {
        Session session = this.getRepository().login(this.credentials, this.workspaceName);
        session.refresh(false);
        return session;
    }

    public Repository getRepository() {
        if (this.repository == null) {
            try {
                this.repository = new URLRemoteRepositoryFactory((LocalAdapterFactory)new ClientAdapterFactory(), new URL(this.rmiUrl)).getRepository();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            catch (ClassCastException e) {
                throw new RuntimeException(e);
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JcrSessionFactory) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        if (this.repository != null) {
            result = 37 * result + this.repository.hashCode();
        }
        if (this.credentials != null) {
            result = 37 * result + this.credentials.hashCode();
        }
        if (this.workspaceName != null) {
            result = 37 * result + this.workspaceName.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SessionFactory for ");
        buffer.append(this.getRepositoryInfo());
        buffer.append("|workspace=");
        buffer.append(this.workspaceName);
        return buffer.toString();
    }

    private String getRepositoryInfo() {
        if (this.getRepository() == null) {
            return "<N/A>";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getRepository().getDescriptor("jcr.repository.name"));
        buffer.append(" ");
        buffer.append(this.getRepository().getDescriptor("jcr.repository.version"));
        return buffer.toString();
    }

    public Properties getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Properties namespaces) {
        this.namespaces = namespaces;
    }

    public void setKeepNewNamespaces(boolean keepNamespaces) {
        this.keepNewNamespaces = keepNamespaces;
    }

    public void setForceNamespacesRegistration(boolean forceNamespacesRegistration) {
        this.forceNamespacesRegistration = forceNamespacesRegistration;
    }

    public void setSkipExistingNamespaces(boolean skipRegisteredNamespace) {
        this.skipExistingNamespaces = skipRegisteredNamespace;
    }

    public boolean isForceNamespacesRegistration() {
        return this.forceNamespacesRegistration;
    }

    public boolean isKeepNewNamespaces() {
        return this.keepNewNamespaces;
    }

    public boolean isSkipExistingNamespaces() {
        return this.skipExistingNamespaces;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getRmiUrl() {
        return this.rmiUrl;
    }

    public void setRmiUrl(String rmiUrl) {
        this.rmiUrl = rmiUrl;
    }
}

