/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.jcr;

import com.sas.svcs.common.client.dao.ContentNodeDAO;
import com.sas.svcs.common.client.dao.jcr.BaseContentJCRDAO;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.framework.client.ValidationException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;

public abstract class JcrContentNodeDAO<T extends ContentNode>
extends BaseContentJCRDAO<T>
implements ContentNodeDAO<T> {
    private boolean versionOnCreate = false;

    public JcrContentNodeDAO(Class<T> contentClazz, long objectType, String objectTypeName, String jcrTypeName) {
        super(contentClazz, objectType, objectTypeName, jcrTypeName);
    }

    public JcrContentNodeDAO(Class<T> contentClazz, long objectType, String objectTypeName, String jcrTypeName, boolean versionOnCreate) {
        super(contentClazz, objectType, objectTypeName, jcrTypeName);
        this.versionOnCreate = versionOnCreate;
    }

    public T create(ObjectIdentity parent, T object) throws ObjectNotFoundException, ObjectExistsException, ValidationException {
        object.setObjectType(this.getObjectType());
        return (T)((ContentNode)this.getSASJcrTemplate().create(parent, object, object.getName(), this.getJcrTypeName(), this.versionOnCreate, this.getCreateMapper()));
    }

    public T findByPath(String path) {
        return (T)((ContentNode)this.getSASJcrTemplate().findByPath(path, this.getObjectType(), this.getMapper()));
    }

    public T findByPath(String path, String versionName) {
        return (T)((ContentNode)this.getSASJcrTemplate().findVersionByPath(path, this.getObjectType(), versionName, this.getMapper()));
    }

    @Override
    protected void populateContentObjectFromJCRVersion(T contentNode, Node node, Version version) throws RepositoryException {
        this.getJcrContentUtils().populateContentNodeFromJCRVersion((ContentNode)contentNode, node, version, this.getObjectType(), this.getObjectTypeName());
        this.mapJcrVersionToContentObject(version, contentNode);
    }

    @Override
    protected void populateContentObjectFromJCRNode(T contentNode, Node node) throws RepositoryException {
        this.getJcrContentUtils().populateContentNodeFromJCRNode((ContentNode)contentNode, node, this.getObjectType(), this.getObjectTypeName());
        this.mapJcrNodeToContentObject(node, contentNode);
    }
}

