/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.jcr;

import com.sas.commons.expr.Expression;
import com.sas.commons.restsupport.query.QueryOptions;
import com.sas.commons.restsupport.query.QueryResult;
import com.sas.svcs.common.client.ContentComparator;
import com.sas.svcs.common.client.FieldMapper;
import com.sas.svcs.common.client.dao.BaseContentDAO;
import com.sas.svcs.common.client.dao.jcr.BaseJCRDAO;
import com.sas.svcs.common.client.dao.jcr.JcrContentUtils;
import com.sas.svcs.common.client.dao.jcr.JcrExpressionParser;
import com.sas.svcs.common.client.dao.jcr.MutableJcrNodeMapper;
import com.sas.svcs.common.client.dao.jcr.SASJcrTemplate;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.commons.springextensions.jcr.JcrCallback;
import com.sas.svcs.content.commons.springextensions.jcr.JcrTemplate;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.framework.client.ObjectModifiedException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.framework.client.ValidationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import org.apache.jackrabbit.util.SpecialNameChars;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseContentJCRDAO<T extends ContentObject>
extends BaseJCRDAO
implements BaseContentDAO<T> {
    private static final Logger log = LogManager.getLogger(BaseContentJCRDAO.class);
    private Class<T> contentClazz;
    private long objectType;
    private String objectTypeName;
    private String jcrTypeName;
    private SASJcrTemplate sasJcrTemplate;
    private Mapper mapper = new Mapper();
    private CreateMapper createMapper = new CreateMapper();

    public BaseContentJCRDAO(Class<T> contentClazz, long objectType, String objectTypeName, String jcrTypeName) {
        this.contentClazz = contentClazz;
        this.objectType = objectType;
        this.objectTypeName = objectTypeName;
        this.jcrTypeName = jcrTypeName;
    }

    public void setSASJcrTemplate(SASJcrTemplate sasJcrTemplate) {
        this.sasJcrTemplate = sasJcrTemplate;
    }

    @Override
    @Autowired
    public void setTemplate(JcrTemplate template) {
        super.setTemplate(template);
        this.sasJcrTemplate = new SASJcrTemplate();
        this.sasJcrTemplate.setJcrTemplate(template);
    }

    protected Class<T> getContentClazz() {
        return this.contentClazz;
    }

    protected long getObjectType() {
        return this.objectType;
    }

    protected String getObjectTypeName() {
        return this.objectTypeName;
    }

    protected String getJcrTypeName() {
        return this.jcrTypeName;
    }

    protected SASJcrTemplate getSASJcrTemplate() {
        return this.sasJcrTemplate;
    }

    protected Mapper getMapper() {
        return this.mapper;
    }

    protected CreateMapper getCreateMapper() {
        return this.createMapper;
    }

    protected void setJcrTypeName(String jcrTypeName) {
        this.jcrTypeName = jcrTypeName;
    }

    protected T getNewContentObject() {
        try {
            return (T)((ContentObject)this.contentClazz.newInstance());
        }
        catch (Exception e) {
            log.error("Exception instantiating content object class: " + this.contentClazz.getName(), (Throwable)e);
            throw new RuntimeException("Exception instantiating content object class: " + this.contentClazz.getName() + " - " + e.getMessage());
        }
    }

    protected static boolean isContentServer(Session session) {
        try {
            NodeType nt = session.getWorkspace().getNodeTypeManager().getNodeType("nt:davcollection");
            log.debug("Node type: " + nt.getName());
        }
        catch (NoSuchNodeTypeException e) {
            return false;
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void initNewNode(Node jcrNode, Calendar cal, long objectType) throws RepositoryException {
        this.getJcrContentUtils().initNewNode(jcrNode, cal, objectType);
    }

    protected void populateJCRNodeFromContentObject(Node node, T contentObject) throws RepositoryException {
        this.getJcrContentUtils().populateJCRNodeFromContentObject(node, (ContentObject)contentObject);
        this.mapContentObjectToJcrNode(contentObject, node);
    }

    protected void populateContentObjectFromJCRVersion(T contentObject, Node node, Version version) throws RepositoryException {
        this.getJcrContentUtils().populateContentObjectFromJCRVersion((ContentObject)contentObject, node, version, this.objectType, this.objectTypeName);
        this.mapJcrVersionToContentObject(version, contentObject);
    }

    protected void populateContentObjectFromJCRNode(T contentObject, Node node) throws RepositoryException {
        this.getJcrContentUtils().populateContentObjectFromJCRNode((ContentObject)contentObject, node, this.objectType, this.objectTypeName);
        this.mapJcrNodeToContentObject(node, contentObject);
    }

    public T findById(String id) {
        return (T)((ContentObject)this.sasJcrTemplate.findById(new ObjectIdentity(this.objectType, id), this.mapper));
    }

    public T findDescriptorById(String id) {
        throw new RuntimeException("NOT YET IMPLEMENTED: BaseContentDAO<T>.findDescriptorById");
    }

    public List<T> findAll() {
        throw new RuntimeException("NOT YET IMPLEMENTED: BaseContentDAO<T>.findAll");
    }

    public boolean delete(T object) throws ObjectNotFoundException {
        return this.deleteById(object.getId());
    }

    public boolean deleteById(String id) throws ObjectNotFoundException {
        return this.sasJcrTemplate.deleteById(new ObjectIdentity(this.objectType, id));
    }

    public T update(T object) throws ObjectNotFoundException, ObjectModifiedException {
        return (T)((ContentObject)this.sasJcrTemplate.update(object, object.getInternalVersion(), this.mapper));
    }

    public List<FieldMapper> getFieldMappers() {
        ArrayList<FieldMapper> mappers = new ArrayList<FieldMapper>();
        return mappers;
    }

    protected Comparator<T> getComparator(QueryOptions request, Class<T> type) {
        ContentComparator result = new ContentComparator(request.getSortKeys(), type);
        result.addFieldMappings(this.getFieldMappers());
        return result;
    }

    public QueryResult<T> findFiltered(QueryOptions request) {
        QueryResult result = null;
        Expression expression = request.getFilter();
        List sortKeys = request.getSortKeys();
        long start = request.getStart();
        int limit = request.getLimit();
        String filterString = null;
        if (expression != null) {
            JcrExpressionParser parser = new JcrExpressionParser();
            parser.addFieldMappings(this.getFieldMappers());
            filterString = parser.parseExpression(expression);
        } else {
            filterString = "/jcr:root/element()[@sas:ObjectType='" + this.objectTypeName + "']";
        }
        final String searchString = filterString;
        try {
            List candidates = (List)this.getTemplate().execute(new JcrCallback<List<T>>(){

                @Override
                public List<T> doInJcr(Session session) throws RepositoryException {
                    String lang = "JCR-SQL2";
                    ArrayList result = new ArrayList();
                    QueryManager manager = session.getWorkspace().getQueryManager();
                    Query query = manager.createQuery(searchString, lang);
                    javax.jcr.query.QueryResult qresult = query.execute();
                    try {
                        NodeIterator nit = qresult.getNodes();
                        while (nit.hasNext()) {
                            Node node = nit.nextNode();
                            result.add(BaseContentJCRDAO.this.mapper.mapFromJcrNode(node));
                        }
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex.getMessage(), ex);
                    }
                    return result;
                }
            });
            int candidateSize = candidates.size();
            if (candidateSize > 1 && sortKeys != null && sortKeys.size() > 0) {
                ContentObject sample = (ContentObject)candidates.get(0);
                Comparator<?> comparator = this.getComparator(request, sample.getClass());
                Collections.sort(candidates, comparator);
            }
            ArrayList<ContentObject> pagedList = new ArrayList<ContentObject>();
            if (limit == 0) {
                limit = candidateSize;
            }
            long end = start + (long)limit - 1L > (long)candidateSize ? (long)candidateSize : start + (long)limit - 1L;
            for (long i = start; i < end; ++i) {
                pagedList.add((ContentObject)candidates.get((int)i));
            }
            result = new QueryResult(request, pagedList, candidateSize);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public T findById(String id, String versionName) {
        return (T)((ContentObject)this.sasJcrTemplate.findVersionById(new ObjectIdentity(this.objectType, id), versionName, this.mapper));
    }

    public T rename(T contentObject, String newName) throws ObjectNotFoundException, ValidationException {
        try {
            return (T)((ContentObject)this.sasJcrTemplate.rename(contentObject, contentObject.getInternalVersion(), newName, this.mapper));
        }
        catch (ObjectModifiedException e) {
            throw new RuntimeException(e);
        }
    }

    protected T createNewObject(T object, Node parentNode) throws RepositoryException {
        Node jcrNode = parentNode.addNode(SpecialNameChars.encode((String)object.getName()), this.getJcrTypeName());
        this.initNewNode(jcrNode, Calendar.getInstance(), this.getObjectType());
        T newNode = this.getNewContentObject();
        object.setId(jcrNode.getUUID());
        object.setObjectType(this.getObjectType());
        this.populateJCRNodeFromContentObject(jcrNode, object);
        this.populateContentObjectFromJCRNode(newNode, jcrNode);
        return newNode;
    }

    protected T getVersion(Node node, String versionName) throws RepositoryException, UnsupportedRepositoryOperationException {
        try {
            return (T)((ContentObject)this.sasJcrTemplate.getVersion(node, versionName, this.mapper));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void mapJcrVersionToContentObject(Version version, T contentObject) throws RepositoryException {
        Node frozenNode = version.getNode("jcr:frozenNode");
        this.mapJcrNodeToContentObject(frozenNode, contentObject);
    }

    protected Node getNodeByUUID(String nodeId, Session session) throws RepositoryException {
        return this.getJcrContentUtils().getNodeByObjectIdentity(new ObjectIdentity(this.objectType, nodeId), session);
    }

    protected Node getNodeForUpdateByUUID(String nodeId, long incomingInternalVersion, Session session) throws RepositoryException, InternalModifiedException {
        try {
            return this.getJcrContentUtils().getNodeForUpdateByObjectIdentity(new ObjectIdentity(this.objectType, nodeId), incomingInternalVersion, session);
        }
        catch (JcrContentUtils.InternalModifiedException e) {
            throw new InternalModifiedException();
        }
    }

    protected abstract void mapJcrNodeToContentObject(Node var1, T var2) throws RepositoryException;

    protected abstract void mapContentObjectToJcrNode(T var1, Node var2) throws RepositoryException;

    protected class Mapper
    implements MutableJcrNodeMapper<T> {
        protected Mapper() {
        }

        @Override
        public T mapFromJcrNode(Node node) throws RepositoryException {
            Object ret = BaseContentJCRDAO.this.getNewContentObject();
            BaseContentJCRDAO.this.populateContentObjectFromJCRNode(ret, node);
            return ret;
        }

        @Override
        public void mapToJcrNode(T obj, Node node) throws RepositoryException {
            BaseContentJCRDAO.this.populateJCRNodeFromContentObject(node, obj);
        }

        @Override
        public T mapFromJcrVersion(Node node, Version version) throws RepositoryException {
            Object ret = BaseContentJCRDAO.this.getNewContentObject();
            BaseContentJCRDAO.this.populateContentObjectFromJCRVersion(ret, node, version);
            return ret;
        }
    }

    protected class CreateMapper
    extends Mapper
    implements MutableJcrNodeMapper<T> {
        protected CreateMapper() {
        }

        @Override
        public void mapToJcrNode(T obj, Node node) throws RepositoryException {
            BaseContentJCRDAO.this.initNewNode(node, Calendar.getInstance(), BaseContentJCRDAO.this.getObjectType());
            super.mapToJcrNode(obj, node);
        }
    }

    public static class InternalModifiedException
    extends RuntimeException {
    }
}

