/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DeployedJobInterface;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileInfo;
import com.sas.scheduler.model.JobDeployerInterface;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SASFolder;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerResultSet;
import com.sas.scheduler.visuals.swing.DeployedJobDialog;
import com.sas.scheduler.visuals.swing.MessageUtil;
import java.awt.Cursor;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class RedeployedJobDialog
extends DeployedJobDialog
implements DeployedJobInterface {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private List<JobInfo> m_deployedJobObjects = new Vector<JobInfo>();

    public RedeployedJobDialog(Frame owner, JobInfo djob, String name, JobDeployerInterface callback, PromptCallbackInterface prompt, List<BatchServerInfo> batchservers) throws SchedulerException {
        this(owner, name, djob, callback, prompt, m_bundle.getString("RedeployedJobDialog.Title.txt"), batchservers, true, null, null);
    }

    public RedeployedJobDialog(Frame owner, List<?> djobs, JobDeployerInterface callback, PromptCallbackInterface prompt, List<BatchServerInfo> batchservers, SASFolder folder) throws SchedulerException {
        this(owner, djobs, callback, prompt, m_bundle.getString("RedeployedJobDialog.Title.txt"), batchservers, folder, null);
    }

    public RedeployedJobDialog(Frame owner, List<?> djobs, JobDeployerInterface callback, PromptCallbackInterface prompt, String title, List<BatchServerInfo> batchservers, SASFolder folder, String fileContent) throws SchedulerException {
        this(owner, null, djobs, callback, prompt, title, batchservers, true, folder, fileContent);
    }

    protected RedeployedJobDialog(Frame owner, String name, Object djobs, JobDeployerInterface callback, PromptCallbackInterface prompt, String title, List<BatchServerInfo> batchservers, boolean preservation, SASFolder folder, String fileContent) throws SchedulerException {
        super(owner, RedeployedJobDialog.determineJobName(name, djobs), title, batchservers, callback, prompt, preservation, true, folder, fileContent);
        this.m_multiselect = false;
        if (djobs instanceof JobInfo) {
            ArrayList<JobInfo> list = new ArrayList<JobInfo>();
            list.add((JobInfo)djobs);
            this.initialize(list);
        } else if (((List)djobs).size() > 0) {
            this.initialize((List)djobs);
        } else {
            throw new InvalidParameterException();
        }
        this.setHelpProduct("scheduler");
        this.setHelpTopic("window_deploy_ds_program");
    }

    private static String determineJobName(String nameStr, Object jobs) {
        if (nameStr != null) {
            return nameStr;
        }
        if (jobs instanceof JobInfo) {
            return ((JobInfo)jobs).getName();
        }
        StringBuffer name = new StringBuffer();
        List joblist = (List)jobs;
        int numJobs = joblist.size();
        if (numJobs <= 0) {
            return null;
        }
        name.append(((JobInfo)joblist.get(0)).getName());
        for (int i = 1; i < numJobs; ++i) {
            name.append(";");
            name.append(((JobInfo)joblist.get(i)).getName());
        }
        return name.toString();
    }

    private void initialize(List<JobInfo> jinfos) throws SchedulerException {
        String names = null;
        String jobs = null;
        BatchServerInfo bsinfo = null;
        String folderName = null;
        PropertyChangeListener filenameListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (RedeployedJobDialog.this.m_jobpanel.isJobNameVisible()) {
                    String filename = RedeployedJobDialog.this.m_jobpanel.getFilename();
                    String[] files = filename.split(";");
                    String names = null;
                    for (int y = 0; y < files.length; ++y) {
                        filename = files[y];
                        if (filename.length() > 0) {
                            try {
                                String name = null;
                                int index = filename.lastIndexOf("\\");
                                if (index == -1) {
                                    index = filename.lastIndexOf("/");
                                }
                                if ((index = (name = index >= 0 ? filename.substring(index + 1) : filename).lastIndexOf(46)) > 0) {
                                    name = name.substring(0, index);
                                }
                                if (names != null) {
                                    String[] currentList = names.split(";");
                                    name = RedeployedJobDialog.this.m_callback.uniqueName(RedeployedJobDialog.this.m_callback.makeValidFileName(name), currentList);
                                }
                                names = names == null ? name : names + ";" + name;
                            }
                            catch (RuntimeException ex) {
                                RedeployedJobDialog.this.m_jobpanel.setJobName("");
                            }
                        }
                        RedeployedJobDialog.this.m_jobpanel.setJobName(names);
                    }
                }
            }
        };
        this.m_jobpanel.resetFilenameListener(filenameListener);
        for (int i = 0; i < jinfos.size(); ++i) {
            JobInfo jinfo = jinfos.get(i);
            this.m_deployedJobObjects.add(jinfo);
            if (i == 0) {
                folderName = jinfo.getLocation();
                bsinfo = jinfo.getBatchServer();
                this.m_dir = jinfo.getSourceDir();
            }
            String jobname = jinfo.getName();
            DisplayInfo job = jinfo.getJob();
            if (job != null) {
                jobname = job.getName();
                FileInfo file = this.m_callback.getSourceCodes(job);
                if (file != null) {
                    if (file.getName() != null && file.getPath() != null) {
                        this.m_fullname = this.m_callback.createFullPath(file, jinfo.getBatchServer());
                    } else if (file.getDescription() != null) {
                        if (jinfos.size() == 1) {
                            this.m_fullname = null;
                            this.m_fileContent = file.getDescription();
                        } else {
                            this.m_fullname = MessageUtil.messageString(m_bundle.getString("RedeployedJobDialog.MissingSourceFile.fmt"), jobname);
                        }
                    }
                } else {
                    this.m_fullname = MessageUtil.messageString(m_bundle.getString("RedeployedJobDialog.MissingSourceFile.fmt"), jobname);
                }
            } else {
                this.m_fullname = MessageUtil.messageString(m_bundle.getString("RedeployedJobDialog.MissingSourceFile.fmt"), jobname);
            }
            names = names == null ? this.m_fullname : names + ";" + this.m_fullname;
            jobs = jobs == null ? jinfo.getName() : jobs + ";" + jinfo.getName();
        }
        if (!this.m_preserve) {
            this.m_jobpanel.setSelectedServer(bsinfo);
        }
        if (this.m_dir != null) {
            this.m_jobpanel.setSelectedDirectory(this.m_dir);
        }
        if (names != null) {
            this.m_jobpanel.setFilename(names);
        }
        if (jobs != null) {
            this.m_jobpanel.setJobName(jobs);
        }
        if (!this.m_preserve) {
            this.m_folder = this.m_callback.getFolder(folderName);
            if (this.m_folder != null) {
                this.m_jobpanel.setFolder(this.m_folder.getLocation());
            } else {
                this.m_jobpanel.setFolder(folderName);
            }
        }
    }

    @Override
    public List<JobInfo> getDeployedJobs() {
        return this.m_deployedJobObjects;
    }

    @Override
    protected boolean onOK() throws SchedulerException {
        this.m_eReturnValue = 64;
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.m_results = this.m_callback.redeploy((DeployedJobInterface)this);
            this.setCursor(Cursor.getDefaultCursor());
            if (this.m_results.getReturnValue() == 0) {
                return false;
            }
            this.m_eReturnValue = 1;
            return true;
        }
        catch (RuntimeException e) {
            this.m_results = new SchedulerResultSet(0, e.toString());
            this.setCursor(Cursor.getDefaultCursor());
            return false;
        }
    }

    static {
        String strClassName = RedeployedJobDialog.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

