/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.visuals.swing.JobSelectionPanel;
import com.sas.scheduler.visuals.swing.MaxDimension;
import com.sas.scheduler.visuals.swing.SchedulerServerPanel;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class NewFlowPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private JTextField m_txtName;
    private SchedulerServerPanel m_pnlSchedulerServerPanel;
    private JTextField m_txtFolder;
    private JButton m_btnSelectFolder;
    private JobSelectionPanel m_pnljobSelection;
    private Frame m_frame;
    private JButton m_btnProperties;

    public NewFlowPanel(Frame frame, List<JobInfo> joblist, List<SchedulerServerInfo> schedulerlist) {
        this.m_frame = frame;
        this.__initialize(new ArrayList<JobInfo>(joblist), new ArrayList<SchedulerServerInfo>(schedulerlist));
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_frame = null;
        this.m_btnSelectFolder = null;
        this.m_btnProperties = null;
    }

    public void __initialize(List<DisplayInfo> jobList, List<SchedulerServerInfo> schedulerList) {
        this.m_txtName = new JTextField();
        this.m_txtName.setToolTipText(m_bundle.getString("NewFlowPanel.Name.ToolTip.txt"));
        String nameText = m_bundle.getString("NewFlowPanel.Name.txt");
        JLabel lblName = new JLabel(Util.getLabelWithoutMnemonic((String)nameText));
        lblName.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)nameText));
        lblName.setLabelFor(this.m_txtName);
        this.m_pnlSchedulerServerPanel = new SchedulerServerPanel(schedulerList, null);
        this.m_txtFolder = new JTextField();
        this.m_txtFolder.setEditable(false);
        this.m_txtName.setToolTipText(m_bundle.getString("NewFlowPanel.Name.ToolTip.txt"));
        String folderText = m_bundle.getString("NewFlowPanel.FolderLabel.txt");
        JLabel folderlabel = new JLabel(Util.getLabelWithoutMnemonic((String)folderText));
        folderlabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)folderText));
        folderlabel.setLabelFor(this.m_txtFolder);
        String selectText = m_bundle.getString("NewFlowPanel.Select.txt");
        this.m_btnSelectFolder = new JButton(Util.getLabelWithoutMnemonic((String)selectText));
        this.m_btnSelectFolder.setMnemonic(Util.getDisplayedMnemonic((String)selectText));
        this.m_btnSelectFolder.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)selectText));
        this.m_btnSelectFolder.setToolTipText(m_bundle.getString("NewFlowPanel.Select.ToolTip.txt"));
        JLabel lblSeperator1 = new JLabel();
        lblSeperator1.setBorder(new EtchedBorder());
        this.m_pnljobSelection = new JobSelectionPanel(this.m_frame, jobList);
        JLabel lblSeperator2 = new JLabel();
        lblSeperator2.setBorder(new EtchedBorder());
        String propertiesText = m_bundle.getString("NewFlowPanel.JobProperties.txt");
        this.m_btnProperties = new JButton(Util.getLabelWithoutMnemonic((String)propertiesText));
        this.m_btnProperties.setMnemonic(Util.getDisplayedMnemonic((String)propertiesText));
        this.m_btnProperties.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)propertiesText));
        this.m_btnProperties.setToolTipText(m_bundle.getString("NewFlowPanel.JobProperties.ToolTip.txt"));
        JLabel lblSeperator3 = new JLabel();
        lblSeperator3.setBorder(new EtchedBorder());
        MaxDimension dim = new MaxDimension(0, 0);
        dim.max(this.m_btnSelectFolder.getPreferredSize());
        dim.max(this.m_pnlSchedulerServerPanel.getServerButtonDim());
        this.m_btnSelectFolder.setPreferredSize(dim);
        this.m_pnlSchedulerServerPanel.setServerButtonDim(dim);
        dim = new MaxDimension(0, 0);
        dim.max(this.m_txtName.getPreferredSize());
        dim.max(this.m_txtFolder.getPreferredSize());
        dim.max(this.m_pnlSchedulerServerPanel.getServerFieldDim());
        this.m_txtName.setPreferredSize(dim);
        this.m_txtFolder.setPreferredSize(dim);
        this.m_pnlSchedulerServerPanel.setServerFieldDim(dim);
        this.setLayout(new GridBagLayout());
        this.add((Component)lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_txtName, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)folderlabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_txtFolder, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_btnSelectFolder, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_pnlSchedulerServerPanel, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)lblSeperator2, new GridBagConstraints(0, 4, 4, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, -2));
        this.add((Component)this.m_pnljobSelection, new GridBagConstraints(0, 5, 4, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.m_btnProperties, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.add((Component)lblSeperator3, new GridBagConstraints(0, 7, 4, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, -2));
    }

    public String getFlowName() {
        return this.m_txtName.getText();
    }

    public SchedulerServerInfo getServer() {
        return this.m_pnlSchedulerServerPanel.getSelectedServer();
    }

    public boolean setServer(String id) {
        if (id == null) {
            return false;
        }
        for (SchedulerServerInfo ssi : this.m_pnlSchedulerServerPanel.getSchedulerServerList()) {
            String temp = ssi != null ? ssi.getId() : null;
            if (temp == null || temp.compareTo(id) != 0) continue;
            this.m_pnlSchedulerServerPanel.setSelectedServer(ssi);
            return true;
        }
        return false;
    }

    public boolean addServer(SchedulerServerInfo sinfo) {
        return this.m_pnlSchedulerServerPanel.addServer(sinfo);
    }

    public void addNewServerButtonListener(ActionListener acl) {
        this.m_pnlSchedulerServerPanel.addNewButtonListener(acl);
    }

    public void removeNewServerButtonListener(ActionListener acl) {
        this.m_pnlSchedulerServerPanel.removeNewButtonListener(acl);
    }

    public String getFolder() {
        return this.m_txtFolder.getText();
    }

    public boolean setFolder(String name) {
        if (name == null) {
            this.m_txtFolder.setText(name);
            return true;
        }
        int lastslash = name.lastIndexOf("/");
        if (lastslash > -1) {
            this.m_txtFolder.setText(name.substring(lastslash + 1));
        } else {
            this.m_txtFolder.setText(name);
        }
        this.m_txtFolder.setToolTipText(name);
        this.m_txtFolder.firePropertyChange("setText", false, true);
        return true;
    }

    public void addSelectFolderButtonListener(ActionListener acl) {
        this.m_btnSelectFolder.addActionListener(acl);
    }

    public void removeSelectFolderButtonListener(ActionListener acl) {
        this.m_btnSelectFolder.removeActionListener(acl);
    }

    public void addJobPropertyButtonListener(ActionListener acl) {
        this.m_btnProperties.addActionListener(acl);
    }

    public void removeJobPropertyButtonListener(ActionListener acl) {
        this.m_btnProperties.removeActionListener(acl);
    }

    public DisplayInfo getSelectedJob() {
        return this.m_pnljobSelection.getSelectedJob();
    }

    public TreeSet<DisplayInfo> getJobs() {
        return this.m_pnljobSelection.getSelectedJobList();
    }

    @Override
    public boolean validateData() {
        if (this.m_pnlSchedulerServerPanel.validateData()) {
            return this.m_pnljobSelection.validateData();
        }
        return false;
    }

    @Override
    public boolean moveDataToView() {
        if (this.m_pnlSchedulerServerPanel.moveDataToView()) {
            return this.m_pnljobSelection.moveDataToView();
        }
        return false;
    }

    @Override
    public boolean moveViewToData() {
        if (this.m_pnlSchedulerServerPanel.moveViewToData()) {
            return this.m_pnljobSelection.moveViewToData();
        }
        return false;
    }

    static {
        String strClassName = NewFlowPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

