/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.CompareDisplayInfoObjects;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;

public class JobSelectionPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private JLabel m_lblDescription;
    private ListSelector m_dualJobList;
    private TreeSet<DisplayInfo> m_sourceJobList = null;
    private ArrayList<DisplayInfo> m_joblist = null;
    private TreeSet<DisplayInfo> m_targetJobList = new TreeSet(new CompareDisplayInfoObjects());
    private CollectionToListModelAdapter m_sourceModel = new CollectionToListModelAdapter();
    private CollectionToListModelAdapter m_targetModel = new CollectionToListModelAdapter();
    private Frame m_frame;

    public JobSelectionPanel(Frame frame, String header, List<DisplayInfo> joblist) {
        this.m_frame = frame;
        this.m_joblist = new ArrayList<DisplayInfo>(joblist);
        this.__initialize(header);
    }

    public JobSelectionPanel(Frame frame, List<DisplayInfo> joblist) {
        this.m_frame = frame;
        this.m_joblist = joblist != null ? new ArrayList<DisplayInfo>(joblist) : new ArrayList();
        this.__initialize(m_bundle.getString("JobSelectionPanel.Description.txt"));
    }

    @Override
    public void saveSettingsAndCleanUp() {
        this.m_lblDescription = null;
        this.m_joblist = null;
        this.m_sourceModel = null;
        this.m_targetModel = null;
        this.m_frame = null;
    }

    protected void __initialize(String header) {
        int height;
        int width;
        this.m_lblDescription = new JLabel(header);
        this.m_dualJobList = new ListSelector();
        this.m_dualJobList.setTargetControlsVisible(false);
        this.m_dualJobList.setDragAndDropEnabled(false);
        this.m_dualJobList.setAlternatingSingleButtonStyle(false);
        this.m_dualJobList.setAlternatingMultipleButtonStyle(false);
        this.setLayout(new GridBagLayout());
        try {
            width = Integer.valueOf(m_bundle.getString("JobSelectionPanel.width.txt"));
            height = Integer.valueOf(m_bundle.getString("JobSelectionPanel.height.txt"));
        }
        catch (NumberFormatException ex) {
            width = 600;
            height = 300;
        }
        this.m_dualJobList.setPreferredSize(new Dimension(width, height));
        this.add((Component)this.m_lblDescription, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_dualJobList), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(20, 20, 15, 0), 0, 0));
    }

    @Override
    public void setEnabled(boolean flag) {
        this.m_lblDescription.setEnabled(flag);
        this.m_dualJobList.setEnabled(flag);
    }

    @Override
    public boolean moveDataToView() {
        this.m_sourceJobList = new TreeSet(new CompareDisplayInfoObjects());
        this.m_sourceJobList.addAll(this.m_joblist);
        this.m_sourceModel.setModel(this.m_sourceJobList);
        this.m_targetModel.setModel(this.m_targetJobList);
        this.m_dualJobList.setModel((ListModel)this.m_sourceModel);
        this.m_dualJobList.setTargetModel((ListModel)this.m_targetModel);
        return true;
    }

    public boolean moveDataToView(List<DisplayInfo> available, List<DisplayInfo> selected) {
        this.m_sourceJobList = new TreeSet(new CompareDisplayInfoObjects());
        this.m_sourceJobList.addAll(available);
        this.m_targetJobList = new TreeSet(new CompareDisplayInfoObjects());
        this.m_targetJobList.addAll(selected);
        this.m_sourceModel.setModel(this.m_sourceJobList);
        this.m_targetModel.setModel(this.m_targetJobList);
        this.m_dualJobList.setModel((ListModel)this.m_sourceModel);
        this.m_dualJobList.setTargetModel((ListModel)this.m_targetModel);
        return true;
    }

    public TreeSet<DisplayInfo> getAvailableJobList() {
        return this.m_sourceJobList;
    }

    public DisplayInfo getSelectedJob() {
        return this.m_dualJobList.getSelected();
    }

    public TreeSet<DisplayInfo> getSelectedJobList() {
        return this.m_targetJobList;
    }

    @Override
    public boolean validateData() {
        ArrayList<String> jobsProcessed = new ArrayList<String>();
        for (DisplayInfo job : this.m_targetJobList) {
            String jobname = job.getName();
            if (jobsProcessed.contains(jobname)) {
                String errorMessage = MessageFormat.format(m_bundle.getString("JobSelectionPanel.DuplicateJobname.Message.fmt"), jobname);
                MessageUtil.displayMessage(this.m_frame, errorMessage, m_bundle.getString("JobSelectionPanel.Title.txt"), 0);
                return false;
            }
            jobsProcessed.add(jobname);
        }
        return true;
    }

    static {
        String strClassName = JobSelectionPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    protected class ListSelector
    extends DualListSelector {
        private static final long serialVersionUID = 1L;
        JList m_sourceList;
        JList m_targetList;

        public ListSelector() {
            String sourceText = m_bundle.getString("JobSelectionPanel.SourceLabel.txt");
            this.sourceLabel.setText(Util.getLabelWithoutMnemonic((String)sourceText));
            this.sourceLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)sourceText));
            String targetText = m_bundle.getString("JobSelectionPanel.TargetLabel.txt");
            this.targetLabel.setText(Util.getLabelWithoutMnemonic((String)targetText));
            this.targetLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)targetText));
            this.rightButton.setToolTipText(m_bundle.getString("JobSelectionPanel.RightButton.ToolTip.txt"));
            this.allRightButton.setToolTipText(m_bundle.getString("JobSelectionPanel.AllRightButton.ToolTip.txt"));
            this.leftButton.setToolTipText(m_bundle.getString("JobSelectionPanel.LeftButton.ToolTip.txt"));
            this.allLeftButton.setToolTipText(m_bundle.getString("JobSelectionPanel.AllLeftButton.ToolTip.txt"));
            this.getSourceComponent().setToolTipText(m_bundle.getString("JobSelectionPanel.SourceList.ToolTip.txt"));
            this.getTargetComponent().setToolTipText(m_bundle.getString("JobSelectionPanel.TargetList.ToolTip.txt"));
            this.__initialize();
        }

        public DisplayInfo getSelected() {
            if (this.m_sourceList != null && this.m_targetList != null) {
                if (JobSelectionPanel.this.m_sourceModel.getSize() > 0 && this.m_sourceList.getSelectedIndex() >= 0) {
                    return (DisplayInfo)this.m_sourceList.getSelectedValue();
                }
                if (JobSelectionPanel.this.m_targetModel.getSize() > 0 && this.m_targetList.getSelectedIndex() >= 0) {
                    return (DisplayInfo)this.m_targetList.getSelectedValue();
                }
            }
            return null;
        }

        public void __initialize() {
            if (this.getSourceComponent() instanceof JList) {
                this.m_sourceList = (JList)this.getSourceComponent();
            }
            if (this.getTargetComponent() instanceof JList) {
                this.m_targetList = (JList)this.getTargetComponent();
            }
        }
    }
}

