/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.swing.visuals.CompoundIcon;
import com.sas.visuals.Resources;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconUtil {
    private static final ResourceBundle m_bundle;
    private static Hashtable<String, Icon> m_ImageCache;
    public static final String NODE_Folder;
    public static final String NODE_Repository;
    public static final String NODE_Schmgr;
    public static final String NODE_DeploymentDirectory;
    public static final String SERVER_Scheduler;
    public static final String SERVER_Batch;
    public static final String ACTION_ScheduleFlow;
    public static final String ACTION_UnScheduleFlow;
    public static final String ACTION_Delete;
    public static final String ACTION_Properties;
    public static final String ACTION_ClearCache;
    public static final String ACTION_NewFlow;
    public static final String ACTION_DeploymentDirectories;
    public static final String ACTION_RescheduleAllFlows;
    public static final String ACTION_DeployJob;
    public static final String ACTION_ManageJob;
    public static final String ACTION_ImportFlow;
    public static final String ACTION_Options;
    public static final String ACTION_EditFlowDiagram;
    public static final String ACTION_AddJob;
    public static final String ACTION_ReportFlow;
    public static final String ACTION_SetScheduler;
    public static final String ACTION_SchedulerConsole;
    public static final String ACTION_AddDependencies;
    public static final String ACTION_SetBatchServer;
    public static final String ACTION_ReadLogfile;
    public static final String ACTION_SetJob;
    public static final String ACTION_Close;
    public static final String ACTION_Save;
    public static final String ACTION_Find;
    public static final String NODE_TimeEvent;
    public static final String NODE_FileEvent;
    public static final String NODE_Grouping;
    public static final String NODE_SASJob;
    public static final String NODE_Job;
    public static final String NODE_JobError;
    public static final String NODE_Flow;
    public static final String NODE_FlowError;
    public static final String NODE_ScheduledFlow;
    public static final String NODE_ScheduledFlowError;
    public static final String NODE_Calendar;
    public static final String NODE_Calendar_Focus;

    public static CompoundIcon getIcon(String name) {
        CompoundIcon compoundImage = null;
        if (m_ImageCache == null) {
            m_ImageCache = new Hashtable();
        } else {
            compoundImage = (CompoundIcon)m_ImageCache.get(name);
            if (compoundImage != null) {
                return compoundImage;
            }
        }
        compoundImage = new CompoundIcon();
        compoundImage.setIconGap(-16);
        String[] icons = name.split(";");
        for (int x = 0; x < icons.length; ++x) {
            ImageIcon image = IconUtil.getImageIcon(icons[x]);
            if (image == null) continue;
            compoundImage.addIcon((Icon)image);
        }
        if (compoundImage.getIconCount() > 0) {
            m_ImageCache.put(name, (Icon)compoundImage);
        }
        return compoundImage;
    }

    public static ImageIcon getImageIcon(String name) {
        ImageIcon image = null;
        String sImagePath = m_bundle.getString("ImageLocation.lcl").trim() + name.trim();
        if (m_ImageCache == null) {
            m_ImageCache = new Hashtable();
        } else {
            image = (ImageIcon)m_ImageCache.get(sImagePath);
            if (image != null) {
                return image;
            }
        }
        try {
            URL url = ClassLoader.getSystemClassLoader().getResource(sImagePath);
            if (url == null) {
                url = IconUtil.class.getClassLoader().getResource(sImagePath);
            }
            image = url != null ? new ImageIcon(url) : Resources.getImageIcon((String)name.trim());
        }
        catch (Exception e2) {
            System.err.println("Exception loading image: " + name);
            e2.printStackTrace();
            String sDefaultPath = "com/sas/scheduler/visuals/images/DefaultImage.gif";
            try {
                URL urlDefault = IconUtil.class.getClassLoader().getResource(sDefaultPath);
                image = new ImageIcon(urlDefault);
            }
            catch (Exception e3) {
                System.err.println("Exception loading image: " + sDefaultPath);
                e3.printStackTrace();
            }
        }
        if (image != null) {
            m_ImageCache.put(sImagePath, image);
        }
        return image;
    }

    static {
        String strClassName = IconUtil.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        NODE_Folder = m_bundle.getString("FolderNode.image");
        NODE_Repository = m_bundle.getString("RepositoryNode.image");
        NODE_Schmgr = m_bundle.getString("ScheduleManager.image");
        NODE_DeploymentDirectory = DirectoryInfo.IconName;
        SERVER_Scheduler = SchedulerServerInfo.IconName;
        SERVER_Batch = BatchServerInfo.IconName;
        ACTION_ScheduleFlow = m_bundle.getString("ScheduleFlowAction.image");
        ACTION_UnScheduleFlow = m_bundle.getString("UnScheduleFlowAction.image");
        ACTION_Delete = m_bundle.getString("DeleteAction.image");
        ACTION_Properties = m_bundle.getString("PropertyAction.image");
        ACTION_ClearCache = m_bundle.getString("ClearCacheAction.image");
        ACTION_NewFlow = FlowInfo.IconNewName;
        ACTION_DeploymentDirectories = DirectoryInfo.IconName;
        ACTION_RescheduleAllFlows = FlowInfo.IconScheduledName;
        ACTION_DeployJob = JobInfo.IconName;
        ACTION_ManageJob = m_bundle.getString("ManageJobAction.image");
        ACTION_ImportFlow = m_bundle.getString("ImportFlowAction.image");
        ACTION_Options = m_bundle.getString("OptionsAction.image");
        ACTION_EditFlowDiagram = m_bundle.getString("EditFlowDiagramAction.image");
        ACTION_AddJob = JobInfo.IconName;
        ACTION_ReportFlow = m_bundle.getString("ReportFlowAction.image");
        ACTION_SetScheduler = SchedulerServerInfo.IconName;
        ACTION_SchedulerConsole = SchedulerServerInfo.IconName;
        ACTION_AddDependencies = m_bundle.getString("AddDependenciesAction.image");
        ACTION_SetBatchServer = BatchServerInfo.IconName;
        ACTION_ReadLogfile = m_bundle.getString("ReadLogfileAction.image");
        ACTION_SetJob = m_bundle.getString("SetJobAction.image");
        ACTION_Close = m_bundle.getString("SaveAndCloseWindow.image");
        ACTION_Save = m_bundle.getString("SaveWindow.image");
        ACTION_Find = m_bundle.getString("FindNode.image");
        NODE_TimeEvent = TimeEventInfo.IconName;
        NODE_FileEvent = FileEventInfo.IconName;
        NODE_Grouping = GroupingEventInfo.IconName;
        NODE_SASJob = m_bundle.getString("SASJob.image");
        NODE_Job = JobInfo.IconName;
        NODE_JobError = JobInfo.IconError;
        NODE_Flow = FlowInfo.IconName;
        NODE_FlowError = FlowInfo.IconError;
        NODE_ScheduledFlow = FlowInfo.IconScheduledName;
        NODE_ScheduledFlowError = FlowInfo.IconScheduledError;
        NODE_Calendar = m_bundle.getString("Calendar.image");
        NODE_Calendar_Focus = m_bundle.getString("Calendar.focus.image");
    }
}

