/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.visuals.swing.JobSelectionPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;

public class FlowCompletionPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private Frame m_frame;
    private FlowInfo m_flow;
    private JobSelectionPanel m_jobSelectionPanel;
    private JLabel m_labelCriteria;
    private JRadioButton m_criteria_default;
    private JRadioButton m_criteria_allSelected;
    private JRadioButton m_criteria_anySelected;
    private JLabel m_labelAfterState;
    private JRadioButton m_afterState_stop;
    private JRadioButton m_afterState_change;
    private JRadioButton m_afterState_continue;
    private JLabel m_labelFlowExit;
    private JRadioButton m_flowExit_last;
    private JRadioButton m_flowExit_sum;

    public FlowCompletionPanel(Frame frame, FlowInfo flow) {
        this.m_frame = frame;
        this.m_flow = flow;
        this.__initialize();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_labelCriteria = null;
        this.m_criteria_default = null;
        this.m_criteria_allSelected = null;
        this.m_criteria_anySelected = null;
        this.m_labelAfterState = null;
        this.m_afterState_stop = null;
        this.m_afterState_change = null;
        this.m_afterState_continue = null;
        this.m_labelFlowExit = null;
        this.m_flowExit_last = null;
        this.m_flowExit_sum = null;
    }

    private void __initialize() {
        this.setLayout(new GridBagLayout());
        this.m_labelCriteria = new JLabel(m_bundle.getString("FlowCompletionPanel.Criteria.Label.txt"));
        this.m_labelCriteria.setToolTipText(m_bundle.getString("FlowCompletionPanel.Criteria.ToolTip.txt"));
        this.m_criteria_default = new JRadioButton(m_bundle.getString("FlowCompletionPanel.RadioButton.Default.txt"));
        this.m_criteria_allSelected = new JRadioButton(m_bundle.getString("FlowCompletionPanel.RadioButton.AllSelected.txt"));
        this.m_criteria_anySelected = new JRadioButton(m_bundle.getString("FlowCompletionPanel.RadioButton.AnySelected.txt"));
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.m_criteria_default);
        buttonGroup1.add(this.m_criteria_allSelected);
        buttonGroup1.add(this.m_criteria_anySelected);
        this.m_criteria_default.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowCompletionPanel.this.setWidgets(1);
            }
        });
        this.m_criteria_allSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowCompletionPanel.this.setWidgets(2);
            }
        });
        this.m_criteria_anySelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowCompletionPanel.this.setWidgets(3);
            }
        });
        this.m_labelAfterState = new JLabel(m_bundle.getString("FlowCompletionPanel.AfterState.Label.txt"));
        this.m_labelAfterState.setToolTipText(m_bundle.getString("FlowCompletionPanel.AfterState.ToolTip.txt"));
        this.m_afterState_stop = new JRadioButton(m_bundle.getString("FlowCompletionPanel.RadioButton.AfterState_stop.txt"));
        this.m_afterState_change = new JRadioButton(m_bundle.getString("FlowCompletionPanel.RadioButton.AfterState_change.txt"));
        this.m_afterState_continue = new JRadioButton(m_bundle.getString("FlowCompletionPanel.RadioButton.AfterState_continue.txt"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.m_afterState_stop);
        buttonGroup2.add(this.m_afterState_change);
        buttonGroup2.add(this.m_afterState_continue);
        this.m_labelFlowExit = new JLabel(m_bundle.getString("FlowCompletionPanel.ExitCode.Label.txt"));
        this.m_labelFlowExit.setToolTipText(m_bundle.getString("FlowCompletionPanel.ExitCode.ToolTip.txt"));
        this.m_flowExit_last = new JRadioButton(m_bundle.getString("FlowCompletionPanel.RadioButton.ExitCode_last.txt"));
        this.m_flowExit_sum = new JRadioButton(m_bundle.getString("FlowCompletionPanel.RadioButton.ExitCode_sum.txt"));
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.m_flowExit_last);
        buttonGroup3.add(this.m_flowExit_sum);
        this.m_jobSelectionPanel = new JobSelectionPanel(this.m_frame, null, this.m_flow.getJobs());
        GridBagConstraints label1_gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
        GridBagConstraints default_gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 15, 0, 0), 0, 0);
        GridBagConstraints all_gbc = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 15, 0, 0), 0, 0);
        GridBagConstraints any_gbc = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 15, 0, 0), 0, 0);
        GridBagConstraints selection_gbc = new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 15, 0, 0), 0, 0);
        GridBagConstraints label2_gbc = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
        GridBagConstraints stop_gbc = new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 15, 0, 0), 0, 0);
        GridBagConstraints change_gbc = new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 15, 0, 0), 0, 0);
        GridBagConstraints continue_gbc = new GridBagConstraints(0, 8, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 15, 0, 0), 0, 0);
        GridBagConstraints label3_gbc = new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
        GridBagConstraints last_gbc = new GridBagConstraints(0, 10, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 15, 0, 0), 0, 0);
        GridBagConstraints sum_gbc = new GridBagConstraints(0, 11, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 15, 0, 0), 0, 0);
        this.setBorder(new EtchedBorder());
        this.add((Component)this.m_labelCriteria, label1_gbc);
        this.add((Component)this.m_criteria_default, default_gbc);
        this.add((Component)this.m_criteria_allSelected, all_gbc);
        this.add((Component)this.m_criteria_anySelected, any_gbc);
        this.add((Component)this.m_labelAfterState, label2_gbc);
        this.add((Component)this.m_afterState_stop, stop_gbc);
        this.add((Component)this.m_afterState_change, change_gbc);
        this.add((Component)this.m_afterState_continue, continue_gbc);
        this.add((Component)this.m_labelFlowExit, label3_gbc);
        this.add((Component)this.m_flowExit_last, last_gbc);
        this.add((Component)this.m_flowExit_sum, sum_gbc);
        this.add((Component)this.m_jobSelectionPanel, selection_gbc);
    }

    public FlowInfo getInfo() {
        return this.m_flow;
    }

    @Override
    public void setEnabled(boolean flag) {
        this.m_labelCriteria.setEnabled(flag);
        this.m_criteria_default.setEnabled(flag);
        this.m_criteria_allSelected.setEnabled(flag);
        this.m_criteria_anySelected.setEnabled(flag);
        this.m_afterState_stop.setEnabled(flag);
        this.m_afterState_change.setEnabled(flag);
        this.m_afterState_continue.setEnabled(flag);
        this.m_flowExit_last.setEnabled(flag);
        this.m_flowExit_sum.setEnabled(flag);
        if (flag) {
            this.setWidgets(this.m_flow.completionLevel());
        } else {
            this.m_jobSelectionPanel.setEnabled(flag);
        }
    }

    @Override
    public boolean moveDataToView() {
        int level = this.m_flow.completionLevel();
        switch (level) {
            case 2: {
                this.m_criteria_default.setSelected(false);
                this.m_criteria_allSelected.setSelected(true);
                this.m_criteria_anySelected.setSelected(false);
                break;
            }
            case 3: {
                this.m_criteria_default.setSelected(false);
                this.m_criteria_allSelected.setSelected(false);
                this.m_criteria_anySelected.setSelected(true);
                break;
            }
            default: {
                this.m_criteria_default.setSelected(true);
                this.m_criteria_allSelected.setSelected(false);
                this.m_criteria_anySelected.setSelected(false);
            }
        }
        int afterstate = this.m_flow.getEndBehaviorDataBinding();
        switch (afterstate) {
            case 2: {
                this.m_afterState_stop.setSelected(false);
                this.m_afterState_change.setSelected(true);
                this.m_afterState_continue.setSelected(false);
                break;
            }
            case 3: {
                this.m_afterState_stop.setSelected(false);
                this.m_afterState_change.setSelected(false);
                this.m_afterState_continue.setSelected(true);
                break;
            }
            default: {
                this.m_afterState_stop.setSelected(true);
                this.m_afterState_change.setSelected(false);
                this.m_afterState_continue.setSelected(false);
            }
        }
        int exitcode = this.m_flow.getExitcodeBehaviorDataBinding();
        switch (exitcode) {
            case 1: {
                this.m_flowExit_last.setSelected(true);
                this.m_flowExit_sum.setSelected(false);
                break;
            }
            default: {
                this.m_flowExit_last.setSelected(false);
                this.m_flowExit_sum.setSelected(true);
            }
        }
        List availableJobs = this.m_flow.getJobs();
        List selectedJobs = this.m_flow.completionSelectedJobs();
        ArrayList<DisplayInfo> availableJobInfos = new ArrayList<DisplayInfo>();
        ArrayList<DisplayInfo> selectedJobInfos = new ArrayList<DisplayInfo>();
        for (int x = 0; x < availableJobs.size(); ++x) {
            DisplayInfo info = (DisplayInfo)availableJobs.get(x);
            if (selectedJobs != null && selectedJobs.contains(info.getName())) {
                selectedJobInfos.add(info);
                continue;
            }
            availableJobInfos.add(info);
        }
        if (!this.m_jobSelectionPanel.moveDataToView(availableJobInfos, selectedJobInfos)) {
            this.m_jobSelectionPanel.moveDataToView();
        }
        this.setWidgets(this.m_flow.completionLevel());
        return true;
    }

    @Override
    public boolean moveViewToData() {
        boolean enabled = false;
        int level = 0;
        ArrayList<String> jobList = null;
        if (this.m_criteria_default.isSelected()) {
            level = 1;
            enabled = true;
        } else if (this.m_criteria_allSelected.isSelected()) {
            level = 2;
            enabled = true;
            this.m_jobSelectionPanel.moveViewToData();
            jobList = new ArrayList<String>();
            Object[] aJobList = this.m_jobSelectionPanel.getSelectedJobList().toArray();
            for (int x = 0; x < aJobList.length; ++x) {
                Object o = aJobList[x];
                if (o instanceof DisplayInfo) {
                    jobList.add(((DisplayInfo)o).getName());
                    continue;
                }
                jobList.add(o.toString());
            }
        } else if (this.m_criteria_anySelected.isSelected()) {
            level = 3;
            enabled = true;
            this.m_jobSelectionPanel.moveViewToData();
            jobList = new ArrayList();
            Object[] aJobList = this.m_jobSelectionPanel.getSelectedJobList().toArray();
            for (int x = 0; x < aJobList.length; ++x) {
                Object o = aJobList[x];
                if (o instanceof DisplayInfo) {
                    jobList.add(((DisplayInfo)o).getName());
                    continue;
                }
                jobList.add(o.toString());
            }
        }
        this.m_flow.setCompletion(enabled, level, jobList);
        if (this.m_afterState_stop.isSelected()) {
            this.m_flow.setEndBehaviorDataBinding(Integer.valueOf(1));
        } else if (this.m_afterState_change.isSelected()) {
            this.m_flow.setEndBehaviorDataBinding(Integer.valueOf(2));
        } else if (this.m_afterState_continue.isSelected()) {
            this.m_flow.setEndBehaviorDataBinding(Integer.valueOf(3));
        } else {
            this.m_flow.setEndBehaviorDataBinding(Integer.valueOf(1));
        }
        if (this.m_flowExit_last.isSelected()) {
            this.m_flow.setExitcodeBehaviorDataBinding(Integer.valueOf(1));
        } else if (this.m_flowExit_sum.isSelected()) {
            this.m_flow.setExitcodeBehaviorDataBinding(Integer.valueOf(2));
        } else {
            this.m_flow.setExitcodeBehaviorDataBinding(Integer.valueOf(2));
        }
        return true;
    }

    @Override
    public boolean validateData() {
        if (this.m_jobSelectionPanel.getSelectedJobList().size() <= 0 && !this.m_criteria_default.isSelected()) {
            String message = m_bundle.getString("FlowCompletionPanel.NoItemsSelected.txt");
            String title = m_bundle.getString("FlowCompletionPanel.Title.txt");
            MessageUtil.displayMessage(this.m_frame, message, title, 0);
            return false;
        }
        return true;
    }

    private void setWidgets(int level) {
        if (level == 2 || level == 3) {
            this.m_jobSelectionPanel.setEnabled(true);
        } else {
            this.m_jobSelectionPanel.setEnabled(false);
        }
        this.invalidate();
    }

    static {
        String strClassName = FlowCompletionPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

