/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FileEventPanel
extends StandardPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final String BYTES = m_bundle.getString("FileEventPanel.SizeUnits.Bytes.txt");
    private final String KILOBYTES = m_bundle.getString("FileEventPanel.SizeUnits.KiloBytes.txt");
    private final String MEGABYTES = m_bundle.getString("FileEventPanel.SizeUnits.MegaBytes.txt");
    private static final ResourceBundle m_bundle;
    private FileEventInfo m_fileevent = null;
    private String m_title = "";
    private Frame m_frame = null;
    private SchedulerServerInfo m_scheduler = null;
    private final JTextField m_filename = new JTextField();
    private final JButton m_browse = new JButton(m_bundle.getString("FileEventPanel.BrowseButton.txt"));
    private boolean m_browseEnable = false;
    private String m_currentType = null;
    private JComboBox m_cmbTypes;
    private final String m_typeNotExist = m_bundle.getString("FileEventPanel.Type.NotExist.txt");
    private final String m_typeExist = m_bundle.getString("FileEventPanel.Type.Exist.txt");
    private final String m_typeSize = m_bundle.getString("FileEventPanel.Type.Size.txt");
    private final String m_typeAge = m_bundle.getString("FileEventPanel.Type.Age.txt");
    private final String m_typeArrive = m_bundle.getString("FileEventPanel.Type.Arrive.txt");
    private sizePanel m_sizePanel = new sizePanel();
    private agePanel m_agePanel = new agePanel();
    private final JTextArea m_desc = new JTextArea();

    public FileEventPanel() {
        this((FileEventInfo)null);
    }

    public FileEventPanel(FileEventInfo event) {
        this.m_fileevent = event;
        this.initialize();
        if (event != null) {
            this.setEvent(event);
        }
    }

    public FileEventPanel(FileEventInfo event, String title, Frame frame) {
        this.m_fileevent = event;
        this.m_title = title;
        this.m_frame = frame;
        this.initialize();
        if (event != null) {
            this.setEvent(event);
        }
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_cmbTypes = null;
        this.m_sizePanel = null;
        this.m_agePanel = null;
        this.m_currentType = null;
    }

    public boolean setFilename(String name) {
        this.m_filename.setText(name);
        this.m_fileevent.setFileName(name);
        return true;
    }

    public FileEventInfo getEvent() {
        return this.m_fileevent;
    }

    public boolean setEvent(FileEventInfo event) {
        this.m_fileevent = event;
        if (event == null) {
            return true;
        }
        this.m_filename.setText(event.getFileName());
        switch (this.m_fileevent.getEventType()) {
            case 0: {
                this.m_currentType = this.m_fileevent.getValue() == 1L ? this.m_typeExist : this.m_typeNotExist;
                this.m_cmbTypes.setSelectedItem(this.m_currentType);
                break;
            }
            case 1: {
                this.m_currentType = this.m_typeSize;
                this.m_cmbTypes.setSelectedItem(this.m_typeSize);
                this.m_sizePanel.setOperator(GeneralUtilities.getOperatorString((int)this.m_fileevent.getOperator()));
                this.m_sizePanel.setValue(this.m_fileevent.getValue());
                this.m_sizePanel.setUnits(this.BYTES);
                break;
            }
            case 3: {
                this.m_currentType = this.m_typeAge;
                this.m_cmbTypes.setSelectedItem(this.m_typeAge);
                this.m_agePanel.setOperator(GeneralUtilities.getOperatorString((int)this.m_fileevent.getOperator()));
                this.m_agePanel.setValue(this.m_fileevent.getValue());
                break;
            }
            case 2: {
                this.m_currentType = this.m_typeArrive;
                this.m_cmbTypes.setSelectedItem(this.m_typeArrive);
            }
        }
        return true;
    }

    public SchedulerServerInfo getScheduler() {
        return this.m_scheduler;
    }

    public boolean setScheduler(SchedulerServerInfo scheduler) {
        this.m_scheduler = scheduler;
        return true;
    }

    public void setEditable(boolean flag) {
    }

    private void initialize() {
        if (this.m_fileevent != null) {
            this.setScheduler(this.m_fileevent.getScheduler());
        }
        JPanel topPanel = new JPanel();
        JLabel filelabel = new JLabel(m_bundle.getString("FileEventPanel.FilenameLabel.txt"));
        this.m_filename.setText(this.m_fileevent != null ? this.m_fileevent.getFileName() : "");
        this.m_filename.setPreferredSize(new Dimension(100, 20));
        JLabel conditionlabel = new JLabel(m_bundle.getString("FileEventPanel.ConditionLabel.txt"));
        this.m_cmbTypes = new JComboBox();
        if (this.m_scheduler != null && this.m_scheduler.isEnterpriseLevelSupportOfFileEvents()) {
            this.m_cmbTypes.addItem(this.m_typeExist);
            this.m_cmbTypes.addItem(this.m_typeNotExist);
            this.m_cmbTypes.addItem(this.m_typeSize);
            this.m_cmbTypes.addItem(this.m_typeAge);
            this.m_cmbTypes.addItem(this.m_typeArrive);
        } else {
            this.m_cmbTypes.addItem(this.m_typeExist);
            this.m_cmbTypes.addItem(this.m_typeNotExist);
            this.m_cmbTypes.addItem(this.m_typeSize);
        }
        if (null == this.m_currentType) {
            this.m_currentType = this.m_typeExist;
            this.m_cmbTypes.setSelectedItem(this.m_currentType);
        } else {
            int numItems = this.m_cmbTypes.getItemCount();
            for (int i = 0; i < numItems; ++i) {
                String type = (String)this.m_cmbTypes.getItemAt(i);
                if (!type.equals(this.m_currentType)) continue;
                this.m_cmbTypes.setSelectedIndex(i);
                break;
            }
        }
        this.setDataChanged(false);
        this.m_cmbTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileEventPanel.this.setDataChanged(true);
            }
        });
        GridBagConstraints gbc_filelabel = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gbc_filename = new GridBagConstraints(1, 0, 40, 1, 1.0, 1.0, 18, 2, new Insets(0, 2, 0, 0), 0, 0);
        GridBagConstraints gbc_browse = new GridBagConstraints(45, 0, 10, 1, 1.0, 1.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_combolabel = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints gbc_combobox = new GridBagConstraints(1, 1, 40, 1, 1.0, 1.0, 18, 2, new Insets(5, 2, 0, 0), 0, 0);
        topPanel.setLayout(new GridBagLayout());
        topPanel.add((Component)filelabel, gbc_filelabel);
        topPanel.add((Component)this.m_filename, gbc_filename);
        topPanel.add((Component)this.m_browse, gbc_browse);
        topPanel.add((Component)conditionlabel, gbc_combolabel);
        topPanel.add((Component)this.m_cmbTypes, gbc_combobox);
        topPanel.setPreferredSize(new Dimension(450, 50));
        JPanel bottomPanel = new JPanel();
        JLabel desclabel = new JLabel(m_bundle.getString("FileEventPanel.DescLabel.txt"));
        JScrollPane desc = new JScrollPane(this.m_desc);
        this.m_desc.setAutoscrolls(true);
        this.m_desc.setLineWrap(true);
        desc.setPreferredSize(new Dimension(267, 120));
        if (this.m_fileevent != null) {
            this.m_desc.setText(this.m_fileevent.getDescription());
        }
        GridBagConstraints gbc_desclabel = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gbc_desc = new GridBagConstraints(1, 0, 40, 20, 1.0, 1.0, 18, 1, new Insets(0, 2, 0, 0), 0, 0);
        bottomPanel.setLayout(new GridBagLayout());
        bottomPanel.add((Component)desclabel, gbc_desclabel);
        bottomPanel.add((Component)desc, gbc_desc);
        int rows = 0;
        int cols = 1;
        int hGap = 10;
        int vGap = 10;
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(rows, cols, hGap, vGap, true, false, false);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout((LayoutManager)mainLayout);
        this.add(topPanel);
        this.add(this.m_sizePanel);
        this.add(this.m_agePanel);
        this.add(bottomPanel);
        this.m_cmbTypes.addActionListener(this);
        this.updateEventType();
    }

    @Override
    public boolean validateData() {
        this.m_fileevent.setFileName(this.m_filename.getText());
        this.m_fileevent.setDescription(this.m_desc.getText());
        String type = (String)this.m_cmbTypes.getSelectedItem();
        if (type.compareTo(this.m_typeExist) == 0) {
            this.m_fileevent.setEventType(0);
            this.m_fileevent.setOperator(-1);
            this.m_fileevent.setValue(1L);
        } else if (type.compareTo(this.m_typeNotExist) == 0) {
            this.m_fileevent.setEventType(0);
            this.m_fileevent.setOperator(-1);
            this.m_fileevent.setValue(0L);
        } else if (type.compareTo(this.m_typeSize) == 0) {
            long value = 0L;
            try {
                value = this.m_sizePanel.getValue();
            }
            catch (NumberFormatException nfe) {
                MessageUtil.displayMessage(this.m_frame, m_bundle.getString("FileEventPanel.Error.Invalid.Numeric.Format.txt"), this.m_title, 0, -1);
                this.m_sizePanel.grabFocus();
                return false;
            }
            this.m_fileevent.setEventType(1);
            this.m_fileevent.setOperator(GeneralUtilities.getOperatorFromString((String)this.m_sizePanel.getOperator()));
            String unit = this.m_sizePanel.getUnits();
            if (unit.equalsIgnoreCase(this.KILOBYTES)) {
                value *= 1024L;
            } else if (unit.equalsIgnoreCase(this.MEGABYTES)) {
                value *= 0x100000L;
            }
            this.m_fileevent.setValue(value);
        } else if (type.compareTo(this.m_typeAge) == 0) {
            this.m_fileevent.setEventType(3);
            this.m_fileevent.setOperator(GeneralUtilities.getOperatorFromString((String)this.m_agePanel.getOperator()));
            this.m_fileevent.setValue(this.m_agePanel.getValue());
        } else if (type.compareTo(this.m_typeArrive) == 0) {
            this.m_fileevent.setEventType(2);
            this.m_fileevent.setOperator(-1);
            this.m_fileevent.setValue(0L);
        }
        return true;
    }

    @Override
    public boolean moveDataToView() {
        this.updateEventType();
        return true;
    }

    @Override
    public boolean onParentOK() {
        return super.onParentOK();
    }

    @Override
    public boolean onParentCancel() {
        return super.onParentCancel();
    }

    public void addBrowseListener(ActionListener al) {
        this.m_browse.addActionListener(al);
        if (!this.m_browseEnable) {
            this.m_browseEnable = true;
            this.m_browse.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.m_cmbTypes) {
            this.updateEventType();
        }
    }

    private void updateEventType() {
        String selected = (String)this.m_cmbTypes.getSelectedItem();
        if (selected.equals(this.m_typeExist)) {
            this.m_sizePanel.setVisible(false);
            this.m_agePanel.setVisible(false);
        } else if (selected.equals(this.m_typeNotExist)) {
            this.m_sizePanel.setVisible(false);
            this.m_agePanel.setVisible(false);
        } else if (selected.equals(this.m_typeSize)) {
            this.m_sizePanel.setVisible(true);
            this.m_agePanel.setVisible(false);
        } else if (selected.equals(this.m_typeAge)) {
            this.m_sizePanel.setVisible(false);
            this.m_agePanel.setVisible(true);
        } else if (selected.equals(this.m_typeArrive)) {
            this.m_sizePanel.setVisible(false);
            this.m_agePanel.setVisible(false);
        }
        this.m_browse.setEnabled(this.m_browseEnable);
        this.resizeWindow();
    }

    private void resizeWindow() {
        Window parentWindow = (Window)this.getTopLevelAncestor();
        if (parentWindow != null) {
            parentWindow.pack();
        }
    }

    static {
        String strClassName = FileEventPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    private class sizePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final JComboBox mc_operators = new JComboBox();
        private final JTextField mc_value = new JTextField();
        private final JComboBox mc_units = new JComboBox();

        public sizePanel() {
            for (int x = 21; x < 27; ++x) {
                this.mc_operators.addItem(GeneralUtilities.getOperatorString((int)x));
            }
            this.mc_value.setPreferredSize(new Dimension(50, 20));
            this.mc_units.addItem(FileEventPanel.this.BYTES);
            this.mc_units.addItem(FileEventPanel.this.KILOBYTES);
            this.mc_units.addItem(FileEventPanel.this.MEGABYTES);
            GridBagConstraints gbc_operators = new GridBagConstraints(0, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 122, 0, 0), 0, 0);
            GridBagConstraints gbc_value = new GridBagConstraints(10, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_units = new GridBagConstraints(50, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.mc_operators, gbc_operators);
            this.add((Component)this.mc_value, gbc_value);
            this.add((Component)this.mc_units, gbc_units);
            this.setPreferredSize(new Dimension(450, 30));
        }

        public String getOperator() {
            return (String)this.mc_operators.getSelectedItem();
        }

        public void setOperator(String operator) {
            this.mc_operators.setSelectedItem(operator);
        }

        public long getValue() {
            return Long.parseLong(this.mc_value.getText());
        }

        public void setValue(long value) {
            this.mc_value.setText(String.valueOf(value));
        }

        public String getUnits() {
            return (String)this.mc_units.getSelectedItem();
        }

        public void setUnits(String unit) {
            this.mc_units.setSelectedItem(unit);
        }
    }

    private class agePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final JComboBox mc_operators = new JComboBox();
        private final JTextField mc_value = new JTextField();

        public agePanel() {
            for (int x = 21; x < 27; ++x) {
                this.mc_operators.addItem(GeneralUtilities.getOperatorString((int)x));
            }
            this.mc_value.setPreferredSize(new Dimension(50, 20));
            GridBagConstraints gbc_operators = new GridBagConstraints(0, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 122, 0, 0), 0, 0);
            GridBagConstraints gbc_value = new GridBagConstraints(10, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_units = new GridBagConstraints(50, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.mc_operators, gbc_operators);
            this.add((Component)this.mc_value, gbc_value);
            this.add((Component)new JLabel(m_bundle.getString("FileEventPanel.AgeUnits.txt")), gbc_units);
            this.setPreferredSize(new Dimension(450, 30));
        }

        public String getOperator() {
            return (String)this.mc_operators.getSelectedItem();
        }

        public void setOperator(String operator) {
            this.mc_operators.setSelectedItem(operator);
        }

        public long getValue() {
            return Long.parseLong(this.mc_value.getText());
        }

        public void setValue(long value) {
            this.mc_value.setText(String.valueOf(value));
        }
    }
}

