/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.visuals.swing.FileEventPanel;
import com.sas.scheduler.visuals.swing.StandardDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class FileEventDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private FileEventPanel m_schedulerPanel;
    private String m_title;
    private FileEventInfo m_event;
    private PromptCallbackInterface m_prompt;

    public FileEventDialog(Frame owner, String dialogTitle, FileEventInfo event, PromptCallbackInterface prompt) {
        super(owner, dialogTitle, true);
        this.m_title = dialogTitle;
        this.m_event = event;
        this.m_prompt = prompt;
        this.init();
    }

    @Override
    public void dispose() {
        if (this.m_schedulerPanel != null) {
            this.m_schedulerPanel.saveSettingsAndCleanUp();
            this.m_event = this.m_schedulerPanel.getEvent();
        }
        this.m_schedulerPanel = null;
        this.m_title = null;
        this.m_prompt = null;
        super.dispose();
    }

    public void setFileEvent(FileEventInfo event) {
        this.m_event = event;
        if (this.m_schedulerPanel != null) {
            this.m_schedulerPanel.setEvent(event);
        }
    }

    public FileEventInfo getFileEvent() {
        return this.m_event;
    }

    private void init() {
        this.m_schedulerPanel = new FileEventPanel(this.m_event, this.m_title, this.m_frame);
        SchedulerServerInfo sinfo = this.m_schedulerPanel.getEvent().getScheduler();
        if (sinfo != null && this.m_prompt.isFileSystemAccessible(sinfo)) {
            ActionListener browseListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename = FileEventDialog.this.m_prompt.browseFileSystem(FileEventDialog.this.m_schedulerPanel.getEvent().getScheduler(), FileEventDialog.this.m_title, "", null, false);
                    if (filename != null) {
                        FileEventDialog.this.m_schedulerPanel.setFilename(filename);
                    }
                }
            };
            this.m_schedulerPanel.addBrowseListener(browseListener);
        }
        this.setMainPanel(this.m_schedulerPanel);
    }

    @Override
    protected boolean validateData() {
        if (this.m_schedulerPanel != null) {
            if (this.m_schedulerPanel.validateData()) {
                this.m_event = this.m_schedulerPanel.getEvent();
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected boolean onOK() throws SchedulerException {
        return super.onOK();
    }
}

