/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.visuals.swing.ButtonsLayout;
import com.sas.scheduler.visuals.swing.DeployJobPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class EnvironmentVariablesPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private Frame m_frame;
    private JList m_list;
    private DefaultListModel m_model;
    private JScrollPane m_variables = null;
    private GridBagConstraints m_gbc_variables = null;
    private JButton m_newBtn = new JButton(m_bundle.getString("EnvironmentVariablesPanel.Button.New.txt"));
    private JButton m_editBtn = new JButton(m_bundle.getString("EnvironmentVariablesPanel.Button.Edit.txt"));
    private JButton m_deleteBtn = new JButton(m_bundle.getString("EnvironmentVariablesPanel.Button.Delete.txt"));

    public EnvironmentVariablesPanel(Frame frame, String list) {
        this.m_frame = frame;
        ArrayList<String> env = new ArrayList<String>();
        if (list != null) {
            String[] variableList = list.split(";");
            for (int i = 0; i < variableList.length; ++i) {
                env.add(i, variableList[i]);
            }
        }
        this.__initialize(env);
    }

    public EnvironmentVariablesPanel(Frame frame, List<String> list) {
        this.m_frame = frame;
        this.__initialize(list);
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_variables = null;
        this.m_gbc_variables = null;
    }

    public String getVariableList() {
        StringBuffer buf = new StringBuffer();
        int num = this.m_model.getSize();
        for (int i = 0; i < num; ++i) {
            String var = (String)this.m_model.get(i);
            if (var.trim().length() <= 0) continue;
            buf.append(var + ';');
        }
        return buf.toString();
    }

    public Map<String, String> getVariableMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        int num = this.m_model.getSize();
        for (int i = 0; i < num; ++i) {
            String var = (String)this.m_model.get(i);
            if (var.trim().length() <= 0) continue;
            String name = this.parseName(var);
            String value = this.parseValue(var);
            map.put(name, var);
        }
        return map;
    }

    private String makeStr(String name, String value) {
        return name + '=' + value;
    }

    private String parseName(String var) {
        return var.substring(0, var.indexOf(61));
    }

    private String parseValue(String var) {
        return var.substring(var.indexOf(61) + 1);
    }

    @Override
    public void setEnabled(boolean flag) {
        this.m_list.setEnabled(flag);
        this.m_newBtn.setEnabled(flag);
        if (this.m_model.size() > 0) {
            this.m_editBtn.setEnabled(flag);
            this.m_deleteBtn.setEnabled(flag);
        } else {
            this.m_editBtn.setEnabled(false);
            this.m_deleteBtn.setEnabled(false);
        }
    }

    private void __initialize(List<String> list) {
        JLabel label = new JLabel(m_bundle.getString("EnvironmentVariablesPanel.Description.txt"));
        this.m_model = new DefaultListModel();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.m_model.add(i, list.get(i));
            }
        }
        this.m_list = new JList(this.m_model);
        this.m_list.setSelectionMode(0);
        this.m_variables = new JScrollPane(this.m_list, 20, 30);
        this.m_variables.setPreferredSize(new Dimension(250, 200));
        this.add((Component)this.m_variables, this.m_gbc_variables);
        this.setWidgets();
        this.paintAll(this.m_variables.getGraphics());
        this.m_newBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardDialog dlg2 = new StandardDialog(EnvironmentVariablesPanel.this.m_frame, true);
                EnvVarPanel pnl = new EnvVarPanel();
                dlg2.setMainPanel(pnl);
                dlg2.makeVisible();
                if (1 == dlg2.getReturnValue()) {
                    String newVar = EnvironmentVariablesPanel.this.makeStr(pnl.getName(), pnl.getValue());
                    EnvironmentVariablesPanel.this.m_model.addElement(newVar);
                    EnvironmentVariablesPanel.this.m_list.setSelectedValue(newVar, true);
                    EnvironmentVariablesPanel.this.setWidgets();
                }
            }
        });
        this.m_editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = EnvironmentVariablesPanel.this.m_list.getSelectedIndex();
                if (index < 0) {
                    MessageUtil.displayMessage(EnvironmentVariablesPanel.this.m_frame, m_bundle.getString("EnvironmentVariablesPanel.Edit.NoVariableSelected.txt"), m_bundle.getString("EnvironmentVariablesPanel.Title.txt"), 2);
                    return;
                }
                StandardDialog dlg2 = new StandardDialog(EnvironmentVariablesPanel.this.m_frame, true);
                EnvVarPanel pnl = new EnvVarPanel();
                String var = (String)EnvironmentVariablesPanel.this.m_model.get(index);
                pnl.setName(EnvironmentVariablesPanel.this.parseName(var));
                pnl.setValue(EnvironmentVariablesPanel.this.parseValue(var));
                dlg2.setMainPanel(pnl);
                dlg2.makeVisible();
                if (1 == dlg2.getReturnValue()) {
                    var = EnvironmentVariablesPanel.this.makeStr(pnl.getName(), pnl.getValue());
                    EnvironmentVariablesPanel.this.m_model.set(index, var);
                }
            }
        });
        this.m_deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = EnvironmentVariablesPanel.this.m_list.getSelectedIndices();
                int num = indices.length;
                for (int i = num - 1; i >= 0; --i) {
                    EnvironmentVariablesPanel.this.m_model.remove(indices[i]);
                }
                EnvironmentVariablesPanel.this.setWidgets();
            }
        });
        StandardPanel pnlButtons = new StandardPanel();
        pnlButtons.setLayout(new ButtonsLayout(1, 1));
        pnlButtons.add(this.m_newBtn);
        pnlButtons.add(this.m_editBtn);
        pnlButtons.add(this.m_deleteBtn);
        GridBagConstraints gbc_label = new GridBagConstraints(0, 0, 10, 0, 1.0, 1.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0);
        this.m_gbc_variables = new GridBagConstraints(0, 1, 9, 8, 1.0, 1.0, 18, 1, new Insets(25, 5, 5, 0), 0, 0);
        GridBagConstraints gbc_buttons = new GridBagConstraints(9, 1, 1, 8, 1.0, 1.0, 12, 3, new Insets(30, 0, 0, 5), 0, 0);
        this.setBorder(new EtchedBorder());
        this.setLayout(new GridBagLayout());
        this.add((Component)label, gbc_label);
        this.add((Component)this.m_variables, this.m_gbc_variables);
        this.add((Component)pnlButtons, gbc_buttons);
    }

    private void setWidgets() {
        if (this.m_model.size() > 0) {
            this.m_editBtn.setEnabled(true);
            this.m_deleteBtn.setEnabled(true);
        } else {
            this.m_editBtn.setEnabled(false);
            this.m_deleteBtn.setEnabled(false);
        }
    }

    static {
        String strClassName = DeployJobPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    private class EnvVarPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private JLabel m_nameLabel;
        private JTextField m_nameText = new JTextField();
        private JLabel m_valueLabel;
        private JTextField m_valueText = new JTextField();
        private String m_name;
        private String m_value;

        public EnvVarPanel() {
            this.__layoutWidgets();
        }

        @Override
        public void saveSettingsAndCleanUp() {
            if (this.m_nameText != null) {
                this.m_name = this.m_nameText.getText();
            }
            if (this.m_valueText != null) {
                this.m_value = this.m_valueText.getText();
            }
            this.m_nameLabel = null;
            this.m_nameText = null;
            this.m_valueLabel = null;
            this.m_valueText = null;
        }

        @Override
        public String getName() {
            if (this.m_nameText != null) {
                this.m_name = this.m_nameText.getText();
            }
            return this.m_name;
        }

        public String getValue() {
            if (this.m_valueText != null) {
                this.m_value = this.m_valueText.getText();
            }
            return this.m_value;
        }

        @Override
        public void setName(String name) {
            this.m_nameText.setText(name);
        }

        public void setValue(String value) {
            this.m_valueText.setText(value);
        }

        private void __layoutWidgets() {
            String nameText = m_bundle.getString("EnvironmentVariablesPanel.View.Name.txt");
            this.m_nameLabel = new JLabel(Util.getLabelWithoutMnemonic((String)nameText));
            this.m_nameLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)nameText));
            String valueText = m_bundle.getString("EnvironmentVariablesPanel.View.Value.txt");
            this.m_valueLabel = new JLabel(Util.getLabelWithoutMnemonic((String)valueText));
            this.m_valueLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)valueText));
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            this.setPreferredSize(new Dimension(315, 80));
            int gridy = 0;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(12, 12, 0, 0);
            gridBagLayout.setConstraints(this.m_nameLabel, gbc);
            this.add(this.m_nameLabel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(12, 12, 0, 12);
            gridBagLayout.setConstraints(this.m_nameText, gbc);
            this.add(this.m_nameText);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(12, 12, 0, 0);
            gridBagLayout.setConstraints(this.m_valueLabel, gbc);
            this.add(this.m_valueLabel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(12, 12, 0, 12);
            gridBagLayout.setConstraints(this.m_valueText, gbc);
            this.add(this.m_valueText);
        }

        @Override
        public boolean validateData() {
            String name = this.getName();
            String value = this.getValue();
            if (name != null && name.trim().length() <= 0) {
                MessageUtil.displayMessage(EnvironmentVariablesPanel.this.m_frame, m_bundle.getString("EnvironmentVariablesPanel.NoNameGiven.txt"), m_bundle.getString("EnvironmentVariablesPanel.Title.txt"), 0, -1);
                return false;
            }
            if (value != null && value.trim().length() <= 0) {
                MessageUtil.displayMessage(EnvironmentVariablesPanel.this.m_frame, m_bundle.getString("EnvironmentVariablesPanel.NoValueGiven.txt"), m_bundle.getString("EnvironmentVariablesPanel.Title.txt"), 1, -1);
                return true;
            }
            return true;
        }
    }
}

