/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class DirectoryPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private static final int TEXT_FIELD_LENGTH = 20;
    private JTextField m_fldDirectoryName;
    private JTextField m_fldDirectory;
    private DirectoryInfo m_oDirectory;
    private JButton m_btnBrowse;
    private Frame m_frame;
    private List<?> m_directories;

    public DirectoryPanel(List<?> existingDirs, Frame frame) {
        this.m_frame = frame;
        this.m_oDirectory = new DirectoryInfo(m_bundle.getString("DirectoryPanel.NewDirectory.Name.txt"), null);
        this.m_directories = existingDirs;
        this.__initialize();
    }

    public DirectoryPanel(DirectoryInfo directory, Frame frame) {
        this.m_oDirectory = directory;
        this.m_frame = frame;
        this.m_directories = null;
        this.__initialize();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        this.m_fldDirectoryName = null;
        this.m_fldDirectory = null;
        this.m_btnBrowse = null;
        this.m_frame = null;
    }

    public DirectoryInfo getDirectory() {
        return this.m_oDirectory;
    }

    public void addBrowseListener(ActionListener acl) {
        this.m_btnBrowse.addActionListener(acl);
    }

    public void setDirectoryText(String text) {
        this.m_fldDirectory.setText(text);
    }

    private void __initialize() {
        this.m_fldDirectoryName = new JTextField(20);
        JLabel lblDirectoryName = new JLabel();
        String dirnameText = m_bundle.getString("DirectoryPanel.DirectoryName.txt");
        lblDirectoryName.setText(Util.getLabelWithoutMnemonic((String)dirnameText));
        lblDirectoryName.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)dirnameText));
        lblDirectoryName.setLabelFor(this.m_fldDirectoryName);
        this.m_fldDirectory = new JTextField(20);
        JLabel lblDirectory = new JLabel();
        String dirText = m_bundle.getString("DirectoryPanel.Directory.txt");
        lblDirectory.setText(Util.getLabelWithoutMnemonic((String)dirText));
        lblDirectory.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)dirText));
        lblDirectory.setLabelFor(this.m_fldDirectory);
        String browseText = m_bundle.getString("DirectoryPanel.Browse.txt");
        this.m_btnBrowse = new JButton(Util.getLabelWithoutMnemonic((String)browseText));
        this.m_btnBrowse.setMnemonic(Util.getDisplayedMnemonic((String)browseText));
        this.m_btnBrowse.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)browseText));
        this.setLayout(new GridBagLayout());
        this.add((Component)lblDirectoryName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.5, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)lblDirectory, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.5, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.m_fldDirectoryName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.5, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.m_fldDirectory, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.5, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_btnBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.8, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
    }

    @Override
    public boolean moveViewToData() {
        this.m_oDirectory.setName(this.m_fldDirectoryName.getText());
        this.m_oDirectory.setPath(this.m_fldDirectory.getText());
        return true;
    }

    @Override
    public boolean moveDataToView() {
        if (this.m_directories == null) {
            this.m_fldDirectoryName.setText(this.m_oDirectory.getName());
            this.m_fldDirectory.setText(this.m_oDirectory.getPath());
        }
        return true;
    }

    @Override
    public boolean validateData() {
        String strDirectoryName = this.m_fldDirectoryName.getText().trim();
        if (0 == strDirectoryName.length()) {
            MessageUtil.displayMessage(this.m_frame, m_bundle.getString("DirectoryPanel.BlankDirectoryName.txt"), m_bundle.getString("DirectoryPanel.ErrorMsg.Title.txt"), 0, -1);
            this.m_fldDirectoryName.grabFocus();
            return false;
        }
        if (this.m_directories != null && !this.uniqueName(strDirectoryName, this.m_directories)) {
            MessageUtil.displayMessage(this.m_frame, m_bundle.getString("DirectoryPanel.DupDirectoryName.txt"), m_bundle.getString("DirectoryPanel.ErrorMsg.Title.txt"), 0, -1);
            this.m_fldDirectoryName.grabFocus();
            return false;
        }
        String strDirectory = this.m_fldDirectory.getText().trim();
        if (0 == strDirectory.length()) {
            MessageUtil.displayMessage(this.m_frame, m_bundle.getString("DirectoryPanel.BlankDirectory.txt"), m_bundle.getString("DirectoryPanel.ErrorMsg.Title.txt"), 0, -1);
            this.m_fldDirectory.grabFocus();
            return false;
        }
        return true;
    }

    private boolean uniqueName(String name, List<?> directories) {
        for (DirectoryInfo dir : directories) {
            if (name.compareTo(dir.getName()) != 0) continue;
            return false;
        }
        return true;
    }

    static {
        String strClassName = DirectoryPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

