/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class AbstractProgressDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private static final int DEFAULT_DELAY = 250;
    protected JProgressBar m_barProgress;
    protected JLabel m_lblText;
    protected Dimension m_dimText;
    protected Timer m_timerProgress;

    public AbstractProgressDialog(Frame frmOwner, String sTitle, String sText) {
        super(frmOwner, sTitle, true);
        this.initialize(sText);
        this.layoutWidgets();
    }

    public AbstractProgressDialog(Dialog dlgOwner, String sTitle, String sText) {
        super(dlgOwner, sTitle, true);
        this.initialize(sText);
        this.layoutWidgets();
    }

    public void setDelay(int msDelay) {
        this.m_timerProgress.setDelay(msDelay);
    }

    public int getDelay() {
        return this.m_timerProgress.getDelay();
    }

    @Override
    public void setModal(boolean bModal) {
        throw new UnsupportedOperationException(m_bundle.getString("ProgressIndicator.ModalError.txt"));
    }

    @Override
    public void setVisible(boolean value) {
        if (value) {
            this.m_timerProgress.start();
        } else {
            this.m_timerProgress.stop();
        }
        super.setVisible(value);
    }

    public void setText(String sText) {
        this.m_lblText.setText(sText);
    }

    public String getText(String sText) {
        return this.m_lblText.getText();
    }

    public void setTextPreferredSize(Dimension dimTextLabel) {
        this.m_lblText.setPreferredSize(dimTextLabel);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public Dimension getTextPreferredSize() {
        return this.m_lblText.getPreferredSize();
    }

    protected boolean isComplete() {
        throw new RuntimeException("Subclass must implement isComplete()");
    }

    protected int getProgressValue() {
        return -1;
    }

    protected void initialize(String sText) {
        this.m_lblText = new JLabel(sText);
        this.m_barProgress = new JProgressBar();
        this.m_timerProgress = new Timer(250, this.createTimerListener());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Toolkit.getDefaultToolkit().beep();
            }
        });
    }

    protected void layoutWidgets() {
        JPanel pnlContents = (JPanel)this.getContentPane();
        pnlContents.setLayout(new GridBagLayout());
        pnlContents.add((Component)this.m_lblText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        pnlContents.add((Component)this.m_barProgress, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected ActionListener createTimerListener() {
        return new cTimerListener();
    }

    static {
        String strClassName = AbstractProgressDialog.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    protected class cTimerListener
    implements ActionListener {
        protected cTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int value;
            if (AbstractProgressDialog.this.isComplete()) {
                AbstractProgressDialog.this.m_timerProgress.stop();
                AbstractProgressDialog.this.dispose();
            }
            if ((value = AbstractProgressDialog.this.getProgressValue()) != -1) {
                AbstractProgressDialog.this.m_barProgress.setValue(value);
            } else {
                value = AbstractProgressDialog.this.m_barProgress.getValue();
                if ((value += 5) > AbstractProgressDialog.this.m_barProgress.getMaximum()) {
                    value = 0;
                }
                AbstractProgressDialog.this.m_barProgress.setValue(value);
            }
        }
    }
}

