/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lookup.dao.jcr;

import com.sas.svcs.common.client.dao.jcr.BaseJCRDAO;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.commons.springextensions.jcr.JcrCallback;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.framework.client.ContentObjectDescriptor;
import com.sas.svcs.content.framework.client.ExtendedContentNode;
import com.sas.svcs.content.framework.client.ExtendedContentObject;
import com.sas.svcs.content.lookup.dao.LookupDAO;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import java.io.IOException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Repository;

@Repository(value="DefaultJCRLookupDAO")
public class DefaultJCRLookupDAO
extends BaseJCRDAO
implements LookupDAO {
    private ObjectTypeService objectTypeService;

    @Autowired
    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    @PreAuthorize(value="hasPermission(#objectIdentity, 'read')")
    public ContentObjectDescriptor findObject(final ObjectIdentity objectIdentity) {
        final ObjectType type = this.objectTypeService.getTypeById(objectIdentity.getObjectType());
        if (type == null) {
            return null;
        }
        return (ContentObjectDescriptor)this.getTemplate().execute((JcrCallback)new JcrCallback<ContentObjectDescriptor>(){

            public ContentObjectDescriptor doInJcr(Session session) throws IOException, RepositoryException {
                if (!DefaultJCRLookupDAO.this.isServerConfigured(session)) {
                    return null;
                }
                Node node = DefaultJCRLookupDAO.this.getNodeByObjectIdentity(objectIdentity, session);
                if (node == null) {
                    return null;
                }
                return DefaultJCRLookupDAO.this.getDescriptorFromJcrNode(node, node.getPath(), type);
            }
        });
    }

    private ContentObjectDescriptor getDescriptorFromJcrNode(Node node, String path, ObjectType type) throws RepositoryException {
        ExtendedContentObject contentObject = null;
        if (path == null || path.isEmpty()) {
            contentObject = new ExtendedContentObject();
            this.getJcrContentUtils().populateContentObjectFromJCRNode((ContentObject)contentObject, node, type.getId(), type.getName());
        } else {
            contentObject = new ExtendedContentNode();
            this.getJcrContentUtils().populateContentNodeFromJCRNode((ContentNode)contentObject, node, type.getId(), type.getName());
            ((ContentNode)contentObject).setPath(path);
        }
        ContentObjectDescriptor descriptor = new ContentObjectDescriptor();
        descriptor.setContentObject((ContentComponent)contentObject);
        return descriptor;
    }

    protected boolean isServerConfigured(Session session) throws RepositoryException {
        try {
            session.getNamespaceURI("sas");
        }
        catch (NamespaceException e) {
            return false;
        }
        return true;
    }
}

