/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.jcr;

import com.sas.svcs.authorization.acl.client.AccessControlEntry;
import com.sas.svcs.authorization.acl.client.AccessControlList;
import com.sas.svcs.authorization.client.AuthorizationPrincipal;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.lifecycle.dao.jcr.ExportAccessControl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ExportAccessControlList
implements Serializable {
    private static final long serialVersionUID = 1L;
    String parentId;
    long parentType;
    List<ExportAccessControl> aces;
    String ownerName;
    int ownerType;
    boolean inheritable;

    public ExportAccessControlList() {
    }

    public ExportAccessControlList(AccessControlList acl) {
        AuthorizationPrincipal principal;
        ObjectIdentity identity = acl.getParentAclId();
        if (identity != null) {
            this.parentId = identity.getId();
            this.parentType = identity.getObjectType();
        }
        if ((principal = acl.getOwner()) != null) {
            this.ownerName = principal.getName();
            this.ownerType = principal.getType() == AuthorizationPrincipal.PrincipalType.User ? 1 : 2;
        }
        List aceList = acl.getAces();
        this.aces = new ArrayList<ExportAccessControl>();
        for (AccessControlEntry ace : aceList) {
            ExportAccessControl nextAce = new ExportAccessControl(ace);
            this.aces.add(nextAce);
        }
        this.inheritable = acl.isInheritable();
    }

    public AccessControlList getAccessControlList() {
        AuthorizationPrincipal owner = null;
        if (this.ownerName != null) {
            owner = new AuthorizationPrincipal(this.ownerName, this.ownerType == 1 ? AuthorizationPrincipal.PrincipalType.User : AuthorizationPrincipal.PrincipalType.Group);
        }
        ObjectIdentity parentIdentity = null;
        if (this.parentId != null) {
            parentIdentity = new ObjectIdentity(this.parentType, this.parentId);
        }
        ArrayList<AccessControlEntry> aceList = new ArrayList<AccessControlEntry>();
        for (ExportAccessControl nextAce : this.aces) {
            AccessControlEntry ace = nextAce.getAce();
            aceList.add(ace);
        }
        AccessControlList result = new AccessControlList(aceList, owner, parentIdentity, this.inheritable);
        return result;
    }

    public final String getParentId() {
        return this.parentId;
    }

    public final void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public final long getParentType() {
        return this.parentType;
    }

    public final void setParentType(long parentType) {
        this.parentType = parentType;
    }

    public final List<ExportAccessControl> getAces() {
        return this.aces;
    }

    public final void setAces(List<ExportAccessControl> aces) {
        this.aces = aces;
    }

    public final String getOwnerName() {
        return this.ownerName;
    }

    public final void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public final int getOwnerType() {
        return this.ownerType;
    }

    public final void setOwnerType(int ownerType) {
        this.ownerType = ownerType;
    }

    public final boolean isInheritable() {
        return this.inheritable;
    }

    public final void setInheritable(boolean inheritable) {
        this.inheritable = inheritable;
    }
}

