/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.jcr;

import com.sas.svcs.authorization.acl.client.AccessControlList;
import com.sas.svcs.authorization.acl.client.AclService;
import com.sas.svcs.authorization.client.AuthorizationService;
import com.sas.svcs.common.client.dao.jcr.JcrContentUtils;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.commons.springextensions.jcr.JcrTemplate;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.framework.client.ObjectModifiedException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ContentConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ExportNode;
import com.sas.svcs.content.lifecycle.client.ExportOperation;
import com.sas.svcs.content.lifecycle.client.TransportOperation;
import com.sas.svcs.content.lifecycle.dao.ExportDAO;
import com.sas.svcs.content.lifecycle.dao.jcr.AbstractJcrPromotionDAO;
import com.sas.svcs.content.lifecycle.dao.jcr.ExportAccessControlList;
import com.sas.svcs.content.lifecycle.dao.jcr.RB;
import com.sas.svcs.content.lifecycle.spi.ExportResult;
import com.sas.svcs.content.navigation.client.NavigationNode;
import com.sas.svcs.content.streaming.client.InputStreamContents;
import com.sas.svcs.content.transport.client.ContentItem;
import com.sas.svcs.content.transport.client.ExportPackage;
import com.sas.svcs.content.transport.client.ExportTypeSubpackage;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.EntityResolver;

public abstract class BaseJcrExportDAO
extends AbstractJcrPromotionDAO
implements ExportDAO {
    private JcrTemplate template;
    private JcrContentUtils jcrUtils = new JcrContentUtils();
    private AclService aclService;
    private AuthorizationService authorizationService;

    @Autowired
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Autowired
    public void setAclService(AclService aclService) {
        this.aclService = aclService;
    }

    @Override
    @Autowired
    public void setTemplate(JcrTemplate template) {
        this.template = template;
    }

    @Override
    protected JcrTemplate getTemplate() {
        return this.template;
    }

    @Override
    protected JcrContentUtils getJcrContentUtils() {
        return this.jcrUtils;
    }

    public void validateContents(List<ExportNode> nodes, ExportOperation operation) throws ContentException {
        for (ExportNode nextNode : nodes) {
            ObjectIdentity objectIdentity = new ObjectIdentity((Identifiable)nextNode.getContentObject());
            boolean userHasPermission = this.authorizationService.hasPermission(objectIdentity, (Object)"read");
            if (userHasPermission) continue;
            throw new ContentException("User does not have read permission on object " + nextNode.getId());
        }
    }

    protected abstract ContentObject getContentObject(ObjectIdentity var1);

    protected abstract void setAttributes(ExportTypeSubpackage var1, List<ExportNode> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportResult exportObjects(List<ExportNode> nodes, ExportOperation operation) throws ContentException {
        String packageid = operation.getPackageId();
        ExportTypeSubpackage subpackage = new ExportTypeSubpackage();
        subpackage.setTypeName(this.packageType);
        String displayType = this.getDisplayType(this.packageType);
        this.logHeadingMessage((TransportOperation<?>)operation, Message.format((String)RB.getStringResource("BaseJcrExportDAO.beginexport.fmt.txt", operation.getLocale()), (Object)displayType));
        this.logMessage((TransportOperation<?>)operation, 400, Message.format((String)RB.getStringResource("BaseJcrExportDAO.exportCount.fmt.txt", operation.getLocale()), (Object)new Integer(nodes.size()), (Object)displayType));
        this.setAttributes(subpackage, nodes);
        ExportPackage exportPackage = this.exportPackageService.getPackageById(new ObjectIdentity(159L, packageid));
        ExportResult result = new ExportResult();
        try {
            block18: {
                StringWriter writer = new StringWriter();
                Marshaller marshaller = new Marshaller((Writer)writer);
                marshaller.setMarshalAsDocument(false);
                Mapping mapping = new Mapping();
                mapping.setEntityResolver((EntityResolver)this.customResolver);
                URL mappingURL = BaseJcrExportDAO.class.getResource(this.mappingFile);
                mapping.loadMapping(mappingURL);
                marshaller.setMapping(mapping);
                this.beforeAnyOutput(writer, marshaller);
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                this.beforeFirstElement(writer, marshaller);
                writer.write("<" + this.rootElement + ">\n");
                HashMap<String, NodeContent> nodeContentMap = new HashMap<String, NodeContent>();
                ArrayList<String> messageList = new ArrayList<String>();
                for (ExportNode nextNode : nodes) {
                    ContentItem aclItem;
                    String path;
                    messageList.clear();
                    ContentComponent co = nextNode.getContentObject();
                    String identifier = Message.format((String)RB.getStringResource("BaseJcrExportDAO.identlogline.fmt.txt", operation.getLocale()), (Object)co.getId(), (Object)nextNode.getName());
                    if (co instanceof ContentNode) {
                        identifier = Message.format((String)RB.getStringResource("BaseJcrExportDAO.pathlogline.fmt.txt", operation.getLocale()), (Object)((ContentNode)co).getPath());
                    }
                    messageList.add(identifier);
                    this.logEnumerationMessages((TransportOperation<?>)operation, 400, (List<String>)messageList);
                    ObjectIdentity identity = new ObjectIdentity(nextNode.getContentObject().getObjectType(), nextNode.getContentObject().getId());
                    ContentObject node = this.getContentObject(identity);
                    if (node instanceof ContentNode && (path = ((ContentNode)node).getPath()) != null) {
                        int index = path.lastIndexOf("/");
                        path = path.substring(0, index);
                        NavigationNode parentNode = this.navigationService.getObjectByPath(path, 79L);
                        ContentConnectionPoint parentConnection = new ContentConnectionPoint();
                        parentConnection.setActive(true);
                        parentConnection.setSourceId(parentNode.getContentObject().getId());
                        parentConnection.setTargetId(parentNode.getContentObject().getId());
                        parentConnection.setName(parentNode.getContentObject().getName());
                        parentConnection.setSourcePath(parentNode.getNavigationPath());
                        parentConnection.setTargetPath(parentNode.getNavigationPath());
                        parentConnection.setObjectType(parentNode.getContentObject().getObjectType());
                        parentConnection.setObjectTypeName(parentNode.getContentObject().getObjectTypeName());
                        nextNode.addConnectionPoint((ConnectionPoint)parentConnection);
                    }
                    result.addExportNode(nextNode);
                    this.beforeNode(writer, marshaller, nextNode);
                    marshaller.marshal((Object)node);
                    this.afterNode(writer, marshaller, nextNode);
                    ContentItem contentItem = this.makeContentItem(node);
                    if (contentItem != null) {
                        subpackage.addContentItem(contentItem);
                        nodeContentMap.put(contentItem.getName(), new NodeContent(node.getId(), node.getObjectType(), contentItem.getName()));
                    }
                    if ((aclItem = this.makeACLItem(node)) == null) continue;
                    subpackage.addContentItem(aclItem);
                }
                writer.write("</" + this.rootElement + ">");
                this.afterEverything(writer, marshaller);
                String dataString = writer.toString();
                writer.close();
                ContentItem transportItem = new ContentItem();
                transportItem.setContent(dataString.getBytes("UTF-8"));
                transportItem.setContentName("TransportMetadata.xml");
                transportItem.setName("TransportMetadata");
                ContentItem placeholder = new ContentItem();
                placeholder.setAttributes(transportItem.getAttributes());
                placeholder.setName(transportItem.getName());
                placeholder.setContentName(transportItem.getContentName());
                subpackage.addContentItem(placeholder);
                this.addSubpackage(exportPackage, subpackage);
                try {
                    subpackage = null;
                    exportPackage = this.exportPackageService.update(exportPackage);
                    subpackage = this.getSubpackage(exportPackage, this.packageType);
                    if (subpackage == null) break block18;
                    List contentItemList = subpackage.getContentItems();
                    for (ContentItem nextContentItem : contentItemList) {
                        if (nextContentItem.getName().equals("TransportMetadata")) {
                            ByteArrayInputStream bis = new ByteArrayInputStream(dataString.getBytes());
                            this.streamService.setStreamContents(new ObjectIdentity(160L, nextContentItem.getId()), "application/octet-stream", (InputStream)bis);
                            bis.close();
                            continue;
                        }
                        NodeContent nodeContent = (NodeContent)nodeContentMap.get(nextContentItem.getName());
                        if (nodeContent == null) continue;
                        InputStreamContents isc = null;
                        try {
                            isc = this.streamService.getInputStreamContents(new ObjectIdentity(nodeContent.getObjectType(), nodeContent.getId()));
                            this.streamService.setStreamContents(new ObjectIdentity(160L, nextContentItem.getId()), "application/octet-stream", isc.getInputStream());
                        }
                        finally {
                            if (isc == null) continue;
                            isc.releaseInputStream();
                        }
                    }
                }
                catch (ObjectModifiedException ex) {
                    this.logMessage((TransportOperation<?>)operation, 200, RB.getStringResource("BaseJcrExportDAO.exportobjectexception.ex.txt", operation.getLocale()), ex);
                    throw new ContentException(ex.getMessage(), (Throwable)ex);
                }
                catch (ObjectNotFoundException ex) {
                    this.logMessage((TransportOperation<?>)operation, 200, RB.getStringResource("BaseJcrExportDAO.exportobjectexception.ex.txt", operation.getLocale()), ex);
                    throw new ContentException(ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable t) {
                    this.logMessage((TransportOperation<?>)operation, 200, RB.getStringResource("BaseJcrExportDAO.exportobjectexception.ex.txt", operation.getLocale()), t);
                    throw new ContentException(t.getMessage(), t);
                }
            }
            this.logMessage((TransportOperation<?>)operation, 400, RB.getStringResource("BaseJcrExportDAO.exportcomplete.txt", operation.getLocale()));
            return result;
        }
        catch (MappingException ex) {
            this.logMessage((TransportOperation<?>)operation, 200, RB.getStringResource("BaseJcrExportDAO.exportobjectexception.ex.txt", operation.getLocale()), ex);
        }
        catch (MarshalException ex) {
            this.logMessage((TransportOperation<?>)operation, 200, RB.getStringResource("BaseJcrExportDAO.exportobjectexception.ex.txt", operation.getLocale()), ex);
        }
        catch (ValidationException ex) {
            this.logMessage((TransportOperation<?>)operation, 200, RB.getStringResource("BaseJcrExportDAO.exportobjectexception.ex.txt", operation.getLocale()), ex);
        }
        catch (IOException ex) {
            this.logMessage((TransportOperation<?>)operation, 200, RB.getStringResource("BaseJcrExportDAO.exportobjectexception.ex.txt", operation.getLocale()), ex);
        }
        return null;
    }

    protected ContentItem makeContentItem(ContentObject node) {
        return null;
    }

    protected byte[] getContent(ContentObject node) {
        return null;
    }

    protected ExportAccessControlList getNodeAcls(ContentObject node) {
        ExportAccessControlList result = null;
        AccessControlList acl = this.aclService.getAcl(new ObjectIdentity((Identifiable)node));
        if (acl != null) {
            result = new ExportAccessControlList(acl);
        }
        return result;
    }

    protected ContentItem makeACLItem(ContentObject node) {
        ExportAccessControlList aclList = this.getNodeAcls(node);
        if (aclList == null) {
            return null;
        }
        ContentItem result = new ContentItem();
        result.setName(node.getId() + "-AccessControl");
        result.setContentName(node.getId() + "-AccessControl");
        result.setObjectType(160L);
        try {
            StringWriter writer = new StringWriter();
            Marshaller marshaller = new Marshaller((Writer)writer);
            marshaller.setMarshalAsDocument(false);
            Mapping mapping = new Mapping();
            mapping.setEntityResolver((EntityResolver)this.customResolver);
            URL mappingURL = BaseJcrExportDAO.class.getResource("/com/sas/svcs/content/lifecycle/dao/jcr/ExportAccessControlMapping.xml");
            mapping.loadMapping(mappingURL);
            marshaller.setMapping(mapping);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<AccessControls>");
            marshaller.marshal((Object)aclList);
            writer.write("</AccessControls>");
            result.setContent(writer.toString().getBytes());
            return result;
        }
        catch (MarshalException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (ValidationException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (MappingException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected void afterEverything(StringWriter writer, Marshaller marshaller) {
    }

    protected void afterNode(StringWriter writer, Marshaller marshaller, ExportNode nextNode) {
    }

    protected void beforeNode(StringWriter writer, Marshaller marshaller, ExportNode nextNode) {
    }

    protected void beforeFirstElement(StringWriter writer, Marshaller marshaller) {
    }

    protected void beforeAnyOutput(StringWriter writer, Marshaller marshaller) {
    }

    private class NodeContent {
        String id;
        long objectType;
        String name;

        public NodeContent(String id, long objectType, String name) {
            this.id = id;
            this.name = name;
            this.objectType = objectType;
        }

        public String getId() {
            return this.id;
        }

        public long getObjectType() {
            return this.objectType;
        }

        public String getName() {
            return this.name;
        }
    }
}

