/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.MissingValues;
import com.sas.lang.ByteDataInterface;
import com.sas.lang.CharacterDataInterface;
import com.sas.lang.DoubleDataInterface;
import com.sas.lang.FloatDataInterface;
import com.sas.lang.IntegerDataInterface;
import com.sas.lang.LongDataInterface;
import com.sas.lang.ShortDataInterface;
import com.sas.lang.StringDataInterface;
import com.sas.nls.collator.SASStringComparator;
import com.sas.util.BaseStringComparator;
import com.sas.util.Comparator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class GenericComparator
implements Comparator,
Serializable,
java.util.Comparator {
    static final long serialVersionUID = -6209322708319709038L;
    private SASStringComparator stringComparator = null;
    public static final GenericComparator defaultInstance = new GenericComparator();

    public GenericComparator() {
    }

    public GenericComparator(SASStringComparator comparator) {
        this.stringComparator = comparator;
    }

    @Override
    public int compare(Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof MissingValues && b instanceof MissingValues) {
            int missB;
            int missA = ((MissingValues)a).getIndex();
            return missA < (missB = ((MissingValues)b).getIndex()) ? -1 : (missA > missB ? 1 : 0);
        }
        if (a instanceof MissingValues) {
            return -1;
        }
        if (b instanceof MissingValues) {
            return 1;
        }
        if (a instanceof String && b instanceof Number) {
            return -1;
        }
        if (a instanceof Number && b instanceof String) {
            return 1;
        }
        if (a instanceof String && b instanceof String) {
            if (this.stringComparator != null) {
                return this.stringComparator.compare(a, b);
            }
            return BaseStringComparator.defaultInstance.compare(a, b);
        }
        if (a instanceof Number && b instanceof Number) {
            if (GenericComparator.isInteger(a) && GenericComparator.isInteger(b)) {
                return GenericComparator.compareIntegers((Number)a, (Number)b);
            }
            return GenericComparator.compareFloat((Number)a, (Number)b);
        }
        if (a instanceof Comparable && b instanceof Comparable && a.getClass().isAssignableFrom(b.getClass())) {
            int compare = ((Comparable)a).compareTo(b);
            if (compare == 0) {
                return 0;
            }
            if (compare < 0) {
                return -1;
            }
            return 1;
        }
        Object compA = GenericComparator.makeComparable(a);
        Object compB = GenericComparator.makeComparable(b);
        if (compA != null && compB != null) {
            return this.compare(compA, compB);
        }
        return Integer.MAX_VALUE;
    }

    protected static Object makeComparable(Object a) {
        if (a instanceof StringDataInterface) {
            return ((StringDataInterface)a).getText();
        }
        if (a instanceof DoubleDataInterface) {
            return new Double(((DoubleDataInterface)a).getDoubleData());
        }
        if (a instanceof FloatDataInterface) {
            return new Float(((FloatDataInterface)a).getFloatData());
        }
        if (a instanceof LongDataInterface) {
            return new Long(((LongDataInterface)a).getLongData());
        }
        if (a instanceof IntegerDataInterface) {
            return new Integer(((IntegerDataInterface)a).getIntegerData());
        }
        if (a instanceof ShortDataInterface) {
            return new Short(((ShortDataInterface)a).getShortData());
        }
        if (a instanceof CharacterDataInterface) {
            return new Character(((CharacterDataInterface)a).getCharacterData());
        }
        if (a instanceof ByteDataInterface) {
            return new Byte(((ByteDataInterface)a).getByteData());
        }
        if (a instanceof Date) {
            return new Long(((Date)a).getTime());
        }
        if (a instanceof Calendar) {
            return new Long(((Calendar)a).getTime().getTime());
        }
        return null;
    }

    public static boolean isInteger(Object a) {
        return a instanceof Number && !(a instanceof Float) && !(a instanceof Double) && !(a instanceof BigDecimal);
    }

    public static int compareIntegers(Number a, Number b) {
        long lB;
        long lA = a.longValue();
        return lA < (lB = b.longValue()) ? -1 : (lA > lB ? 1 : 0);
    }

    public static int compareFloat(Number a, Number b) {
        double dB;
        double dA = a.doubleValue();
        return dA < (dB = b.doubleValue()) ? -1 : (dA > dB ? 1 : 0);
    }
}

