/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.SASFormatEntry;
import com.sas.text.SASNumericFormat;
import com.sas.text.SingleEntry;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

@SASScope
class exp
extends SASNumericFormat {
    private DecimalFormat expdf = new DecimalFormat("+00;-00");
    private DecimalFormat df = new DecimalFormat();
    private StringBuffer result;
    private StringBuffer pattern;
    private static Object[] expFormats;

    public exp() {
        this.expdf.setDecimalSeparatorAlwaysShown(false);
        this.df.setDecimalSeparatorAlwaysShown(false);
        this.result = new StringBuffer();
        this.pattern = new StringBuffer();
    }

    @Override
    protected void init() {
        super.init();
        this.df.setDecimalFormatSymbols(new DecimalFormatSymbols(this.locale));
    }

    @Override
    public StringBuffer format(double value) {
        int e = 0;
        this.result.setLength(0);
        double nValue = Math.abs(value);
        if (nValue >= 10.0) {
            BigDecimal bdVal = new BigDecimal("" + nValue);
            BigDecimal val10 = new BigDecimal(".1");
            while (bdVal.doubleValue() >= 10.0) {
                bdVal = bdVal.multiply(val10);
                ++e;
            }
            nValue = bdVal.doubleValue();
        } else if (0.0 < nValue && nValue < 1.0) {
            while (nValue < 1.0) {
                nValue *= 10.0;
                --e;
            }
        }
        int width = this.info.getWidth();
        if (value >= 0.0 && width != 7) {
            --width;
        }
        int diff = width - 4;
        if (value < 0.0) {
            this.result.append('-');
            --diff;
        }
        if (diff <= 2) {
            nValue = this.round(nValue, 0);
            this.df.applyPattern("#");
        } else {
            this.pattern.setLength(0);
            this.pattern.append("0.0");
            for (int i = 3; i < diff; ++i) {
                this.pattern.append('0');
            }
            nValue = this.round(nValue, diff - 2);
            this.df.applyPattern(this.pattern.toString());
        }
        while (nValue >= 10.0) {
            nValue /= 10.0;
            ++e;
        }
        this.result.append(this.df.format(new Double(nValue)));
        this.result.append("E" + this.expdf.format(e));
        this.insertLeadingBlanks(this.result);
        return this.result;
    }

    @Override
    public double informat(String value) {
        return -1.0;
    }

    static Object[] getDefinedFormats() {
        if (expFormats == null) {
            SingleEntry entry = new SingleEntry("Ew", exp.class.getName());
            ((SASFormatEntry)entry).addPattern(12, 32, null, true);
            ((SASFormatEntry)entry).addPattern(7, 11, null);
            expFormats = new Object[1];
            exp.expFormats[0] = entry;
        }
        return expFormats;
    }
}

