/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.MissingValues;
import com.sas.text.SASUserDefinedFormat;
import com.sas.text.TableEntry;
import com.sas.text.ValueEntry;
import com.sas.text.ValueFormatDescription;
import java.text.FieldPosition;

public class SASValueFormat
extends SASUserDefinedFormat {
    private ValueEntry entry = null;
    private FieldPosition position = new FieldPosition(0);
    private StringBuffer buffer = new StringBuffer(32);

    protected SASValueFormat() {
    }

    @Override
    protected void init() {
        this.entry = (ValueEntry)this.formatInfo.getEntry();
        this.entry.setWidth(this.formatInfo.getWidth());
        this.entry.init();
        this.formatInfo.width = this.entry.getWidth();
    }

    public StringBuffer format(double value) {
        if (!this.isCharacterFormat()) {
            return this.format(new Double(value), new StringBuffer(), this.position);
        }
        throw new IllegalArgumentException("Error: Format " + this.entry.getBaseFormatName() + " is not a numeric format");
    }

    public StringBuffer format(String value) {
        if (this.isCharacterFormat()) {
            return this.format(value, new StringBuffer(), this.position);
        }
        throw new IllegalArgumentException("Error: Format " + this.entry.getBaseFormatName() + " is not a character format");
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer result, FieldPosition pos) {
        int length;
        int width;
        String value;
        if (obj instanceof Double && ((Double)obj).isNaN()) {
            obj = MissingValues.Dot;
        }
        if ((value = this.entry.getValue(obj)).indexOf(".0E") != -1) {
            value = value.replaceFirst(".0E", "E");
        }
        if (value.indexOf(".0e") != -1) {
            value = value.replaceFirst(".0e", "e");
        }
        if ((width = this.entry.getWidth()) - (length = value.length()) < 0) {
            result.append(value.substring(0, width));
        } else if (width - length != 0) {
            this.buffer.setLength(0);
            this.buffer.append(value);
            result.append(this.insertTrailingWhitespaces(this.buffer, width - length));
        } else {
            result.append(value);
        }
        return result;
    }

    public static ValueFormatDescription createValueFormat(String name) {
        String cls = SASValueFormat.class.getName();
        ValueEntry entry = new ValueEntry(name.toUpperCase(), cls);
        String key = entry.getBaseFormatName();
        TableEntry te = (TableEntry)lookUpTable.get(key);
        try {
            if (te == null || Class.forName(te.getClassName()).getSuperclass() == SASUserDefinedFormat.class) {
                lookUpTable.put(key, entry);
            } else {
                entry = null;
            }
        }
        catch (ClassNotFoundException e) {
            lookUpTable.put(key, entry);
        }
        return entry;
    }
}

