/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.SASNumericFormat;
import com.sas.text.SingleEntry;
import java.util.Locale;

@SASScope
public class Roman
extends SASNumericFormat {
    static final char[][] A2R = new char[][]{{'\u0000', 'M'}, {'\u0000', 'C', 'D', 'M'}, {'\u0000', 'X', 'L', 'C'}, {'\u0000', 'I', 'V', 'X'}};
    private static Object[] romanFormats;

    @Override
    public double informat(String value) {
        return 0.0;
    }

    @Override
    protected void init() {
        super.init();
        if (this.info.getWidth() <= 0) {
            this.info.setWidth(6);
        }
        if (this.info.getWidth() > 32) {
            this.info.setWidth(32);
        }
        if (this.info.getWidth() == 1) {
            this.info.setWidth(2);
        }
    }

    @Override
    public StringBuffer format(double value) {
        int w = this.info.getWidth();
        if (this.info.getDefaultWidth() <= 0 || this.info.getWidth() <= 0) {
            this.info.setWidth(6);
            w = 6;
        }
        boolean isNegative = false;
        if (value < 0.0) {
            isNegative = true;
        }
        StringBuffer romanVal = new StringBuffer();
        int num = (int)Math.abs(value);
        if (num == 0) {
            return this.insertTrailingWhitespaces(romanVal.append(0));
        }
        if (num < -9999 || num > 9999) {
            char[] arr = new char[w];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = 42;
            }
            return romanVal.append(arr);
        }
        romanVal = this.romanFormat(num);
        if (isNegative) {
            romanVal.insert(0, '-');
        }
        if (romanVal.length() > w) {
            char[] arr = new char[w];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = 42;
            }
            romanVal.delete(0, romanVal.length());
            romanVal.append(arr);
        }
        return this.insertTrailingWhitespaces(romanVal);
    }

    private StringBuffer romanFormat(int n) {
        int d;
        StringBuffer sb = new StringBuffer();
        for (d = n; d >= 4000; d -= 1000) {
            sb.append(A2R[0][1]);
        }
        int place = 1000;
        for (int pos = 0; pos < 4; ++pos) {
            int k;
            int ch = d / place;
            d %= place;
            place /= 10;
            if (ch == 0) continue;
            if (ch <= 3) {
                for (k = 1; k <= ch; ++k) {
                    sb.append(A2R[pos][1]);
                }
                continue;
            }
            if (ch == 4) {
                sb.append(A2R[pos][1]);
                sb.append(A2R[pos][2]);
                continue;
            }
            if (ch == 5) {
                sb.append(A2R[pos][2]);
                continue;
            }
            if (ch <= 8) {
                sb.append(A2R[pos][2]);
                for (k = 6; k <= ch; ++k) {
                    sb.append(A2R[pos][1]);
                }
                continue;
            }
            sb.append(A2R[pos][1]);
            sb.append(A2R[pos][3]);
        }
        return sb;
    }

    static synchronized Object[] getDefinedFormats() {
        if (romanFormats == null) {
            romanFormats = new Object[1];
            SingleEntry entry = new SingleEntry("ROMANw", Roman.class.getName());
            entry.setFormatLocale(Locale.US);
            entry.addPattern(2, 32, null, true);
            entry.setDefaultWidth(6);
            Roman.romanFormats[0] = entry;
        }
        return romanFormats;
    }
}

