/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.DateTimeValue;
import com.sas.text.DateValue;
import com.sas.text.FormatDescription;
import com.sas.text.InvalidFormatException;
import com.sas.text.NLInformats;
import com.sas.text.SASFormat;
import com.sas.text.SASFormatEntry;
import com.sas.text.SASFormatInfo;
import com.sas.text.SingleEntry;
import com.sas.text.TableEntry;
import com.sas.text.TimeValue;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SASScope
public class NLFormats {
    public static final String DATE9 = "DATE9";
    public static final String YYMMDD10 = "YYMMDD10";
    public static final String LONG_YEAR_NAME = "NLDATEYR";
    public static final String SHORT_YEAR_NAME = "NLDATEYR2";
    public static final String LONG_MONTH_YEAR_NAME = "NLDATEYM";
    public static final String SHORT_MONTH_YEAR_NAME = "NLDATEYM2";
    public static final String MONTH_YEAR_NAME = "NLDATEYM";
    public static final String LONG_WEEK_NAME = "NLDATEYW";
    public static final String SHORT_WEEK_NAME = "NLDATEYW2";
    public static final String HOURS_MINUTES_24_NAME = "NLTIMENS";
    public static final String HOURS_MINUTES_12_NAME = "NLTIMNAP";
    public static final String LONG_QUARTER_NAME = "NLDATEYQ";
    public static final String SHORT_QUARTER_NAME = "NLDATEYQ2";
    public static final String XML_SCHEMA_NAME = "NLDATMXML";
    private static final Pattern namePattern = Pattern.compile("^([^0-9]+)[0-9]+$");
    private static final String NLDATETIME_PREFIX = "NLDATM";
    private static final String NLDATE_PREFIX = "NLDATE";
    private static final String NLTIME_PREFIX = "NLTIM";
    private static final String N_CHAR = "N";
    private static final String MISSING_PATTERN = "***";
    private static final String DATE = "DATE";
    private static final String YYMMDD = "YYMMDD";
    private static final String SHORT_QUARTER = "QQ";
    private static final String NLTIME = "NLTIME";
    private static final String NLTIMAP = "NLTIMAP";
    private static final String QUARTER_START = "q";
    private static final String QUARTER_END = "_s";
    private static final String XML_SCHEMA_PATTERN = "yyyy-M-d'T'H:mm:ss";
    private static final String NLDATEMD = "NLDATEMD";
    private static final Pattern NLTIME_PATTERN = Pattern.compile("(.*mm[^:.]*)('[:.]'|[:.])?ss(\\s*'o''clock'|\\s*'uur'|\\s*'Uhr')?");
    private static final Pattern NLTIMAP_PATTERN = Pattern.compile("(.*mm[^:.]*)('[:.]'|[:.])?ss(.*)");
    private static final Pattern SUFFIX_PATTERN = Pattern.compile("a|'o''clock'|'uur'|'Uhr'");
    private static final Collection EMPTY_COLLECTION = new ArrayList(0);
    private static final Map dateTimeFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map dateFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map shortDateFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map longDateFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map timeFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map quarterFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map quarterQuartersFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map monthFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map weekFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map yearFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map allDateFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Map allDateMap = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Locale, Collection<FormatPattern>> serverDateFormats = Collections.synchronizedMap(new WeakHashMap());
    private static final Set<String> SERVER_DATE_FORMATS;
    private static final String BUNDLE_NAME = "com/sas/text/NLFormatNames";
    private static final ResourceBundle bundle;

    private NLFormats() {
    }

    public static String getPattern(String name, Locale locale) {
        String nm = name;
        Matcher matcher = namePattern.matcher(name);
        if (matcher.find()) {
            nm = matcher.group(1);
        }
        List<FormatPattern> patterns = NLFormats.checkAllDateTime(nm, locale);
        String pattern = null;
        for (FormatPattern fmt : patterns) {
            if (!fmt.name.equals(name)) continue;
            pattern = fmt.pattern;
        }
        if (pattern == null) {
            for (FormatPattern fmt : patterns) {
                if (!fmt.name.equals(nm)) continue;
                pattern = fmt.pattern;
            }
        }
        return pattern;
    }

    public static String getSASFormatPattern(String name, Locale locale, int width) {
        String pattern = "";
        SASFormat format = SASFormat.getInstance(name, locale);
        try {
            SASFormatInfo formatInfo = new SASFormatInfo((SASFormatEntry)format.formatInfo.getEntry(), name, width, 0);
            pattern = formatInfo.getPattern();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pattern;
    }

    public static Collection getNLDateTimeFormats(Locale locale) {
        Collection cached = (Collection)dateTimeFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        Collection<FormatPattern> coll = NLFormats.getNLFormats(DateTimeValue.getDefinedFormats(locale), locale, new DateTimePatterns());
        Collection<FormatPattern> unmodifiableCollection = Collections.unmodifiableCollection(coll);
        dateTimeFormats.put(locale, unmodifiableCollection);
        return unmodifiableCollection;
    }

    public static Collection getNLDateFormats(Locale locale) {
        Collection cached = (Collection)dateFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        Collection<FormatPattern> coll = NLFormats.getNLFormats(DateValue.getDefinedFormats(locale), locale, new DatePatterns());
        Collection<FormatPattern> unmodifiableCollection = Collections.unmodifiableCollection(coll);
        dateFormats.put(locale, unmodifiableCollection);
        return unmodifiableCollection;
    }

    public static Collection getNLServerDateFormats(Locale locale) {
        Collection<FormatPattern> cached = serverDateFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        Object[] formats = DateValue.getDefinedFormats(locale);
        HashSet<FormatPattern> coll = new HashSet<FormatPattern>();
        for (int j = 0; j < formats.length; ++j) {
            FormatDescription format = (FormatDescription)formats[j];
            String formatName = format.getBaseFormatName();
            if (!SERVER_DATE_FORMATS.contains(formatName) || !(format instanceof SingleEntry)) continue;
            SingleEntry entry = (SingleEntry)format;
            HashSet<String> patterns = new HashSet<String>();
            int additional = 1;
            FormatPattern fmt = null;
            for (int i = format.getMaxWidth(); i >= format.getMinWidth(); --i) {
                try {
                    String pattern = entry.getPattern(formatName, i);
                    if (pattern == null || pattern.startsWith(MISSING_PATTERN)) continue;
                    if (!patterns.contains(pattern)) {
                        patterns.add(pattern);
                        fmt = additional == 1 ? new FormatPattern(formatName, pattern, formatName, i) : new FormatPattern(formatName + additional, pattern, formatName, i);
                        fmt.minMVAWidth = i;
                        coll.add(fmt);
                        ++additional;
                        continue;
                    }
                    if (fmt == null || !fmt.pattern.equals(pattern)) continue;
                    fmt.minMVAWidth = i;
                    continue;
                }
                catch (InvalidFormatException invalidFormatException) {
                    // empty catch block
                }
            }
        }
        Collection unmodifiableCollection = Collections.unmodifiableCollection(coll);
        serverDateFormats.put(locale, unmodifiableCollection);
        return unmodifiableCollection;
    }

    public static Collection getNLShortDateFormats(Locale locale) {
        Collection cached = (Collection)shortDateFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        Collection datefmt = NLFormats.getNLDateFormats(locale);
        FormatPattern[] patterns = datefmt.toArray(new FormatPattern[datefmt.size()]);
        Arrays.sort(patterns, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String str0 = ((FormatPattern)arg0).pattern.replaceAll("'", "");
                String str1 = ((FormatPattern)arg1).pattern.replaceAll("'", "");
                return str0.length() - str1.length();
            }
        });
        HashSet<FormatPattern> coll = new HashSet<FormatPattern>();
        for (int i = 0; i < patterns.length / 2; ++i) {
            coll.add(patterns[i]);
        }
        Collection unmodifiableCollection = Collections.unmodifiableCollection(coll);
        shortDateFormats.put(locale, unmodifiableCollection);
        return unmodifiableCollection;
    }

    public static Collection getNLLongDateFormats(Locale locale) {
        Collection cached = (Collection)longDateFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        Collection datefmt = NLFormats.getNLDateFormats(locale);
        FormatPattern[] patterns = datefmt.toArray(new FormatPattern[datefmt.size()]);
        Arrays.sort(patterns, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String str0 = ((FormatPattern)arg0).pattern.replaceAll("'", "");
                String str1 = ((FormatPattern)arg1).pattern.replaceAll("'", "");
                return str0.length() - str1.length();
            }
        });
        HashSet<FormatPattern> coll = new HashSet<FormatPattern>();
        for (int i = patterns.length / 2; i < patterns.length; ++i) {
            coll.add(patterns[i]);
        }
        Collection unmodifiableCollection = Collections.unmodifiableCollection(coll);
        longDateFormats.put(locale, unmodifiableCollection);
        return unmodifiableCollection;
    }

    public static Collection getNLTimeFormats(Locale locale) {
        Collection cached = (Collection)timeFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        Collection<FormatPattern> coll = NLFormats.getNLFormats(TimeValue.getDefinedFormats(locale), locale, new TimePatterns());
        Collection<FormatPattern> unmodifiableCollection = Collections.unmodifiableCollection(coll);
        timeFormats.put(locale, unmodifiableCollection);
        return unmodifiableCollection;
    }

    public static Collection getNLQuarterFormats(Locale locale) {
        Collection cached = (Collection)quarterFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        Collection coll = NLFormats.getNLFormats(DateValue.getDefinedFormats(locale), LONG_QUARTER_NAME, null, EMPTY_COLLECTION);
        Collection unmodifiableCollection = Collections.unmodifiableCollection(coll);
        quarterFormats.put(locale, unmodifiableCollection);
        return unmodifiableCollection;
    }

    public static Collection getNLMonthFormats(Locale locale) {
        Collection cached = (Collection)monthFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        Object[] formats = DateValue.getDefinedFormats(locale);
        Collection coll = NLFormats.getNLFormats(formats, "NLDATEYM", null, EMPTY_COLLECTION);
        coll.addAll(NLFormats.getNLFormats(formats, "NLDATEYM", null, EMPTY_COLLECTION));
        coll.addAll(NLFormats.getNLFormats(formats, NLDATEMD, null, EMPTY_COLLECTION));
        Collection unmodifiableCollection = Collections.unmodifiableCollection(coll);
        monthFormats.put(locale, unmodifiableCollection);
        return unmodifiableCollection;
    }

    public static Collection getNLWeekFormats(Locale locale) {
        Collection cached = (Collection)weekFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        Collection coll = NLFormats.getNLFormats(DateValue.getDefinedFormats(locale), LONG_WEEK_NAME, null, EMPTY_COLLECTION);
        Collection unmodifiableCollection = Collections.unmodifiableCollection(coll);
        weekFormats.put(locale, unmodifiableCollection);
        return unmodifiableCollection;
    }

    public static Collection getNLYearFormats(Locale locale) {
        Collection cached = (Collection)yearFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        Collection coll = NLFormats.getNLFormats(DateValue.getDefinedFormats(locale), LONG_YEAR_NAME, null, EMPTY_COLLECTION);
        Collection unmodifiableCollection = Collections.unmodifiableCollection(coll);
        yearFormats.put(locale, unmodifiableCollection);
        return unmodifiableCollection;
    }

    public static Collection getAllNLDateFormats(Locale locale) {
        FormatPattern pattern;
        Collection cached = (Collection)allDateFormats.get(locale);
        if (cached != null) {
            return cached;
        }
        Object[] formats = DateValue.getDefinedFormats(locale);
        Collection coll = NLFormats.getNLFormats(formats, NLDATE_PREFIX, N_CHAR, EMPTY_COLLECTION);
        if ("en".equals(locale.getLanguage()) && "US".equalsIgnoreCase(locale.getCountry()) && (pattern = NLFormats.getNLFormat(formats, DATE, 9)) != null) {
            coll.add(pattern);
        }
        if ((pattern = NLFormats.getNLFormat(formats, YYMMDD, 10)) != null) {
            coll.add(pattern);
        }
        Collection unmodifiableCollection = Collections.unmodifiableCollection(coll);
        allDateFormats.put(locale, unmodifiableCollection);
        return unmodifiableCollection;
    }

    public static String fixQuarter(String name, Date date, Locale locale) {
        if (name.contains(SHORT_QUARTER)) {
            throw new IllegalArgumentException("The parameter 'name' must not be a pattern");
        }
        if (name.equals(LONG_QUARTER_NAME)) {
            return NLFormats.fixQuarterPattern(NLFormats.getPattern(LONG_QUARTER_NAME, locale), date, locale);
        }
        if (name.equals(SHORT_QUARTER_NAME)) {
            return NLFormats.fixQuarterPattern(NLFormats.getPattern(SHORT_QUARTER_NAME, locale), date, locale);
        }
        return null;
    }

    public static String fixQuarterPattern(String pattern, Date date, Locale locale) {
        return NLInformats.fixQuarterPattern(pattern, date.getMonth(), locale);
    }

    public static String fixQuarter(String name, Date date, Locale locale, Calendar cal) {
        if (name.contains(SHORT_QUARTER)) {
            throw new IllegalArgumentException("The parameter 'name' must not be a pattern");
        }
        if (name.equals(LONG_QUARTER_NAME)) {
            return NLFormats.fixQuarterPattern(NLFormats.getPattern(LONG_QUARTER_NAME, locale), date, locale, cal);
        }
        if (name.equals(SHORT_QUARTER_NAME)) {
            return NLFormats.fixQuarterPattern(NLFormats.getPattern(SHORT_QUARTER_NAME, locale), date, locale, cal);
        }
        return null;
    }

    public static String fixQuarterPattern(String pattern, Date date, Locale locale, Calendar cal) {
        cal.setTime(date);
        return NLInformats.fixQuarterPattern(pattern, cal.get(2), locale);
    }

    public static Date parseQuarterString(String str, Locale locale) throws ParseException {
        return NLInformats.parseQuarterString(str, locale);
    }

    public static Date parseQuarterString(String str, ParsePosition ppos, Locale locale) throws ParseException {
        return NLInformats.parseQuarterString(str, ppos, locale);
    }

    public static Date parseQuarterString(String str, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parseQuarterString(str, locale, cal);
    }

    public static Date parseQuarterString(String str, ParsePosition ppos, Locale locale, Calendar cal) throws ParseException {
        return NLInformats.parseQuarterString(str, ppos, locale, cal);
    }

    static QuarterPatterns loadQuarterPatterns(Locale locale) {
        QuarterPatterns qPatterns = (QuarterPatterns)quarterQuartersFormats.get(locale);
        if (qPatterns == null) {
            qPatterns = new QuarterPatterns();
            SASFormat.refreshFormatCache(locale);
            Object object = SASFormat.localeFormatCache.get(locale);
            Map lookUpTable = (Map)object;
            TableEntry entry = (TableEntry)lookUpTable.get(LONG_QUARTER_NAME);
            StringBuffer buff = new StringBuffer(QUARTER_START);
            buff.append(1);
            qPatterns.abFirstQuarter = "1";
            qPatterns.abSecondQuarter = "2";
            qPatterns.abThirdQuarter = "3";
            qPatterns.abFourthQuarter = "4";
            qPatterns.shortFirstQuarter = entry.getString("q1_s");
            qPatterns.shortSecondQuarter = entry.getString("q2_s");
            qPatterns.shortThirdQuarter = entry.getString("q3_s");
            qPatterns.shortFourthQuarter = entry.getString("q4_s");
            qPatterns.longFirstQuarter = entry.getString("q1");
            qPatterns.longSecondQuarter = entry.getString("q2");
            qPatterns.longThirdQuarter = entry.getString("q3");
            qPatterns.longFourthQuarter = entry.getString("q4");
            quarterQuartersFormats.put(locale, qPatterns);
        }
        return qPatterns;
    }

    private static Collection<FormatPattern> getNLFormats(Object[] definedFormats, Locale locale, PatternType patternType) {
        HashSet<FormatPattern> formats = new HashSet<FormatPattern>();
        Collection<String> patternNames = patternType.getPatternNames();
        for (int j = 0; j < definedFormats.length; ++j) {
            FormatDescription format = (FormatDescription)definedFormats[j];
            String formatName = format.getBaseFormatName();
            if (!patternNames.contains(formatName) || !(format instanceof SingleEntry)) continue;
            SingleEntry entry = (SingleEntry)format;
            HashSet<String> patterns = new HashSet<String>();
            int additional = 1;
            FormatPattern fmt = null;
            for (int i = format.getMaxWidth(); i >= format.getMinWidth(); --i) {
                try {
                    String pattern = entry.getPattern(formatName, i);
                    if (pattern == null || pattern.startsWith(MISSING_PATTERN)) continue;
                    String trimmedPattern = NLFormats.trimPattern(pattern);
                    if (!patterns.contains(trimmedPattern) && patternType.isCorrectType(pattern)) {
                        patterns.add(trimmedPattern);
                        fmt = additional == 1 ? new FormatPattern(formatName, pattern, formatName, i) : new FormatPattern(formatName + additional, pattern, formatName, i);
                        fmt.minMVAWidth = i;
                        formats.add(fmt);
                        ++additional;
                        continue;
                    }
                    if (fmt == null || !fmt.pattern.equals(pattern)) continue;
                    fmt.minMVAWidth = i;
                    continue;
                }
                catch (InvalidFormatException invalidFormatException) {
                    // empty catch block
                }
            }
        }
        patternType.addExtraFormats(definedFormats, locale, formats);
        return formats;
    }

    private static Collection<FormatPattern> getNLFormatsDups(Object[] definedFormats, Locale locale, PatternType patternType, String targetName) {
        HashSet<FormatPattern> formats = new HashSet<FormatPattern>();
        for (int j = 0; j < definedFormats.length; ++j) {
            FormatDescription format = (FormatDescription)definedFormats[j];
            String formatName = format.getBaseFormatName();
            if (!(format instanceof SingleEntry)) continue;
            SingleEntry entry = (SingleEntry)format;
            HashSet<String> patterns = new HashSet<String>();
            int additional = 1;
            FormatPattern fmt = null;
            for (int i = format.getMaxWidth(); i >= format.getMinWidth(); --i) {
                try {
                    String trimmedPattern;
                    String pattern = entry.getPattern(formatName, i);
                    if (pattern == null || pattern.startsWith(MISSING_PATTERN) || patterns.contains(trimmedPattern = NLFormats.trimPattern(pattern))) continue;
                    patterns.add(trimmedPattern);
                    fmt = additional == 1 ? new FormatPattern(formatName, pattern, formatName, i) : new FormatPattern(formatName + additional, pattern, formatName, i);
                    fmt.minMVAWidth = i;
                    formats.add(fmt);
                    ++additional;
                    continue;
                }
                catch (InvalidFormatException invalidFormatException) {
                    // empty catch block
                }
            }
        }
        patternType.addExtraFormats(definedFormats, locale, formats, targetName);
        return formats;
    }

    private static Map getAllDateMap(Locale locale) {
        HashMap<String, String> map = (HashMap<String, String>)allDateMap.get(locale);
        if (map == null) {
            map = new HashMap<String, String>();
            for (FormatPattern pattern : NLFormats.getNLDateTimeFormats(locale)) {
                map.put(pattern.name, pattern.pattern);
            }
            for (FormatPattern pattern : NLFormats.getNLTimeFormats(locale)) {
                map.put(pattern.name, pattern.pattern);
            }
            for (FormatPattern pattern : NLFormats.getAllNLDateFormats(locale)) {
                map.put(pattern.name, pattern.pattern);
            }
            allDateMap.put(locale, map);
        }
        return map;
    }

    private static List<FormatPattern> checkAllDateTime(String name, Locale locale) {
        ArrayList<FormatPattern> result = new ArrayList<FormatPattern>();
        result.addAll(NLFormats.getNLFormatsDups(DateTimeValue.getDefinedFormats(locale), locale, new DateTimePatterns(), name));
        result.addAll(NLFormats.getNLFormatsDups(TimeValue.getDefinedFormats(locale), locale, new TimePatterns(), name));
        result.addAll(NLFormats.getNLFormatsDups(DateValue.getDefinedFormats(locale), locale, new DatePatterns(), name));
        return result;
    }

    private static Collection getNLFormats(Object[] definedFormats, String namePrefix, String nameSuffix, Collection exclude) {
        HashSet<FormatPattern> formats = new HashSet<FormatPattern>();
        for (int j = 0; j < definedFormats.length; ++j) {
            FormatDescription format = (FormatDescription)definedFormats[j];
            String formatName = format.getBaseFormatName();
            if (!formatName.startsWith(namePrefix) || nameSuffix != null && formatName.endsWith(nameSuffix) || !(format instanceof SingleEntry)) continue;
            SingleEntry entry = (SingleEntry)format;
            HashSet<String> patterns = new HashSet<String>();
            int additional = 1;
            FormatPattern fmt = null;
            for (int i = format.getMaxWidth(); i >= format.getMinWidth(); --i) {
                try {
                    String pattern = entry.getPattern(formatName, i);
                    if (pattern == null || pattern.startsWith(MISSING_PATTERN) || exclude.contains(pattern)) continue;
                    if (!patterns.contains(pattern)) {
                        patterns.add(pattern);
                        fmt = additional == 1 ? new FormatPattern(formatName, pattern, formatName, i) : new FormatPattern(formatName + additional, pattern, formatName, i);
                        fmt.minMVAWidth = i;
                        formats.add(fmt);
                        ++additional;
                        continue;
                    }
                    if (fmt == null || !fmt.pattern.equals(pattern)) continue;
                    fmt.minMVAWidth = i;
                    continue;
                }
                catch (InvalidFormatException invalidFormatException) {
                    // empty catch block
                }
            }
        }
        return formats;
    }

    private static Collection getExcludedPatterns(Locale locale) {
        HashSet<String> exclude = new HashSet<String>();
        Collection formats = NLFormats.getNLTimeFormats(locale);
        for (FormatPattern format : formats) {
            exclude.add(format.pattern);
        }
        formats = NLFormats.getNLDateFormats(locale);
        for (FormatPattern format : formats) {
            exclude.add(format.pattern);
        }
        return exclude;
    }

    private static FormatPattern getNLFormat(Object[] definedFormats, String name, int width) {
        for (int j = 0; j < definedFormats.length; ++j) {
            FormatDescription format = (FormatDescription)definedFormats[j];
            String formatName = format.getBaseFormatName();
            if (!formatName.equals(name)) continue;
            SingleEntry entry = (SingleEntry)format;
            try {
                String pattern = entry.getPattern(formatName, width);
                if (pattern == null) continue;
                FormatPattern fmt = new FormatPattern(name + width, pattern, name, width);
                fmt.minMVAWidth = width;
                return fmt;
            }
            catch (InvalidFormatException invalidFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String trimPattern(String pattern) {
        StringBuilder buff = null;
        int length = pattern.length();
        int i = 0;
        int j = 0;
        while (i < length) {
            if (pattern.charAt(i) == '\'') {
                if (buff == null) {
                    buff = new StringBuilder(pattern);
                }
                boolean nextIsApos = false;
                if (i < length - 1) {
                    boolean bl = nextIsApos = pattern.charAt(i + 1) == '\'';
                }
                if (nextIsApos) {
                    ++i;
                }
                buff.deleteCharAt(j);
                --j;
            }
            ++i;
            ++j;
        }
        if (buff != null) {
            return buff.toString();
        }
        return pattern;
    }

    static {
        bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        SERVER_DATE_FORMATS = new HashSet<String>();
        SERVER_DATE_FORMATS.add(NLDATE_PREFIX);
        SERVER_DATE_FORMATS.add(NLDATEMD);
        SERVER_DATE_FORMATS.add("NLDATEMN");
        SERVER_DATE_FORMATS.add("NLDATEW");
        SERVER_DATE_FORMATS.add("NLDATEWN");
        SERVER_DATE_FORMATS.add("NLDATEYM");
        SERVER_DATE_FORMATS.add(LONG_QUARTER_NAME);
        SERVER_DATE_FORMATS.add(LONG_YEAR_NAME);
        SERVER_DATE_FORMATS.add(LONG_WEEK_NAME);
        SERVER_DATE_FORMATS.add(NLDATETIME_PREFIX);
        SERVER_DATE_FORMATS.add("NLDATMAP");
        SERVER_DATE_FORMATS.add("NLDATMDT");
        SERVER_DATE_FORMATS.add("NLDATMMD");
        SERVER_DATE_FORMATS.add("NLDATMTM");
        SERVER_DATE_FORMATS.add("NLDATMW");
        SERVER_DATE_FORMATS.add("NLDATMMN");
        SERVER_DATE_FORMATS.add("NLDATMWN");
        SERVER_DATE_FORMATS.add("NLDATMYM");
        SERVER_DATE_FORMATS.add("NLDATMYQ");
        SERVER_DATE_FORMATS.add("NLDATMYR");
        SERVER_DATE_FORMATS.add("NLDATMYW");
        SERVER_DATE_FORMATS.add(NLTIMAP);
        SERVER_DATE_FORMATS.add(NLTIME);
    }

    @SASScope
    public static class FormatPattern {
        public final String name;
        public final String pattern;
        private final String baseMVAName;
        private int minMVAWidth;
        private final int maxMVAWidth;

        FormatPattern(String name, String pattern) {
            this.name = name;
            this.pattern = pattern;
            this.baseMVAName = null;
            this.maxMVAWidth = -1;
            this.minMVAWidth = -1;
        }

        FormatPattern(String name, String pattern, String mvaName, int maxWidth) {
            this.name = name;
            this.pattern = pattern;
            this.baseMVAName = mvaName;
            this.maxMVAWidth = maxWidth;
            this.minMVAWidth = -1;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FormatPattern)) {
                return false;
            }
            FormatPattern pat = (FormatPattern)obj;
            return this.pattern.equals(pat.pattern) && this.name.equals(pat.name);
        }

        public int hashCode() {
            return this.pattern.hashCode() + this.name.hashCode();
        }

        public String getBaseMVAName() {
            return this.baseMVAName;
        }

        public int getMaxMVAWidth() {
            return this.maxMVAWidth;
        }

        public int getMinMVAWidth() {
            return this.minMVAWidth;
        }
    }

    @SASScope
    private static class DateTimePatterns
    extends BasePatterns {
        private static final String PATTERNS_KEY = "datetime.patterns.txt";
        public static final String XML_SCHEMA_NAME = "NLDATMXML";
        private static final String XML_SCHEMA_PATTERN = "yyyy-M-d'T'H:mm:ss";

        private DateTimePatterns() {
        }

        @Override
        public Collection<String> getPatternNames() {
            return this.getPatternNames(PATTERNS_KEY);
        }

        @Override
        public boolean isCorrectType(String pattern) {
            return pattern.indexOf("yy") >= 0 && pattern.indexOf("M") >= 0 && pattern.indexOf("d") >= 0 && (pattern.indexOf("h") >= 0 || pattern.indexOf("H") >= 0 || pattern.indexOf("k") >= 0 || pattern.indexOf("K") >= 0) && pattern.indexOf("m") >= 0;
        }

        @Override
        public void addExtraFormats(Object[] definedFormats, Locale locale, Set<FormatPattern> formats) {
            formats.add(new FormatPattern("NLDATMXML", "yyyy-M-d'T'H:mm:ss"));
            String pattern = NLFormats.getPattern("NLDATMTZ", locale);
            if (pattern != null) {
                formats.add(new FormatPattern("NLDATMTZ", pattern));
            }
        }

        @Override
        public void addExtraFormats(Object[] definedFormats, Locale locale, Set<FormatPattern> formats, String targetName) {
            if (targetName.equals("NLDATMXML")) {
                formats.add(new FormatPattern("NLDATMXML", "yyyy-M-d'T'H:mm:ss"));
            }
        }
    }

    @SASScope
    private static interface PatternType {
        public Collection<String> getPatternNames();

        public void addExtraFormats(Object[] var1, Locale var2, Set<FormatPattern> var3);

        public void addExtraFormats(Object[] var1, Locale var2, Set<FormatPattern> var3, String var4);

        public boolean isCorrectType(String var1);
    }

    @SASScope
    private static class DatePatterns
    extends BasePatterns {
        private static final String PATTERNS_KEY = "date.patterns.txt";
        private static final String DATE = "DATE";
        private static final String YYMMDD = "YYMMDD";

        private DatePatterns() {
        }

        @Override
        public Collection<String> getPatternNames() {
            return this.getPatternNames(PATTERNS_KEY);
        }

        @Override
        public boolean isCorrectType(String pattern) {
            return pattern.indexOf("yy") >= 0 && pattern.indexOf("M") >= 0 && pattern.indexOf("d") >= 0;
        }

        @Override
        public void addExtraFormats(Object[] definedFormats, Locale locale, Set<FormatPattern> formats) {
            FormatPattern pattern;
            if ("en".equals(locale.getLanguage()) && "US".equalsIgnoreCase(locale.getCountry()) && (pattern = this.getNLFormat(definedFormats, "DATE", 9)) != null) {
                formats.add(pattern);
            }
            if ((pattern = this.getNLFormat(definedFormats, "YYMMDD", 10)) != null) {
                formats.add(pattern);
            }
        }

        @Override
        public void addExtraFormats(Object[] definedFormats, Locale locale, Set<FormatPattern> formats, String targetName) {
            FormatPattern pattern;
            if ("en".equals(locale.getLanguage()) && "US".equalsIgnoreCase(locale.getCountry()) && targetName.equals("DATE") && (pattern = this.getNLFormat(definedFormats, "DATE", 9)) != null) {
                formats.add(pattern);
            }
            if (targetName.equals("YYMMDD") && (pattern = this.getNLFormat(definedFormats, "YYMMDD", 10)) != null) {
                formats.add(pattern);
            }
        }
    }

    @SASScope
    private static class TimePatterns
    extends BasePatterns {
        private static final String PATTERNS_KEY = "time.patterns.txt";
        private static final String NLTIME = "NLTIME";
        private static final String NLTIMAP = "NLTIMAP";
        private static final String HOURS_MINUTES_24_NAME = "NLTIMENS";
        private static final String HOURS_MINUTES_12_NAME = "NLTIMNAP";
        private static final Pattern NLTIME_PATTERN = Pattern.compile("(.*mm[^:.]*)('[:.]'|[:.])?ss(\\s*'o''clock'|\\s*'uur'|\\s*'Uhr')?");
        private static final Pattern NLTIMAP_PATTERN = Pattern.compile("(.*mm[^:.]*)('[:.]'|[:.])?ss(.*)");
        private static final Pattern SUFFIX_PATTERN = Pattern.compile("a|'o''clock'|'uur'|'Uhr'");

        private TimePatterns() {
        }

        @Override
        public Collection<String> getPatternNames() {
            return this.getPatternNames(PATTERNS_KEY);
        }

        @Override
        public boolean isCorrectType(String pattern) {
            return (pattern.indexOf("h") >= 0 || pattern.indexOf("H") >= 0 || pattern.indexOf("k") >= 0 || pattern.indexOf("K") >= 0) && pattern.indexOf("m") >= 0;
        }

        @Override
        public void addExtraFormats(Object[] definedFormats, Locale locale, Set<FormatPattern> formats) {
            HashSet<String> patterns = new HashSet<String>();
            for (FormatPattern pat : formats) {
                patterns.add(NLFormats.trimPattern(pat.pattern));
            }
            HashSet<FormatPattern> fmts = new HashSet<FormatPattern>(formats);
            for (FormatPattern pat : fmts) {
                String trimmedPattern;
                String prefix;
                Matcher matcher;
                if (pat.name.equals("NLTIME")) {
                    matcher = NLTIME_PATTERN.matcher(pat.pattern);
                    if (!matcher.find()) continue;
                    String str = prefix = matcher.group(1);
                    String suffix = matcher.group(3);
                    if (suffix != null) {
                        str = prefix + suffix;
                    }
                    if (patterns.contains(trimmedPattern = NLFormats.trimPattern(str = str.trim()))) continue;
                    formats.add(new FormatPattern("NLTIMENS", str));
                    patterns.add(trimmedPattern);
                    continue;
                }
                if (!pat.name.equals("NLTIMAP") || !(matcher = NLTIMAP_PATTERN.matcher(pat.pattern)).find()) continue;
                prefix = matcher.group(1);
                String suffix = matcher.group(3);
                String str = (matcher = SUFFIX_PATTERN.matcher(suffix)).find() ? prefix + suffix : prefix;
                trimmedPattern = NLFormats.trimPattern(str = str.trim());
                if (patterns.contains(trimmedPattern)) continue;
                formats.add(new FormatPattern("NLTIMNAP", str));
                patterns.add(trimmedPattern);
            }
        }

        @Override
        public void addExtraFormats(Object[] definedFormats, Locale locale, Set<FormatPattern> formats, String targetName) {
            if (!targetName.equals("NLTIMENS") && !targetName.equals("NLTIMNAP")) {
                return;
            }
            HashSet<FormatPattern> fmts = new HashSet<FormatPattern>(formats);
            for (FormatPattern pat : fmts) {
                String trimmedPattern;
                String prefix;
                Matcher matcher;
                if (pat.name.equals("NLTIME")) {
                    matcher = NLTIME_PATTERN.matcher(pat.pattern);
                    if (matcher.find()) {
                        String str = prefix = matcher.group(1);
                        String suffix = matcher.group(3);
                        if (suffix != null) {
                            str = prefix + suffix;
                        }
                        str = str.trim();
                        trimmedPattern = NLFormats.trimPattern(str);
                        formats.add(new FormatPattern("NLTIMENS", str));
                        continue;
                    }
                    formats.add(new FormatPattern("NLTIMENS", pat.pattern));
                    continue;
                }
                if (!pat.name.equals("NLTIMAP")) continue;
                matcher = NLTIMAP_PATTERN.matcher(pat.pattern);
                if (matcher.find()) {
                    prefix = matcher.group(1);
                    String suffix = matcher.group(3);
                    String str = (matcher = SUFFIX_PATTERN.matcher(suffix)).find() ? prefix + suffix : prefix;
                    str = str.trim();
                    trimmedPattern = NLFormats.trimPattern(str);
                    formats.add(new FormatPattern("NLTIMNAP", str));
                    continue;
                }
                formats.add(new FormatPattern("NLTIMNAP", pat.pattern));
            }
        }
    }

    @SASScope
    static final class QuarterPatterns {
        String abFirstQuarter;
        String abSecondQuarter;
        String abThirdQuarter;
        String abFourthQuarter;
        String shortFirstQuarter;
        String shortSecondQuarter;
        String shortThirdQuarter;
        String shortFourthQuarter;
        String longFirstQuarter;
        String longSecondQuarter;
        String longThirdQuarter;
        String longFourthQuarter;

        QuarterPatterns() {
        }
    }

    @SASScope
    private static abstract class BasePatterns
    implements PatternType {
        private BasePatterns() {
        }

        Collection<String> getPatternNames(String key) {
            HashSet<String> patternNames = new HashSet<String>();
            String value = bundle.getString(key);
            if (value == null || value.length() == 0) {
                return null;
            }
            String[] names = value.split(",");
            for (int i = 0; i < names.length; ++i) {
                patternNames.add(names[i]);
            }
            return patternNames;
        }

        protected FormatPattern getNLFormat(Object[] definedFormats, String name, int width) {
            for (int j = 0; j < definedFormats.length; ++j) {
                FormatDescription format = (FormatDescription)definedFormats[j];
                String formatName = format.getBaseFormatName();
                if (!formatName.equals(name)) continue;
                SingleEntry entry = (SingleEntry)format;
                try {
                    String pattern = entry.getPattern(formatName, width);
                    if (pattern == null) continue;
                    FormatPattern fmt = new FormatPattern(name + width, pattern, name, width);
                    fmt.minMVAWidth = width;
                    return fmt;
                }
                catch (InvalidFormatException invalidFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

