/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.models.BufferHints;
import com.sas.models.CacheBase;
import com.sas.models.CacheException;
import com.sas.models.RB;
import com.sas.models.StaticCacheInterface;
import com.sas.text.Message;
import com.sas.util.Util;
import java.util.BitSet;

public class SequentialCache
extends CacheBase {
    public static final String RB_KEY = "SequentialCache.";
    private static boolean DEBUG = false;
    protected Object[] values;
    protected long offset;
    protected BitSet inUse;
    long lastFetchStart = -9223372036854775807L;
    long lastFetchEnd = Long.MAX_VALUE;

    public SequentialCache() {
        this(null);
    }

    public SequentialCache(StaticCacheInterface secondaryCache) {
        this(secondaryCache, 128, 16, 0, 25);
    }

    public SequentialCache(StaticCacheInterface secondaryCache, int maxSize, int lookAheadSize) {
        this(secondaryCache, maxSize, lookAheadSize, 0, 25);
    }

    public SequentialCache(StaticCacheInterface secondaryCache, int maxSize, int lookAheadSize, int thresholdType, int thresholdValue) {
        super(secondaryCache, maxSize, lookAheadSize, thresholdType, thresholdValue);
        this.init(maxSize);
    }

    private void init(int size) {
        this.inUse = new BitSet(size);
        this.values = new Object[size];
        this.offset = 0L;
    }

    protected final int index(long key) {
        return (int)(key + this.offset);
    }

    protected final int size() {
        return this.maxSize;
    }

    protected final long key(int index) {
        return (long)index - this.offset;
    }

    protected final boolean inCache(int index) {
        return index >= 0 && index < this.size() && this.inUse.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getFromCache(long key) throws CacheException {
        int index = this.index(key);
        if (this.inCache(index)) {
            return this.values[index];
        }
        this.inferReadDirection(key);
        if (this.getDirection() == 256 && this.inCache(index + 1)) {
            try {
                this.disableLookAhead();
                Object object = this.getFromSecondaryCache(key);
                return object;
            }
            finally {
                this.enableLookAhead();
            }
        }
        if (this.getDirection() == 512 && this.inCache(index - 1)) {
            try {
                this.disableLookAhead();
                Object object = this.getFromSecondaryCache(key);
                return object;
            }
            finally {
                this.enableLookAhead();
            }
        }
        return this.getFromSecondaryCache(key);
    }

    protected synchronized Object getFromSecondaryCache(long key) throws CacheException {
        this.inferReadDirection(key);
        if (this.lookAheadEnabled()) {
            boolean disabled = false;
            try {
                disabled = this.disableLookAhead();
                long[] keys = this.computeCacheKeyRange(key, key, this.lookAheadSize);
                if (DEBUG) {
                    System.out.println("secondaryCache.getFromCache(" + this.toString(keys) + ")");
                }
                this.lastFetchStart = keys[0];
                this.lastFetchEnd = keys[keys.length - 1];
                Object[] newValues = this.secondaryCache.getFromCache(keys, false);
                this.storeInCache(keys, newValues);
                int nKeys = Math.min(keys.length, newValues.length);
                for (int i = 0; i < nKeys; ++i) {
                    if (keys[i] != key) continue;
                    Object object = newValues[i];
                    return object;
                }
                throw new CacheException(Message.format(RB.getStringResource("keyNotInCache.ex.txt"), (Object)new Long(key)));
            }
            finally {
                if (disabled) {
                    this.enableLookAhead();
                }
            }
        }
        if (DEBUG) {
            System.out.println("secondaryCache.getFromCache(" + key + ")");
        }
        Object value = this.secondaryCache.getFromCache(key);
        this.lastFetchStart = this.lastFetchEnd = key;
        this.storeInCache(key, value);
        return value;
    }

    protected void inferReadDirection(long key) {
        int index = this.index(key);
        if (DEBUG) {
            System.out.println("inferReadDirection(" + key + "), index is " + index + ", leaning is " + this.leaning);
        }
        if (index < 0 || index < this.firstInCache()) {
            this.leanLeft();
        } else if (index > this.size() || index > this.lastInCache()) {
            this.leanRight();
        } else if (key < this.lastFetchStart) {
            this.leanLeft();
        } else if (key > this.lastFetchStart) {
            this.leanRight();
        }
    }

    protected void leanRight() {
        ++this.leaning;
        if (this.leaning - this.directionChangeThreshold >= 0) {
            this.setDirection(256);
            this.leaning = 0;
        }
    }

    protected void leanLeft() {
        --this.leaning;
        if (this.leaning + this.directionChangeThreshold <= 0) {
            this.setDirection(512);
            this.leaning = 0;
        }
    }

    protected int firstInCache() {
        for (int i = 0; i < this.maxSize; ++i) {
            if (!this.inUse.get(i)) continue;
            return i;
        }
        return 0;
    }

    protected int lastInCache() {
        for (int i = this.maxSize - 1; i >= 0; --i) {
            if (!this.inUse.get(i)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void setDirection(int newDirection) {
        int actual = this.getDirection();
        if (newDirection != actual) {
            if (DEBUG) {
                System.out.println("setDirection " + (newDirection == 512 ? "backwards" : "forwards"));
            }
            super.setDirection(newDirection);
            this.secondaryCache.useBufferHints(new BufferHints(16384, this.getDirection(), 0));
        }
    }

    @Override
    public synchronized Object[] getFromCache(long[] keys, boolean readFully) throws CacheException {
        int index;
        int i;
        int nFound = 0;
        int nKeys = keys.length;
        if (nKeys == 0) {
            return SequentialCache.nullObjectArray();
        }
        int blockStart = 0;
        int blockEnd = -1;
        boolean haveSubBlock = false;
        int nMisses = 0;
        for (int i2 = 0; i2 < nKeys; ++i2) {
            int index2 = this.index(keys[i2]);
            if (this.inCache(index2)) {
                ++nFound;
                continue;
            }
            ++nMisses;
            if (!haveSubBlock) {
                blockStart = i2;
                blockEnd = i2;
                haveSubBlock = true;
                continue;
            }
            if (i2 != blockEnd + 1) continue;
            blockEnd = i2;
        }
        if (nMisses > 0 && !(haveSubBlock &= blockEnd - blockStart + 1 == nMisses && nMisses > 1 && nMisses < nKeys)) {
            boolean surpassedThreshold;
            if (this.thresholdType == 1) {
                surpassedThreshold = nKeys - nFound > this.threshold;
            } else {
                boolean bl = surpassedThreshold = 100 * (nKeys - nFound) / nKeys > this.threshold;
            }
            if (surpassedThreshold) {
                if (DEBUG) {
                    System.out.println("secondaryCache.getFromCache(" + this.toString(keys) + "," + readFully + ")");
                }
                Object[] result = this.secondaryCache.getFromCache(keys, readFully);
                this.lastFetchStart = keys[0];
                this.lastFetchEnd = keys[keys.length - 1];
                this.storeInCache(keys, result);
                if (DEBUG) {
                    for (i = 0; i < result.length; ++i) {
                        System.out.println("result[i]0-----------------------" + result[i]);
                    }
                }
                return result;
            }
        } else {
            this.lastFetchStart = keys[0];
            this.lastFetchEnd = keys[keys.length - 1];
        }
        Object[] result = new Object[keys.length];
        int len = keys.length;
        for (i = 0; i < len; ++i) {
            index = this.index(keys[i]);
            if (!this.inCache(index)) continue;
            result[i] = this.values[index];
        }
        if (DEBUG) {
            for (i = 0; i < result.length; ++i) {
                System.out.println("result[i]1-----------------------" + result[i]);
            }
        }
        if (nFound == keys.length) {
            return result;
        }
        if (haveSubBlock) {
            long[] subKeys = new long[nMisses];
            System.arraycopy(keys, blockStart, subKeys, 0, nMisses);
            Object[] subResult = this.getFromCache(subKeys, readFully);
            if (subResult.length < nMisses) {
                result = Util.resizeArray(result, blockStart + subResult.length);
            }
            System.arraycopy(subResult, 0, result, blockStart, subResult.length);
        } else {
            try {
                len = keys.length;
                for (i = 0; i < len; ++i) {
                    index = this.index(keys[i]);
                    if (this.inCache(index)) continue;
                    result[i] = this.getFromSecondaryCache(keys[i]);
                }
            }
            catch (CacheException e) {
                if (readFully) {
                    throw e;
                }
                result = Util.resizeArray(result, i - 1);
            }
        }
        if (DEBUG) {
            for (int i3 = 0; i3 < result.length; ++i3) {
                System.out.println("result[i]2-----------------------" + result[i3]);
            }
        }
        return result;
    }

    @Override
    public synchronized Object[] getFromCache(long startKey, long endKey, boolean readFully) throws CacheException {
        int i;
        int index;
        if (DEBUG) {
            System.out.println(" primaryCache: startKey:" + startKey + " endKey:" + endKey);
        }
        if (startKey == endKey && this.inCache(index = this.index(startKey))) {
            return new Object[]{this.values[index]};
        }
        int size = readFully ? 0 : this.lookAheadSize;
        long[] keys = this.computeCacheKeyRange(startKey, endKey, size);
        boolean same = true;
        long s = startKey;
        int len = keys.length;
        int i2 = 0;
        while (same && i2 < len) {
            boolean bl = same = keys[i2] == s;
            if (DEBUG) {
                System.out.println("keys[i]:" + keys[i2] + " i:" + i2 + " s:" + s);
            }
            ++i2;
            ++s;
        }
        Object[] results = this.getFromCache(keys, readFully);
        if (same && len > 0 && keys[len - 1] >= endKey) {
            return results;
        }
        boolean found = false;
        len = keys.length;
        for (i = 0; i < len && !(found = keys[i] == startKey); ++i) {
        }
        if (found) {
            return (Object[])Util.copyArray(results, i, Math.min(results.length, i + len));
        }
        throw new CacheException(Message.format(RB.getStringResource("keyNotInCache.ex.txt"), (Object)new Long(startKey)));
    }

    @Override
    public synchronized long[] computeCacheKeyRange(long start, long end, int size) throws CacheException {
        this.inferReadDirection(start);
        if (DEBUG) {
            System.out.println("secondaryCache.computeCachekeyRange(" + start + ", " + end + ", " + size + ")");
        }
        return this.secondaryCache.computeCacheKeyRange(start, end, size);
    }

    public String toString(long[] keys) {
        StringBuffer b = new StringBuffer();
        b.append("{");
        for (long key : keys) {
            b.append(key);
            b.append(",");
        }
        b.append("}");
        return b.toString();
    }

    public static synchronized long[] computeDirectionalCacheKeyRange(long key, int size, int direction) throws CacheException {
        if (direction == 512) {
            return SequentialCache.computeSequentialKeyRange(key - (long)size + 1L, key, size);
        }
        return SequentialCache.computeSequentialKeyRange(key, key + (long)size - 1L, size);
    }

    public static long[] computeSequentialKeyRange(long start, long end, int size) {
        int nKeys = Math.max((int)(end - start) + 1, size);
        long[] keys = new long[nKeys];
        for (int i = nKeys - 1; i >= 0; --i) {
            keys[i] = start + (long)i;
        }
        return keys;
    }

    public static long[] computeSequentialKeyRange(long start, long end) {
        return SequentialCache.computeSequentialKeyRange(start, end, 0);
    }

    @Override
    public synchronized long[] getCacheKeys() throws CacheException {
        int n = 0;
        for (int index = this.size() - 1; index >= 0; --index) {
            if (!this.inUse.get(index)) continue;
            ++n;
        }
        long[] keys = new long[n];
        int size = this.size();
        int j = 0;
        for (int index = 0; index < size; ++index) {
            if (!this.inUse.get(index)) continue;
            keys[j++] = this.key(index);
        }
        return keys;
    }

    @Override
    public synchronized boolean cacheContainsKey(long key) throws CacheException {
        return this.inCache(this.index(key));
    }

    @Override
    public synchronized void invalidateCache() {
        for (int index = this.size() - 1; index >= 0; --index) {
            this.inUse.clear(index);
            this.values[index] = null;
        }
        this.count = 0;
    }

    @Override
    public synchronized void invalidateCache(long key) throws CacheException {
        int index = this.index(key);
        if (this.inUse.get(index)) {
            --this.count;
            this.inUse.clear(index);
            this.values[index] = null;
        }
    }

    @Override
    public synchronized void storeInCache(long key, Object value) throws CacheException {
        int index = this.index(key);
        int s = this.size();
        if (index < 0 || index >= s) {
            this.accommodateKeys(key - (long)(s / 2), key);
            index = this.index(key);
        }
        this.storeInCacheQuickly(index, value);
    }

    protected void accommodateKeys(long startKey, long endKey) throws CacheException {
        long newOffset;
        int n;
        int to;
        int from;
        long startIndex = this.index(startKey);
        long endIndex = this.index(endKey);
        int size = this.size();
        if (startIndex >= 0L && endIndex < (long)size) {
            return;
        }
        if (endKey - startKey >= (long)size) {
            throw new CacheException(Message.format(RB.getStringResource("cacheOverflow.ex.txt"), (Object)new Long(endKey - startKey)));
        }
        long firstKey = this.key(0);
        boolean noOverlap = firstKey + (long)this.maxSize < startKey || endKey < firstKey;
        int delta = (int)Math.floor(((long)this.maxSize - (endKey - startKey + 1L)) / 2L);
        if (noOverlap) {
            this.invalidateCache();
            this.offset = -startKey;
            return;
        }
        if (startKey > firstKey) {
            from = this.index(startKey) - delta;
            to = 0;
            n = delta;
            newOffset = this.offset - (long)from;
        } else {
            from = (int)(endKey - firstKey + 1L);
            to = (int)((long)delta + (endKey - startKey) + 1L);
            n = (int)((long)this.maxSize - (endKey - startKey + 1L) - (long)delta);
            newOffset = (int)((long)delta - startKey);
        }
        if (DEBUG) {
            System.out.println("accommodateKeys(startKey=" + startKey + ", endKey=" + endKey + ")");
            System.out.println("accommodateKeys: offset was " + this.offset + ", becomes " + newOffset + ", size = " + this.maxSize);
            System.out.println("accommodateKeys: move " + n + " items from " + from + " to " + to);
        }
        BitSet oldBitSet = this.inUse;
        Object[] oldValues = this.values;
        this.offset = newOffset;
        this.inUse = new BitSet(size);
        this.values = new Object[size];
        while (n > 0) {
            if (oldBitSet.get(from)) {
                if (DEBUG) {
                    System.out.println("accommodateKeys:\tmove [" + oldValues[from] + "] from " + from + " to " + to);
                }
                this.storeInCacheQuickly(to, oldValues[from]);
            }
            ++from;
            ++to;
            --n;
        }
    }

    protected void storeInCacheQuickly(int index, Object value) throws CacheException {
        if (!this.inUse.get(index)) {
            ++this.count;
        }
        this.inUse.set(index);
        this.values[index] = value;
    }

    protected synchronized void storeInCache(long[] keys, Object[] newValues) throws CacheException {
        if (newValues.length == 0) {
            return;
        }
        int nKeys = newValues.length;
        int lastIndex = nKeys - 1;
        long lastKey = keys[nKeys - 1];
        if (this.direction == 512) {
            long minKey = lastKey - (long)this.size() + 1L;
            int firstIndex = nKeys - 1;
            int index = nKeys - 2;
            while (index >= 0 && keys[index] <= lastKey && keys[index] >= minKey) {
                firstIndex = index--;
            }
            this.accommodateKeys(keys[firstIndex], lastKey);
            for (index = firstIndex; index < nKeys; ++index) {
                this.storeInCacheQuickly(this.index(keys[index]), newValues[index]);
            }
        } else {
            long firstKey = keys[0];
            long maxKey = firstKey + (long)this.size() - 1L;
            lastIndex = 0;
            int firstIndex = 0;
            int index = 1;
            while (index < keys.length && keys[index] <= lastKey && keys[index] <= maxKey) {
                lastIndex = index++;
            }
            this.accommodateKeys(keys[0], keys[lastIndex]);
            for (index = firstIndex; index <= lastIndex; ++index) {
                this.storeInCacheQuickly(this.index(keys[index]), newValues[index]);
            }
        }
    }

    @Override
    public void useBufferHints(BufferHints hints) {
        while (hints != null) {
            try {
                if ((hints.how & 1) == 1) {
                    if (hints.what == 8192) {
                        this.configureCache(hints.count, -1, -1, -1, -1);
                    } else if (hints.what == 4096) {
                        this.configureCache(-1, hints.count, -1, -1, -1);
                    }
                }
                super.useBufferHints(hints);
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
            hints = hints.moreHints;
        }
    }

    @Override
    public synchronized void configureCache(int maxCacheSize, int bufferLookAhead, int thresholdType, int thresholdValue, int accessType) throws CacheException {
        if (maxCacheSize > this.values.length || maxCacheSize - this.values.length > this.values.length / 2) {
            BitSet newBitSet = new BitSet(maxCacheSize);
            int newCount = 0;
            int max = Math.min(this.maxSize, maxCacheSize);
            for (int i = 0; i < max; ++i) {
                if (!this.inUse.get(i)) continue;
                ++newCount;
                newBitSet.set(i);
            }
            this.values = Util.resizeArray(this.values, maxCacheSize);
            this.inUse = newBitSet;
            this.count = newCount;
        }
        super.configureCache(maxCacheSize, bufferLookAhead, thresholdType, thresholdValue, accessType);
    }
}

