/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.RB;
import com.sas.util.NumberUtil;
import com.sas.util.Strings;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableDecimalValueOptionInterface;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class DoubleType
extends BaseDataType {
    public static final DoubleType DEFAULT_INSTANCE = new DoubleType();
    public static final DoubleType DEFAULT_INSTANCE_TRUNCATE_NO_ERROR = new DoubleType(true);
    private static final int MAX_NUM_SIGNIFICANT_DIGITS = 15;
    private boolean truncateStringsWithoutError;

    public DoubleType() {
        this(false);
    }

    public DoubleType(boolean truncateStringsWithoutError) {
        this.truncateStringsWithoutError = truncateStringsWithoutError;
    }

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        block20: {
            if (inputValue instanceof List && ((List)inputValue).size() == 1) {
                inputValue = ((List)inputValue).get(0);
            }
            if (inputValue instanceof Double) {
                int precisionDigits;
                Double doubleObject = (Double)inputValue;
                String doubleString = doubleObject.toString();
                Double returnValue = doubleObject;
                if (doubleString.length() > 15 && (precisionDigits = NumberUtil.getPrecisionDigitCount(doubleString, Locale.US)) > 15) {
                    MathContext mc = new MathContext(15, RoundingMode.DOWN);
                    BigDecimal bigDecimal = new BigDecimal(doubleString, mc);
                    returnValue = new Double(bigDecimal.doubleValue());
                }
                return returnValue;
            }
            if (inputValue instanceof Float) {
                Double d = new Double(((Float)inputValue).floatValue() + "f");
                return d;
            }
            if (inputValue instanceof Number) {
                Double d = new Double(((Number)inputValue).doubleValue());
                return d;
            }
            if (inputValue instanceof ValueItem) {
                return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
            }
            if (inputValue instanceof String) {
                String trimmedInput = ((String)inputValue).trim();
                int trimmedInputLength = trimmedInput.length();
                if (trimmedInputLength == 0) {
                    return null;
                }
                MissingValues missingValue = MissingValues.getNumericMissingValues(trimmedInput);
                if (missingValue != null) {
                    return missingValue;
                }
                SpecialValues specialValue = SpecialValues.valueOf(trimmedInput);
                if (specialValue != null) {
                    return specialValue;
                }
                try {
                    int precisionDigits;
                    if (!this.truncateStringsWithoutError && trimmedInputLength > 15 && (precisionDigits = NumberUtil.getPrecisionDigitCount(trimmedInput, inputLocale)) > 15) {
                        throw new IllegalArgumentException(RB.getStringResource("DoubleType.max15digits.ex.txt", inputLocale));
                    }
                    NumberFormat formatter = NumberFormat.getNumberInstance(inputLocale);
                    ParsePosition position = new ParsePosition(0);
                    String parsedString = trimmedInput;
                    parsedString = parsedString.toUpperCase();
                    parsedString = Strings.replace(parsedString, 0, -1, "E+", "E");
                    Number number = formatter.parse(parsedString = BaseDataType.replaceBreakingSpace(formatter, parsedString), position);
                    if (number == null || position.getErrorIndex() != -1 || position.getIndex() != parsedString.length()) break block20;
                    boolean valid = true;
                    if (formatter instanceof DecimalFormat) {
                        valid = DoubleType.isGroupingValid((DecimalFormat)formatter, parsedString);
                    }
                    if (valid) {
                        return this.coerceValue(new Double(number.doubleValue()), inputLocale);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
                    return this.coerceValue(((String[])inputValue)[0], inputLocale);
                }
                if (inputValue instanceof MissingValues) {
                    return inputValue;
                }
                if (inputValue instanceof SpecialValues) {
                    return inputValue;
                }
                if (inputValue == null) {
                    return null;
                }
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource("DoubleType.unableToConvert.fmt", inputLocale), this.formatValueForException(inputValue, inputLocale)));
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)value).trim().length() == 0) {
            return null;
        }
        if (value instanceof MissingValues) {
            return MissingValues.toQueryString((MissingValues)value);
        }
        if (value instanceof SpecialValues) {
            return this.getSpecialValuesAsString((SpecialValues)value, outputLocale);
        }
        double d = (Double)value;
        return NumberUtil.toString(d, outputLocale);
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        return this.coerceValue(input, Locale.US);
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        if (value instanceof Double && ((Double)value).isNaN()) {
            return "NaN";
        }
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public int getSQLType() {
        return 8;
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        return this.coerceValue(value, inputLocale);
    }

    public String getDisplayString(Object value, Locale locale, int minimumDecimalDigits) {
        return this.padDecimalsPlaces(value, locale, minimumDecimalDigits);
    }

    public String padDecimalsPlaces(Object value, Locale locale, int minimumDecimalDigits) {
        return this.padDecimalsPlaces(value, locale, minimumDecimalDigits, false);
    }

    public String padDecimalsPlaces(Object value, Locale locale, int minimumDecimalDigits, boolean formatAsInteger) {
        String s = null;
        if (value != null && value instanceof Double) {
            Double num = (Double)value;
            double d = num;
            s = NumberUtil.toString(d, locale);
            if (minimumDecimalDigits > 0 && !num.isNaN() && !num.isInfinite() && s != null) {
                String lower = (s = s.trim()).toLowerCase();
                int eIndexOrEnd = lower.indexOf("e");
                if (eIndexOrEnd >= 0) {
                    return s;
                }
                for (int decimalCount = NumberUtil.getDecimalDigitCount(s, locale); decimalCount < minimumDecimalDigits; ++decimalCount) {
                    s = s + "0";
                }
            } else if (formatAsInteger && minimumDecimalDigits == 0 && IntegerType.isInteger(num)) {
                NumberFormat numFormat = NumberFormat.getInstance(locale);
                s = numFormat.format(num.intValue());
            }
        }
        return s;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        if (this.isSpecialMacroValue(value)) {
            return this.getMacroVariablesForSpecialValues(macroInfoSource, value);
        }
        int minDecimalPlaces = 0;
        if (macroInfoSource instanceof MacroVariableDecimalValueOptionInterface) {
            minDecimalPlaces = ((MacroVariableDecimalValueOptionInterface)((Object)macroInfoSource)).getMinimumDecimalPlaces();
        }
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(baseMacroVariableName, this.padDecimalsPlaces(value, Locale.US, minDecimalPlaces));
        return map;
    }
}

