/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.util.macrovar.BaseMacroInfoSource;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public abstract class BaseDataType
implements DataTypeInterface {
    public static final String SEPARATOR = " :: ";
    private static char breakingSpace = (char)32;

    @Override
    public List coerceValueToList(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object coercedValue = this.coerceValue(value, inputLocale);
        if (coercedValue instanceof List) {
            return (List)coercedValue;
        }
        ArrayList<Object> newList = new ArrayList<Object>(1);
        newList.add(coercedValue);
        return newList;
    }

    @Override
    public String getDisplayString(Object value, Locale outputLocale) {
        if (value instanceof MissingValues) {
            return MissingValues.toDisplayString((MissingValues)value, outputLocale);
        }
        if (value instanceof SpecialValues) {
            return SpecialValues.toDisplayString((SpecialValues)value, outputLocale);
        }
        String untrimmedValue = this.getValueAsString(value, outputLocale);
        if (untrimmedValue != null) {
            untrimmedValue = untrimmedValue.trim();
        }
        return untrimmedValue;
    }

    @Override
    public int getExpressionUsage() {
        return this.getSQLType();
    }

    @Override
    public Map getMacroVariableValues(String baseMacroVariableName, Object value) {
        return this.getMacroVariableValues(baseMacroVariableName, value, Locale.US);
    }

    @Override
    public Map getMacroVariableValues(String baseMacroVariableName, Object value, Locale locale) {
        BaseMacroInfoSource macroInfoSource = new BaseMacroInfoSource(baseMacroVariableName);
        return this.getMacroVariableValues(macroInfoSource, value, Locale.US);
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        if (this.isSpecialMacroValue(value)) {
            return this.getMacroVariablesForSpecialValues(macroInfoSource, value);
        }
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(baseMacroVariableName, this.getValueAsString(value, Locale.US));
        return map;
    }

    @Override
    public int getEstimatedMaxMacroVariableNameLength(String baseName) {
        int longest = 0;
        Collection extensions = this.getPossibleMacroVariableExtensions();
        for (String ext : extensions) {
            if (ext.length() <= longest) continue;
            longest = ext.length();
        }
        return baseName.length() + longest;
    }

    @Override
    public Collection getPossibleMacroVariableExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(1);
        extensions.add("");
        return extensions;
    }

    @Override
    public boolean isMacroVariablesIndexed() {
        return false;
    }

    @Override
    public Map getUnsetMacroVariableValues(MacroVariableOptionInterface macroInfoSource) {
        return this.newSingleItemMap(macroInfoSource.getMacroVariableBaseName(), "");
    }

    protected boolean isSpecialMacroValue(Object value) {
        return value == null || value instanceof MissingValues || value instanceof SpecialValues;
    }

    protected Map getMacroVariablesForSpecialValues(MacroVariableOptionInterface macroInfoSource, Object value) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (value == null) {
            return this.getMacroVariablesForNull(macroInfoSource);
        }
        if (value instanceof MissingValues) {
            return this.newSingleItemMap(baseMacroVariableName, MissingValues.toQueryString((MissingValues)value));
        }
        if (value instanceof SpecialValues) {
            if (value == SpecialValues.ALL) {
                return this.newSingleItemMap(baseMacroVariableName, "_ALL_VALUES_");
            }
            if (value == SpecialValues.OTHER) {
                return this.newSingleItemMap(baseMacroVariableName, "_OTHER_VALUES_");
            }
            throw new IllegalStateException();
        }
        return Collections.EMPTY_MAP;
    }

    protected Map getMacroVariablesForNull(MacroVariableOptionInterface macroInfoSource) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        return this.newSingleItemMap(baseMacroVariableName, "");
    }

    protected Map newSingleItemMap(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(key, value);
        return map;
    }

    protected String getSpecialValuesAsString(SpecialValues value, Locale outputLocale) {
        return value.toString(outputLocale);
    }

    static String replaceBreakingSpace(NumberFormat formatter, String parsedString) {
        DecimalFormatSymbols sym = ((DecimalFormat)formatter).getDecimalFormatSymbols();
        char gs = sym.getGroupingSeparator();
        if (Character.getType(gs) == 12) {
            parsedString = parsedString.replace(breakingSpace, gs);
        }
        return parsedString;
    }

    static boolean isGroupingValid(DecimalFormat formatter, String parsedString) {
        boolean valid = true;
        int groupSize = formatter.getGroupingSize();
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        int index = parsedString.indexOf(symbols.getDecimalSeparator());
        String intSide = parsedString;
        if (index >= 0) {
            intSide = parsedString.substring(0, index);
        }
        int cnt = 0;
        char groupChar = symbols.getGroupingSeparator();
        for (int i = intSide.length() - 1; i >= 0; --i) {
            char c = intSide.charAt(i);
            if (c == groupChar) {
                if (cnt % groupSize != 0) {
                    valid = false;
                    break;
                }
                cnt = 0;
                continue;
            }
            if (!Character.isDigit(c)) continue;
            ++cnt;
        }
        return valid;
    }

    protected Collection addExtensions(Collection extensions, String[] newExtensions) {
        if (newExtensions.length == 0) {
            if (extensions == null) {
                extensions = Collections.EMPTY_LIST;
            }
            return extensions;
        }
        if (extensions == null || extensions == Collections.EMPTY_LIST) {
            extensions = new ArrayList<String>(newExtensions.length);
        }
        if (extensions instanceof ArrayList) {
            extensions.ensureCapacity(extensions.size() + newExtensions.length);
        }
        int n = newExtensions.length;
        for (int i = 0; i < n; ++i) {
            if (extensions.contains(newExtensions[i])) continue;
            extensions.add(newExtensions[i]);
        }
        return extensions;
    }

    protected Object formatValueForException(Object value, Locale locale) {
        if (value instanceof Object[]) {
            value = Arrays.asList((Object[])value);
        }
        return value;
    }
}

