/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.PublicClonable;
import com.sas.util.Util;

class Entry
implements PublicClonable {
    long key;
    Object value;
    Entry next;

    public Entry() {
    }

    public Entry(long key, Object value, Entry next) {
        this.key = key;
        this.value = value;
        this.next = next;
    }

    Entry previous(long lookup) {
        Entry previous = this;
        Entry nextItem = this.next;
        while (nextItem != null) {
            if (nextItem.key == lookup) {
                return previous;
            }
            previous = nextItem;
            nextItem = previous.next;
        }
        return null;
    }

    Entry previous(Object item, boolean whenEquals) {
        Entry previous = this;
        Entry nextItem = this.next;
        if (whenEquals) {
            while (nextItem != null) {
                if (Util.equal(nextItem.value, item)) {
                    return previous;
                }
                previous = nextItem;
                nextItem = previous.next;
            }
        } else {
            while (nextItem != null) {
                if (nextItem.value == item) {
                    return previous;
                }
                previous = nextItem;
                nextItem = previous.next;
            }
        }
        return null;
    }

    int fill(Object[] array, int index) {
        int count = 0;
        Entry item = this.next;
        while (item != null) {
            array[index++] = item.value;
            ++count;
            item = item.next;
        }
        return count;
    }

    int fill(long[] array, int index) {
        int count = 0;
        Entry item = this.next;
        while (item != null) {
            array[index++] = item.key;
            ++count;
            item = item.next;
        }
        return count;
    }

    @Override
    public Object clone() {
        Entry clone = null;
        try {
            clone = (Entry)super.clone();
            clone.next = this.next == null ? null : (Entry)this.next.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return new Entry(this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }
        return clone;
    }
}

