/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.PublicClonable;
import com.sas.collection.IndexedEnumeration;
import com.sas.collection.RB;
import com.sas.util.Comparator;
import com.sas.util.Enumerable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class AVLNode
implements Serializable,
PublicClonable,
Enumerable {
    public static final String RB_KEY = "AVLNode.";
    static final long serialVersionUID = 3784226262729130827L;
    private static long counter;
    private Object obejct;
    private transient AVLNode left;
    private transient AVLNode right;
    private byte state;
    private transient long id;
    private static final int LEFT_THREAD = 1;
    private static final int RIGHT_THREAD = 2;
    private static final int THREAD_MASK = 3;
    private static final int NEGATIVE_BALANCE = 4;
    private static final int POSITIVE_BALANCE = 8;
    private static final int BALANCE_MASK = 12;

    public AVLNode() {
        this(null);
    }

    public AVLNode(Object object) {
        this.init();
        this.setLeftThread(null);
        this.setRightThread(null);
        this.setEvenBalance();
        this.setObject(object);
    }

    private void init() {
        this.id = counter++;
    }

    public void setObject(Object object) {
        this.obejct = object;
    }

    public Object getObject() {
        return this.obejct;
    }

    protected void setBalance(int balance) {
        if (balance == 0) {
            this.setEvenBalance();
        } else if (balance == -1) {
            this.setNegativeBalance();
        } else if (balance == 1) {
            this.setPositiveBalance();
        } else {
            throw new IllegalArgumentException("balance not in {-1, 0, +1}");
        }
    }

    protected int balance() {
        if (this.isNegativelyBalanced()) {
            return -1;
        }
        if (this.isPositivelyBalanced()) {
            return 1;
        }
        return 0;
    }

    protected void setNegativeBalance() {
        this.state = (byte)(this.state & 3 | 4);
    }

    protected void setPositiveBalance() {
        this.state = (byte)(this.state & 3 | 8);
    }

    protected void setEvenBalance() {
        this.state = (byte)(this.state & 3);
    }

    protected boolean isNegativelyBalanced() {
        return (this.state & 4) == 4;
    }

    protected boolean isPositivelyBalanced() {
        return (this.state & 8) == 8;
    }

    protected boolean isEvenlyBalanced() {
        return (this.state & 0xC) == 0;
    }

    public AVLNode leftLink() {
        return this.left;
    }

    protected void setLeftChild(AVLNode child, AVLNode thread) {
        if (child == null) {
            this.setLeftThread(thread);
        } else {
            this.setLeftChild(child);
        }
    }

    protected void setLeftChild(AVLNode child) {
        this.state = (byte)(this.state & 0xFFFFFFFE);
        this.left = child;
    }

    public AVLNode getLeftChild() {
        if (this.hasLeftThread()) {
            return null;
        }
        return this.leftLink();
    }

    public AVLNode getLeftThread() {
        if (this.hasLeftThread()) {
            return this.leftLink();
        }
        return null;
    }

    protected void setLeftThread(AVLNode prev) {
        this.state = (byte)(this.state | 1);
        this.left = prev;
    }

    protected boolean hasLeftThread() {
        return (this.state & 1) != 0;
    }

    public final boolean hasLeftChild() {
        return !this.hasLeftThread();
    }

    public AVLNode rightLink() {
        return this.right;
    }

    public AVLNode getRightChild() {
        if (this.hasRightThread()) {
            return null;
        }
        return this.rightLink();
    }

    public AVLNode getRightThread() {
        if (this.hasRightThread()) {
            return this.rightLink();
        }
        return null;
    }

    protected void setRightThread(AVLNode next) {
        this.state = (byte)(this.state | 2);
        this.right = next;
    }

    protected void setRightChild(AVLNode child, AVLNode thread) {
        if (child == null) {
            this.setRightThread(thread);
        } else {
            this.setRightChild(child);
        }
    }

    protected void setRightChild(AVLNode child) {
        this.state = (byte)(this.state & 0xFFFFFFFD);
        this.right = child;
    }

    protected boolean hasRightThread() {
        return (this.state & 2) != 0;
    }

    public final boolean hasRightChild() {
        return !this.hasRightThread();
    }

    public AVLNode getNextNode() {
        AVLNode node = this.rightLink();
        if (this.hasRightThread()) {
            return node;
        }
        return node.leftMostDescendent();
    }

    public AVLNode leftMostDescendent() {
        AVLNode node = this;
        while (node.hasLeftChild()) {
            node = node.getLeftChild();
        }
        return node;
    }

    public AVLNode getPreviousNode() {
        AVLNode node = this.leftLink();
        if (this.hasLeftThread()) {
            return node;
        }
        return node.rightMostDescendent();
    }

    public AVLNode rightMostDescendent() {
        AVLNode node = this;
        while (node.hasRightChild()) {
            node = node.getRightChild();
        }
        return node;
    }

    public static AVLNode search(Object object, AVLNode node, Comparator comparator) {
        if (node == null) {
            return null;
        }
        int compare = comparator.compare(object, node.getObject());
        switch (compare) {
            case 0: {
                return node;
            }
            case -1: {
                return AVLNode.search(object, node.getLeftChild(), comparator);
            }
            case 1: {
                return AVLNode.search(object, node.getRightChild(), comparator);
            }
        }
        return null;
    }

    public static AVLNode add(Object object, AVLNode root, Comparator comparator, boolean allowDuplicates) {
        return AVLNode.add(new AVLNode(object), root, comparator, allowDuplicates);
    }

    public static AVLNode add(AVLNode node, AVLNode root, Comparator comparator, boolean allowDuplicates) {
        int a;
        if (root == null) {
            root = node;
            node.setLeftThread(null);
            node.setRightThread(null);
            node.setEvenBalance();
            return root;
        }
        AVLNode p = root;
        AVLNode q = null;
        AVLNode s = root;
        AVLNode t = null;
        long cmap = 0L;
        long gt = 1L;
        while (true) {
            int compare;
            if (((compare = comparator.compare(node.getObject(), p.getObject())) == 0 || compare == Integer.MAX_VALUE) && allowDuplicates) {
                int n = node.id < p.id ? -1 : (compare = node.id > p.id ? 1 : 0);
                if (compare == 0) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "duplicatesNotAllowed.ex.txt"));
                }
            }
            if (compare == -1) {
                AVLNode ll = p.leftLink();
                if (p.hasLeftThread()) {
                    node.setLeftThread(ll);
                    node.setRightThread(p);
                    p.setLeftChild(node);
                    break;
                }
                q = ll;
            } else if (compare == 1) {
                cmap |= gt;
                AVLNode rl = p.rightLink();
                if (p.hasRightThread()) {
                    node.setRightThread(rl);
                    node.setLeftThread(p);
                    p.setRightChild(node);
                    break;
                }
                q = rl;
            } else {
                return null;
            }
            if (!q.isEvenlyBalanced()) {
                s = q;
                t = p;
                cmap = 0L;
                gt = 1L;
            } else {
                gt <<= 1;
            }
            p = q;
        }
        node.setEvenBalance();
        if ((cmap & 1L) != 0L) {
            a = 1;
            q = p = s.rightLink();
        } else {
            a = -1;
            q = p = s.leftLink();
        }
        gt = 2L;
        while (p != node) {
            if ((cmap & gt) != 0L) {
                p.setPositiveBalance();
                p = p.rightLink();
            } else {
                p.setNegativeBalance();
                p = p.leftLink();
            }
            gt <<= 1;
        }
        if (s.isEvenlyBalanced()) {
            s.setBalance(a);
            return root;
        }
        if (s.balance() == -a) {
            s.setEvenBalance();
            return root;
        }
        s.setEvenBalance();
        if (q.balance() == a) {
            q.setEvenBalance();
            p = q;
            if (a > 0) {
                if (q.hasLeftThread()) {
                    s.setRightThread(q);
                } else {
                    s.setRightChild(q.leftLink());
                }
                q.setLeftChild(s);
            } else {
                if (q.hasRightThread()) {
                    s.setLeftThread(q);
                } else {
                    s.setLeftChild(q.rightLink());
                }
                q.setRightChild(s);
            }
        } else {
            q.setEvenBalance();
            if (a > 0) {
                p = q.leftLink();
                if (p.hasRightThread()) {
                    q.setLeftThread(p);
                } else {
                    q.setLeftChild(p.rightLink());
                }
                p.setRightChild(q);
                if (p.hasLeftThread()) {
                    s.setRightThread(p);
                } else {
                    s.setRightChild(p.leftLink());
                }
                p.setLeftChild(s);
            } else {
                p = q.rightLink();
                if (p.hasLeftThread()) {
                    q.setRightThread(p);
                } else {
                    q.setRightChild(p.leftLink());
                }
                p.setLeftChild(q);
                if (p.hasRightThread()) {
                    s.setLeftThread(p);
                } else {
                    s.setLeftChild(p.rightLink());
                }
                p.setRightChild(s);
            }
            if (p.balance() == a) {
                s.setBalance(-a);
            } else if (!p.isEvenlyBalanced()) {
                q.setBalance(a);
            }
            p.setEvenBalance();
        }
        if (t == null) {
            root = p;
        } else if (t.rightLink() == s) {
            t.setRightChild(p);
        } else {
            t.setLeftChild(p);
        }
        return root;
    }

    @Override
    public Enumeration getItems() {
        return this.getItems(false);
    }

    public Enumeration getItems(int start, int end) {
        return new IndexedEnumeration(this.getItems(false), start, end);
    }

    public Cursor getItems(boolean reversedOrder) {
        return new Cursor(this, reversedOrder);
    }

    static AVLNode[] remove(AVLNode root, Object x, Comparator comparator, long id) {
        Env env = new Env(root, false, comparator, id);
        AVLNode.remove(x, env, null, null);
        if (env.deleted) {
            return new AVLNode[]{env.p};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(Object x, Env env, AVLNode leftThread, AVLNode rightThread) {
        if (env.p == null) {
            env.h = false;
            return;
        }
        int result = env.comparator.compare(x, env.p.getObject());
        if (result < 0) {
            AVLNode p = env.p;
            try {
                env.p = env.p.getLeftChild();
                AVLNode.remove(x, env, leftThread, p);
                AVLNode newRoot = env.p;
                p.setLeftChild(newRoot, leftThread);
                if (newRoot != null && newRoot.hasRightThread()) {
                    newRoot.setRightThread(p);
                }
            }
            finally {
                env.p = p;
            }
            if (env.h) {
                AVLNode.balance1(env);
            }
        } else if (result > 0) {
            AVLNode p = env.p;
            try {
                env.p = env.p.getRightChild();
                AVLNode.remove(x, env, p, rightThread);
                AVLNode newRoot = env.p;
                p.setRightChild(newRoot, rightThread);
                if (newRoot != null && newRoot.hasLeftThread()) {
                    newRoot.setLeftThread(p);
                }
            }
            finally {
                env.p = p;
            }
            if (env.h) {
                AVLNode.balance2(env);
            }
        } else {
            env.deleted = true;
            AVLNode q = env.p;
            if (!q.hasRightChild()) {
                env.p = q.getLeftChild();
                if (env.p != null) {
                    env.p.setRightThread(rightThread);
                }
                env.h = true;
            } else if (!q.hasLeftChild()) {
                env.p = q.getRightChild();
                if (env.p != null) {
                    env.p.setLeftThread(leftThread);
                }
                env.h = true;
            } else {
                AVLNode p = env.p;
                try {
                    env.p = q.getLeftChild();
                    AVLNode.del(q, rightThread, env);
                    q.setLeftChild(env.p, leftThread);
                }
                finally {
                    env.p = p;
                }
                if (env.h) {
                    AVLNode.balance1(env);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void del(AVLNode q, AVLNode rightThread, Env env) {
        AVLNode p = env.p;
        AVLNode right = p.getRightChild();
        if (right != null) {
            try {
                env.p = right;
                AVLNode.del(q, rightThread, env);
                p.setRightChild(env.p, q);
            }
            finally {
                env.p = p;
            }
            if (env.h) {
                AVLNode.balance2(env);
            }
        } else {
            q.setObject(env.p.getObject());
            AVLNode leftChild = env.p.getLeftChild();
            if (leftChild != null) {
                leftChild.setRightThread(q);
            }
            env.p = leftChild;
            env.h = true;
        }
    }

    private static void balance1(Env env) {
        switch (env.p.balance()) {
            case -1: {
                env.p.setEvenBalance();
                break;
            }
            case 0: {
                env.p.setPositiveBalance();
                env.h = false;
                break;
            }
            case 1: {
                AVLNode p1 = env.p.getRightChild();
                int b1 = p1.balance();
                if (b1 >= 0) {
                    env.p.setRightChild(p1.getLeftChild(), p1);
                    p1.setLeftChild(env.p);
                    if (b1 == 0) {
                        env.p.setPositiveBalance();
                        p1.setNegativeBalance();
                        env.h = false;
                    } else {
                        env.p.setEvenBalance();
                        p1.setEvenBalance();
                    }
                    env.p = p1;
                    break;
                }
                AVLNode p2 = p1.getLeftChild();
                int b2 = p2.balance();
                p1.setLeftChild(p2.getRightChild(), p2);
                p2.setRightChild(p1);
                env.p.setRightChild(p2.getLeftChild(), p2);
                p2.setLeftChild(env.p);
                if (b2 == 1) {
                    env.p.setNegativeBalance();
                } else {
                    env.p.setEvenBalance();
                }
                if (b2 == -1) {
                    p1.setPositiveBalance();
                } else {
                    p1.setEvenBalance();
                }
                env.p = p2;
                p2.setEvenBalance();
            }
        }
    }

    private static void balance2(Env env) {
        switch (env.p.balance()) {
            case 1: {
                env.p.setEvenBalance();
                break;
            }
            case 0: {
                env.p.setNegativeBalance();
                env.h = false;
                break;
            }
            case -1: {
                AVLNode p1 = env.p.getLeftChild();
                int b1 = p1.balance();
                if (b1 <= 0) {
                    env.p.setLeftChild(p1.getRightChild(), p1);
                    p1.setRightChild(env.p);
                    if (b1 == 0) {
                        env.p.setNegativeBalance();
                        p1.setPositiveBalance();
                        env.h = false;
                    } else {
                        env.p.setEvenBalance();
                        p1.setEvenBalance();
                    }
                    env.p = p1;
                    break;
                }
                AVLNode p2 = p1.getRightChild();
                int b2 = p2.balance();
                p1.setRightChild(p2.getLeftChild(), p2);
                p2.setLeftChild(p1);
                env.p.setLeftChild(p2.getRightChild(), p2);
                p2.setRightChild(env.p);
                if (b2 == -1) {
                    env.p.setPositiveBalance();
                } else {
                    env.p.setEvenBalance();
                }
                if (b2 == 1) {
                    p1.setNegativeBalance();
                } else {
                    p1.setEvenBalance();
                }
                env.p = p2;
                p2.setEvenBalance();
            }
        }
    }

    public static AVLNode find(AVLNode root, Object object, Comparator comparator) {
        while (root != null) {
            int result = comparator.compare(object, root.getObject());
            if (result < 0) {
                root = root.getLeftChild();
                continue;
            }
            if (result <= 0) break;
            root = root.getRightChild();
        }
        return root;
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean printValue, boolean showThreads) {
        StringBuffer b = new StringBuffer();
        if (printValue) {
            b.append(this.getObject());
        }
        b.append("#");
        b.append(this.id);
        switch (this.balance()) {
            case -1: {
                b.append("[-]");
                break;
            }
            case 0: {
                b.append("[ ]");
                break;
            }
            case 1: {
                b.append("[+]");
                break;
            }
            default: {
                b.append("[****");
                b.append(this.balance());
                b.append("****]");
            }
        }
        if (showThreads) {
            if (this.hasLeftThread()) {
                b.append(" left:");
                b.append(this.getLeftThread().toString(printValue, false));
            }
            if (this.hasRightThread()) {
                b.append(" right:");
                b.append(this.getRightThread().toString(printValue, false));
            }
        }
        return b.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AVLNode clone = (AVLNode)super.clone();
        clone.init();
        return clone;
    }

    AVLNode clone(AVLNode[] nodes) throws CloneNotSupportedException {
        AVLNode clone = (AVLNode)this.clone();
        if (this.hasLeftChild()) {
            AVLNode leftClone;
            nodes[1] = clone;
            nodes[0] = leftClone = this.getLeftChild().clone(nodes);
            clone.setLeftChild(leftClone);
            nodes[1].setRightThread(clone);
        } else {
            clone.setLeftThread(nodes[0]);
            nodes[0] = clone;
        }
        if (this.hasRightChild()) {
            AVLNode temp = nodes[0];
            nodes[0] = clone;
            AVLNode rightClone = this.getRightChild().clone(nodes);
            clone.setRightChild(rightClone);
            nodes[0] = temp;
        } else {
            nodes[1] = clone;
        }
        return clone;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.left = (AVLNode)stream.readObject();
        this.init();
        this.right = (AVLNode)stream.readObject();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.left);
        stream.writeObject(this.right);
    }

    public static class Cursor
    implements Enumeration {
        private AVLNode node;
        private boolean reversedOrder;

        public Cursor(AVLNode root, boolean reversedOrder) {
            this.reversedOrder = reversedOrder;
            if (root == null) {
                this.node = null;
            } else if (reversedOrder) {
                this.node = new AVLNode();
                this.node.setLeftThread(root.rightMostDescendent());
            } else {
                this.node = new AVLNode();
                this.node.setRightThread(root.leftMostDescendent());
            }
        }

        @Override
        public boolean hasMoreElements() {
            if (this.reversedOrder) {
                return this.hasBackwardElement();
            }
            return this.hasForwardElement();
        }

        public Object nextElement() {
            if (this.reversedOrder) {
                return this.backwardElement();
            }
            return this.forwardElement();
        }

        public boolean hasForwardElement() {
            return this.node != null && this.node.right != null;
        }

        public Object forwardElement() {
            try {
                this.node = this.node.getNextNode();
                return this.node.getObject();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                throw new NoSuchElementException(e.getMessage());
            }
        }

        public boolean hasBackwardElement() {
            return this.node != null && this.node.left != null;
        }

        public Object backwardElement() {
            try {
                this.node = this.node.getPreviousNode();
                return this.node.getObject();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                throw new NoSuchElementException(e.getMessage());
            }
        }
    }

    static class Env {
        AVLNode p;
        boolean h;
        Comparator comparator;
        boolean deleted;
        long id;

        Env(AVLNode node, boolean h, Comparator comparator, long id) {
            this.p = node;
            this.h = h;
            this.comparator = comparator;
            this.deleted = false;
            this.id = id;
        }
    }
}

