/*
 * Decompiled with CFR 0.152.
 */
package com.sas.beans;

import com.sas.ComponentException;
import com.sas.GlobalInfoTable;
import com.sas.beans.Introspector;
import com.sas.beans.PropertyChangeSource;
import com.sas.beans.RB;
import com.sas.security.BaseSecuritySupport;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Map;
import java.util.WeakHashMap;

public class Util {
    private static Map designTimeTable;

    public static PropertyDescriptor getPropertyDescriptor(Object bean, String property) {
        Class<?> cl = bean.getClass();
        return Util.getPropertyDescriptor(cl, property);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class cl, String property) {
        try {
            BeanInfo sourceBeanInfo = Introspector.getBeanInfo(cl);
            PropertyDescriptor propertyDescriptor = Introspector.getPropertyDescriptor(property, sourceBeanInfo);
            if (propertyDescriptor == null) {
                String errorMessage = RB.getStringResource("Util.unableToGetPropertyDescriptor.ex.txt");
                throw new ComponentException(MessageFormat.format(errorMessage, property));
            }
            return propertyDescriptor;
        }
        catch (Exception e) {
            String errorMessage = RB.getStringResource("Util.errorLookingUpPropertyInformation.ex.txt");
            System.out.println(MessageFormat.format(errorMessage, e.toString()));
            e.printStackTrace();
            return null;
        }
    }

    public static Class getPropertyType(Object bean, String property) {
        try {
            BeanInfo sourceBeanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor propertyDescriptor = Introspector.getPropertyDescriptor(property, sourceBeanInfo);
            if (propertyDescriptor == null) {
                String errorMessage = RB.getStringResource("Util.unableToGetPropertyDescriptor.ex.txt");
                throw new ComponentException(MessageFormat.format(errorMessage, property));
            }
            return propertyDescriptor.getPropertyType();
        }
        catch (Exception e) {
            String errorMessage = RB.getStringResource("Util.errorLookingUpPropertyInformation.ex.txt");
            System.out.println(MessageFormat.format(errorMessage, e.toString()));
            e.printStackTrace();
            return null;
        }
    }

    public static Class getIndexedPropertyType(Object bean, String property, int index) {
        try {
            BeanInfo sourceBeanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor propertyDescriptor = Introspector.getPropertyDescriptor(property, sourceBeanInfo);
            if (propertyDescriptor == null) {
                String errorMessage = RB.getStringResource("Util.unableToGetPropertyDescriptor.ex.txt");
                throw new ComponentException(MessageFormat.format(errorMessage, property));
            }
            if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                return ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedPropertyType();
            }
            return null;
        }
        catch (Exception e) {
            String errorMessage = RB.getStringResource("Util.errorLookingUpPropertyInformation.ex.txt");
            System.out.println(MessageFormat.format(errorMessage, e.toString()));
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPropertyValue(Object bean, String property) {
        try {
            BeanInfo sourceBeanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor propertyDescriptor = Introspector.getPropertyDescriptor(property, sourceBeanInfo);
            if (propertyDescriptor == null) {
                String errorMessage = RB.getStringResource("Util.unableToGetPropertyDescriptor.ex.txt");
                throw new ComponentException(MessageFormat.format(errorMessage, property));
            }
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod == null) {
                String errorMessage = RB.getStringResource("Util.unableToGetReadMethod.ex.txt");
                throw new ComponentException(MessageFormat.format(errorMessage, property));
            }
            return BaseSecuritySupport.securitySupport.invokeMethod(readMethod, bean, null);
        }
        catch (ComponentException sourceBeanInfo) {
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable realException = ((InvocationTargetException)e).getTargetException();
                String errorMessage = RB.getStringResource("Util.unableToGetPropertyDescriptor.ex.txt");
                System.out.println(MessageFormat.format(errorMessage, realException.toString()));
                realException.printStackTrace();
            }
            String errorMessage = RB.getStringResource("Util.errorLookingUpPropertyInformation.ex.txt");
            System.out.println(MessageFormat.format(errorMessage, e.toString()));
            e.printStackTrace();
        }
        return null;
    }

    public static Object getIndexedPropertyValue(Object bean, String property, int index) {
        try {
            BeanInfo sourceBeanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor propertyDescriptor = Introspector.getPropertyDescriptor(property, sourceBeanInfo);
            if (propertyDescriptor == null) {
                String errorMessage = RB.getStringResource("Util.unableToGetPropertyDescriptor.ex.txt");
                throw new ComponentException(MessageFormat.format(errorMessage, property));
            }
            if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                Method readMethod = ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod();
                Object[] params = new Object[]{new Integer(index)};
                return BaseSecuritySupport.securitySupport.invokeMethod(readMethod, bean, params);
            }
            String errorMessage = RB.getStringResource("Util.unableToGetIndexedReadMethod.ex.txt");
            throw new ComponentException(MessageFormat.format(errorMessage, property));
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable realException = ((InvocationTargetException)e).getTargetException();
                String errorMessage = RB.getStringResource("Util.errorLookingUpPropertyInformation.ex.txt");
                System.out.println(MessageFormat.format(errorMessage, realException.toString()));
                realException.printStackTrace();
            } else {
                String errorMessage = RB.getStringResource("Util.errorLookingUpPropertyInformation.ex.txt");
                System.out.println(MessageFormat.format(errorMessage, e.toString()));
                e.printStackTrace();
            }
            return null;
        }
    }

    public static void setPropertyValue(Object bean, String property, Object value) {
        try {
            BeanInfo sourceBeanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor propertyDescriptor = Introspector.getPropertyDescriptor(property, sourceBeanInfo);
            if (propertyDescriptor == null) {
                String errorMessage = RB.getStringResource("Util.unableToGetPropertyDescriptor.ex.txt");
                throw new ComponentException(MessageFormat.format(errorMessage, property));
            }
            if (propertyDescriptor.getWriteMethod() == null) {
                String errorMessage = RB.getStringResource("Util.unableToGetWriteMethod.ex.txt");
                throw new ComponentException(MessageFormat.format(errorMessage, property));
            }
            Object[] params = new Object[]{value};
            BaseSecuritySupport.securitySupport.invokeMethod(propertyDescriptor.getWriteMethod(), bean, params);
        }
        catch (Exception e) {
            String errorMessage2 = RB.getStringResource("Util.setPropertyValue.ex.txt");
            System.out.println(MessageFormat.format(errorMessage2, property));
            if (e instanceof InvocationTargetException) {
                Throwable realException = ((InvocationTargetException)e).getTargetException();
                String errorMessage = RB.getStringResource("Util.errorLookingUpPropertyInformation.ex.txt");
                System.out.println(MessageFormat.format(errorMessage, realException.toString()));
                realException.printStackTrace();
            }
            String errorMessage = RB.getStringResource("Util.errorLookingUpPropertyInformation.ex.txt");
            System.out.println(MessageFormat.format(errorMessage, e.toString()));
            e.printStackTrace();
        }
    }

    public static void setIndexedPropertyValue(Object bean, String property, Object value, int index) {
        try {
            BeanInfo sourceBeanInfo = Introspector.getBeanInfo(bean.getClass());
            IndexedPropertyDescriptor propertyDescriptor = (IndexedPropertyDescriptor)Introspector.getPropertyDescriptor(property, sourceBeanInfo);
            if (propertyDescriptor == null) {
                String errorMessage = RB.getStringResource("Util.unableToGetPropertyDescriptor.ex.txt");
                throw new ComponentException(MessageFormat.format(errorMessage, property));
            }
            if (propertyDescriptor.getIndexedWriteMethod() == null) {
                String errorMessage = RB.getStringResource("Util.unableToGetIndexedWriteMethod.ex.txt");
                throw new ComponentException(MessageFormat.format(errorMessage, property));
            }
            Object[] params = new Object[]{new Integer(index), value};
            BaseSecuritySupport.securitySupport.invokeMethod(propertyDescriptor.getIndexedWriteMethod(), bean, params);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable realException = ((InvocationTargetException)e).getTargetException();
                String errorMessage = RB.getStringResource("Util.unableToGetPropertyDescriptor.ex.txt");
                System.out.println(MessageFormat.format(errorMessage, realException.toString()));
                realException.printStackTrace();
            }
            String errorMessage = RB.getStringResource("Util.errorLookingUpPropertyInformation.ex.txt");
            System.out.println(MessageFormat.format(errorMessage, e.toString()));
            e.printStackTrace();
        }
    }

    public static Class getPropertyEditorClass(Object bean, String property) {
        try {
            BeanInfo sourceBeanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor propertyDescriptor = Introspector.getPropertyDescriptor(property, sourceBeanInfo);
            if (propertyDescriptor == null) {
                String errorMessage = RB.getStringResource("Util.unableToGetPropertyDescriptor.ex.txt");
                throw new ComponentException(MessageFormat.format(errorMessage, property));
            }
            return propertyDescriptor.getPropertyEditorClass();
        }
        catch (Exception e) {
            String errorMessage = RB.getStringResource("Util.errorLookingUpPropertyInformation.ex.txt");
            System.out.println(MessageFormat.format(errorMessage, e.toString()));
            e.printStackTrace();
            return null;
        }
    }

    public static boolean addPropertyChangeListener(Object object, PropertyChangeListener listener) {
        if (object instanceof PropertyChangeSource) {
            PropertyChangeSource source = (PropertyChangeSource)object;
            source.addPropertyChangeListener(listener);
            return true;
        }
        if (object.getClass().getName().startsWith("java.lang.")) {
            return false;
        }
        return Util.addEventListener(PropertyChangeListener.class, "addPropertyChangeListener", object, listener);
    }

    public static boolean removePropertyChangeListener(Object object, PropertyChangeListener listener) {
        if (object instanceof PropertyChangeSource) {
            PropertyChangeSource source = (PropertyChangeSource)object;
            source.removePropertyChangeListener(listener);
            return true;
        }
        if (object.getClass().getName().startsWith("java.lang.")) {
            return false;
        }
        return Util.removeEventListener(PropertyChangeListener.class, "removePropertyChangeListener", object, listener);
    }

    public static boolean addEventListener(Class listenerClass, String addListenerMethod, Object object, PropertyChangeListener listener) {
        Object[] params = new Object[]{listener};
        try {
            Class[] argTypes = new Class[]{listenerClass};
            Method method = BaseSecuritySupport.securitySupport.getMethod(object.getClass(), addListenerMethod, argTypes);
            BaseSecuritySupport.securitySupport.invokeMethod(method, object, params);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean removeEventListener(Class listenerClass, String removeListenerMethod, Object object, PropertyChangeListener listener) {
        Object[] params = new Object[]{listener};
        try {
            Class[] argTypes = new Class[]{listenerClass};
            Method method = BaseSecuritySupport.securitySupport.getMethod(object.getClass(), removeListenerMethod, argTypes);
            BaseSecuritySupport.securitySupport.invokeMethod(method, object, params);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void prependToPropertyEditorSearchPath(String path) {
        Util.specifyModelEditor();
        String[] searchPath = PropertyEditorManager.getEditorSearchPath();
        for (int i = 0; i < searchPath.length; ++i) {
            if (!searchPath[i].equals(path)) continue;
            return;
        }
        String[] newSearchPath = new String[searchPath.length + 1];
        System.arraycopy(searchPath, 0, newSearchPath, 1, searchPath.length);
        newSearchPath[0] = path;
        final String[] newSearchPathFinal = newSearchPath;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PropertyEditorManager.setEditorSearchPath(newSearchPathFinal);
                return null;
            }
        });
    }

    public static void prependToBeanInfoSearchPath(String path) {
        String[] searchPath = java.beans.Introspector.getBeanInfoSearchPath();
        for (int i = 0; i < searchPath.length; ++i) {
            if (!searchPath[i].equals(path)) continue;
            return;
        }
        String[] newSearchPath = new String[searchPath.length + 1];
        System.arraycopy(searchPath, 0, newSearchPath, 1, searchPath.length);
        newSearchPath[0] = path;
        final String[] newSearchPathFinal = newSearchPath;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                java.beans.Introspector.setBeanInfoSearchPath(newSearchPathFinal);
                return null;
            }
        });
    }

    public static void specifyModelEditor() {
        Util.prependToBeanInfoSearchPath("com.sas.beans.beaninfos");
        try {
            Class[] swingClasses = new Class[]{GlobalInfoTable.loadClass("javax.swing.JButton"), GlobalInfoTable.loadClass("javax.swing.JCheckBox"), GlobalInfoTable.loadClass("javax.swing.JList"), GlobalInfoTable.loadClass("javax.swing.JComboBox"), GlobalInfoTable.loadClass("javax.swing.JProgressBar"), GlobalInfoTable.loadClass("javax.swing.JRadioButton"), GlobalInfoTable.loadClass("javax.swing.JScrollBar"), GlobalInfoTable.loadClass("javax.swing.JSlider"), GlobalInfoTable.loadClass("javax.swing.JToggleButton"), GlobalInfoTable.loadClass("javax.swing.JTree"), GlobalInfoTable.loadClass("javax.swing.JTabbedPane"), GlobalInfoTable.loadClass("javax.swing.JTable")};
            Class<?> propertyType = null;
            String modelEditor = "com.sas.beans.editors._javaxSwingModelEditor";
            for (int i = 0; i < swingClasses.length; ++i) {
                BeanInfo sourceBeanInfo = Introspector.getBeanInfo(swingClasses[i]);
                PropertyDescriptor propertyDescriptor = Introspector.getPropertyDescriptor("model", sourceBeanInfo);
                if (propertyDescriptor == null) continue;
                propertyType = propertyDescriptor.getPropertyType();
                PropertyEditorManager.registerEditor(propertyType, GlobalInfoTable.loadClass(modelEditor));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void setDesignTime(boolean designTime) {
        if (designTimeTable == null) {
            designTimeTable = new WeakHashMap();
        }
        designTimeTable.put(Thread.currentThread(), designTime ? Boolean.TRUE : Boolean.FALSE);
    }

    public static synchronized boolean isDesignTime() {
        if (designTimeTable == null) {
            return false;
        }
        Boolean designTimeBoolean = (Boolean)designTimeTable.get(Thread.currentThread());
        if (designTimeBoolean == null) {
            return false;
        }
        return designTimeBoolean;
    }
}

