/*
 * Decompiled with CFR 0.152.
 */
package com.sas.beans;

import com.sas.GlobalInfoTable;
import com.sas.beans.BeanDescriptor;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.IndexedPropertyDescriptor;
import com.sas.beans.PropertyDescriptor;
import com.sas.beans.PropertyMetadata;
import com.sas.beans.RB;
import com.sas.beans.SimpleBeanInfo;
import com.sas.collection.Pair;
import com.sas.security.BaseSecuritySupport;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;

public class Introspector {
    public static final String RB_KEY = "Introspector.";
    public static final String DEFAULT_WIDTH = "defaultWidth";
    public static final String DEFAULT_HEIGHT = "defaultHeight";
    public static final String DEFAULT_INPUT_PROPERTY = "defaultInputProperty";
    public static final String DEFAULT_OUTPUT_PROPERTY = "defaultOutputProperty";
    private static WeakHashMap cache = new WeakHashMap();
    private static Map defaultSizeMap;
    private static Map extendedBeanInfoMap;

    private Introspector() {
    }

    public static BeanInfo getBeanInfo(Class beanClass) throws IntrospectionException {
        return Introspector.getBeanInfo(beanClass, null);
    }

    public static BeanInfo getBeanInfo(Class beanClass, Class stopClass) throws IntrospectionException {
        Pair index = new Pair(beanClass, (Object)stopClass);
        BeanInfo beanInfo = (BeanInfo)cache.get(index);
        if (null == beanInfo) {
            beanInfo = Introspector.introspect(beanClass, stopClass);
            cache.put(index, beanInfo);
        }
        return beanInfo;
    }

    public static void flushCaches() {
        cache.clear();
        extendedBeanInfoMap = null;
    }

    public static String decapitalize(String string) {
        return java.beans.Introspector.decapitalize(string);
    }

    public static String[] getBeanInfoSearchPath() {
        return java.beans.Introspector.getBeanInfoSearchPath();
    }

    public static void setBeanInfoSearchPath(String[] path) {
        java.beans.Introspector.setBeanInfoSearchPath(path);
    }

    protected static BeanInfo introspect(Class beanClass, Class stopClass) throws IntrospectionException {
        java.beans.BeanDescriptor beanDescriptor;
        Introspector.validateStopClass(beanClass, stopClass);
        BeanInfo beanInfo = BaseSecuritySupport.securitySupport.getBeanInfo(beanClass, stopClass);
        EventSetDescriptor[] descriptors = beanInfo.getEventSetDescriptors();
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        Introspector.getExtendedBeanInfo(beanClass, ebi);
        java.beans.PropertyDescriptor[] instanceProperties = beanInfo.getPropertyDescriptors();
        java.beans.PropertyDescriptor[] staticProperties = Introspector.introspectStaticProperties(beanClass, beanInfo);
        int defaultInputPropertyIndex = beanInfo.getDefaultPropertyIndex();
        int defaultOutputPropertyIndex = beanInfo.getDefaultPropertyIndex();
        Image icon = beanInfo.getIcon(1);
        if (ebi != null) {
            Introspector.annotateProperties(beanClass, instanceProperties, ebi);
            Introspector.annotateProperties(beanClass, staticProperties, ebi);
            if (ebi.defaultInputPropertyName != null && ebi.defaultInputPropertyName.length() > 0) {
                defaultInputPropertyIndex = Introspector.lookupPropertyIndex(instanceProperties, defaultInputPropertyIndex, ebi.defaultInputPropertyName);
            }
            if (ebi.defaultOutputPropertyName != null && ebi.defaultOutputPropertyName.length() > 0) {
                defaultOutputPropertyIndex = Introspector.lookupPropertyIndex(instanceProperties, defaultInputPropertyIndex, ebi.defaultOutputPropertyName);
            }
        }
        if ((beanDescriptor = beanInfo.getBeanDescriptor()) == null) {
            beanDescriptor = new BeanDescriptor(beanClass);
        } else if (!(beanDescriptor instanceof BeanDescriptor)) {
            BeanDescriptor newBeanDescriptor = new BeanDescriptor((Class)beanDescriptor.getBeanClass(), (Class)beanDescriptor.getCustomizerClass());
            newBeanDescriptor.setShortDescription(beanDescriptor.getShortDescription());
            beanDescriptor = newBeanDescriptor;
        }
        if (ebi.shortDescription.length() > 0) {
            beanDescriptor.setShortDescription(ebi.shortDescription);
        }
        String defaultInputProperty = null;
        String defaultOutputProperty = null;
        if (defaultInputPropertyIndex != -1) {
            defaultInputProperty = instanceProperties[defaultInputPropertyIndex].getName();
        }
        if (defaultOutputPropertyIndex != -1) {
            defaultOutputProperty = instanceProperties[defaultOutputPropertyIndex].getName();
        }
        Introspector.annotateBeanDescriptor(beanClass, beanDescriptor, defaultInputProperty, defaultOutputProperty);
        return new SimpleBeanInfo(beanDescriptor, descriptors, beanInfo.getDefaultEventIndex(), instanceProperties, beanInfo.getDefaultPropertyIndex(), beanInfo.getMethodDescriptors(), staticProperties, defaultInputPropertyIndex, defaultOutputPropertyIndex, icon);
    }

    protected static void annotateBeanDescriptor(Class beanClass, java.beans.BeanDescriptor beanDescriptor, String defaultInputProperty, String defaultOutputProperty) {
        try {
            Class[] paramTypes = new Class[]{};
            Method getDefaultWidthMethod = BaseSecuritySupport.securitySupport.getMethod(beanClass, "getDefaultWidth", paramTypes);
            Integer defaultWidth = (Integer)BaseSecuritySupport.securitySupport.invokeMethod(getDefaultWidthMethod, null, null);
            beanDescriptor.setValue(DEFAULT_WIDTH, defaultWidth);
            Method getDefaultHeightMethod = BaseSecuritySupport.securitySupport.getMethod(beanClass, "getDefaultHeight", paramTypes);
            Integer defaultHeight = (Integer)BaseSecuritySupport.securitySupport.invokeMethod(getDefaultHeightMethod, null, null);
            beanDescriptor.setValue(DEFAULT_HEIGHT, defaultHeight);
            beanDescriptor.setValue(DEFAULT_INPUT_PROPERTY, defaultInputProperty);
            beanDescriptor.setValue(DEFAULT_OUTPUT_PROPERTY, defaultOutputProperty);
        }
        catch (Exception e) {
            Introspector.loadEBIMap();
            if (defaultSizeMap == null) {
                return;
            }
            try {
                String defaultWidthPropertyValue = (String)defaultSizeMap.get(beanClass.getName() + "_defaultWidth");
                if (defaultWidthPropertyValue != null) {
                    beanDescriptor.setValue(DEFAULT_WIDTH, new Integer(defaultWidthPropertyValue));
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                String defaultHeightPropertyValue = (String)defaultSizeMap.get(beanClass.getName() + "_defaultHeight");
                if (defaultHeightPropertyValue != null) {
                    beanDescriptor.setValue(DEFAULT_HEIGHT, new Integer(defaultHeightPropertyValue));
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    protected static void loadEBIMap() {
        if (extendedBeanInfoMap == null || defaultSizeMap == null) {
            try {
                Properties ebiPropertiesMap = new Properties();
                InputStream inputStream = BaseSecuritySupport.securitySupport.getResourceAsStream(Introspector.class, "ExtendedBeanInfoMap.properties");
                ebiPropertiesMap.load(inputStream);
                defaultSizeMap = new HashMap();
                extendedBeanInfoMap = Introspector.parseEBIMap(ebiPropertiesMap);
            }
            catch (IOException e) {
                System.out.println(" IOException " + e);
                e.printStackTrace();
            }
        }
    }

    private static Map parseEBIMap(Map ebiPropMap) {
        HashMap<String, String> metaDataMap = new HashMap<String, String>();
        metaDataMap.put("NAME", "Name");
        metaDataMap.put("DEFAULT_VALUE", "Default value");
        metaDataMap.put("SHORT_DESCRIPTION", "Short description");
        metaDataMap.put("DESCRIPTION", "Description");
        metaDataMap.put("READ_METHOD", "Read method");
        metaDataMap.put("WRITE_METHOD", "Write method");
        metaDataMap.put("BOUND", "Bound");
        metaDataMap.put("LINKABLE", "Linkable");
        metaDataMap.put("COMPARE_VALUE", "Compare value");
        metaDataMap.put("PERSIST", "Persist");
        metaDataMap.put("FIELD_NAME", "Field name");
        metaDataMap.put("CONSTRAINED", "Constrained");
        metaDataMap.put("PROPERTY_EDITOR_CLASS", "Property editor class");
        metaDataMap.put("EXPERT", "Expert");
        metaDataMap.put("HIDDEN", "Hidden");
        metaDataMap.put("MASKED", "Masked");
        metaDataMap.put("SEND_EVENT", "Send event");
        metaDataMap.put("STATIC", "Static");
        metaDataMap.put("CATEGORY", "Category");
        HashMap classMap = new HashMap();
        String classToken = ".class";
        Set keySet = ebiPropMap.keySet();
        for (String key : keySet) {
            Object value = ebiPropMap.get(key);
            try {
                String metaDataName;
                int index = key.indexOf(classToken);
                if (index == -1) continue;
                String className = key.substring(0, index);
                String remainingName = key.substring(index + classToken.length() + 1);
                index = remainingName.indexOf(46);
                if (remainingName.equals(DEFAULT_HEIGHT) || remainingName.equals(DEFAULT_WIDTH)) {
                    String sizeKey = className + "_" + remainingName;
                    defaultSizeMap.put(sizeKey, value);
                    continue;
                }
                HashMap<String, Object> classPropMap = (HashMap<String, Object>)classMap.get(className);
                if (classPropMap == null) {
                    classPropMap = new HashMap<String, Object>();
                    classMap.put(className, classPropMap);
                }
                if (index == -1) {
                    ExtendedBeanInfo ebi = (ExtendedBeanInfo)classPropMap.get("_ExtendedBeanInfo");
                    if (ebi == null) {
                        ebi = new ExtendedBeanInfo();
                        classPropMap.put("_ExtendedBeanInfo", ebi);
                    }
                    if (remainingName.equals("defaultInputPropertyName")) {
                        ebi.defaultInputPropertyName = (String)value;
                        continue;
                    }
                    if (remainingName.equals("defaultOutputPropertyName")) {
                        ebi.defaultOutputPropertyName = (String)value;
                        continue;
                    }
                    if (!remainingName.equals("shortDescription")) continue;
                    ebi.shortDescription = (String)value;
                    continue;
                }
                String propName = remainingName.substring(0, index);
                String attribName = remainingName.substring(index + 1);
                HashMap<String, String> propNameMap = (HashMap<String, String>)classPropMap.get(propName);
                if (propNameMap == null) {
                    propNameMap = new HashMap<String, String>();
                    propNameMap.put("Name", propName);
                    classPropMap.put(propName, propNameMap);
                }
                if ((metaDataName = (String)metaDataMap.get(attribName)) == null) continue;
                propNameMap.put(metaDataName, (String)value);
            }
            catch (Exception e) {
                String msgTemplate = RB.getStringResource(RB_KEY, "errorParsingKey.txt");
                System.out.println(MessageFormat.format(msgTemplate, key, value));
            }
        }
        HashMap<String, ExtendedBeanInfo> ebiMap = new HashMap<String, ExtendedBeanInfo>();
        Set classNameSet = classMap.keySet();
        for (String className : classNameSet) {
            Map classPropMap = (Map)classMap.get(className);
            ExtendedBeanInfo ebi = (ExtendedBeanInfo)classPropMap.get("_ExtendedBeanInfo");
            if (ebi == null) {
                ebi = new ExtendedBeanInfo();
            } else {
                classPropMap.remove("_ExtendedBeanInfo");
            }
            ebi.propertyMetadata = new String[classPropMap.size()][][];
            Set classPropSet = classPropMap.keySet();
            Iterator classPropSetIterator = classPropSet.iterator();
            int i = 0;
            while (classPropSetIterator.hasNext()) {
                String propName = (String)classPropSetIterator.next();
                Map propNameMap = (Map)classPropMap.get(propName);
                String[][] metaData = new String[propNameMap.size()][2];
                Set metaDataSet = propNameMap.keySet();
                Iterator metaDataIterator = metaDataSet.iterator();
                int j = 0;
                while (metaDataIterator.hasNext()) {
                    metaData[j][0] = (String)metaDataIterator.next();
                    metaData[j][1] = (String)propNameMap.get(metaData[j][0]);
                    ++j;
                }
                ebi.propertyMetadata[i] = metaData;
                ++i;
            }
            ebiMap.put(className, ebi);
        }
        return ebiMap;
    }

    protected static void getExtendedBeanInfo(Class beanClass, ExtendedBeanInfo compositeEBI) {
        Class introspectInterfaceForBeanInfoClass;
        if (beanClass.getSuperclass() != null) {
            Introspector.getExtendedBeanInfo(beanClass.getSuperclass(), compositeEBI);
        }
        ExtendedBeanInfo ebi = null;
        try {
            Class[] paramTypes = new Class[]{};
            Method gebiMethod = BaseSecuritySupport.securitySupport.getMethod(beanClass, "getExtendedBeanInfo", paramTypes);
            ebi = (ExtendedBeanInfo)BaseSecuritySupport.securitySupport.invokeMethod(gebiMethod, null, null);
        }
        catch (Exception paramTypes) {
            // empty catch block
        }
        if (ebi == null) {
            Introspector.loadEBIMap();
            if (extendedBeanInfoMap != null) {
                ebi = (ExtendedBeanInfo)extendedBeanInfoMap.get(beanClass.getName());
            }
        }
        if (ebi != null) {
            compositeEBI.composite(ebi);
        }
        if ((introspectInterfaceForBeanInfoClass = GlobalInfoTable._loadClass("com.sas.beans.IntrospectInterfaceForBeanInfo")).isAssignableFrom(beanClass) || beanClass.isInterface()) {
            String className = Introspector.getRemoteClassBaseName(beanClass.getName());
            try {
                Class interfaceBeanInfoClass = GlobalInfoTable.loadClass(className + "BeanInfo");
                Introspector.getExtendedBeanInfo(interfaceBeanInfoClass, compositeEBI);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    protected static String getRemoteClassBaseName(String className) {
        String packageName = "";
        if (className.indexOf(46) != -1) {
            packageName = className.substring(0, className.lastIndexOf(46) + 1);
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        if (className.startsWith("Final")) {
            className = className.substring(5);
        }
        if (className.startsWith("_rprx")) {
            className = className.substring(5);
        }
        if (className.startsWith("J2")) {
            className = className.substring(2);
        }
        if (className.startsWith("Remote")) {
            className = className.substring(6);
        }
        if (className.startsWith("DesignTime")) {
            className = className.substring(10);
        }
        if (!(className = packageName + className).endsWith("Interface")) {
            className = className + "Interface";
        }
        return className;
    }

    protected static void annotateProperties(Class beanClass, java.beans.PropertyDescriptor[] properties, ExtendedBeanInfo ebi) throws IntrospectionException {
        Hashtable metadataTable = PropertyMetadata.create(ebi.propertyMetadata);
        for (int i = 0; i < properties.length; ++i) {
            if (!metadataTable.containsKey(properties[i].getName())) continue;
            PropertyMetadata metadata = (PropertyMetadata)metadataTable.get(properties[i].getName());
            PropertyDescriptor pd = null;
            if (properties[i] instanceof PropertyDescriptor) {
                pd = (PropertyDescriptor)properties[i];
            } else {
                pd = new PropertyDescriptor(properties[i]);
                properties[i] = pd;
            }
            if (metadata.defaultValue_set) {
                pd.setDefaultValue(metadata.defaultValue);
            }
            if (metadata.linkable_set) {
                pd.setLinkable(metadata.linkable);
            }
            if (metadata.description_set) {
                pd.setDescription(metadata.description);
            }
            if (metadata.persist_set) {
                pd.setPersisted(metadata.persist);
            }
            if (metadata.shortdesc_set) {
                pd.setShortDescription(metadata.shortDescription);
            }
            if (metadata.bound_set) {
                pd.setBound(metadata.bound);
            }
            if (metadata.constrained_set) {
                pd.setConstrained(metadata.constrained);
            }
            if (metadata.expert_set) {
                pd.setExpert(metadata.expert);
            }
            if (metadata.hidden_set) {
                pd.setHidden(metadata.hidden);
            }
            if (metadata.masked_set) {
                pd.setMasked(metadata.masked);
            }
            pd.setPropertyEditorClass(metadata.propertyEditorClass);
            if (metadata.defaultValue.length() == 0) {
                Class<?> propType = pd.getPropertyType();
                if (propType == String.class) {
                    pd.setDefaultValue("\"\"");
                } else if (propType == Boolean.TYPE) {
                    pd.setDefaultValue("false");
                } else if (propType == Integer.TYPE || propType == Short.TYPE || propType == Long.TYPE || propType == Double.TYPE || propType == Float.TYPE || propType == Byte.TYPE || propType == Character.TYPE) {
                    pd.setDefaultValue("0");
                } else {
                    pd.setDefaultValue("null");
                }
            }
            if (metadata.readMethodName != null) {
                try {
                    Method getMethod = BaseSecuritySupport.securitySupport.getMethod(beanClass, metadata.readMethodName, null);
                    pd.setReadMethod(getMethod);
                }
                catch (NoSuchMethodException e) {
                    String message = RB.getStringResource(RB_KEY, "annotateProperties.ex.txt");
                    System.out.println(MessageFormat.format(message, e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (metadata.writeMethodName == null) continue;
            Class[] params = new Class[]{pd.getPropertyType()};
            try {
                Method setMethod = BaseSecuritySupport.securitySupport.getMethod(beanClass, metadata.writeMethodName, params);
                pd.setWriteMethod(setMethod);
                continue;
            }
            catch (NoSuchMethodException e) {
                String message = RB.getStringResource(RB_KEY, "annotateProperties.ex.txt");
                System.out.println(MessageFormat.format(message, e.getMessage()));
                e.printStackTrace();
            }
        }
        String[] stringArray = new String[1];
        int[] intArray = new int[1];
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor pd;
            if (properties[i].getPropertyEditorClass() != null) continue;
            if (properties[i].getPropertyType() == stringArray.getClass()) {
                pd = null;
                if (properties[i] instanceof PropertyDescriptor) {
                    pd = (PropertyDescriptor)properties[i];
                } else {
                    pd = new PropertyDescriptor(properties[i]);
                    properties[i] = pd;
                }
                pd.setPropertyEditorClass("com.sas.beans.editors.StringArrayEditor");
                continue;
            }
            if (properties[i].getPropertyType() != intArray.getClass()) continue;
            pd = null;
            if (properties[i] instanceof PropertyDescriptor) {
                pd = (PropertyDescriptor)properties[i];
            } else {
                pd = new PropertyDescriptor(properties[i]);
                properties[i] = pd;
            }
            pd.setPropertyEditorClass("com.sas.beans.editors._IntArrayEditor");
        }
    }

    protected static java.beans.PropertyDescriptor[] introspectStaticProperties(Class beanClass, BeanInfo beanInfo) throws IntrospectionException {
        boolean propertyChangeSource = false;
        Hashtable properties = new Hashtable();
        Method[] methodList = BaseSecuritySupport.securitySupport.getDeclaredMethods(beanClass);
        for (int i = 0; i < methodList.length; ++i) {
            Method method = methodList[i];
            int modifier = BaseSecuritySupport.securitySupport.getMethodModifiers(method);
            if (!Modifier.isPublic(modifier) || !Modifier.isStatic(modifier)) continue;
            String name = BaseSecuritySupport.securitySupport.getMethodName(method);
            Class[] argTypes = BaseSecuritySupport.securitySupport.getMethodParameterTypes(method);
            Class resultType = BaseSecuritySupport.securitySupport.getMethodReturnType(method);
            java.beans.PropertyDescriptor pd = null;
            boolean getMethod = false;
            boolean setMethod = false;
            boolean isMethod = false;
            if (name == null) continue;
            if (name.length() > 3) {
                if (name.startsWith("get")) {
                    getMethod = true;
                } else if (name.startsWith("set")) {
                    setMethod = true;
                }
            } else if (name.startsWith("is") && name.length() > 2) {
                isMethod = true;
            }
            if (!getMethod && !setMethod && !isMethod) continue;
            if (getMethod && argTypes.length == 0) {
                pd = new PropertyDescriptor(Introspector.decapitalize(name.substring(3)), method, null);
            } else if (getMethod && argTypes.length == 1 && argTypes[0] == Integer.TYPE) {
                pd = new java.beans.IndexedPropertyDescriptor(Introspector.decapitalize(name.substring(3)), null, null, method, null);
            } else if (setMethod && argTypes.length == 1 && resultType == Void.TYPE) {
                pd = new PropertyDescriptor(Introspector.decapitalize(name.substring(3)), null, method);
                if (Introspector.throwsException(method, PropertyVetoException.class)) {
                    pd.setConstrained(true);
                }
            } else if (setMethod && argTypes.length == 2 && argTypes[0] == Integer.TYPE) {
                pd = new java.beans.IndexedPropertyDescriptor(Introspector.decapitalize(name.substring(3)), null, null, null, method);
                if (Introspector.throwsException(method, PropertyVetoException.class)) {
                    pd.setConstrained(true);
                }
            } else if (isMethod && argTypes.length == 0 && resultType == Boolean.TYPE) {
                pd = new PropertyDescriptor(Introspector.decapitalize(name.substring(2)), method, null);
            }
            if (pd == null) continue;
            if (propertyChangeSource) {
                pd.setBound(true);
            }
            Introspector.addProperty(properties, pd);
        }
        java.beans.PropertyDescriptor[] result = new java.beans.PropertyDescriptor[properties.size()];
        Enumeration elements = properties.elements();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (java.beans.PropertyDescriptor)elements.nextElement();
        }
        return result;
    }

    static void addProperty(Hashtable properties, java.beans.PropertyDescriptor pd) throws IntrospectionException {
        PropertyDescriptor composite;
        String name = pd.getName();
        java.beans.PropertyDescriptor old = (java.beans.PropertyDescriptor)properties.get(name);
        if (old == null) {
            properties.put(name, pd);
            return;
        }
        Class<?> opd = old.getPropertyType();
        Class<?> npd = pd.getPropertyType();
        if (opd != null && npd != null && opd != npd) {
            properties.put(name, pd);
            return;
        }
        if (old instanceof java.beans.IndexedPropertyDescriptor || pd instanceof java.beans.IndexedPropertyDescriptor) {
            Method readMethod = old.getReadMethod();
            Method writeMethod = old.getWriteMethod();
            if (pd.getReadMethod() != null) {
                readMethod = pd.getReadMethod();
            }
            if (pd.getWriteMethod() != null) {
                writeMethod = pd.getWriteMethod();
            }
            composite = new IndexedPropertyDescriptor(old.getName(), readMethod, writeMethod);
        } else {
            Method readMethod = old.getReadMethod();
            Method writeMethod = old.getWriteMethod();
            if (pd.getReadMethod() != null) {
                readMethod = pd.getReadMethod();
            }
            if (pd.getWriteMethod() != null) {
                writeMethod = pd.getWriteMethod();
            }
            composite = new PropertyDescriptor(old.getName(), readMethod, writeMethod);
        }
        properties.put(name, composite);
    }

    protected static void validateStopClass(Class beanClass, Class stopClass) throws IntrospectionException {
        if (stopClass == null) {
            return;
        }
        String stopClassName = stopClass.getName();
        for (Class c = beanClass.getSuperclass(); c != null; c = c.getSuperclass()) {
            if (!stopClassName.equals(c.getName())) continue;
            return;
        }
        String message = RB.getStringResource(RB_KEY, "validateStopClass.ex.txt");
        throw new IntrospectionException(MessageFormat.format(message, stopClass.getName(), beanClass.getName()));
    }

    private static boolean throwsException(Method method, Class exception) {
        Class[] exs = BaseSecuritySupport.securitySupport.getMethodExceptionTypes(method);
        for (int i = 0; i < exs.length; ++i) {
            if (exs[i] != exception) continue;
            return true;
        }
        return false;
    }

    protected static int lookupPropertyIndex(java.beans.PropertyDescriptor[] properties, int defaultIndex, String propertyName) {
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i].getName().equals(propertyName)) continue;
            return i;
        }
        return defaultIndex;
    }

    public static java.beans.PropertyDescriptor getPropertyDescriptor(String propertyName, BeanInfo beanInfo) {
        java.beans.PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i].getName().equals(propertyName)) continue;
            return properties[i];
        }
        return null;
    }

    public static Class[] getInterfaces(Class objClass) {
        Class tmpClass;
        int numInterfaces = 0;
        for (tmpClass = objClass; tmpClass != null; tmpClass = tmpClass.getSuperclass()) {
            numInterfaces += tmpClass.getInterfaces().length;
        }
        Class[] interfaces = new Class[numInterfaces];
        int index = 0;
        for (tmpClass = objClass; tmpClass != null; tmpClass = tmpClass.getSuperclass()) {
            Class<?>[] oneClassIFList = tmpClass.getInterfaces();
            for (int i = 0; i < oneClassIFList.length; ++i) {
                interfaces[index++] = oneClassIFList[i];
            }
        }
        return interfaces;
    }
}

