/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.migration.joinconversion;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

public class OldJobsPropertyTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(OldJobsPropertyTab.class);
    private List m_lSteps;
    private DualListSelector m_dlsJobs;
    private DefaultListModel m_lstTargetModel;
    private DefaultListModel m_lstSourceModel;
    private WATextArea m_txtArea;
    private List m_selectedJobSteps;

    public OldJobsPropertyTab(List steps) {
        this.m_lSteps = steps;
        this.m_selectedJobSteps = new ArrayList();
        this.initialize();
    }

    protected void initialize() {
        this.m_txtArea = new WATextArea();
        this.m_txtArea.setBehavior(1);
        this.m_txtArea.setText(bundle.getString("OldJobsPropertyTab.OldTransformMessage.txt"));
        this.m_txtArea.setAutosize(true);
        this.m_dlsJobs = new DualListSelector();
        this.m_dlsJobs.setTransferAllControlsVisible(true);
        this.m_dlsJobs.setAlternatingMultipleButtonStyle(false);
        this.m_dlsJobs.setAlternatingSingleButtonStyle(false);
        this.m_lstTargetModel = new DefaultListModel();
        this.m_lstSourceModel = new DefaultListModel();
        this.m_dlsJobs.setModel((ListModel)this.m_lstSourceModel);
        this.m_dlsJobs.setTargetModel((ListModel)this.m_lstTargetModel);
        this.setPreferredSize(new Dimension(500, 300));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_txtArea, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_dlsJobs, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        HashMap<String, cStepJob> jobMap = new HashMap<String, cStepJob>();
        ArrayList<cStepJob> jobList = new ArrayList<cStepJob>();
        if (this.m_lSteps != null) {
            int size = this.m_lSteps.size();
            for (int i = 0; i < size; ++i) {
                cStepJob sJob;
                TransformationActivity ta;
                AssociationList lJobs;
                TransformationStep ts = (TransformationStep)this.m_lSteps.get(i);
                AssociationList lTS = ts.getActivities();
                if (lTS.isEmpty() || (lJobs = (ta = (TransformationActivity)lTS.get(0)).getJobs()).isEmpty()) continue;
                Job job = (Job)lJobs.get(0);
                if (jobMap.containsKey(job.getFQID())) {
                    sJob = (cStepJob)jobMap.get(job.getFQID());
                    sJob.addStep(ts);
                    continue;
                }
                sJob = new cStepJob(job);
                sJob.addStep(ts);
                jobMap.put(job.getFQID(), sJob);
                jobList.add(sJob);
            }
            if (!jobList.isEmpty()) {
                Object[] arrJobs = jobList.toArray();
                Arrays.sort(arrJobs, new JobComparator());
                for (int i = 0; i < arrJobs.length; ++i) {
                    this.m_lstSourceModel.addElement(arrJobs[i]);
                }
            }
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_selectedJobSteps.clear();
        int size = this.m_lstTargetModel.getSize();
        for (int i = 0; i < size; ++i) {
            this.m_selectedJobSteps.add(this.m_lstTargetModel.get(i));
        }
    }

    public List getSelectedSteps() {
        return this.m_selectedJobSteps;
    }

    public static class cStepJob {
        List m_steps = new ArrayList();
        Job m_job;
        boolean m_converted = false;

        public cStepJob(Job job) {
            this.m_job = job;
        }

        public String toString() {
            String str = this.m_job.toString();
            try {
                str = str + " (" + this.m_job.getFQID() + ")";
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return str;
        }

        public List getTransformationSteps() {
            return this.m_steps;
        }

        public Job getJob() {
            return this.m_job;
        }

        public void addStep(TransformationStep step) {
            this.m_steps.add(step);
        }

        public void setConverted(boolean value) {
            this.m_converted = value;
        }
    }

    public static class JobComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    }
}

