/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.migration.joinconversion;

import com.sas.codegen.CodegenRequest;
import com.sas.etl.migration.joinconversion.JoinMatch;
import com.sas.etl.migration.joinconversion.ParsedExpression;
import com.sas.etl.migration.joinconversion.SQLModel2;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.query.QueryException;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.FilterNetwork;
import com.sas.query.models.FilterNetworkAtomExpression;
import com.sas.query.models.FilterNode;
import com.sas.query.models.FilterTree;
import com.sas.query.models.GroupItem;
import com.sas.query.models.GroupItemList;
import com.sas.query.models.Join;
import com.sas.query.models.JoinList;
import com.sas.query.models.JoinRelationship;
import com.sas.query.models.JoinRelationshipList;
import com.sas.query.models.OrderItem;
import com.sas.query.models.OrderItemList;
import com.sas.query.models.PhysicalColumn;
import com.sas.query.models.Table;
import com.sas.query.models.TableList;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.wa.WAQuery;
import com.sas.query.wa.WAdminDataSource;
import com.sas.wadmin.pfd.PFDMetadataParsing;
import com.sas.wadmin.pfd.PFDUtil;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.transforms.sql.model.AbstractClause;
import com.sas.wadmin.transforms.sql.model.AbstractExpression;
import com.sas.wadmin.transforms.sql.model.AbstractTable;
import com.sas.wadmin.transforms.sql.model.ClauseInterface;
import com.sas.wadmin.transforms.sql.model.ClauseType;
import com.sas.wadmin.transforms.sql.model.CreateSelect;
import com.sas.wadmin.transforms.sql.model.From;
import com.sas.wadmin.transforms.sql.model.GroupBy;
import com.sas.wadmin.transforms.sql.model.GroupByColumn;
import com.sas.wadmin.transforms.sql.model.Having;
import com.sas.wadmin.transforms.sql.model.OperandInterface;
import com.sas.wadmin.transforms.sql.model.OrderBy;
import com.sas.wadmin.transforms.sql.model.OrderByColumn;
import com.sas.wadmin.transforms.sql.model.Query;
import com.sas.wadmin.transforms.sql.model.SQLStatementInterface;
import com.sas.wadmin.transforms.sql.model.SelectResults;
import com.sas.wadmin.transforms.sql.model.SimpleExpressionInterface;
import com.sas.wadmin.transforms.sql.model.SourceTable;
import com.sas.wadmin.transforms.sql.model.SourceTableInterface;
import com.sas.wadmin.transforms.sql.model.TableColumn;
import com.sas.wadmin.transforms.sql.model.TargetTable;
import com.sas.wadmin.transforms.sql.model.TextOperand;
import com.sas.wadmin.transforms.sql.model.Where;
import com.sas.wadmin.visuals.TransformationType;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.PluginUtil;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConversionUtils {
    private static final WAdminResource bundle = WAdminResource.getBundle(ConversionUtils.class);
    private static final String EQUALS_OPERATOR = "=";
    private static final String NOT_EQUALS_OPERATOR = "<>";
    private static final String IN_OPERATOR = "IN";
    private static final String NOT_IN_OPERATOR = "NOT IN";
    private static final String GREATER_THAN_OPERATOR = ">";
    private static final String GREATER_THAN_EQUALS_OPERATOR = ">=";
    private static final String LESS_THAN_OPERATOR = "<";
    private static final String LESS_THAN_EQUALS_OPERATOR = "<=";
    private static final String BETWEEN_OPERATOR = "BETWEEN";
    private static final String NOT_BETWEEN_OPERATOR = "NOT BETWEEN";
    private static final String EXISTS_OPERATOR = "EXISTS";
    private static final String NOT_EXISTS_OPERATOR = "NOT EXISTS";
    private static final String MISSING_OPERATOR = "IS MISSING";
    private static final String NOT_MISSING_OPERATOR = "NOT IS MISSING";
    private static final String NULL_OPERATOR = "IS NULL";
    private static final String NOT_NULL_OPERATOR = "NOT IS NULL";
    private static final String CONTAINS_OPERATOR = "CONTAINS";
    private static final String NOT_CONTAINS_OPERATOR = "NOT CONTAINS";
    private static final String LIKE_OPERATOR = "LIKE";
    private static final String NOT_LIKE_OPERATOR = "NOT LIKE";
    private static final String SOUNDS_LIKE_OPERATOR = "=%";
    private static final String NOT_SOUNDS_LIKE_OPERATOR = "NOT =%";
    private static final String OLD_SQL_REMOVE_XML = "<TransformationStep><Extensions/><UsingPrototype><Prototype><PrototypeProperties/></Prototype></UsingPrototype><SourceCode/><SuccessorDependencies/><PredecessorDependencies/><Properties/><PropertySets><PropertySet><Properties/></PropertySet></PropertySets><Transformations><Select><ClassifierTargets><WorkTable><Columns><Column><SourceFeatureMaps/></Column></Columns></WorkTable></ClassifierTargets><SourceCode/><SourceSpecifications/><SubstitutionVariables/><OrderByForSelect/><GroupByForSelect/><FeatureMaps><FeatureMap><SourceCode/><SubstitutionVariables/></FeatureMap></FeatureMaps></Select> </Transformations><PropertySets/></TransformationStep>";

    public static List getOperators() {
        ArrayList<String> m_operators = new ArrayList<String>();
        m_operators.add(NOT_EQUALS_OPERATOR);
        m_operators.add(NOT_IN_OPERATOR);
        m_operators.add(IN_OPERATOR);
        m_operators.add(GREATER_THAN_EQUALS_OPERATOR);
        m_operators.add(GREATER_THAN_OPERATOR);
        m_operators.add(LESS_THAN_EQUALS_OPERATOR);
        m_operators.add(LESS_THAN_OPERATOR);
        m_operators.add(NOT_BETWEEN_OPERATOR);
        m_operators.add(BETWEEN_OPERATOR);
        m_operators.add(NOT_EXISTS_OPERATOR);
        m_operators.add(EXISTS_OPERATOR);
        m_operators.add(NOT_MISSING_OPERATOR);
        m_operators.add(MISSING_OPERATOR);
        m_operators.add(NOT_NULL_OPERATOR);
        m_operators.add(NULL_OPERATOR);
        m_operators.add(NOT_CONTAINS_OPERATOR);
        m_operators.add(CONTAINS_OPERATOR);
        m_operators.add(NOT_LIKE_OPERATOR);
        m_operators.add(LIKE_OPERATOR);
        m_operators.add(NOT_SOUNDS_LIKE_OPERATOR);
        m_operators.add(SOUNDS_LIKE_OPERATOR);
        m_operators.add(EQUALS_OPERATOR);
        return m_operators;
    }

    public static void addExpression(AbstractExpression sqlExpression, Expression oldExpression, WAQuery oldSQLModel, int openParenCnt, int closeParenCnt, String logicalOp) {
        if (oldExpression instanceof CompoundExpression) {
            CompoundExpression cExp = (CompoundExpression)oldExpression;
            ParsedExpression pExp = new ParsedExpression(cExp.generateSQL(oldSQLModel.getSqlLogic(), 0), ConversionUtils.getOperators());
            String leftSt = pExp.getLeftString();
            String rightSt = pExp.getRightString();
            com.sas.wadmin.transforms.sql.model.Expression newExp = new com.sas.wadmin.transforms.sql.model.Expression(logicalOp, null, pExp.getOperator(), null, openParenCnt, closeParenCnt, sqlExpression);
            TextOperand leftOp = new TextOperand((SimpleExpressionInterface)newExp, leftSt);
            TextOperand rightOp = new TextOperand((SimpleExpressionInterface)newExp, rightSt);
            newExp.setLeftOperand((OperandInterface)leftOp);
            newExp.setRightOperand((OperandInterface)rightOp);
            sqlExpression.addExpression(newExp);
        } else {
            ParsedExpression pExp = new ParsedExpression(oldExpression.generateSQL(oldSQLModel.getSqlLogic(), 0), ConversionUtils.getOperators());
            com.sas.wadmin.transforms.sql.model.Expression newExp = new com.sas.wadmin.transforms.sql.model.Expression(logicalOp, null, pExp.getOperator(), null, openParenCnt, closeParenCnt, sqlExpression);
            TextOperand leftOp = new TextOperand((SimpleExpressionInterface)newExp, pExp.getLeftString());
            TextOperand rightOp = new TextOperand((SimpleExpressionInterface)newExp, pExp.getRightString());
            newExp.setLeftOperand((OperandInterface)leftOp);
            newExp.setRightOperand((OperandInterface)rightOp);
            sqlExpression.addExpression(newExp);
        }
    }

    public static void convertFilterTree(WAQuery oldSQLModel, FilterTree tree, AbstractExpression sqlExpression) {
        sqlExpression.getExpressions().clear();
        FilterNetwork fn = new FilterNetwork();
        FilterNetworkAtomExpression list = fn.generateOptimizedFilterClause((com.sas.query.Query)oldSQLModel, tree, null);
        int openParenCnt = 0;
        int closeParenCnt = 0;
        String logicalOp = "";
        for (int index = 0; index < list.size(); ++index) {
            Object item2;
            Object item = list.elementAt(index);
            if (item instanceof String) {
                if (item.toString().equals("(")) {
                    ++openParenCnt;
                    continue;
                }
                if (item.toString().trim().equals("AND")) {
                    logicalOp = "AND";
                    continue;
                }
                if (!item.toString().trim().equals("OR")) continue;
                logicalOp = "OR";
                continue;
            }
            if (!(item instanceof FilterNode)) continue;
            for (int ind2 = index + 1; ind2 < list.size() && (item2 = list.elementAt(ind2)) instanceof String && item2.toString().equals(")"); ++ind2) {
                ++closeParenCnt;
            }
            FilterNode node = (FilterNode)item;
            Expression expression = node.getNodeData();
            if (expression == null) continue;
            ConversionUtils.addExpression(sqlExpression, expression, oldSQLModel, openParenCnt, closeParenCnt, logicalOp);
            openParenCnt = 0;
            closeParenCnt = 0;
            logicalOp = "";
        }
    }

    public static List doTheFind(Job mdoJob, String transformRole) throws RemoteException, MdException {
        ArrayList<TransformationStep> lSteps = new ArrayList<TransformationStep>();
        AssociationList lJobActivities = mdoJob.getJobActivities();
        if (lJobActivities != null && lJobActivities.size() > 0) {
            AssociationList jSteps = ((TransformationActivity)lJobActivities.get(0)).getSteps();
            for (TransformationStep step : jSteps) {
                AssociationList properties = step.getProperties();
                for (int j = 0; j < properties.size(); ++j) {
                    String classname;
                    Property prop = (Property)properties.get(j);
                    if (!"Class".equals(prop.getPropertyName()) || !(classname = prop.getDefaultValue()).equals(transformRole)) continue;
                    lSteps.add(step);
                }
            }
        }
        return lSteps;
    }

    public static boolean doTheUpdate(List selectedSteps, TransformationType newTransform, DateFormat dFormat) throws RemoteException, MdException {
        Node firstNode;
        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
        int size = selectedSteps.size();
        ArrayList<TransformationStep> convertedSteps = new ArrayList<TransformationStep>();
        try {
            String classId = newTransform.getTypeID();
            Class<?> transformClass = Class.forName(classId);
            TransformInterface transform = (TransformInterface)transformClass.newInstance();
            String transformXMLString = transform.getXML();
            Document doc = factory.getOMIUtil().parseXML(transformXMLString);
            firstNode = doc.getFirstChild();
        }
        catch (ClassNotFoundException e) {
            throw new MdException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new MdException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MdException((Throwable)e);
        }
        for (int i = 0; i < size; ++i) {
            TransformationStep oStep = (TransformationStep)selectedSteps.get(i);
            MdObjectStore store = (MdObjectStore)oStep.getObjectStore();
            TransformationStep originalStep = oStep;
            String reposId = originalStep.getFQID().substring(0, 8);
            WAdminDataSource waDS = null;
            try {
                waDS = new WAdminDataSource();
            }
            catch (QueryException exc) {
                throw new MdException((Throwable)exc);
            }
            WAQuery oldSQLModel = new WAQuery(waDS, (CMetadata)originalStep);
            if (!oldSQLModel.loadModelFromMetadata()) {
                StringBuffer statusText = new StringBuffer();
                statusText.append(dFormat.format(new Date())).append(" - ").append(bundle.getString("JoinConversion.TransformFailed.txt")).append(" - ").append(originalStep.toString()).append(" (").append(originalStep.getFQID()).append(")\n");
                throw new MdException(statusText.toString());
            }
            try {
                Select originalCM = (Select)originalStep.getTransformations().get(0);
                AssociationList origFMs = originalCM.getFeatureMaps();
                ArrayList fms = new ArrayList(origFMs);
                originalCM.setName(originalCM.getName());
                origFMs.clear();
                TransformationActivity ta = (TransformationActivity)originalStep.getActivities().get(0);
                TransformationStep newStep = (TransformationStep)factory.createComplexMetadataObject(store, null, originalStep.getName(), "TransformationStep", reposId);
                newStep = (TransformationStep)PFDMetadataParsing.populateNewObjects((CMetadata)newStep, (NamedNodeMap)firstNode.getAttributes(), (NodeList)firstNode.getChildNodes(), (String)reposId, new ArrayList(), new ArrayList());
                ta.getSteps().add((Object)newStep);
                newStep.getComputeLocations().addAll((Collection)originalStep.getComputeLocations());
                ClassifierMap newCM = (ClassifierMap)newStep.getTransformations().get(0);
                int fmSize = fms.size();
                for (int j = 0; j < fmSize; ++j) {
                    FeatureMap fm = (FeatureMap)fms.get(j);
                    if (fm.getTransformRole().equalsIgnoreCase("SQLGROUPBYINTEGER")) continue;
                    if (fm.getTransformRole().equalsIgnoreCase("DERIVED")) {
                        FeatureMap textOperand = (FeatureMap)factory.createComplexMetadataObject(store, null, "TextOperand", "FeatureMap", reposId);
                        textOperand.setTransformRole("TextOperand");
                        AssociationList lSourceCodes = fm.getSourceCodes();
                        int srcSize = lSourceCodes.size();
                        for (int k = srcSize - 1; k >= 0; --k) {
                            Text src = (Text)lSourceCodes.get(k);
                            src.getAssociatedTransformations().remove((Object)fm);
                            src.getAssociatedTransformations().add((Object)textOperand);
                        }
                        AssociationList lVariables = fm.getSubstitutionVariables();
                        textOperand.getSubstitutionVariables().addAll((Collection)lVariables);
                        fm.getTransformationTargets().add((Object)textOperand);
                        lVariables.clear();
                    }
                    newCM.getFeatureMaps().add((Object)fm);
                }
                store.removeObjectsFromStore((List)newCM.getClassifierTargets());
                newStep.setName(originalStep.getName());
                newStep.setIsActive(originalStep.getIsActive());
                newStep.setIsUserDefined(originalStep.getIsUserDefined());
                newStep.setDesc(originalStep.getDesc());
                newCM.setName(originalCM.getName());
                newCM.setIsActive(originalCM.getIsActive());
                newCM.setIsUserDefined(originalCM.getIsUserDefined());
                newCM.setDesc(originalCM.getDesc());
                AssociationList lstSourceCode = originalCM.getSourceCodes();
                int srcSize = lstSourceCode.size();
                for (int j = srcSize - 1; j >= 0; --j) {
                    Text src = (Text)lstSourceCode.get(j);
                    src.getAssociatedTransformations().remove((Object)originalCM);
                    src.getAssociatedTransformations().add((Object)newCM);
                }
                AssociationList lstRespParty = originalStep.getResponsibleParties();
                newStep.getResponsibleParties().addAll((Collection)lstRespParty);
                lstRespParty.clear();
                AssociationList lstNotes = originalStep.getNotes();
                newStep.getNotes().addAll((Collection)lstNotes);
                lstNotes.clear();
                AssociationList lstDocs = originalStep.getDocuments();
                newStep.getDocuments().addAll((Collection)lstDocs);
                lstDocs.clear();
                AssociationList lstExt = originalStep.getExtensions();
                int extSize = lstExt.size();
                for (int j = extSize - 1; j >= 0; --j) {
                    Extension ext = (Extension)lstExt.get(j);
                    Extension newExt = (Extension)factory.createComplexMetadataObject(store, null, ext.getName(), "Extension", reposId);
                    newExt.setOwningObject((Root)newStep);
                    MdStoreUtil.copyObjectAttributes((CMetadata)ext, (CMetadata)newExt, (int)1);
                }
                ArrayList preds = new ArrayList();
                preds.addAll(originalStep.getPredecessorDependencies(true));
                ArrayList succs = new ArrayList();
                succs.addAll(originalStep.getSuccessorDependencies(true));
                int pSize = preds.size();
                for (int j = 0; j < pSize; ++j) {
                    StepPrecedence sp = (StepPrecedence)preds.get(j);
                    sp.getPredecessors().removeElement((Object)originalStep);
                    sp.getPredecessors().addElement((Object)newStep);
                }
                int sSize = succs.size();
                for (int j = 0; j < sSize; ++j) {
                    StepPrecedence sp = (StepPrecedence)succs.get(j);
                    sp.getSuccessors().removeElement((Object)originalStep);
                    sp.getSuccessors().addElement((Object)newStep);
                    originalStep.getSuccessorDependencies().removeElement((Object)sp);
                    newStep.getSuccessorDependencies().addElement((Object)sp);
                }
                AssociationList targets = originalCM.getClassifierTargets();
                AssociationList sources = originalCM.getClassifierSources();
                newCM.getClassifierSources().addAll((Collection)sources);
                newCM.getClassifierTargets().addAll((Collection)targets);
                PropertyHandler optionSet = new PropertyHandler((Root)originalStep, true);
                optionSet.setSetRole("OPTIONS");
                Select newSelect = (Select)factory.createComplexMetadataObject(store, null, "CreateSelect", "Select", reposId);
                newSelect.setTransformRole("CreateSelect");
                newCM.getTransformationSources().add((Object)newSelect);
                newSelect.getClassifierSources().addAll((Collection)sources);
                SQLModel2 sqlModel = new SQLModel2(newStep);
                CodegenRequest cgReq = sqlModel.createNewCodegenRequest();
                sqlModel.setCodegenRequest(cgReq);
                sqlModel.setFireEventsEnabled(false);
                sqlModel.moveDataToModel();
                SQLStatementInterface sqlSt = sqlModel.getStatement();
                if (sqlSt instanceof CreateSelect) {
                    String fromClause;
                    CreateSelect select = (CreateSelect)sqlSt;
                    Query query = select.getQuery();
                    TargetTable sqlTarget = select.getTargetTable();
                    DataTable targetDT = sqlTarget.getDataTable();
                    if (targetDT instanceof PhysicalTable) {
                        PhysicalTable pTarget = (PhysicalTable)targetDT;
                        OptionsPropertyHandler op = new OptionsPropertyHandler((Root)originalStep);
                        String viewPropertyName = "WORKVIEW";
                        boolean createView = false;
                        if (op.getSpecificProperty(viewPropertyName) == null) {
                            if (pTarget.getMemberType().equals("")) {
                                createView = true;
                            }
                        } else {
                            createView = op.stringToBoolean(op.getSpecificOptionValue(viewPropertyName));
                        }
                        PFDUtil.setTableMemberType((PhysicalTable)pTarget, (boolean)createView);
                    }
                    List qrySources = query.getAllSourceTables();
                    block21: for (int srcIndex = 0; srcIndex < qrySources.size(); ++srcIndex) {
                        SourceTable source = (SourceTable)qrySources.get(srcIndex);
                        TableList oldSources = oldSQLModel.getTables();
                        for (int oldIndex = 0; oldIndex < oldSQLModel.getTableCount(); ++oldIndex) {
                            Table oldSource = oldSources.elementAt(oldIndex);
                            if (!((DataTable)oldSource.getDataSourceTable().getUnderlyingTable()).getFQID().equals(source.getDataTable().getFQID())) continue;
                            if (oldSource.getCorrelationName() == null) continue block21;
                            source.setAlias(oldSource.getCorrelationName());
                            continue block21;
                        }
                    }
                    SelectResults selResults = (SelectResults)query.getClause(ClauseType.SELECT);
                    if (oldSQLModel.getDuplicateRowsRule() == 0) {
                        selResults.setUseDistinct(true);
                    }
                    if ((fromClause = oldSQLModel.getFromString()) != null && fromClause.length() > 0) {
                        boolean displayInt;
                        Expression exp;
                        FilterTree whereTree;
                        Join oldJoin;
                        int j;
                        From from = query.getFrom();
                        com.sas.wadmin.transforms.sql.model.Join previousJoin = null;
                        ArrayList<JoinMatch> joinMatches = new ArrayList<JoinMatch>();
                        JoinList joins = oldSQLModel.getJoins();
                        JoinList jrJoins = new JoinList();
                        for (j = 0; j < joins.size(); ++j) {
                            oldJoin = joins.elementAt(j);
                            JoinRelationshipList conditions = oldJoin.getRelationships();
                            if (conditions == null || conditions.size() <= 0) continue;
                            jrJoins.addElement(joins.elementAt(j));
                        }
                        for (j = jrJoins.size() - 1; j >= 0; --j) {
                            oldJoin = jrJoins.elementAt(j);
                            int type = oldJoin.getJoinType();
                            String joinType = "Inner";
                            if (type == 4) {
                                joinType = "Cross";
                            } else if (type == 1) {
                                joinType = "Left";
                            } else if (type == 3) {
                                joinType = "Full";
                            } else if (type == 2) {
                                joinType = "Right";
                            } else if (type == 5) {
                                joinType = "Union";
                            }
                            JoinRelationshipList conditions = oldJoin.getRelationships();
                            com.sas.wadmin.transforms.sql.model.Join newJoin = query.addJoin(null, null, joinType);
                            newJoin.getExpressions().clear();
                            if (previousJoin != null) {
                                previousJoin.setLeftSide((SourceTableInterface)newJoin);
                            }
                            previousJoin = newJoin;
                            JoinRelationship jr = conditions.elementAt(0);
                            if (j >= 0) {
                                newJoin.setLeftSide((SourceTableInterface)ConversionUtils.getSourceTable(jr.getLeftTable(), newJoin.getParentQuery()));
                            }
                            newJoin.setRightSide((SourceTableInterface)ConversionUtils.getSourceTable(jr.getRightTable(), newJoin.getParentQuery()));
                            newJoin.setUseImplicit(false);
                            joinMatches.add(new JoinMatch(newJoin, oldJoin, oldSQLModel));
                        }
                        if (!joinMatches.isEmpty()) {
                            SourceTableInterface src = from.getSource();
                            if (src instanceof ClauseInterface) {
                                query.removeClause((ClauseInterface)src);
                            }
                            from.setSource((SourceTableInterface)((JoinMatch)joinMatches.get(0)).getNewJoin());
                        }
                        for (int j2 = 0; j2 < joinMatches.size(); ++j2) {
                            ((JoinMatch)joinMatches.get(j2)).buildExpressions();
                        }
                        FilterTree havingTree = oldSQLModel.getHavingFilterTree();
                        if (havingTree != null && havingTree.getRoot() != null) {
                            Having sqlHaving = (Having)query.addClause(ClauseType.HAVING);
                            ConversionUtils.convertFilterTree(oldSQLModel, havingTree, (AbstractExpression)sqlHaving);
                        }
                        if ((whereTree = oldSQLModel.getWhereFilterTree()) != null && whereTree.getRoot() != null) {
                            Where sqlWhere = (Where)query.addClause(ClauseType.WHERE);
                            ConversionUtils.convertFilterTree(oldSQLModel, whereTree, (AbstractExpression)sqlWhere);
                        }
                        if (oldSQLModel.getGroupItemCount() > 0) {
                            GroupItemList groupList = oldSQLModel.getGroupItems();
                            GroupBy sqlGroupBy = (GroupBy)query.addClause(ClauseType.GROUPBY);
                            int cSize = groupList.size();
                            for (int j3 = 0; j3 < cSize; ++j3) {
                                GroupItem groupItem = groupList.elementAt(j3);
                                exp = groupItem.getExpression();
                                displayInt = false;
                                TableColumn tColumn = null;
                                if (exp instanceof ColumnExpression) {
                                    PhysicalColumn pCol;
                                    Object colObject;
                                    ColumnExpression colExp = (ColumnExpression)exp;
                                    if (colExp.getColumn() instanceof PhysicalColumn && (colObject = (pCol = (PhysicalColumn)colExp.getColumn()).getDataSourceColumn().getUnderlyingColumn()) instanceof Column) {
                                        Column metaCol = (Column)colObject;
                                        DataTable metaTable = metaCol.getTable();
                                        AbstractTable tInt = ConversionUtils.getSQLTable(metaTable, query);
                                        tColumn = tInt.findTableColumn(metaCol);
                                    }
                                } else if (exp instanceof UnparsedExpression) {
                                    String val = exp.getDisplayString();
                                    try {
                                        Integer intVal = Integer.valueOf(val);
                                        tColumn = (TableColumn)sqlTarget.getTableColumns().get(intVal - 1);
                                        displayInt = true;
                                    }
                                    catch (NumberFormatException intVal) {
                                        // empty catch block
                                    }
                                }
                                if (tColumn == null) continue;
                                GroupByColumn gColumn = new GroupByColumn(tColumn, tColumn.getParent(), displayInt, (AbstractClause)sqlGroupBy);
                                sqlGroupBy.addGroupByColumn(gColumn);
                            }
                        }
                        if (oldSQLModel.getOrderItemCount() > 0) {
                            OrderBy sqlOrderBy = (OrderBy)query.addClause(ClauseType.ORDERBY);
                            OrderItemList orderList = oldSQLModel.getOrderItems();
                            int cSize = orderList.size();
                            for (int j4 = 0; j4 < cSize; ++j4) {
                                OrderItem orderItem = orderList.elementAt(j4);
                                exp = orderItem.getExpression();
                                displayInt = false;
                                String sortOrder = orderItem.getSortingDirection() == 2 ? "desc" : "asc";
                                TableColumn tColumn = null;
                                if (exp instanceof ColumnExpression) {
                                    PhysicalColumn pCol;
                                    Object colObject;
                                    ColumnExpression colExp = (ColumnExpression)exp;
                                    if (colExp.getColumn() instanceof PhysicalColumn && (colObject = (pCol = (PhysicalColumn)colExp.getColumn()).getDataSourceColumn().getUnderlyingColumn()) instanceof Column) {
                                        Column metaCol = (Column)colObject;
                                        DataTable metaTable = metaCol.getTable();
                                        AbstractTable tInt = ConversionUtils.getSQLTable(metaTable, query);
                                        tColumn = tInt.findTableColumn(metaCol);
                                    }
                                } else if (exp instanceof UnparsedExpression) {
                                    String val = exp.getDisplayString();
                                    try {
                                        Integer intVal = Integer.valueOf(val);
                                        tColumn = (TableColumn)sqlTarget.getTableColumns().get(intVal - 1);
                                        displayInt = true;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (tColumn == null) continue;
                                OrderByColumn oColumn = new OrderByColumn(tColumn, tColumn.getParent(), sortOrder, displayInt, (AbstractClause)sqlOrderBy);
                                sqlOrderBy.addOrderByColumn(oColumn);
                            }
                        }
                    }
                }
                sqlModel.setSystemOptions(optionSet.getSpecificOptionValue("SystemOptions"));
                sqlModel.setSQLOptions(optionSet.getSpecificOptionValue("ProcSQLOptions"));
                sqlModel.setCreateSyslast(optionSet.stringToBoolean(optionSet.getSpecificOptionValue("SYSLAST"), true));
                sqlModel.moveDataToStore();
                sources.clear();
                targets.clear();
                store.updatedMetadataAll();
                originalStep.getUsingPrototypes(true);
                PluginUtil.doRemoveFromChildStore((MdObjectStore)store, (String)OLD_SQL_REMOVE_XML, (CMetadata)originalStep);
                store.updatedMetadataAll();
                convertedSteps.add(originalStep);
                continue;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new MdException((Throwable)exc);
            }
        }
        return size == convertedSteps.size();
    }

    public static String convertStackTraceToString(Throwable throwable) {
        StringBuffer stackTraceStringBuffer = new StringBuffer();
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        stackTraceStringBuffer.append(throwable);
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            stackTraceStringBuffer.append("\n at " + element.toString());
        }
        return stackTraceStringBuffer.toString();
    }

    public static SourceTable getSourceTable(Table oldSQLTable, Query newQuery) {
        DataTable dtable;
        List sTables;
        Object table;
        SourceTable stable = null;
        if (oldSQLTable != null && (table = oldSQLTable.getDataSourceTable().getUnderlyingTable()) instanceof DataTable && !(sTables = newQuery.findAllSourceTables(dtable = (DataTable)table)).isEmpty()) {
            stable = (SourceTable)sTables.get(0);
        }
        return stable;
    }

    public static AbstractTable getSQLTable(DataTable table, Query query) throws RemoteException {
        ArrayList<TargetTable> tables = new ArrayList<TargetTable>(query.getAllSourceTables());
        tables.add(query.getTargetTable());
        for (int i = 0; i < tables.size(); ++i) {
            AbstractTable t = (AbstractTable)tables.get(i);
            if (!t.getDataTable().getFQID().equals(table.getFQID())) continue;
            return t;
        }
        return null;
    }
}

