/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.migration.batch;

import com.sas.etl.migration.ETLMigrationProcessor;
import com.sas.etl.migration.ETLMigrationStatus;
import com.sas.etl.migration.ETLMigrationUtility;
import com.sas.etl.migration.batch.BatchETLMigrationOptions;
import com.sas.etl.migration.batch.RB;
import com.sas.etl.models.impl.ObjectFactory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.plugins.InvalidPluginDirectoryException;
import com.sas.plugins.PluginLoader;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.util.ProcessStatus;
import com.sas.text.Message;
import com.sas.wadmin.app.VersionedObjectManager;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractVersionedObjectManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class BatchETLMigration
extends BatchDriver2 {
    private boolean _clean = false;
    private boolean _migrate = false;
    private boolean _fix = false;
    private boolean _migrateData = false;
    private boolean _analyze = false;

    private BatchETLMigration() {
        this._logFilePrefix = "ETLMigration";
        this._logContextName = "com.sas.etl.migration";
    }

    public BatchETLMigration(String host, String port, String user, String password) {
        this();
        this.setConnection(host, port);
        this.setCredential(user, password);
    }

    public BatchETLMigration(SessionContextInterface session) throws ServiceException, RemoteException {
        this();
        this.setConnection(session);
    }

    protected void parse(String[] args) throws ParseException, MissingOptionException {
        this._options = new BatchETLMigrationOptions();
        if (args == null || args.length == 0) {
            this._help = true;
            return;
        }
        super.parse(args);
        if (this._help) {
            return;
        }
        this._analyze = this._commandLine.hasOption("analyze");
        this._clean = this._commandLine.hasOption("clean");
        this._migrate = this._commandLine.hasOption("migrate");
        this._migrateData = this._commandLine.hasOption("migrateData");
        this._fix = this._commandLine.hasOption("fix");
        if (!(this._clean || this._migrate || this._migrateData || this._fix || this._help)) {
            this._help = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BatchETLMigration etlMigrator = new BatchETLMigration();
        int rc = 0;
        try {
            etlMigrator.parse(args);
            if (etlMigrator._help) {
                HelpFormatter help = new HelpFormatter();
                String[] exclusions = new String[]{"debug", "fix", "migrateData"};
                Options helpOptions = BatchETLMigration.getHelpOptions((Options)etlMigrator._options, (String[])exclusions);
                help.printHelp(80, BatchETLMigration.getUsage(help), RB.getStringResource("AbstractPromotionDriverOptions.Options.txt"), helpOptions, null);
                return;
            }
            etlMigrator.initialize();
            etlMigrator.validateSetup();
            ProcessStatus migrationStatus = new ProcessStatus(ETLMigrationUtility.getLogger(), "BatchETLMigration");
            ProcessStatus.setGlobalStatus((ProcessStatus)migrationStatus);
            ProcessStatus cleanStatus = etlMigrator.clean();
            migrationStatus.addStatus(cleanStatus);
            ProcessStatus migrateStatus = etlMigrator.migrate();
            migrationStatus.addStatus(migrateStatus);
            if (migrationStatus.hasErrors()) {
                rc |= 4;
            }
            System.out.println(RB.getStringResource("BatchETLMigration.Complete.txt"));
        }
        catch (ParseException e) {
            System.err.println(RB.getStringResource("BatchETLMigration.InvalidOptions.log"));
            System.err.println(e.getLocalizedMessage());
            rc = 8;
        }
        catch (RuntimeException e) {
            Throwable except = e;
            Throwable cause = e.getCause();
            if (cause != null) {
                except = cause;
            }
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"BatchETLMigration.Failed.fmt.txt", (Object)except.getLocalizedMessage());
            System.err.println(msg);
            rc = 8;
        }
        catch (Exception e) {
            Throwable except = e;
            Throwable cause = e.getCause();
            if (cause != null) {
                except = cause;
            }
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"BatchETLMigration.Failed.fmt.txt", (Object)except.getLocalizedMessage());
            System.err.println(msg);
            rc = 8;
        }
        finally {
            if (etlMigrator != null) {
                rc |= etlMigrator.getReturnCode();
                String logFileName = etlMigrator.getLogFileName();
                if (logFileName != null) {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchETLMigration.ViewLog.fmt.txt", (Object)logFileName));
                }
            }
        }
        System.exit(rc);
    }

    private ProcessStatus migrate() throws RemoteException, ServiceException, MdException {
        ProcessStatus status = new ProcessStatus(ETLMigrationUtility.getLogger(), "migrate ETL");
        if (this._migrate || this._fix) {
            if (this._fix) {
                if (this._analyze) {
                    this.getLogger().debug("Analyzing fix for ETL Migration...");
                } else {
                    this.getLogger().debug("Executing fix for ETL Migration...");
                }
            }
            this.getLogger().debug("Executing migrate for ETL Migration...");
            ETLMigrationProcessor jobMig = new ETLMigrationProcessor(this._server);
            jobMig.setExecuteMigration(!this._analyze);
            if (this._fix) {
                jobMig.setFixBrokenObjectsOnly(true);
            }
            if (this._migrateData || this._fix) {
                if (this._analyze) {
                    this.getLogger().debug("Analyze migrate data for ETL Migration...");
                } else {
                    this.getLogger().debug("Executing migrate data for ETL Migration...");
                }
                jobMig.setMigrateDataTypes(true);
            }
            jobMig.migrate();
            List migrateList = jobMig.getStatusList();
            for (ETLMigrationStatus migStatus : migrateList) {
                if (migStatus.hasErrors()) {
                    status.addError(Message.format((String)RB.getStringResource("BatchETLMigration.ErrorMigratingType.txt"), (Object)migStatus.getDisplayName()));
                }
                migStatus.logSuccessStats();
            }
            this._factory.dumpDetailHashMap();
        } else if (this._analyze) {
            this.getLogger().debug("Analyze was not called");
        } else {
            this.getLogger().debug("Migrate was not called");
        }
        return status;
    }

    private ProcessStatus clean() throws RemoteException, ServiceException, MdException {
        ProcessStatus status = new ProcessStatus(ETLMigrationUtility.getLogger(), "clean ETL");
        if (this._clean) {
            if (this._analyze) {
                this.getLogger().debug("Analyzing Clean for ETL Migration...");
            } else {
                this.getLogger().debug("Executing Clean for ETL Migration...");
            }
            ETLMigrationProcessor jobMig = new ETLMigrationProcessor(this._server);
            jobMig.setExecuteMigration(!this._analyze);
            jobMig.setFixBrokenObjectsOnly(true);
            jobMig.setRemovePreviousVersionObjects(true);
            jobMig.prep();
            List migrateList = jobMig.getStatusList();
            for (ETLMigrationStatus migStatus : migrateList) {
                if (migStatus.hasErrors()) {
                    status.addError(Message.format((String)RB.getStringResource("BatchETLMigration.ErrorMigratingType.txt"), (Object)migStatus.getDisplayName()));
                }
                migStatus.logSuccessStats();
            }
            this._factory.dumpDetailHashMap();
        } else if (this._analyze) {
            this.getLogger().debug("Analyze was not called");
        } else {
            this.getLogger().debug("Clean was not called");
        }
        return status;
    }

    public void initialize() throws ServiceException, LogicalTypeException, RemoteException {
        super.initialize();
        Log.initAlreadyConfiguredLogger((String)this._logContextName, (String)this._logFileName);
        if (Workspace.getWorkspace() == null) {
            try {
                if (this._debug) {
                    String[] args = new String[]{"-serverLog", "-debug", "-consoleLog"};
                    Workspace.processCommandLineArguments((String[])args);
                }
                Workspace wksp = new Workspace(this._session);
                CMetadata foundationRepos = this._factory.getOMIUtil().getFoundationRepository();
                if (foundationRepos != null) {
                    wksp.setDefaultRepository(foundationRepos);
                }
                if (wksp.getAppDefaultsFile() == null) {
                    wksp.setAppDefaultsFile(new WorkspaceFile());
                }
                VersionedObjectManager mgr = new VersionedObjectManager();
                WsAbstractVersionedObjectManager.setInstance((WsAbstractVersionedObjectManager)mgr);
                WorkspaceFile wkspFile = wksp.getWorkspaceFile();
                if (wkspFile == null) {
                    wkspFile = this._securityContext.getWorkspaceFile() == null ? new WorkspaceFile() : this._securityContext.getWorkspaceFile();
                    wksp.setWorkspaceFile(wkspFile);
                }
                this.initializePlugins();
                TransformManager xformManager = TransformManager.getInstance();
                if (xformManager == null) {
                    Workspace.getDefaultLogger().error((Object)"Error loading TransformManager");
                }
            }
            catch (MdException e) {
                throw new ServiceException((Throwable)e);
            }
        }
    }

    private static String getUsage(HelpFormatter help) {
        String NEW_LINE = help.defaultNewLine;
        StringBuffer usage = new StringBuffer();
        usage.append(RB.getStringResource("BatchETLMigration.HelpUsage.txt"));
        usage.append(NEW_LINE).append(NEW_LINE);
        usage.append(RB.getStringResource("BatchETLMigration.HelpExample1.txt"));
        usage.append(NEW_LINE).append("BatchETLMigration -clean");
        usage.append(NEW_LINE);
        return usage.toString();
    }

    private String initializePlugins() {
        try {
            ArrayList<String> lPluginDirs = new ArrayList<String>();
            String pluginsDir = Workspace.getWorkspace().getPluginsDir();
            if (pluginsDir != null) {
                lPluginDirs.add(pluginsDir);
            } else {
                lPluginDirs.add(System.getProperty("user.dir") + System.getProperty("file.separator") + "plugins");
            }
            String sAdditionalPluginDir = System.getProperty("AddPluginDir");
            if (sAdditionalPluginDir != null) {
                lPluginDirs.add(sAdditionalPluginDir);
            }
            PluginLoader plLoader = new PluginLoader(lPluginDirs);
            plLoader.initializePlugins();
            Workspace.getWorkspace().setPluginLoader(plLoader);
            ObjectFactory.initializePlugins((PluginLoader)plLoader);
            return null;
        }
        catch (InvalidPluginDirectoryException e) {
            String strPluginError = RB.getStringResource("BatchETLMigration.Warning.NoPluginDirectory.txt");
            this.getLogger().warn(strPluginError);
            PluginLoader plLoader = new PluginLoader();
            Workspace.getWorkspace().setPluginLoader(plLoader);
            return strPluginError;
        }
    }
}

