/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.migration;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.JobCG;
import com.sas.codegen.WorkTableCG;
import com.sas.etl.migration.ETLMigrationProcessor;
import com.sas.etl.migration.ETLMigrationStatus;
import com.sas.etl.migration.ETLMigrationUtility;
import com.sas.etl.migration.RB;
import com.sas.etl.migration.TempOMRAdapter;
import com.sas.etl.migration.joinconversion.ConversionUtils;
import com.sas.etl.migration.joinconversion.Converter;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.impl.ConditionActionsTemplateJobModel;
import com.sas.etl.models.job.transforms.ExtractTransformModel;
import com.sas.etl.models.job.transforms.GeneratedTransformModel;
import com.sas.etl.models.job.transforms.SortTransformModel;
import com.sas.etl.models.job.transforms.TableLoaderTransformModel;
import com.sas.etl.models.job.transforms.common.IOrderBy;
import com.sas.etl.models.job.transforms.common.ISorting;
import com.sas.etl.models.job.transforms.facttable.FactTableTransformModel;
import com.sas.etl.models.job.transforms.rank.RankTransformModel;
import com.sas.etl.models.job.transforms.scd.ISCDTransformModel;
import com.sas.etl.models.job.transforms.scd.impl.KEDTransformModel;
import com.sas.etl.models.job.transforms.scd.impl.SCDType2TransformModel;
import com.sas.etl.models.job.transforms.sql.impl.SQLJoinTransformModel;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.Action;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Condition;
import com.sas.metadata.remote.ConditionActionSet;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.GroupByClause;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.Key;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Role;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.services.util.ProcessStatus;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import com.sas.wadmin.pfd.PFDUtil;
import com.sas.wadmin.plugins.TransformMetadataUpgradePluginInterface;
import com.sas.wadmin.prompts.conversion.DISEntityConverter;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.NewJobDialog;
import com.sas.workspace.ILogger;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.SCDType2Utilities;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractVersionedObjectManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.prefs.BackingStoreException;

public class UpgradeJobAction {
    private static final String OLD_SQL_TRANSFORM_ROLE = "com.sas.query.wa.SASJoin";
    private static final String OLD_FACT_TRANSFORM_ROLE = "com.sas.wadmin.transforms.sasscd.visuals.FactTable";
    private static final String OLD_LOADER_TRANSFORM_ROLE = "com.sas.wadmin.visuals.SASLoader";
    private static final String OLD_RANK_TRANSFORM_ROLE = "com.sas.wadmin.transforms.sasrank.SASRank";
    private static final String RCCHECK_TRANSFORM_ROLE = "com.sas.wadmin.visuals.SASReturnCodeCheck";
    private static final String LOOP_TRANSFORM_ROLE = "com.sas.wadmin.transforms.control.Loop";
    private static final String LOOPEND_TRANSFORM_ROLE = "com.sas.wadmin.transforms.control.LoopEnd";
    private static final String INNERJOB_TRANSFORM_ROLE = "com.sas.wadmin.visuals.SASJob";
    private static final String OLD_EFI_TRANSFORM_ROLE = "com.sas.wadmin.efi.visuals.EFICodegen";
    private static final String SQLJOIN_TRANSFORM_ROLE = "com.sas.wadmin.transforms.sql.SQL";
    private static final String EXTRACT_TRANSFORM_ROLE = "com.sas.wadmin.visuals.SASExtract";
    private static final String SPD_LOADER_TANSFORM_ROLE = "com.sas.wadmin.visuals.SPDSLoader";
    private static final String SORT_DESCENDING_34 = "Descending";
    private static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private static Map s_mapJobIDs;
    private static String CUBE_CLASS_ID;
    private static final String CAS_TEMPLATE = "<Templates><ConditionActionSet><AssociatedCondition/><Actions/><PropertySets/></ConditionActionSet><Action><PropertySets/><Properties/></Action><Condition><PropertySets/><Properties/></Condition><PropertySet><SetProperties/></PropertySet></Templates>";

    private static synchronized void upgradeSQLTransformsInJob(Job mdoJob) throws RemoteException, MdException {
        Converter transformConverter = new Converter();
        List steps = ConversionUtils.doTheFind(mdoJob, OLD_SQL_TRANSFORM_ROLE);
        if (!steps.isEmpty()) {
            transformConverter.doUpdate(steps);
        }
    }

    public static synchronized void upgradeJob(Job mdoJob, UserContextInterface userContext) throws RemoteException, MdException {
        ProcessStatus status = new ProcessStatus(ETLMigrationUtility.getLogger(), ProcessStatus.generateLoggingName((CMetadata)mdoJob));
        UpgradeJobAction.upgradeJob(status, mdoJob, userContext);
    }

    public static synchronized void resetState() {
        s_mapJobIDs = new HashMap();
    }

    public static synchronized void upgradeJob(ProcessStatus status, Job mdoJob, UserContextInterface userContext) throws RemoteException, MdException {
        ILogger logger = ETLMigrationUtility.getLogger(0);
        logger.debug((Object)("Starting upgrade of job object \"" + mdoJob.getName() + "\""));
        Workspace.setAppPathName((String)"SASDataIntegrationStudio");
        Workspace.setAppVersions((String[])new String[]{"4.3", "4.2"});
        Workspace.createAppDataDirectory();
        if (s_mapJobIDs == null) {
            s_mapJobIDs = new HashMap();
        }
        String sID = mdoJob.getId();
        if (!UpgradeJobAction.isUpgradeable(mdoJob)) {
            if (UpgradeJobAction.isCubeJob(mdoJob)) {
                logger.info((Object)("\"" + mdoJob.getName() + "\" is a cube based job; exiting"));
            } else {
                logger.info((Object)("\"" + mdoJob.getName() + "\" is not upgradeable; exiting"));
            }
            s_mapJobIDs.put(sID, sID);
            return;
        }
        if (s_mapJobIDs.containsKey(sID)) {
            logger.info((Object)("\"" + mdoJob.getName() + "\" has already been upgraded; exiting"));
            return;
        }
        s_mapJobIDs.put(sID, sID);
        logger.debug((Object)"Running deployed job updates...");
        MetaUtilities.fixOldJobObject((Job)mdoJob);
        String excludedTypes = "Job.";
        if (mdoJob.getPublicType() != null && mdoJob.getPublicType().startsWith(excludedTypes)) {
            logger.info((Object)("Not upgrading job of type: " + mdoJob.getPublicType()));
            return;
        }
        ConditionActionsTemplateJobModel mdl = null;
        TempOMRAdapter omr = null;
        try {
            TransformMetadataUpgradePluginInterface pluginUpgrade;
            boolean b_loopsExistInJobUpgrade = UpgradeJobAction.doesLoopExistInJob(mdoJob);
            if (b_loopsExistInJobUpgrade) {
                logger.debug((Object)("Found loop within job: " + ProcessStatus.generateLoggingName((CMetadata)mdoJob)));
                status.addError(Message.format((String)RB.getStringResource("UpgradeJobAction.RecursiveLoopFoundInUpgrade.fmt.txt"), (Object)ProcessStatus.generateLoggingName((CMetadata)mdoJob)));
                return;
            }
            List upgradePlugins = Workspace.getWorkspace().getPluginLoader().getPlugins(TransformMetadataUpgradePluginInterface.class);
            Iterator iterator = upgradePlugins.iterator();
            while (iterator.hasNext() && !(pluginUpgrade = (TransformMetadataUpgradePluginInterface)iterator.next()).upgradeFromPreviousVersion(status, mdoJob)) {
            }
            DISEntityConverter entityConverter = new DISEntityConverter((MdObjectStore)mdoJob.getObjectStore(), (Root)mdoJob, userContext);
            entityConverter.convert2Prompt(false, true);
            logger.debug((Object)"Upgrading SQL Transformations...");
            UpgradeJobAction.upgradeSQLTransformsInJob(mdoJob);
            logger.debug((Object)"Upgrading all inner jobs and SyncStep Transformations...");
            UpgradeJobAction.upgradeInnerJobsAndSyncStepTransformsInJob(status, mdoJob, userContext);
            logger.debug((Object)("Upgrading condition action sets hanging off of the job: " + mdoJob.getName() + "..."));
            List templates = UpgradeJobAction.getConditionActionSetTemplates((MdObjectStore)mdoJob.getObjectStore());
            UpgradeJobAction.convertConditionActions(status, (MdObjectStore)mdoJob.getObjectStore(), (Root)mdoJob, templates);
            mdoJob.updateMetadataAll();
            mdl = new ConditionActionsTemplateJobModel();
            mdl.setDebugName(mdoJob.getName() + " job upgrade");
            mdl.setModelEventsEnabled(false);
            omr = new TempOMRAdapter((IModel)mdl, Workspace.getMdFactory(), "upgrading job " + mdoJob.getName());
            logger.debug((Object)"Generating 9.1.3 step order ...");
            TransformationStep[] steps = JobCG.getStepOrder((Job)mdoJob);
            ITransform[] transforms = new ITransform[steps.length];
            for (int i = 0; i < steps.length; ++i) {
                TransformMetadataUpgradePluginInterface pluginUpgrade2;
                AssociationList lJobActivities;
                String classname = null;
                boolean bOldLoader = false;
                boolean bSQLJoin = false;
                boolean bExtract = false;
                boolean scdOrKed = false;
                boolean bSPDLoader = false;
                AssociationList properties = steps[i].getProperties();
                for (int j = 0; j < properties.size(); ++j) {
                    Property prop = (Property)properties.get(j);
                    if (!"Class".equals(prop.getPropertyName())) continue;
                    classname = prop.getDefaultValue();
                    if ("com.sas.wadmin.transforms.sasscd.visuals.SCDType2".equals(classname)) {
                        prop.setDefaultValue(SCDType2TransformModel.getTransformTypeID());
                        scdOrKed = true;
                        break;
                    }
                    if ("com.sas.wadmin.transforms.sasscd.visuals.KeyEffectiveDate".equals(classname)) {
                        prop.setDefaultValue(KEDTransformModel.getTransformTypeID());
                        scdOrKed = true;
                        break;
                    }
                    if (OLD_FACT_TRANSFORM_ROLE.equals(classname)) {
                        prop.setDefaultValue(FactTableTransformModel.getTransformTypeID());
                        break;
                    }
                    if (OLD_RANK_TRANSFORM_ROLE.equals(classname)) {
                        prop.setDefaultValue(RankTransformModel.getTransformTypeID());
                        break;
                    }
                    if (OLD_SQL_TRANSFORM_ROLE.equals(classname)) {
                        prop.setDefaultValue(SQLJoinTransformModel.getTransformTypeID());
                        break;
                    }
                    if (OLD_LOADER_TRANSFORM_ROLE.equals(classname)) {
                        prop.setDefaultValue(TableLoaderTransformModel.getTransformTypeID());
                        bOldLoader = true;
                        break;
                    }
                    if (OLD_EFI_TRANSFORM_ROLE.equals(classname)) {
                        ETLMigrationUtility.getLogger().warn("Job " + mdoJob.getName() + " is a version 1 EFI job and could not be upgraded. This job will be skipped.");
                        status.addError(Message.format((String)RB.getStringResource("UpgradeJobAction.OldEFINotMigrated.fmt.txt"), (Object)mdoJob.getName()));
                        return;
                    }
                    if (SQLJOIN_TRANSFORM_ROLE.equals(classname)) {
                        bSQLJoin = true;
                        break;
                    }
                    if (EXTRACT_TRANSFORM_ROLE.equals(classname)) {
                        bExtract = true;
                        break;
                    }
                    if (!SPD_LOADER_TANSFORM_ROLE.equals(classname)) break;
                    bSPDLoader = true;
                    break;
                }
                if (bOldLoader) {
                    UpgradeJobAction.upgradeLoaderTransform((MdObjectStore)mdoJob.getObjectStore(), steps[i]);
                    UpgradeJobAction.convertConditionActions(status, (MdObjectStore)mdoJob.getObjectStore(), (Root)steps[i], templates);
                }
                if (bSPDLoader) {
                    UpgradeJobAction.upgradeSPDSLoader((MdObjectStore)mdoJob.getObjectStore(), mdoJob, steps[i], status);
                }
                if (scdOrKed) {
                    UpgradeJobAction.upgradeGeneratedKey((MdObjectStore)mdoJob.getObjectStore(), mdoJob, steps[i], status);
                    UpgradeJobAction.upgradeSCDLoadTimeColumn((MdObjectStore)mdoJob.getObjectStore(), mdoJob, steps[i], status);
                }
                if (bSQLJoin) {
                    UpgradeJobAction.removeAnyBadJoinMetadata((MdObjectStore)mdoJob.getObjectStore(), steps[i]);
                }
                if (bExtract) {
                    UpgradeJobAction.fixBadExtractMetadata((MdObjectStore)mdoJob.getObjectStore(), steps[i]);
                }
                if (!(lJobActivities = mdoJob.getJobActivities()).isEmpty()) {
                    TransformationActivity mdActivity = (TransformationActivity)lJobActivities.get(0);
                    AssociationList lSteps = mdActivity.getSteps();
                    for (TransformationStep mdStep : lSteps) {
                        if (mdStep.getTransformRole().equalsIgnoreCase("LOOKUP")) {
                            AssociationList featureMaps = ((ClassifierMap)mdStep.getTransformations().get(0)).getFeatureMaps();
                            for (int t = 0; t < featureMaps.size(); ++t) {
                                FeatureMap fm = (FeatureMap)featureMaps.get(t);
                                if (!fm.getTransformRole().equalsIgnoreCase("lookup")) continue;
                                UpgradeJobAction.convertConditionActions(status, (MdObjectStore)mdStep.getObjectStore(), (Root)fm, templates);
                            }
                            continue;
                        }
                        UpgradeJobAction.convertConditionActions(status, (MdObjectStore)mdStep.getObjectStore(), (Root)mdStep, templates);
                    }
                }
                Iterator iterator2 = upgradePlugins.iterator();
                while (iterator2.hasNext() && !(pluginUpgrade2 = (TransformMetadataUpgradePluginInterface)iterator2.next()).upgradeFromPreviousVersion(status, steps[i])) {
                }
                steps[i].updateMetadataAll();
                transforms[i] = (ITransform)omr.acquireObject((Root)steps[i]);
                String sType = transforms[i].getType();
                if (transforms[i] instanceof IDataTransform) {
                    ((IDataTransform)transforms[i]).setGenerateIndexesOnTargetTables(false);
                }
                if (SortTransformModel.getTransformTypeID().equals(sType)) {
                    UpgradeJobAction.upgradeSortTransform(omr, (SortTransformModel)transforms[i], steps[i]);
                    continue;
                }
                if (ExtractTransformModel.getTransformTypeID().equals(sType)) {
                    UpgradeJobAction.upgradeExtractOrderByTransform(omr, (ExtractTransformModel)transforms[i], steps[i]);
                    continue;
                }
                if (SCDType2TransformModel.getTransformTypeID().equals(sType)) {
                    UpgradeJobAction.upgradeBusinessKeys(omr, (ISCDTransformModel)((SCDType2TransformModel)transforms[i]), steps[i]);
                    continue;
                }
                if (GeneratedTransformModel.getTransformTypeID().equals(sType)) {
                    UpgradeJobAction.updateDisplayedPortsForGeneratedTransform((GeneratedTransformModel)transforms[i]);
                    continue;
                }
                if (!TableLoaderTransformModel.getTransformTypeID().equals(sType)) continue;
                ((TableLoaderTransformModel)transforms[i]).setUnmappedEqMissingInUpdate(true);
            }
            IJob modelJob = (IJob)omr.acquireObject((Root)mdoJob);
            mdl.setMainObject((IPersistableObject)modelJob);
            if (modelJob.getControlOrderedTransformsList().isEmpty()) {
                for (int i = 0; i < transforms.length; ++i) {
                    modelJob.getControlOrderedTransformsList().add(transforms[i]);
                }
            }
            modelJob.setMapAutomatically(NewJobDialog.isUserPreferenceToAutomaticallyMap());
            modelJob.setPropagateAutomatically(NewJobDialog.isUserPreferenceToAutomaticallyPropagate());
            modelJob.setAutomaticPropagationDirection(NewJobDialog.getUserPreferenceForAutomaticPropagationDirection());
            modelJob.setUseNLSDateFormat(false);
            modelJob.setGenerateStatusHandlingLast(false);
            modelJob.setGenerateWarningOnMapping(false);
            modelJob.setCollectStatistics(false);
            modelJob.setCollectTableStatistics(false);
            ModelList lDataObjects = (ModelList)modelJob.getDataObjectsList();
            IOMRPersistable newDataObject = null;
            AssociationList lJobActivities = mdoJob.getJobActivities();
            if (lJobActivities != null && lJobActivities.size() > 0) {
                TransformationActivity mdActivity = (TransformationActivity)lJobActivities.get(0);
                AssociationList lSteps = mdActivity.getSteps();
                for (TransformationStep mdStep : lSteps) {
                    String sTransformRole = mdStep.getTransformRole();
                    AssociationList lQueueObjects = null;
                    if ("QueueReader".equals(sTransformRole)) {
                        lQueueObjects = mdStep.getTargetTransformations();
                    } else if ("IBMWSQWriter".equals(sTransformRole) || "QueueWriter".equals(sTransformRole)) {
                        lQueueObjects = mdStep.getSourceTransformations();
                    }
                    if (lQueueObjects != null) {
                        for (AbstractTransformation queue : lQueueObjects) {
                            if (!PFDUtil.PFD_TRANSFORMROLE_MQ.equals(queue.getTransformRole()) || lDataObjects.contains((Object)(newDataObject = omr.acquireObject((Root)queue)))) continue;
                            lDataObjects.add((Object)newDataObject);
                        }
                    }
                    AssociationList lCMs = mdStep.getTransformations();
                    for (Transformation mdTransformation : lCMs) {
                        if (!(mdTransformation instanceof ClassifierMap)) continue;
                        ClassifierMap mdCM = (ClassifierMap)mdTransformation;
                        AssociationList lSources = mdCM.getClassifierSources();
                        for (Classifier mdClassifier : lSources) {
                            if ("Contents".equals(mdCM.getTransformRole())) {
                                RelationalSchema mdRS = ((WorkTable)mdClassifier).getTablePackage();
                                if (mdRS == null) continue;
                                SASLibrary mdLibrary = null;
                                if (mdRS instanceof SASLibrary) {
                                    mdLibrary = (SASLibrary)mdRS;
                                } else {
                                    Object mdObject;
                                    AssociationList lLibraries = ((DatabaseSchema)mdRS).getUsedByPackages();
                                    if (lLibraries != null && !lLibraries.isEmpty() && (mdObject = lLibraries.get(0)) instanceof SASLibrary) {
                                        mdLibrary = (SASLibrary)mdObject;
                                    }
                                }
                                if (mdLibrary == null || lDataObjects.contains((Object)(newDataObject = omr.acquireObject((Root)mdLibrary)))) continue;
                                lDataObjects.add((Object)newDataObject);
                                continue;
                            }
                            String sType = mdClassifier.getCMetadataType();
                            if (!"PhysicalTable".equals(sType) && !"ExternalTable".equals(sType) || lDataObjects.contains((Object)(newDataObject = omr.acquireObject((Root)mdClassifier)))) continue;
                            lDataObjects.add((Object)newDataObject);
                        }
                        AssociationList lTargets = mdCM.getClassifierTargets();
                        for (Classifier mdClassifier : lTargets) {
                            WorkTable wTable;
                            String sType = mdClassifier.getCMetadataType();
                            if ("PhysicalTable".equals(sType) || "ExternalTable".equals(sType)) {
                                newDataObject = omr.acquireObject((Root)mdClassifier);
                                if (lDataObjects.contains((Object)newDataObject)) continue;
                                lDataObjects.add((Object)newDataObject);
                                continue;
                            }
                            if (!"WorkTable".equals(sType) || !"".equals((wTable = (WorkTable)mdClassifier).getMemberType())) continue;
                            WorkTableCG wCG = (WorkTableCG)CodeGenUtil.getCodeGenClass((CMetadata)wTable);
                            IWorkTable workTable = (IWorkTable)modelJob.getModel().getObject(wTable.getFQID());
                            if (workTable == null) continue;
                            workTable.setView(wCG.isView(mdStep));
                        }
                    }
                }
                for (int iTarget = lDataObjects.size() - 1; iTarget >= 0; --iTarget) {
                    ITable target;
                    Object table = lDataObjects.get(iTarget);
                    if (!(table instanceof ITable) || (target = (ITable)table).getConsumerTransforms().length != 0 || target.getProducerTransforms().length != 0) continue;
                    lDataObjects.remove(iTarget);
                }
                lDataObjects.saveToOMR((OMRAdapter)omr, (List)mdActivity.getTransformationTargets());
            }
            MdObjectStore jobStore = omr.getOMRStore();
            modelJob.saveToOMR((OMRAdapter)omr);
            omr.save();
            modelJob.loadFromOMR((OMRAdapter)omr);
            Iterator iter = jobStore.getDetailObjectMap().values().iterator();
            ArrayList<DataTable> tablesToColumnUpdate = new ArrayList<DataTable>();
            ArrayList<Column> lColumnsToUpdate = new ArrayList<Column>();
            ArrayList<Transformation> messagesToUpdate = new ArrayList<Transformation>();
            while (iter.hasNext()) {
                String publicType;
                Transformation trans;
                String role;
                Object obj = iter.next();
                if (!(obj instanceof CMetadata)) continue;
                CMetadata object = (CMetadata)obj;
                if (object.getCMetadataType().equalsIgnoreCase("Column")) {
                    Column column = (Column)object;
                    lColumnsToUpdate.add(column);
                    continue;
                }
                if (!object.getCMetadataType().equalsIgnoreCase("Transformation") || (role = (trans = (Transformation)object).getTransformRole()) == null || !role.equals("SASMessageQueue") || (publicType = trans.getPublicType()) != null && publicType.length() != 0) continue;
                messagesToUpdate.add(trans);
            }
            for (int i = 0; i < lColumnsToUpdate.size(); ++i) {
                Column column = (Column)lColumnsToUpdate.get(i);
                DataTable table = column.getTable();
                if (table == null || "PhysicalTable".equals(table.getCMetadataType()) || "ExternalTable".equals(table.getCMetadataType()) || tablesToColumnUpdate.contains(table)) continue;
                tablesToColumnUpdate.add(table);
            }
            for (DataTable table : tablesToColumnUpdate) {
                ArrayList<String> lSASColumnNames = new ArrayList<String>();
                ArrayList<Column> lColumns = new ArrayList<Column>();
                AssociationList columns = table.getColumns();
                for (Column column : columns) {
                    column.setPublicType("Embedded:Column");
                    column.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
                    String sasColName = column.getSASColumnName();
                    if (sasColName == null || sasColName.length() == 0) {
                        lColumns.add(column);
                        continue;
                    }
                    lSASColumnNames.add(sasColName);
                }
                UpgradeJobAction.fixSASColumnNames(status, lColumns, lSASColumnNames);
                table.updateMetadataAll();
            }
            UpgradeJobAction.updateAndMigrateMessageQueues(status, mdoJob, messagesToUpdate);
        }
        catch (MdException e) {
            status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)mdoJob), (Throwable)e);
            logger.error((Object)("Error upgrading job \"" + mdoJob + "\""), (Throwable)e);
            throw e;
        }
        catch (RemoteException e) {
            status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)mdoJob), (Throwable)e);
            logger.error((Object)("Error upgrading job \"" + mdoJob + "\""), (Throwable)e);
            throw e;
        }
        catch (BackingStoreException e) {
            status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)mdoJob), (Throwable)e);
            logger.error((Object)("Error upgrading job \"" + mdoJob + "\""), (Throwable)e);
            throw new MdException((Throwable)e);
        }
        catch (Exception e) {
            status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)mdoJob), (Throwable)e);
            logger.error((Object)("Error upgrading job \"" + mdoJob + "\""), (Throwable)e);
            throw new MdException((Throwable)e);
        }
        finally {
            if (mdl != null) {
                mdl.dispose();
            }
            if (omr != null) {
                omr.dispose();
            }
        }
    }

    private static boolean doesLoopExistInJob(Job mdoJob) throws RemoteException, MdException {
        boolean returnValue = false;
        Stack<Job> jobStack = new Stack<Job>();
        jobStack.push(mdoJob);
        returnValue = UpgradeJobAction.doesLoopExistInInnerJob(mdoJob, jobStack);
        jobStack.pop();
        return returnValue;
    }

    private static boolean doesLoopExistInInnerJob(Job mdoJob, Stack jobStack) throws RemoteException, MdException {
        boolean returnValue = false;
        AssociationList lJobActivities = mdoJob.getJobActivities();
        if (lJobActivities != null && lJobActivities.size() > 0) {
            AssociationList lSteps = ((TransformationActivity)lJobActivities.get(0)).getSteps();
            ArrayList<TransformationStep> listOfInnerJobs = new ArrayList<TransformationStep>();
            block0: for (TransformationStep step : lSteps) {
                AssociationList properties = step.getProperties();
                for (int j = 0; j < properties.size(); ++j) {
                    String classname;
                    Property prop = (Property)properties.get(j);
                    if (!"Class".equals(prop.getPropertyName()) || !INNERJOB_TRANSFORM_ROLE.equals(classname = prop.getDefaultValue())) continue;
                    listOfInnerJobs.add(step);
                    continue block0;
                }
            }
            for (int i = 0; i < listOfInnerJobs.size() && !returnValue; ++i) {
                Object obj;
                TransformationStep jobStep = (TransformationStep)listOfInnerJobs.get(i);
                AssociationList lTransformations = jobStep.getTransformations();
                if (lTransformations == null || lTransformations.isEmpty() || !((obj = lTransformations.get(0)) instanceof Job)) continue;
                Job innerJob = (Job)obj;
                if (jobStack.contains(innerJob)) {
                    returnValue = true;
                    break;
                }
                jobStack.push(innerJob);
                returnValue = UpgradeJobAction.doesLoopExistInInnerJob(innerJob, jobStack);
                jobStack.pop();
            }
        }
        return returnValue;
    }

    private static void updateAndMigrateMessageQueues(ProcessStatus status, Job mdoJob, List messagesToUpdate) throws RemoteException, MdException, ServiceException {
        for (Transformation trans : messagesToUpdate) {
            String existingType = trans.getPublicType();
            if (existingType != null && existingType.length() != 0) continue;
            String oldName = trans.getName();
            boolean isProjectRepositoryObject = trans.getObjectStore().getFactory().getRepositoryUtil().isProjectType("A0000001." + trans.getRepositoryID());
            if (isProjectRepositoryObject) {
                trans.delete();
                trans.updateMetadataAll();
                status.addWarning("Message queue \"" + oldName + "\" was deleted.  Message Queue not supported in projects.  Please update job with existing message queue after upgrade.");
                continue;
            }
            trans.setPublicType("MessageQueue");
            trans.updateMetadataAll();
            String transWPath = ProcessStatus.generateLoggingName((CMetadata)trans);
            ETLMigrationStatus queueStatus = new ETLMigrationStatus(ETLMigrationUtility.getLogger(0), "message queue", "MessageQueue");
            ETLMigrationProcessor processor = new ETLMigrationProcessor(Workspace.getWorkspace().getUserContext().getAuthServer());
            processor.migrateMessageQueue(queueStatus, trans);
            transWPath = ProcessStatus.generateLoggingName((CMetadata)trans);
            status.addInfo(Message.format((String)RB.getStringResource("UpgradeJobAction.CreatingSASMessageQueueWarning.fmt.txt"), (Object)transWPath));
            List migrateList = processor.getStatusList();
            String newName = trans.getName();
            if (newName != oldName) {
                int newStartIndex = newName.indexOf(40);
                if (newName.endsWith(")") && newStartIndex > 0) {
                    String queueName = newName.substring(0, newStartIndex);
                    Transformation newTrans = null;
                    AssociationList servers = trans.getDeployedComponents();
                    if (servers.size() > 0) {
                        DeployedComponent queueManager = (DeployedComponent)servers.get(0);
                        AssociationList queues = queueManager.getInitProcesses();
                        Iterator queueIter = queues.iterator();
                        while (queueIter.hasNext() && newTrans == null) {
                            Transformation queueObject;
                            AbstractTransformation object = (AbstractTransformation)queueIter.next();
                            if (!(object instanceof Transformation) || !(queueObject = (Transformation)object).getName().equals(queueName) || !queueObject.getTransformRole().equals(trans.getTransformRole())) continue;
                            newTrans = queueObject;
                        }
                    }
                    if (newTrans != null) {
                        AssociationList targetTransformations = trans.getTargetTransformations();
                        newTrans.getTargetTransformations().addAll((Collection)targetTransformations);
                        AssociationList transformationSources = trans.getTransformationSources();
                        newTrans.getTransformationSources().addAll((Collection)transformationSources);
                        AssociationList transformationTargets = trans.getTransformationTargets();
                        newTrans.getTransformationTargets().addAll((Collection)transformationTargets);
                        trans.delete();
                        newTrans.updateMetadataAll();
                        String newTransPath = ProcessStatus.generateLoggingName(newTrans);
                        status.addInfo(Message.format((String)RB.getStringResource("UpgradeJobAction.ReplaceMessageQueueMessage.fmt.txt"), (Object)newTransPath, (Object)transWPath));
                    } else {
                        status.addWarning(Message.format((String)RB.getStringResource("UpgradeJobAction.MessageQueueInvalidForCodegen.fmt.txt"), (Object)transWPath));
                    }
                }
            }
            for (ETLMigrationStatus migStatus : migrateList) {
                if (!migStatus.hasErrors()) continue;
                status.addError(Message.format((String)RB.getStringResource("BatchETLMigration.ErrorMigratingType.txt"), (Object)migStatus.getDisplayName()));
            }
        }
    }

    private static boolean isUpgradeable(Job mdoJob) throws RemoteException, MdException {
        return !UpgradeJobAction.isCubeJob(mdoJob) && WsAbstractVersionedObjectManager.isUpgradeable((String)mdoJob.getPublicType(), (UsageVersion)UsageVersion.decode((double)mdoJob.getUsageVersion()));
    }

    private static boolean isCubeJob(Job mdoJob) throws RemoteException, MdException {
        AssociationList acts = mdoJob.getJobActivities();
        for (int i = 0; i < acts.size(); ++i) {
            TransformationActivity ta = (TransformationActivity)acts.get(i);
            AssociationList steps = ta.getSteps();
            for (int j = 0; j < steps.size(); ++j) {
                TransformationStep step = (TransformationStep)steps.get(j);
                if (!CUBE_CLASS_ID.equals(MacroPluginUtilities.getTransformationStepClassName((TransformationStep)step))) continue;
                return true;
            }
        }
        return false;
    }

    public static void convertConditionActions(ProcessStatus status, MdObjectStore store, Root oMetadataObject, List templates) throws MdException, RemoteException {
        ArrayList<Object> deleteList = new ArrayList<Object>();
        if (((AbstractTransformation)oMetadataObject).getConditionActionSets().size() > 0) {
            return;
        }
        AssociationList lEvents = ((AbstractTransformation)oMetadataObject).getTriggeredEvents();
        for (int i = 0; i < lEvents.size(); ++i) {
            Event event = (Event)lEvents.get(i);
            StringBuffer sOptions = new StringBuffer(150);
            sOptions.append("<Templates>");
            sOptions.append("<Event>");
            sOptions.append("<PropertySets>");
            sOptions.append("<PropertySet>");
            sOptions.append("<SetProperties>");
            sOptions.append("<Property>");
            sOptions.append("<Properties/>");
            sOptions.append("</Property>");
            sOptions.append("</SetProperties>");
            sOptions.append("</PropertySet>");
            sOptions.append("</PropertySets>");
            sOptions.append("</Event>");
            sOptions.append("</Templates>");
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)event, null, null, sOptions.toString(), 268);
            for (int j = 0; j < event.getPropertySets().size(); ++j) {
                PropertySet set = (PropertySet)event.getPropertySets().get(j);
                deleteList.add(set);
                if (!"Actions".equalsIgnoreCase(set.getSetRole())) continue;
                ConditionActionSet abortSet = null;
                for (int k = 0; k < set.getSetProperties().size(); ++k) {
                    ConditionActionSet foundTemplate;
                    Property action = (Property)set.getSetProperties().get(k);
                    deleteList.add(action);
                    if (!"action".equalsIgnoreCase(action.getPropertyRole()) || (foundTemplate = UpgradeJobAction.findConditionActionSetTemplate(status, templates, event)) == null) continue;
                    boolean bExists = UpgradeJobAction.doesTemplateActionExist(status, foundTemplate, action);
                    if (!bExists) {
                        ETLMigrationUtility.getLogger().warn("This action was not found in the standard set of actions and could not be migrated.  This may be a user defined action and will require additional handling: " + action.getPropertyName());
                        status.addWarning(Message.format((String)RB.getStringResource("UpgradeJobAction.UserDefinedActionNotMigrated.fmt.txt"), (Object)action.getPropertyName()));
                        continue;
                    }
                    ConditionActionSet newSet = UpgradeJobAction.makeNewConditionActionSet((MdObjectStore)event.getObjectStore(), foundTemplate, event.getRepositoryID());
                    newSet.setPrototypeConditionActionSet(foundTemplate);
                    if ("Abort".equalsIgnoreCase(action.getPropertyName()) && abortSet == null) {
                        abortSet = newSet;
                    } else {
                        ((AbstractTransformation)oMetadataObject).getConditionActionSets().add((Object)newSet);
                    }
                    Action templateAction = UpgradeJobAction.findTemplateAction(status, foundTemplate, action);
                    if (templateAction != null) {
                        ArrayList<Property> lOldStyleProperties = new ArrayList<Property>();
                        if (action.getProperties().size() > 0) {
                            AssociationList retrievedProperties = action.getProperties();
                            for (int t = 0; t < retrievedProperties.size(); ++t) {
                                Property property = (Property)retrievedProperties.get(t);
                                lOldStyleProperties.add(property);
                                deleteList.add(property);
                            }
                        }
                        UpgradeJobAction.makeNewAction(store, templateAction, action, lOldStyleProperties, event.getRepositoryID(), newSet, event);
                        continue;
                    }
                    status.addWarning(Message.format((String)RB.getStringResource("UpgradeJobAction.UserDefinedActionNotMigrated.fmt.txt"), (Object)action.getName()));
                    ETLMigrationUtility.getLogger().error("This action could not be migrated: " + action.getName());
                }
                if (abortSet == null) continue;
                ((AbstractTransformation)oMetadataObject).getConditionActionSets().add(abortSet);
                abortSet = null;
            }
            deleteList.add(event);
        }
        if (deleteList.size() > 0) {
            store.removeObjectsFromStore(deleteList);
        }
    }

    private static boolean doesTemplateActionExist(ProcessStatus status, ConditionActionSet foundTemplateSet, Property oldStyleAction) throws MdException, RemoteException {
        AssociationList templateActions = foundTemplateSet.getActions();
        for (int i = 0; i < templateActions.size(); ++i) {
            Action templateAction = (Action)templateActions.get(i);
            if (!templateAction.getActionType().equalsIgnoreCase(oldStyleAction.getPropertyName())) continue;
            return true;
        }
        String xmlselect = "<XMLSELECT search=\"*[@PublicType='Action']\"/>";
        StringBuffer sOptions = new StringBuffer();
        sOptions.append(xmlselect);
        List lAllActions = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(foundTemplateSet.getObjectStore(), Workspace.getMdFactory().getOMIUtil().getFoundationReposID(), "Action", 392, sOptions.toString());
        if (!lAllActions.isEmpty()) {
            for (int i = 0; i < lAllActions.size(); ++i) {
                Action newTemplateAction = (Action)lAllActions.get(i);
                if (!newTemplateAction.getActionType().equalsIgnoreCase(oldStyleAction.getPropertyName())) continue;
                try {
                    foundTemplateSet.setDesc(foundTemplateSet.getDesc());
                    foundTemplateSet.updateMetadataAll();
                }
                catch (MdException ex) {
                    status.addWarning(Message.format((String)RB.getStringResource("UpgradeJobAction.UserDefinedActionUnrestricted.fmt.txt"), (Object)oldStyleAction.getPropertyName(), (Object)foundTemplateSet.getUniqueIdentifier()));
                    ETLMigrationUtility.getLogger().error("The action named " + oldStyleAction.getPropertyName() + " was on this template named " + foundTemplateSet.getUniqueIdentifier() + ".  In order to upgrade you have to import or update as unrestricted user.");
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static Action findTemplateAction(ProcessStatus status, ConditionActionSet foundTemplateSet, Property oldStyleAction) throws MdException, RemoteException {
        AssociationList templateActions = foundTemplateSet.getActions();
        for (int i = 0; i < templateActions.size(); ++i) {
            Action templateAction = (Action)templateActions.get(i);
            if (!templateAction.getActionType().equalsIgnoreCase(oldStyleAction.getPropertyName())) continue;
            return templateAction;
        }
        String xmlselect = "<XMLSELECT search=\"*[@PublicType='Action']\"/>";
        StringBuffer sOptions = new StringBuffer();
        sOptions.append(xmlselect);
        List lAllActions = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(foundTemplateSet.getObjectStore(), Workspace.getMdFactory().getOMIUtil().getFoundationReposID(), "Action", 392, sOptions.toString());
        if (!lAllActions.isEmpty()) {
            for (int i = 0; i < lAllActions.size(); ++i) {
                Action newTemplateAction = (Action)lAllActions.get(i);
                if (!newTemplateAction.getActionType().equalsIgnoreCase(oldStyleAction.getPropertyName())) continue;
                try {
                    foundTemplateSet.setDesc(foundTemplateSet.getDesc());
                    foundTemplateSet.updateMetadataAll();
                }
                catch (MdException ex) {
                    status.addWarning(Message.format((String)RB.getStringResource("UpgradeJobAction.UserDefinedActionUnrestricted.fmt.txt"), (Object)oldStyleAction.getPropertyName(), (Object)foundTemplateSet.getUniqueIdentifier()));
                    ETLMigrationUtility.getLogger().error(ex.getMessage(), ex.fillInStackTrace());
                    ETLMigrationUtility.getLogger().error("A user defined action named " + oldStyleAction.getPropertyName() + " was on this template named " + foundTemplateSet.getUniqueIdentifier() + ".  In order to upgrade you have to import or update as unrestricted user.");
                    return null;
                }
                foundTemplateSet.getActions().add((Object)newTemplateAction);
                return newTemplateAction;
            }
        }
        return null;
    }

    private static List getConditionActionSetTemplates(MdObjectStore store) throws MdException, RemoteException {
        ArrayList lConditionActionSets = new ArrayList();
        StringBuffer sOptions = new StringBuffer(CAS_TEMPLATE);
        String xmlselect = "<XMLSELECT search=\"*[@PublicType='ConditionActionSet']\"/>";
        sOptions.append(xmlselect);
        List objects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, Workspace.getMdFactory().getOMIUtil().getFoundationReposID(), "ConditionActionSet", 396, sOptions.toString());
        if (!objects.isEmpty()) {
            lConditionActionSets.addAll(objects);
        }
        return lConditionActionSets;
    }

    private static ConditionActionSet findConditionActionSetTemplate(ProcessStatus status, List templates, Event event) throws MdException, RemoteException {
        ConditionActionSet foundSet = null;
        if (event.getEventRole() == null) {
            ETLMigrationUtility.getLogger().error("A condition was found that is missing its type.  This condition could not be migrated.");
            return null;
        }
        if (event.getEventRole().equalsIgnoreCase("Condition1")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETSUCCESS");
        } else if (event.getEventRole().equalsIgnoreCase("Condition2")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETWARN");
        } else if (event.getEventRole().equalsIgnoreCase("Condition3")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETERROR");
        } else if (event.getEventRole().equalsIgnoreCase("Condition4")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETDATAMODIFIED");
        } else if (event.getEventRole().equalsIgnoreCase("Condition5")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETTABLECREATED");
        } else if (event.getEventRole().equalsIgnoreCase("Condition6")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETTABLEDROPPED");
        } else if (event.getEventRole().equalsIgnoreCase("Condition8")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETTABLETRUNCATED");
        } else if (event.getEventRole().equalsIgnoreCase("Condition9")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETTABLENOEXIST");
        } else if (event.getEventRole().equalsIgnoreCase("Condition10")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETTABLENOMATCH");
        } else if (event.getEventRole().equalsIgnoreCase("Condition11")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETDATAEXCEPTION");
        } else if (event.getEventRole().equalsIgnoreCase("Condition12")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETJOBSTATUS");
        } else if (event.getEventRole().equalsIgnoreCase("Condition14")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETLOOKUPMISS");
        } else if (event.getEventRole().equalsIgnoreCase("Condition15")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETLOOKUPNOREC");
        } else if (event.getEventRole().equalsIgnoreCase("Condition16")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETLOOKUPNOFOUND");
        } else if (event.getEventRole().equalsIgnoreCase("Condition17")) {
            foundSet = UpgradeJobAction.findConditionActionSet(templates, "DIS_SETERRORINPROC");
        }
        if (foundSet != null) {
            return foundSet;
        }
        status.addWarning(Message.format((String)RB.getStringResource("UpgradeJobAction.UserDefinedCondition.fmt.txt"), (Object)event.getEventRole()));
        ETLMigrationUtility.getLogger().error("Condition " + event.getEventRole() + " was not found in the standard set of condition sets.  This may be one that was added by a user, and will have to be manually migrated.");
        return null;
    }

    private static ConditionActionSet findConditionActionSet(List templates, String uniqueID) throws MdException, RemoteException {
        for (int i = 0; i < templates.size(); ++i) {
            ConditionActionSet templateSet = (ConditionActionSet)templates.get(i);
            if (!templateSet.getUniqueIdentifier().equalsIgnoreCase(uniqueID)) continue;
            return templateSet;
        }
        return null;
    }

    private static ConditionActionSet makeNewConditionActionSet(MdObjectStore store, ConditionActionSet templateSet, String reposID) throws MdException, RemoteException {
        ConditionActionSet oNewSet = (ConditionActionSet)Workspace.getMdFactory().createComplexMetadataObject(store, templateSet.getName(), "ConditionActionSet", reposID);
        oNewSet.setConditionActionSetType(templateSet.getConditionActionSetType());
        oNewSet.setInstanceVersion(templateSet.getInstanceVersion());
        oNewSet.setUniqueIdentifier(templateSet.getUniqueIdentifier());
        oNewSet.setName(templateSet.getName());
        oNewSet.setDesc(templateSet.getDesc());
        oNewSet.setPublicType("Embedded:ConditionActionSet");
        oNewSet.setUsageVersion("1000000.0");
        Condition templateCondition = templateSet.getAssociatedCondition();
        UpgradeJobAction.makeNewCondition(store, templateCondition, reposID, oNewSet);
        return oNewSet;
    }

    private static Condition makeNewCondition(MdObjectStore store, Condition templateCondition, String reposID, ConditionActionSet owningSet) throws MdException, RemoteException {
        Condition oNewCondition = (Condition)Workspace.getMdFactory().createComplexMetadataObject(store, templateCondition.getName(), "Condition", reposID);
        oNewCondition.setConditionType(templateCondition.getConditionType());
        oNewCondition.setInstanceVersion(templateCondition.getInstanceVersion());
        oNewCondition.setIsActive(templateCondition.getIsActive());
        oNewCondition.setUniqueIdentifier(templateCondition.getUniqueIdentifier());
        oNewCondition.getConditionActionSets().add((Object)owningSet);
        oNewCondition.setPublicType("Embedded:Condition");
        oNewCondition.setUsageVersion("1000000.0");
        return oNewCondition;
    }

    private static Action makeNewAction(MdObjectStore store, Action templateAction, Property instanceAction, List instanceActionProperties, String reposID, ConditionActionSet owningSet, Event event) throws MdException, RemoteException {
        Action oNewAction = (Action)Workspace.getMdFactory().createComplexMetadataObject(store, templateAction.getName(), "Action", reposID);
        oNewAction.setActionType(templateAction.getActionType());
        oNewAction.setInstanceVersion(templateAction.getInstanceVersion());
        oNewAction.setUniqueIdentifier(templateAction.getUniqueIdentifier());
        oNewAction.getConditionActionSets().add((Object)owningSet);
        oNewAction.setPublicType("Embedded:Action");
        oNewAction.setUsageVersion("1000000.0");
        PropertySet templateActionOptionsPropertySet = null;
        if (templateAction.getPropertySets().size() > 0) {
            templateActionOptionsPropertySet = (PropertySet)templateAction.getPropertySets().get(0);
            PropertySet oNewSet = (PropertySet)Workspace.getMdFactory().createComplexMetadataObject(store, templateActionOptionsPropertySet.getName(), "PropertySet", reposID);
            oNewSet.setDesc(templateActionOptionsPropertySet.getDesc());
            oNewSet.setPropertySetName(templateActionOptionsPropertySet.getPropertySetName());
            oNewSet.setSetRole(templateActionOptionsPropertySet.getSetRole());
            oNewSet.setOwningObject((Root)oNewAction);
            AssociationList templateSetProperties = templateActionOptionsPropertySet.getSetProperties();
            block0: for (int i = 0; i < templateSetProperties.size(); ++i) {
                Property templateProperty = (Property)templateSetProperties.get(i);
                Property oNewProperty = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, templateProperty.getName(), "Property", reposID);
                oNewProperty.setDesc(templateProperty.getDesc());
                oNewProperty.setDelimiter(templateProperty.getDelimiter());
                oNewProperty.setPropertyName(templateProperty.getPropertyName());
                oNewProperty.setPropertyRole(templateProperty.getPropertyRole());
                oNewProperty.setUseValueOnly(templateProperty.getUseValueOnly());
                oNewProperty.getAssociatedPropertySets().add((Object)oNewSet);
                for (int j = 0; j < instanceActionProperties.size(); ++j) {
                    Property instanceActionProperty = (Property)instanceActionProperties.get(j);
                    UpgradeJobAction.fixupPropertyName(instanceActionProperty);
                    String sPropertyName = instanceActionProperty.getPropertyName();
                    if (sPropertyName.equalsIgnoreCase("Table Name (libref.table)")) {
                        sPropertyName = "Table_Name";
                    } else if (sPropertyName.equalsIgnoreCase("TableName")) {
                        sPropertyName = "Table_Name";
                    } else if (sPropertyName.equalsIgnoreCase("Email Address")) {
                        sPropertyName = "Email_Address";
                    } else if (sPropertyName.equalsIgnoreCase("Path and Filename")) {
                        sPropertyName = instanceActionProperty.getAssociatedObject() instanceof Property && instanceActionProperty.getAssociatedObject().getName().equalsIgnoreCase("Send Entry To Text File") ? "FileName" : "Path_and_Filename";
                    }
                    if (oNewProperty.getPropertyRole().equalsIgnoreCase("Event") && instanceActionProperty.getPropertyRole().equalsIgnoreCase("Event") || oNewProperty.getPropertyRole().equalsIgnoreCase("SoftwareComponent") && instanceActionProperty.getPropertyRole().equalsIgnoreCase("SoftwareComponent") || oNewProperty.getPropertyRole().equalsIgnoreCase("ServiceComponent") && instanceActionProperty.getPropertyRole().equalsIgnoreCase("ServiceComponent") || oNewProperty.getPropertyRole().equalsIgnoreCase("ListenerType") && instanceActionProperty.getPropertyRole().equalsIgnoreCase("ListenerType")) {
                        oNewProperty.setName(sPropertyName);
                        oNewProperty.setPropertyName(sPropertyName);
                    }
                    if (!oNewProperty.getPropertyName().equalsIgnoreCase(sPropertyName) && (!oNewProperty.getPropertyName().equalsIgnoreCase("Email_Address") || sPropertyName.indexOf("Address") <= -1)) continue;
                    oNewProperty.setDefaultValue(instanceActionProperty.getDefaultValue());
                    if (!"DIS_SETTARGETCOL".equalsIgnoreCase(oNewAction.getUniqueIdentifier()) || instanceActionProperty.getSpecTargetTransformations().size() <= 0) continue block0;
                    TextStore text = (TextStore)Workspace.getMdFactory().createComplexMetadataObject(store, instanceActionProperty.getName(), "TextStore", reposID);
                    text.setStoredText(instanceActionProperty.getDefaultValue());
                    FeatureMap fm = (FeatureMap)instanceActionProperty.getSpecTargetTransformations().get(0);
                    fm.setSourceCode((Text)text);
                    fm.getTargetSpecifications().clear();
                    fm.getTargetSpecifications().add((Object)oNewProperty);
                    continue block0;
                }
            }
        }
        return oNewAction;
    }

    private static void fixupPropertyName(Property propertyToFixup) throws RemoteException {
        if ("Custom Code".equalsIgnoreCase(propertyToFixup.getPropertyName())) {
            propertyToFixup.setPropertyName("Custom");
        } else if ("Email Address".equalsIgnoreCase(propertyToFixup.getPropertyName())) {
            propertyToFixup.setPropertyName("Address");
        } else if ("Path and File Name".equalsIgnoreCase(propertyToFixup.getPropertyName())) {
            propertyToFixup.setPropertyName("FileName");
        } else if ("Dataset Name".equalsIgnoreCase(propertyToFixup.getPropertyName())) {
            propertyToFixup.setPropertyName("Dataset");
        } else if ("Return Code".equalsIgnoreCase(propertyToFixup.getPropertyName())) {
            propertyToFixup.setPropertyName("ReturnCode");
        } else if (propertyToFixup.getPropertyName().length() == 0) {
            if (propertyToFixup.getName().equalsIgnoreCase("Path and Filename")) {
                propertyToFixup.setPropertyName("Path and Filename");
            } else {
                propertyToFixup.setPropertyName(propertyToFixup.getDesc());
            }
        }
    }

    private static synchronized void upgradeExtractOrderByTransform(OMRAdapter omr, ExtractTransformModel model, TransformationStep step) throws MdException, RemoteException {
        IOrderBy orderBy = model.getOrderBy();
        AssociationList lTransformations = step.getTransformations();
        if (lTransformations != null && !lTransformations.isEmpty()) {
            Select select = (Select)lTransformations.get(0);
            OrderByClause obc = select.getOrderByForSelect();
            if (obc == null) {
                return;
            }
            AssociationList byColumnsList = obc.getColumns();
            AssociationList ptList = select.getClassifierTargets();
            List columnsList = null;
            if (!ptList.isEmpty()) {
                DataTable pt = (DataTable)ptList.get(0);
                columnsList = pt.getColumns();
            }
            if (columnsList != null && columnsList.size() > 0) {
                block0: for (int i = 0; i < byColumnsList.size(); ++i) {
                    Column col = (Column)byColumnsList.get(i);
                    for (int j = 0; j < columnsList.size(); ++j) {
                        Column clCol = (Column)columnsList.get(j);
                        if (clCol != col) continue;
                        String sortDirection = col.getSortOrder();
                        IColumn modelColumn = (IColumn)omr.acquireObject((Root)col);
                        if (SORT_DESCENDING_34.equals(sortDirection)) {
                            orderBy.getSortColumnContainingColumn(modelColumn).setDirection("descending");
                            continue block0;
                        }
                        orderBy.getSortColumnContainingColumn(modelColumn).setDirection("ascending");
                        continue block0;
                    }
                }
            }
        }
    }

    private static synchronized void upgradeSortTransform(OMRAdapter omr, SortTransformModel sortModel, TransformationStep step) throws MdException, RemoteException {
        ISorting sortOrder = sortModel.getSortOrder();
        AssociationList lTransformations = step.getTransformations();
        if (lTransformations != null && !lTransformations.isEmpty()) {
            Select select = (Select)lTransformations.get(0);
            OrderByClause obc = select.getOrderByForSelect();
            AssociationList byColumnsList = obc.getColumns();
            AssociationList ptList = select.getClassifierTargets();
            List columnsList = null;
            if (!ptList.isEmpty()) {
                DataTable pt = (DataTable)ptList.get(0);
                columnsList = pt.getColumns();
            }
            if (columnsList != null && columnsList.size() > 0) {
                block0: for (int i = 0; i < byColumnsList.size(); ++i) {
                    Column col = (Column)byColumnsList.get(i);
                    for (int j = 0; j < columnsList.size(); ++j) {
                        Column clCol = (Column)columnsList.get(j);
                        if (clCol != col) continue;
                        String sortDirection = col.getSortOrder();
                        IColumn modelColumn = (IColumn)omr.acquireObject((Root)col);
                        if (SORT_DESCENDING_34.equals(sortDirection)) {
                            sortOrder.getSortColumnContainingColumn(modelColumn).setDirection("descending");
                            continue block0;
                        }
                        sortOrder.getSortColumnContainingColumn(modelColumn).setDirection("ascending");
                        continue block0;
                    }
                }
            }
        }
    }

    private static synchronized void upgradeBusinessKeys(OMRAdapter omr, ISCDTransformModel scdModel, TransformationStep step) throws MdException, RemoteException {
        block5: {
            ClassifierMap cM;
            AssociationList lTargetTables;
            block6: {
                AssociationList lActivities = step.getActivities();
                if (lActivities == null || lActivities.isEmpty()) break block5;
                TransformationActivity ta = (TransformationActivity)lActivities.get(0);
                AssociationList lTables = ta.getTransformationTargets();
                IDataObject[] targets = scdModel.getDataTargets();
                if (lTables == null || lTables.isEmpty()) break block6;
                for (int i = 0; i < lTables.size(); ++i) {
                    Object obj = lTables.get(i);
                    if (!(obj instanceof DataTable)) continue;
                    DataTable table = (DataTable)obj;
                    for (int j = 0; j < targets.length; ++j) {
                        Key key;
                        if (!table.getFQID().equals(targets[j].getID()) || (key = SCDType2Utilities.findLogicalKey((DataTable)((DataTable)obj), (String)"BUSINESS_KEY")) == null) continue;
                        AssociationList lColumns = key.getKeyedColumns();
                        for (int k = 0; k < lColumns.size(); ++k) {
                            scdModel.addBusinessKeyColumn((IColumn)omr.acquireObject((Root)((Column)lColumns.get(k))));
                        }
                    }
                }
                break block5;
            }
            AssociationList lTransforms = step.getTransformations();
            if (lTransforms == null || lTransforms.isEmpty() || (lTargetTables = (cM = (ClassifierMap)lTransforms.get(0)).getClassifierTargets()) == null || lTargetTables.isEmpty()) break block5;
            for (int i = 0; i < lTargetTables.size(); ++i) {
                Key key;
                Object obj = lTargetTables.get(i);
                if (!(obj instanceof DataTable) || (key = SCDType2Utilities.findLogicalKey((DataTable)((DataTable)obj), (String)"BUSINESS_KEY")) == null) continue;
                AssociationList lColumns = key.getKeyedColumns();
                for (int j = 0; j < lColumns.size(); ++j) {
                    scdModel.addBusinessKeyColumn((IColumn)omr.acquireObject((Root)((Column)lColumns.get(j))));
                }
            }
        }
    }

    private static synchronized void upgradeGeneratedKey(MdObjectStore store, Job job, TransformationStep step, ProcessStatus status) throws MdException, RemoteException {
        AssociationList lColumns;
        DataTable table;
        Key key;
        ClassifierMap cM;
        AssociationList lTables;
        AssociationList lTransforms = step.getTransformations();
        if (lTransforms != null && !lTransforms.isEmpty() && (lTables = (cM = (ClassifierMap)lTransforms.get(0)).getClassifierTargets()) != null && !lTables.isEmpty() && (key = SCDType2Utilities.findLogicalKey((DataTable)(table = (DataTable)lTables.get(0)), (String)"GENERATED_KEY")) != null && (lColumns = key.getKeyedColumns()).size() > 0) {
            Column column = (Column)lColumns.get(0);
            AssociationList lCustAssocs = step.getCustomAssociations();
            boolean foundGeneratedKey = false;
            for (int iCustAssoc = 0; iCustAssoc < lCustAssocs.size(); ++iCustAssoc) {
                CustomAssociation custAssoc = (CustomAssociation)lCustAssocs.get(iCustAssoc);
                String sName = custAssoc.getName();
                if (!sName.equals("SCD2_GeneratedKey")) continue;
                foundGeneratedKey = true;
                break;
            }
            if (!foundGeneratedKey) {
                CustomAssociation custAssoc = (CustomAssociation)Workspace.getMdFactory().createComplexMetadataObject(store, "SCD2_GeneratedKey", "CustomAssociation", step.getRepositoryID());
                custAssoc.setPartnerName("SCD2_GeneratedKeyPartner");
                custAssoc.setisOwned(0);
                AssociationList lKeyColumns = custAssoc.getAssociatedObjects();
                lKeyColumns.add(column);
                PropertyHandler keyProperties = new PropertyHandler((Root)key, "SCD2_RETAINEDKEY", true);
                String retainedKeyValue = keyProperties.getSpecificOptionValue("RetainedKey");
                String uniqueRetainedKeyValue = keyProperties.getSpecificOptionValue("UniqueRetainedKey");
                keyProperties = new PropertyHandler((Root)custAssoc, "SCD2_RETAINEDKEY", true);
                keyProperties.createPropertySet();
                keyProperties.setSpecificProperty("RetainedKey", retainedKeyValue);
                keyProperties.setSpecificProperty("UniqueRetainedKey", uniqueRetainedKeyValue);
                lCustAssocs.add(custAssoc);
            }
        }
    }

    private static synchronized void upgradeSCDLoadTimeColumn(MdObjectStore store, Job job, TransformationStep step, ProcessStatus status) throws MdException, RemoteException {
        Column loadTimeColumn;
        PropertySet optionsPropertySet = null;
        AssociationList propertySets = step.getPropertySets();
        for (int i = 0; i < propertySets.size(); ++i) {
            PropertySet propertySet = (PropertySet)propertySets.get(i);
            if (!"OPTIONS".equalsIgnoreCase(propertySet.getSetRole())) continue;
            optionsPropertySet = propertySet;
            break;
        }
        if (optionsPropertySet == null) {
            optionsPropertySet = (PropertySet)Workspace.getMdFactory().createComplexMetadataObject(store, "OPTIONS", "PropertySet", step.getRepositoryID());
            step.getPropertySets().add((Object)optionsPropertySet);
        }
        AssociationList optionsProperties = optionsPropertySet.getProperties();
        String loadTimeColumnName = null;
        Property oldLoadTimeProperty = null;
        for (int i = optionsProperties.size() - 1; i >= 0; --i) {
            Property property = (Property)optionsProperties.get(i);
            String propertyName = property.getPropertyName();
            if (!"LoadTime".equals(propertyName)) continue;
            oldLoadTimeProperty = property;
            loadTimeColumnName = property.getDefaultValue();
            optionsProperties.remove(i);
            break;
        }
        Property newLoadTimeProperty = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "LoadTime", "Property", step.getRepositoryID());
        newLoadTimeProperty.setPropertyName("LoadTime");
        newLoadTimeProperty.setPropertyRole("LoadTime");
        newLoadTimeProperty.setSQLType(2000);
        newLoadTimeProperty.setUseValueOnly(1);
        Transformation loadTimeTransformation = (Transformation)Workspace.getMdFactory().createComplexMetadataObject(store, null, "LoadTime", "Transformation", step.getRepositoryID());
        loadTimeTransformation.setTransformRole("LoadTime");
        loadTimeTransformation.setIsActive(1);
        newLoadTimeProperty.getSpecTargetTransformations().add((Object)loadTimeTransformation);
        if (loadTimeColumnName != null && loadTimeColumnName.length() > 0 && (loadTimeColumn = UpgradeJobAction.upgradeLoaderLoadTimeColumn(step, loadTimeColumnName)) != null) {
            if (!loadTimeColumn.getSASColumnType().equals("N")) {
                status.addWarning(ProcessStatus.generateLoggingName((CMetadata)step), Message.format((String)RB.getStringResource("UpgradeJobAction.NonNumericLoadTimeColumn.fmt.txt"), (Object)step.getName(), (Object)job.getName()));
            }
            loadTimeTransformation.getSourceSpecifications().add((Object)loadTimeColumn);
        }
        optionsProperties.add(newLoadTimeProperty);
        store.removeObjectFromStore((CMetadata)oldLoadTimeProperty, null);
    }

    private static synchronized void upgradeSPDSLoader(MdObjectStore store, Job job, TransformationStep step, ProcessStatus status) throws MdException, RemoteException {
        int i;
        PropertySet optionsPropertySet = null;
        AssociationList propertySets = step.getPropertySets();
        AssociationList properties = step.getProperties();
        for (i = 0; i < properties.size(); ++i) {
            Property prop = (Property)properties.get(i);
            if (!"DataTableOptions".equalsIgnoreCase(prop.getPropertyName())) continue;
            return;
        }
        for (i = 0; i < propertySets.size(); ++i) {
            PropertySet propertySet = (PropertySet)propertySets.get(i);
            if (!"OPTIONS".equalsIgnoreCase(propertySet.getSetRole())) continue;
            optionsPropertySet = propertySet;
            break;
        }
        if (optionsPropertySet == null) {
            return;
        }
        AssociationList optionsProperties = optionsPropertySet.getProperties();
        for (int i2 = optionsProperties.size() - 1; i2 >= 0; --i2) {
            Property property = (Property)optionsProperties.get(i2);
            String propertyName = property.getPropertyName();
            if (!"DataTableOptions".equals(propertyName)) continue;
            Property newDataTableOptionsProperty = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "DataTableOptions", "Property", step.getRepositoryID());
            newDataTableOptionsProperty.setDefaultValue(property.getDefaultValue());
            newDataTableOptionsProperty.setDesc(property.getDesc());
            newDataTableOptionsProperty.setPropertyName("DataTableOptions");
            newDataTableOptionsProperty.setPropertyRole("DataTableOptions");
            newDataTableOptionsProperty.setUseValueOnly(1);
            properties.add(newDataTableOptionsProperty);
            break;
        }
    }

    private static synchronized void upgradeLoaderTransform(MdObjectStore store, TransformationStep step) throws MdException, RemoteException {
        AssociationList properties = step.getProperties();
        String reposId = step.getRepositoryID();
        for (int j = 0; j < properties.size(); ++j) {
            Property prop = (Property)properties.get(j);
            if (!"Class".equals(prop.getPropertyName())) continue;
            prop.setDefaultValue(TableLoaderTransformModel.getTransformTypeID());
        }
        ArrayList<Property> deleteList = new ArrayList<Property>();
        AssociationList tsPropSets = step.getPropertySets();
        PropertySet tsOptionsSet = null;
        for (int i = 0; i < tsPropSets.size(); ++i) {
            PropertySet propSet_i = (PropertySet)tsPropSets.get(i);
            if (!"OPTIONS".equalsIgnoreCase(propSet_i.getSetRole())) continue;
            tsOptionsSet = propSet_i;
        }
        if (tsOptionsSet == null) {
            tsOptionsSet = (PropertySet)Workspace.getMdFactory().createComplexMetadataObject(store, "OPTIONS", "PropertySet", reposId);
            step.getPropertySets().add((Object)tsOptionsSet);
        }
        AssociationList oldOptionsSetProperties = tsOptionsSet.getProperties();
        tsOptionsSet.setSetRole("OPTIONS");
        PhysicalTable targetTable = null;
        AssociationList maps = step.getTransformations();
        if (maps.isEmpty()) {
            return;
        }
        ClassifierMap map = (ClassifierMap)step.getTransformations().get(0);
        AssociationList targets = map.getClassifierTargets();
        if (!targets.isEmpty()) {
            targetTable = (PhysicalTable)targets.get(0);
        }
        PropertySet setLoadStyle = (PropertySet)Workspace.getMdFactory().createComplexMetadataObject(store, null, "LoadStyle", "PropertySet", reposId);
        setLoadStyle.setSetRole("LoadStyle");
        Property pStyle = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "Style", "Property", reposId);
        pStyle.setPropertyName("Style");
        pStyle.setPropertyRole("Style");
        pStyle.setDefaultValue("Replace");
        pStyle.setSQLType(2000);
        pStyle.setUseValueOnly(1);
        setLoadStyle.getSetProperties().add((Object)pStyle);
        Property pReplaceType = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "ReplaceType", "Property", reposId);
        pReplaceType.setPropertyName("ReplaceType");
        pReplaceType.setPropertyRole("ReplaceType");
        pReplaceType.setDefaultValue("EntireTable");
        pReplaceType.setSQLType(2000);
        pReplaceType.setUseValueOnly(1);
        setLoadStyle.getSetProperties().add((Object)pReplaceType);
        PropertySet setRowActions = (PropertySet)Workspace.getMdFactory().createComplexMetadataObject(store, "RowActions", "PropertySet", reposId);
        setRowActions.setSetRole("RowActions");
        Property pMatchingRows = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "MatchingRows", "Property", reposId);
        pMatchingRows.setPropertyName("MatchingRows");
        pMatchingRows.setPropertyRole("MatchingRows");
        pMatchingRows.setDefaultValue("SQLSet");
        pMatchingRows.setSQLType(2000);
        pMatchingRows.setUseValueOnly(1);
        setRowActions.getSetProperties().add((Object)pMatchingRows);
        Property pNewRows = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "NewRows", "Property", reposId);
        pNewRows.setPropertyName("NewRows");
        pNewRows.setPropertyRole("NewRows");
        pNewRows.setDefaultValue("AppendProc");
        pNewRows.setSQLType(2000);
        pNewRows.setUseValueOnly(1);
        setRowActions.getSetProperties().add((Object)pNewRows);
        Property punique = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "unique", "Property", reposId);
        punique.setPropertyName("unique");
        punique.setPropertyRole("unique");
        punique.setDefaultValue("false");
        punique.setSQLType(2000);
        punique.setUseValueOnly(1);
        setRowActions.getSetProperties().add((Object)punique);
        Property pnomissingcheck = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "nomissingcheck", "Property", reposId);
        pnomissingcheck.setPropertyName("nomissingcheck");
        pnomissingcheck.setPropertyRole("nomissingcheck");
        pnomissingcheck.setDefaultValue("true");
        pnomissingcheck.setSQLType(2000);
        pnomissingcheck.setUseValueOnly(1);
        setRowActions.getSetProperties().add((Object)pnomissingcheck);
        Property pModifyIndex = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "ModifyIndex", "Property", reposId);
        pModifyIndex.setPropertyName("ModifyIndex");
        pModifyIndex.setPropertyRole("ModifyIndex");
        pModifyIndex.setDefaultValue("ModifyIndex");
        pModifyIndex.setSQLType(2000);
        pModifyIndex.setUseValueOnly(1);
        setRowActions.getSetProperties().add((Object)pModifyIndex);
        Property pMatchColumns = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "MatchColumns", "Property", reposId);
        pMatchColumns.setPropertyName("MatchColumns");
        pMatchColumns.setPropertyRole("MatchColumns");
        pMatchColumns.setDefaultValue("MatchColumns");
        pMatchColumns.setSQLType(2000);
        pMatchColumns.setUseValueOnly(1);
        setRowActions.getSetProperties().add((Object)pMatchColumns);
        PropertySet setAdditionalActions = (PropertySet)Workspace.getMdFactory().createComplexMetadataObject(store, null, "AdditionalActions", "PropertySet", reposId);
        setAdditionalActions.setSetRole("AdditionalActions");
        Property pConstraintActionBefore = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "ConstraintActionBefore", "Property", reposId);
        pConstraintActionBefore.setPropertyName("ConstraintActionBefore");
        pConstraintActionBefore.setPropertyRole("ConstraintActionBefore");
        pConstraintActionBefore.setDefaultValue("ASIS");
        pConstraintActionBefore.setSQLType(2000);
        pConstraintActionBefore.setUseValueOnly(1);
        setAdditionalActions.getSetProperties().add((Object)pConstraintActionBefore);
        Property pConstraintActionAfter = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "ConstraintActionAfter", "Property", reposId);
        pConstraintActionAfter.setPropertyName("ConstraintActionAfter");
        pConstraintActionAfter.setPropertyRole("ConstraintActionAfter");
        pConstraintActionAfter.setDefaultValue("ASIS");
        pConstraintActionAfter.setSQLType(2000);
        pConstraintActionAfter.setUseValueOnly(1);
        setAdditionalActions.getSetProperties().add((Object)pConstraintActionAfter);
        Property pIndexActionBefore = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "IndexActionBefore", "Property", reposId);
        pIndexActionBefore.setPropertyName("IndexActionBefore");
        pIndexActionBefore.setPropertyRole("IndexActionBefore");
        pIndexActionBefore.setDefaultValue("ASIS");
        pIndexActionBefore.setSQLType(2000);
        pIndexActionBefore.setUseValueOnly(1);
        setAdditionalActions.getSetProperties().add((Object)pIndexActionBefore);
        Property pIndexActionAfter = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "IndexActionAfter", "Property", reposId);
        pIndexActionAfter.setPropertyName("IndexActionAfter");
        pIndexActionAfter.setPropertyRole("IndexActionAfter");
        pIndexActionAfter.setDefaultValue("ASIS");
        pIndexActionAfter.setSQLType(2000);
        pIndexActionAfter.setUseValueOnly(1);
        setAdditionalActions.getSetProperties().add((Object)pIndexActionAfter);
        String sLoadType = "Refresh";
        String sDropIndex = "NO";
        String sUnique = "NO";
        String sUpdateType = "Implicit";
        String sNoMissingCheck = "NO";
        String sTruncate = "YES";
        String sKey = "";
        String sIndex = "";
        String sLoadTimeColumnName = "";
        map.getPropertySets().add((Object)setLoadStyle);
        map.getPropertySets().add((Object)setRowActions);
        map.getPropertySets().add((Object)setAdditionalActions);
        for (int i = oldOptionsSetProperties.size() - 1; i >= 0; --i) {
            Property oldProperty = (Property)oldOptionsSetProperties.get(i);
            String oldPropertyName = oldProperty.getPropertyName();
            if ("LoadTime".equals(oldPropertyName)) {
                sLoadTimeColumnName = oldProperty.getDefaultValue();
                deleteList.add(oldProperty);
                oldOptionsSetProperties.remove(i);
                continue;
            }
            if ("LoadType".equals(oldPropertyName)) {
                sLoadType = oldProperty.getDefaultValue();
                deleteList.add(oldProperty);
                oldOptionsSetProperties.remove(i);
                continue;
            }
            if ("DropIndex".equals(oldPropertyName)) {
                sDropIndex = oldProperty.getDefaultValue();
                deleteList.add(oldProperty);
                oldOptionsSetProperties.remove(i);
                continue;
            }
            if ("Unique".equals(oldPropertyName)) {
                sUnique = oldProperty.getDefaultValue();
                deleteList.add(oldProperty);
                oldOptionsSetProperties.remove(i);
                continue;
            }
            if ("UpdateType".equals(oldPropertyName)) {
                sUpdateType = oldProperty.getDefaultValue();
                deleteList.add(oldProperty);
                oldOptionsSetProperties.remove(i);
                continue;
            }
            if ("NoMissingCheck".equals(oldPropertyName)) {
                sNoMissingCheck = oldProperty.getDefaultValue();
                deleteList.add(oldProperty);
                oldOptionsSetProperties.remove(i);
                continue;
            }
            if ("Truncate".equals(oldPropertyName)) {
                sTruncate = oldProperty.getDefaultValue();
                deleteList.add(oldProperty);
                oldOptionsSetProperties.remove(i);
                continue;
            }
            if ("Key".equals(oldPropertyName)) {
                sKey = oldProperty.getDefaultValue();
                deleteList.add(oldProperty);
                oldOptionsSetProperties.remove(i);
                continue;
            }
            if (!"Index".equals(oldPropertyName)) continue;
            sIndex = oldProperty.getDefaultValue();
            deleteList.add(oldProperty);
            oldOptionsSetProperties.remove(i);
        }
        boolean bHasIndexes = false;
        if (targetTable != null) {
            bHasIndexes = targetTable.getIndexes().size() > 0;
        }
        Property pLoadTime = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "LoadTime", "Property", reposId);
        pLoadTime.setPropertyName("LoadTime");
        pLoadTime.setPropertyRole("LoadTime");
        pLoadTime.setSQLType(2000);
        pLoadTime.setUseValueOnly(1);
        Transformation tLoadTime = (Transformation)Workspace.getMdFactory().createComplexMetadataObject(store, null, "LoadTime", "Transformation", reposId);
        tLoadTime.setTransformRole("LoadTime");
        tLoadTime.setIsActive(1);
        pLoadTime.getSpecTargetTransformations().add((Object)tLoadTime);
        if (sLoadTimeColumnName.length() > 0) {
            Column oLoadTimeColumn = null;
            oLoadTimeColumn = UpgradeJobAction.upgradeLoaderLoadTimeColumn(step, sLoadTimeColumnName);
            if (oLoadTimeColumn != null) {
                tLoadTime.getSourceSpecifications().add((Object)oLoadTimeColumn);
            }
        }
        oldOptionsSetProperties.add(pLoadTime);
        Property pUnmappedEqMissingInUpdate = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, null, "UnmappedEqMissingInUpdate", "Property", reposId);
        pUnmappedEqMissingInUpdate.setPropertyName("UnmappedEqMissingInUpdate");
        pUnmappedEqMissingInUpdate.setPropertyRole("OPTION");
        pUnmappedEqMissingInUpdate.setSQLType(12);
        pUnmappedEqMissingInUpdate.setUseValueOnly(1);
        tsOptionsSet.getSetProperties().add((Object)pUnmappedEqMissingInUpdate);
        pUnmappedEqMissingInUpdate.setDefaultValue("YES");
        pConstraintActionBefore.setDefaultValue("ASIS");
        pConstraintActionAfter.setDefaultValue("ASIS");
        if (bHasIndexes) {
            if (sLoadType.equals("Update")) {
                pIndexActionBefore.setDefaultValue("INIT");
                pIndexActionAfter.setDefaultValue("ASIS");
            } else {
                pIndexActionBefore.setDefaultValue("ASIS");
                pIndexActionAfter.setDefaultValue("INIT");
            }
        }
        if (sLoadType.equals("Append")) {
            pStyle.setDefaultValue("AppendToExisting");
            if (sDropIndex.equals("YES")) {
                pIndexActionBefore.setDefaultValue("OFF");
                pIndexActionAfter.setDefaultValue("ON");
            }
        } else if (sLoadType.equals("Refresh") && sTruncate.equals("YES")) {
            pStyle.setDefaultValue("Replace");
            pConstraintActionBefore.setDefaultValue("ASIS");
            if (sDropIndex.equals("YES")) {
                pIndexActionBefore.setDefaultValue("OFF");
                pIndexActionAfter.setDefaultValue("ON");
            }
            String sReplaceTypeForTruncate = UpgradeJobAction.getLoaderReplaceTypeForTruncate(targetTable);
            pReplaceType.setDefaultValue(sReplaceTypeForTruncate);
            if (sReplaceTypeForTruncate.equals("SimulateTruncate")) {
                pConstraintActionBefore.setDefaultValue("RECREATEASIS");
            }
        } else if (sLoadType.equals("Refresh")) {
            pStyle.setDefaultValue("Replace");
            pReplaceType.setDefaultValue("EntireTable");
        } else if (sLoadType.equals("Update") && sUpdateType.equals("Implicit")) {
            pStyle.setDefaultValue("Update");
            pMatchingRows.setDefaultValue("SQLSet");
            pNewRows.setDefaultValue("InsertSQL");
            Transformation transformation = (Transformation)Workspace.getMdFactory().createComplexMetadataObject(store, null, "MatchColumns", "Transformation", reposId);
            transformation.setTransformRole("MatchColumns");
            transformation.setIsActive(1);
            pMatchColumns.getSpecTargetTransformations().add((Object)transformation);
            String[] aColumns = sKey.split(":::");
            block3: for (int t = 0; t < aColumns.length; ++t) {
                String strOldSASColumnName = aColumns[t];
                AssociationList lColumns = targetTable.getColumns();
                for (int j = 0; j < lColumns.size(); ++j) {
                    Column oNewTargetColumn = (Column)lColumns.get(j);
                    String sNewTargetSASColumnName = oNewTargetColumn.getSASColumnName();
                    if (!sNewTargetSASColumnName.equals(strOldSASColumnName)) continue;
                    transformation.getSourceSpecifications().add((Object)oNewTargetColumn);
                    continue block3;
                }
            }
        } else if (sLoadType.equals("Update") && sUpdateType.equals("BY")) {
            pStyle.setDefaultValue("Update");
            pMatchingRows.setDefaultValue("ModifyByColumn");
            pNewRows.setDefaultValue("ModifyByColumn");
            pnomissingcheck.setDefaultValue(sNoMissingCheck.equalsIgnoreCase("YES") ? "true" : "false");
            punique.setDefaultValue(sUnique.equalsIgnoreCase("YES") ? "true" : "false");
            Transformation transformation = (Transformation)Workspace.getMdFactory().createComplexMetadataObject(store, null, "ModifyByColumn", "Transformation", reposId);
            transformation.setTransformRole("ModifyByColumn");
            transformation.setIsActive(1);
            pMatchColumns.getSpecTargetTransformations().add((Object)transformation);
            String[] aColumns = sKey.split(":::");
            block5: for (int t = 0; t < aColumns.length; ++t) {
                String strOldSASColumnName = aColumns[t];
                AssociationList lColumns = targetTable.getColumns();
                for (int j = 0; j < lColumns.size(); ++j) {
                    Column oNewTargetColumn = (Column)lColumns.get(j);
                    String sNewTargetSASColumnName = oNewTargetColumn.getSASColumnName();
                    if (!sNewTargetSASColumnName.equals(strOldSASColumnName)) continue;
                    transformation.getSourceSpecifications().add((Object)oNewTargetColumn);
                    continue block5;
                }
            }
        } else if (sLoadType.equals("Update") && sUpdateType.equals("KEY")) {
            pStyle.setDefaultValue("Update");
            pMatchingRows.setDefaultValue("ModifyUsingIndex");
            pNewRows.setDefaultValue("ModifyUsingIndex");
            pnomissingcheck.setDefaultValue(sNoMissingCheck.equalsIgnoreCase("YES") ? "true" : "false");
            punique.setDefaultValue(sUnique.equalsIgnoreCase("YES") ? "true" : "false");
            Transformation transformation = (Transformation)Workspace.getMdFactory().createComplexMetadataObject(store, null, "ModifyIndex", "Transformation", reposId);
            transformation.setTransformRole("ModifyIndex");
            transformation.setIsActive(1);
            pModifyIndex.getSpecTargetTransformations().add((Object)transformation);
            AssociationList lIndexes = targetTable.getIndexes();
            for (int j = 0; j < lIndexes.size(); ++j) {
                Index oNewTargetIndex = (Index)lIndexes.get(j);
                if (!oNewTargetIndex.getName().equals(sIndex)) continue;
                transformation.getSourceSpecifications().add((Object)oNewTargetIndex);
                break;
            }
        }
        if (deleteList.size() > 0) {
            store.removeObjectsFromStore(deleteList);
        }
    }

    private static synchronized Column upgradeLoaderLoadTimeColumn(TransformationStep step, String sOldLoadtimeCol) throws RemoteException, MdException {
        ClassifierMap trans;
        AssociationList lTables;
        AssociationList lTransforms = step.getTransformations();
        if (lTransforms != null && !lTransforms.isEmpty() && lTransforms.get(0) instanceof ClassifierMap && (lTables = (trans = (ClassifierMap)lTransforms.get(0)).getClassifierTargets()) != null && !lTables.isEmpty()) {
            Column col = null;
            Object obj = lTables.get(0);
            if (obj instanceof DataTable) {
                DataTable targetTable = (DataTable)obj;
                AssociationList lColumns = targetTable.getColumns();
                for (int i = 0; i < lColumns.size(); ++i) {
                    col = (Column)lColumns.get(i);
                    if (!col.getSASColumnName().equalsIgnoreCase(sOldLoadtimeCol)) continue;
                    return col;
                }
            }
        }
        return null;
    }

    private static synchronized void removeAnyBadJoinMetadata(MdObjectStore store, TransformationStep step) throws MdException, RemoteException {
        AssociationList lCMs = step.getTransformations();
        if (lCMs.size() == 0) {
            return;
        }
        ClassifierMap cM = (ClassifierMap)lCMs.get(0);
        AssociationList sources = cM.getClassifierSources();
        AssociationList lTSs = cM.getTransformationSources();
        if (lTSs.size() == 0) {
            return;
        }
        Select select = (Select)lTSs.get(0);
        AssociationList qryTables = select.getClassifierSources();
        ArrayList badObjs = new ArrayList();
        UpgradeJobAction.checkSQLObjects(select, badObjs, (List)sources, (List)qryTables);
        if (badObjs.size() > 0) {
            store.removeObjectsFromStore(badObjs);
        }
    }

    private static synchronized void fixBadExtractMetadata(MdObjectStore store, TransformationStep step) throws MdException, RemoteException {
        AssociationList lCMs = step.getTransformations();
        if (lCMs.size() == 0) {
            return;
        }
        ClassifierMap cM = (ClassifierMap)lCMs.get(0);
        Select select = (Select)cM;
        if (select == null) {
            return;
        }
        UpgradeJobAction.checkExtractObjects(select, store, step);
    }

    private static void checkSQLObjects(Select select, List badObjs, List sources, List qryTables) throws MdException, RemoteException {
        AssociationList qryObjs = select.getTransformationSources();
        for (int i = 0; i < qryObjs.size(); ++i) {
            DataTable table;
            Root object = (Root)qryObjs.get(i);
            if (!(object instanceof ClassifierMap)) continue;
            ClassifierMap clsMap = (ClassifierMap)object;
            String type = clsMap.getTransformRole();
            if (type.equalsIgnoreCase("Join") || type.equalsIgnoreCase("StartJoin")) {
                AssociationList joinTgts;
                AssociationList joinSrcs = clsMap.getClassifierSources();
                if (joinSrcs.size() == 1) {
                    DataTable table2 = (DataTable)joinSrcs.get(0);
                    if (table2 instanceof QueryTable) {
                        Role mdoRole;
                        String sRole;
                        AssociationList lRoles = table2.getRoles();
                        if (!(lRoles.isEmpty() || (sRole = (mdoRole = (Role)lRoles.get(0)).getContext()).equals("SubQuery") || qryTables.contains(table2))) {
                            badObjs.add(object);
                        }
                    } else if (!sources.contains(table2)) {
                        badObjs.add(object);
                        continue;
                    }
                }
                if ((joinTgts = clsMap.getClassifierTargets()).size() != 1) continue;
                table = (DataTable)joinTgts.get(0);
                if (table instanceof QueryTable) {
                    Role mdoRole;
                    String sRole;
                    AssociationList lRoles = table.getRoles();
                    if (lRoles.isEmpty() || (sRole = (mdoRole = (Role)lRoles.get(0)).getContext()).equals("SubQuery") || qryTables.contains(table)) continue;
                    badObjs.add(object);
                    continue;
                }
                if (sources.contains(table)) continue;
                badObjs.add(object);
                continue;
            }
            if (!type.equalsIgnoreCase("InLineView") && !type.equalsIgnoreCase("SUBQUERY")) continue;
            AssociationList subQryTables = ((Select)object).getClassifierSources();
            for (int j = 0; j < subQryTables.size(); ++j) {
                table = (QueryTable)subQryTables.get(j);
                AssociationList targetCMs = table.getTargetClassifierMaps();
                for (int k = 0; k < targetCMs.size(); ++k) {
                    DataTable subTable;
                    ClassifierMap cm = (ClassifierMap)targetCMs.get(k);
                    if (!cm.getTransformRole().equals("TableAlias") || cm.getClassifierSources().isEmpty() || sources.contains(subTable = (DataTable)cm.getClassifierSources().get(0))) continue;
                    sources.add(subTable);
                }
            }
            UpgradeJobAction.checkSQLObjects((Select)object, badObjs, sources, (List)subQryTables);
        }
    }

    private static void checkExtractObjects(Select select, MdObjectStore store, TransformationStep step) throws MdException, RemoteException {
        GroupByClause gbClause = select.getGroupByForSelect();
        if (gbClause == null) {
            return;
        }
        AssociationList fmList = select.getFeatureMaps();
        ArrayList<FeatureMap> badObjs = new ArrayList<FeatureMap>();
        for (int i = 0; i < fmList.size(); ++i) {
            FeatureMap fm = (FeatureMap)fmList.get(i);
            String role = fm.getTransformRole();
            if (!fm.getTransformRole().equals("SQLGROUPBYINTEGER")) continue;
            badObjs.add(fm);
        }
        if (badObjs.size() == 0) {
            return;
        }
        AssociationList columns = gbClause.getColumns();
        if (columns.size() == 0) {
            return;
        }
        for (int j = 0; j < badObjs.size(); ++j) {
            Column featureTarget;
            FeatureMap fmap = (FeatureMap)badObjs.get(j);
            AssociationList cflist = fmap.getFeatureTargets();
            if (cflist.size() == 0 || (featureTarget = (Column)cflist.get(0)) == null) continue;
            Column grpColumn = null;
            boolean isIntColumn = false;
            for (int k = 0; k < columns.size(); ++k) {
                Column col = (Column)columns.get(k);
                if (col.getSASColumnName() == featureTarget.getSASColumnName() && col.getSASColumnType() == featureTarget.getSASColumnType()) {
                    isIntColumn = true;
                }
                if ((grpColumn = col) == null) continue;
                PropertySet columnProperties = (PropertySet)Workspace.getMdFactory().createComplexMetadataObject(store, "ColumnProperties", "PropertySet", step.getRepositoryID());
                columnProperties.setSetRole("ColumnProperties");
                gbClause.getPropertySets().add((Object)columnProperties);
                Property displayInt = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, "DisplayInteger", "Property", step.getRepositoryID());
                if (isIntColumn) {
                    displayInt.setDefaultValue("YES");
                } else {
                    displayInt.setDefaultValue("NO");
                }
                displayInt.setPropertyRole("DisplayInteger");
                displayInt.setPropertyName("DisplayInteger");
                displayInt.setUseValueOnly(1);
                Property columnProp = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, "Column", "Property", step.getRepositoryID());
                columnProp.setDefaultValue("Column");
                columnProp.setPropertyRole("Column");
                columnProp.setPropertyName("Column");
                columnProp.setUseValueOnly(1);
                columnProperties.getSetProperties().add((Object)displayInt);
                columnProperties.getSetProperties().add((Object)columnProp);
                Transformation columnTrans = (Transformation)Workspace.getMdFactory().createComplexMetadataObject(store, "Column", "Transformation", step.getRepositoryID());
                columnTrans.setTransformRole("Column");
                columnProp.getSpecTargetTransformations().add((Object)columnTrans);
                columnTrans.getSourceSpecifications().add((Object)grpColumn);
            }
        }
    }

    private static synchronized String getLoaderReplaceTypeForTruncate(PhysicalTable targetTable) throws RemoteException, MdException {
        if (targetTable == null) {
            return "Truncate";
        }
        String sReplaceTypeForTruncate = "SimulateTruncate";
        AssociationList packages = targetTable.getTablePackages();
        if (!packages.isEmpty() && !(packages.get(0) instanceof SASLibrary)) {
            SASLibrary lib = CodeGenUtil.getLibrary((DataTable)targetTable);
            String sTargetEngine = null;
            if (lib != null) {
                sTargetEngine = lib.getEngine();
            }
            if (("ODBC".equalsIgnoreCase(sTargetEngine) || "DB2".equalsIgnoreCase(sTargetEngine) || "OLEDB".equalsIgnoreCase(sTargetEngine)) && lib.getLibraryConnection() != null) {
                sTargetEngine = lib.getLibraryConnection().getSource().getProductName();
            }
            if (sTargetEngine != null) {
                sReplaceTypeForTruncate = sTargetEngine.contains("DB2OS390") || sTargetEngine.contains("INFORMIX") || sTargetEngine.contains("ACCESS") || sTargetEngine.contains("TERADATA") || sTargetEngine.equalsIgnoreCase("SASESOCK") || sTargetEngine.equalsIgnoreCase("XML") ? "Delete" : (sTargetEngine.contains("EXCEL") ? "EntireTable" : "Truncate");
            }
        }
        return sReplaceTypeForTruncate;
    }

    private static synchronized void upgradeInnerJobsAndSyncStepTransformsInJob(ProcessStatus status, Job oldJob, UserContextInterface userContext) throws RemoteException, MdException {
        AssociationList lJobActivities = oldJob.getJobActivities();
        if (lJobActivities != null && lJobActivities.size() > 0) {
            AssociationList lSteps = ((TransformationActivity)lJobActivities.get(0)).getSteps();
            ArrayList<TransformationStep> listOfInnerJobs = new ArrayList<TransformationStep>();
            ArrayList<TransformationStep> listOfSyncSteps = new ArrayList<TransformationStep>();
            block0: for (TransformationStep step : lSteps) {
                AssociationList properties = step.getProperties();
                for (int j = 0; j < properties.size(); ++j) {
                    Property prop = (Property)properties.get(j);
                    if (!"Class".equals(prop.getPropertyName())) continue;
                    String classname = prop.getDefaultValue();
                    if (RCCHECK_TRANSFORM_ROLE.equals(classname)) {
                        listOfSyncSteps.add(step);
                        continue block0;
                    }
                    if (LOOP_TRANSFORM_ROLE.equals(classname)) {
                        listOfSyncSteps.add(step);
                        continue block0;
                    }
                    if (LOOPEND_TRANSFORM_ROLE.equals(classname)) {
                        listOfSyncSteps.add(step);
                        continue block0;
                    }
                    if (!INNERJOB_TRANSFORM_ROLE.equals(classname)) continue;
                    listOfInnerJobs.add(step);
                    continue block0;
                }
            }
            for (int i = 0; i < listOfInnerJobs.size(); ++i) {
                Object obj;
                TransformationStep jobStep = (TransformationStep)listOfInnerJobs.get(i);
                AssociationList lTransformations = jobStep.getTransformations();
                if (lTransformations == null || lTransformations.isEmpty() || !((obj = lTransformations.get(0)) instanceof Job)) continue;
                Job innerJob = (Job)obj;
                innerJob.setPublicType("Job");
                ProcessStatus innerStatus = new ProcessStatus(ETLMigrationUtility.getLogger(), ProcessStatus.generateLoggingName((CMetadata)innerJob));
                UpgradeJobAction.upgradeJob(innerStatus, innerJob, userContext);
                status.addStatus(innerStatus);
                innerJob.setUsageVersion(CURRENT_VERSION.encode());
                innerJob.updateMetadataAll();
            }
            for (int t = listOfSyncSteps.size(); t > 0; --t) {
                TransformationStep oldStep = (TransformationStep)listOfSyncSteps.get(t - 1);
                UpgradeJobAction.upgradeSyncStepTransform((MdObjectStore)oldJob.getObjectStore(), oldStep);
            }
            oldJob.updateMetadataAll();
        }
    }

    private static synchronized TransformationStep upgradeSyncStepTransform(MdObjectStore store, TransformationStep oldStep) throws MdException, RemoteException {
        ArrayList<Object> deleteList = new ArrayList<Object>();
        String reposId = oldStep.getRepositoryID();
        TransformationStep newStep = (TransformationStep)Workspace.getMdFactory().createComplexMetadataObject(store, null, oldStep.getName(), "TransformationStep", reposId);
        newStep.setDesc(oldStep.getDesc());
        newStep.setIsActive(oldStep.getIsActive());
        newStep.setIsUserDefined(oldStep.getIsUserDefined());
        newStep.setTransformRole(oldStep.getTransformRole());
        if (oldStep.getActivities().size() > 0) {
            newStep.getActivities().add(oldStep.getActivities().get(0));
        }
        if (oldStep.getComputeLocations().size() > 0) {
            newStep.getComputeLocations().add(oldStep.getComputeLocations().get(0));
        }
        if (oldStep.getDocuments().size() > 0) {
            newStep.getDocuments().addAll((Collection)oldStep.getDocuments());
        }
        if (oldStep.getExtensions().size() > 0) {
            AssociationList lOldExtensions = oldStep.getExtensions();
            for (int t = 0; t < lOldExtensions.size(); ++t) {
                Extension oldExt = (Extension)lOldExtensions.get(t);
                Extension newExt = (Extension)Workspace.getMdFactory().createComplexMetadataObject(store, null, oldExt.getName(), "Extension", reposId);
                newExt.setDesc(oldExt.getDesc());
                newExt.setValue(oldExt.getValue());
                newExt.setExtensionType(oldExt.getExtensionType());
                newStep.getExtensions().add((Object)newExt);
            }
        }
        if (oldStep.getNotes().size() > 0) {
            newStep.getNotes().addAll((Collection)oldStep.getNotes());
        }
        if (oldStep.getPredecessorDependencies().size() > 0) {
            StepPrecedence oldNextSP = (StepPrecedence)oldStep.getPredecessorDependencies().get(0);
            StepPrecedence newNextSP = (StepPrecedence)Workspace.getMdFactory().createComplexMetadataObject(store, null, "StepPrecedence", "StepPrecedence", reposId);
            newNextSP.getPredecessors().add((Object)newStep);
            if (oldNextSP.getSuccessors().size() > 0) {
                newNextSP.getSuccessors().add(oldNextSP.getSuccessors().get(0));
            }
            deleteList.add(oldNextSP);
        }
        if (oldStep.getSuccessorDependencies().size() > 0) {
            StepPrecedence oldPrevSP = (StepPrecedence)oldStep.getSuccessorDependencies().get(0);
            StepPrecedence newPrevSP = (StepPrecedence)Workspace.getMdFactory().createComplexMetadataObject(store, null, "StepPrecedence", "StepPrecedence", reposId);
            newPrevSP.getSuccessors().add((Object)newStep);
            if (oldPrevSP.getPredecessors().size() > 0) {
                newPrevSP.getPredecessors().add(oldPrevSP.getPredecessors().get(0));
            }
            deleteList.add(oldPrevSP);
        }
        if (oldStep.getProperties().size() > 0) {
            newStep.getProperties().addAll((Collection)oldStep.getProperties());
        }
        if (oldStep.getPropertySets().size() > 0) {
            AssociationList lOldPropertySets = oldStep.getPropertySets();
            for (int i = 0; i < lOldPropertySets.size(); ++i) {
                PropertySet oldSet = (PropertySet)lOldPropertySets.get(i);
                PropertySet newSet = (PropertySet)Workspace.getMdFactory().createComplexMetadataObject(store, null, oldSet.getName(), "PropertySet", reposId);
                newSet.setDesc(oldSet.getDesc());
                newSet.setSetRole(oldSet.getSetRole());
                newSet.getProperties().addAll((Collection)oldSet.getProperties());
                newSet.getSetProperties().addAll((Collection)oldSet.getSetProperties());
                newStep.getPropertySets().add((Object)newSet);
                deleteList.add(oldSet);
            }
        }
        if (oldStep.getResponsibleParties().size() > 0) {
            newStep.getResponsibleParties().addAll((Collection)oldStep.getResponsibleParties());
        }
        if (oldStep.getSourceCodes().size() > 0) {
            newStep.getSourceCodes().addAll((Collection)oldStep.getSourceCodes());
        }
        if (oldStep.getSourceSpecifications().size() > 0) {
            newStep.getSourceSpecifications().addAll((Collection)oldStep.getSourceSpecifications());
        }
        if (oldStep.getSourceTransformations().size() > 0) {
            newStep.getSourceTransformations().addAll((Collection)oldStep.getSourceTransformations());
        }
        if (oldStep.getSpecSourceTransformations().size() > 0) {
            newStep.getSpecSourceTransformations().addAll((Collection)oldStep.getSpecSourceTransformations());
        }
        if (oldStep.getSpecTargetTransformations().size() > 0) {
            newStep.getSpecTargetTransformations().addAll((Collection)oldStep.getSpecTargetTransformations());
        }
        if (oldStep.getTargetSpecifications().size() > 0) {
            newStep.getTargetSpecifications().addAll((Collection)oldStep.getTargetSpecifications());
        }
        if (oldStep.getTargetTransformations().size() > 0) {
            newStep.getTargetTransformations().addAll((Collection)oldStep.getTargetTransformations());
        }
        if (oldStep.getTransformations().size() > 0) {
            newStep.getTransformations().addAll((Collection)oldStep.getTransformations());
        }
        if (oldStep.getTransformationSources().size() > 0) {
            newStep.getTransformationSources().addAll((Collection)oldStep.getTransformationSources());
        }
        if (oldStep.getTransformationTargets().size() > 0) {
            newStep.getTransformationTargets().addAll((Collection)oldStep.getTransformationTargets());
        }
        if (oldStep.getTriggeredEvents().size() > 0) {
            newStep.getTriggeredEvents().addAll((Collection)oldStep.getTriggeredEvents());
        }
        if (oldStep.getTriggeringEvents().size() > 0) {
            newStep.getTriggeringEvents().addAll((Collection)oldStep.getTriggeringEvents());
        }
        if (oldStep.getUsedByPrototypes().size() > 0) {
            newStep.getUsedByPrototypes().addAll((Collection)oldStep.getUsedByPrototypes());
        }
        if (oldStep.getUsingPrototypes().size() > 0) {
            newStep.getUsingPrototypes().addAll((Collection)oldStep.getUsingPrototypes());
        }
        deleteList.add(oldStep);
        if (deleteList.size() > 0) {
            store.removeObjectsFromStore(deleteList);
        }
        return newStep;
    }

    private static synchronized void updateDisplayedPortsForGeneratedTransform(GeneratedTransformModel genTransformModel) {
        genTransformModel.getTemplate().updateDisplayedPorts(true);
    }

    private static void fixSASColumnNames(ProcessStatus status, List lColumns, List lUniqueSASColumnNames) throws RemoteException, MdException {
        for (Column column : lColumns) {
            PhysicalTable pTable;
            RelationalSchema lib;
            String metaName = column.getName();
            String newSASColumnName = null;
            try {
                if (metaName != null && metaName.length() > 0) {
                    newSASColumnName = Names.mapNameToSASVariableName((String)metaName, (Collection)lUniqueSASColumnNames);
                } else {
                    String tName = Names.generateName((int)32);
                    newSASColumnName = Names.mapNameToSASVariableName((String)tName, (Collection)lUniqueSASColumnNames);
                }
            }
            catch (IllegalArgumentException e) {
                status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)column), (Throwable)e);
                ETLMigrationUtility.getLogger().error(e.getMessage(), (Throwable)e);
            }
            lUniqueSASColumnNames.add(newSASColumnName);
            column.setSASColumnName(newSASColumnName);
            DataTable table = column.getTable();
            status.addWarning(ProcessStatus.generateLoggingName((CMetadata)column), Message.format((String)RB.getStringResource("UpgradeJobAction.SetSASColumnNameWarning.fmt.txt"), (Object)newSASColumnName, (Object)metaName));
            if (!(table instanceof PhysicalTable) || (lib = (pTable = (PhysicalTable)table).getTablePackage()) != null && !(lib instanceof SASLibrary)) continue;
            AssociationList indexes = column.getIndexes();
            for (Index index : indexes) {
                if (index.getColumns().size() != 1 || !column.equals(index.getColumns().get(0))) continue;
                String indexOldName = index.getName();
                index.setName(newSASColumnName);
                String indexMessage = Message.format((String)RB.getStringResource("UpgradeJobAction.SetIndexName.fmt.txt"), (Object[])new Object[]{indexOldName, index.getName(), table.getName()});
                status.addWarning(indexMessage);
            }
        }
    }

    static {
        CUBE_CLASS_ID = "com.sas.olapadmin.designer.model.CodeGeneration";
    }
}

