/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.migration;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.util.UsageVersion;
import com.sas.workspace.ILogger;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ETLMigrationUtility {
    private static final Map usageVersionMap = new HashMap();

    public static Map getUsageVersionMappings() {
        return usageVersionMap;
    }

    public static Logger getLogger() {
        String context = "com.sas.etl.migration";
        Logger logService = LogManager.getLogger((String)context);
        return logService;
    }

    public static ILogger getLogger(int x) {
        String context = "com.sas.etl.migration";
        return Workspace.getLogger((String)context);
    }

    protected static List searchForObject(ServerInterface server, int omrFlags, String template, String objectType, FilterComponent filterComponent) throws RemoteException, ServiceException {
        if (server == null) {
            throw new IllegalArgumentException("Server was null, unable to execute search.");
        }
        Filter filter = new Filter();
        filter.setOMRFlags(omrFlags | 4 | 0x80 | 0x100 | 0x2000);
        filter.setOMRTemplate(template);
        filter.setType(objectType);
        if (filterComponent != null) {
            filter.setFilterComponent(filterComponent);
        }
        ETLMigrationUtility.getLogger().debug("Executing search with filter: " + filter);
        List outList = server.getFoundationRepository().browseSearch((FilterInterface)filter);
        return outList;
    }

    public static List getAllObjectsByMetadataType(ServerInterface server, String type, String template) throws RemoteException, ServiceException {
        FilterComponent fc = null;
        List foundObjects = ETLMigrationUtility.searchForObject(server, 8, template, type, fc);
        return foundObjects;
    }

    public static List getObjectsByMetadataTypeAndAttrValue(ServerInterface server, String type, String template, String attribute, String value) throws RemoteException, ServiceException {
        FilterComponent fc = new FilterComponent(attribute, 0, value);
        List foundObjects = ETLMigrationUtility.searchForObject(server, 8, template, type, fc);
        return foundObjects;
    }

    static {
        usageVersionMap.put("Table", new UsageVersion(1, 0));
        usageVersionMap.put("ExternalFile", new UsageVersion(1, 0));
        usageVersionMap.put("Job", new UsageVersion(1, 0));
        usageVersionMap.put("GeneratedTransform", new UsageVersion(1, 0));
        usageVersionMap.put("Action", new UsageVersion(1, 0));
        usageVersionMap.put("Condition", new UsageVersion(1, 0));
        usageVersionMap.put("ConditionActionSet", new UsageVersion(1, 0));
        usageVersionMap.put("Note", new UsageVersion(1, 0));
        usageVersionMap.put("Document", new UsageVersion(1, 0));
        usageVersionMap.put("Column", new UsageVersion(1, 0));
    }
}

