/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.GlobalInfoTable;
import com.sas.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleTemplate2 {
    protected static int DELIMITER_REPLACE_PAD_SIZE = 20;
    protected String submit_string = "";
    protected String template_string = "";
    protected ArrayList text_and_token_string_array;
    protected ArrayList temp_string_array;
    protected boolean dirty = true;
    protected String vdelimiter;
    protected char openc;
    protected char closec;
    protected transient String openStr;
    protected transient String closeStr;
    public Map dmapValues = null;
    protected boolean allowClassLoading = false;
    protected Map _toStringCache = new HashMap();
    protected boolean _toStringCachingEnabled = true;
    protected boolean _toStringCacheClearedOnFormat = true;
    protected PrintWriter writer;

    public SimpleTemplate2() {
        this.init("", null, '%', '(', ')', false);
    }

    public SimpleTemplate2(String pattern) {
        this.init(pattern, null, '%', '(', ')', false);
    }

    public SimpleTemplate2(String pattern, Map dictionary) {
        this.init(pattern, dictionary, '%', '(', ')', false);
    }

    public SimpleTemplate2(String pattern, Map dictionary, char marker, char open, char close) {
        this.init(pattern, dictionary, marker, open, close, false);
    }

    public SimpleTemplate2(String pattern, char marker, char open, char close) {
        this.init(pattern, null, marker, open, close, false);
    }

    public SimpleTemplate2(Map dictionary) {
        this.init("", dictionary, '%', '(', ')', false);
    }

    public SimpleTemplate2(boolean allowClassLoading) {
        this.init("", null, '%', '(', ')', allowClassLoading);
    }

    public SimpleTemplate2(String pattern, boolean allowClassLoading) {
        this.init(pattern, null, '%', '(', ')', allowClassLoading);
    }

    public SimpleTemplate2(String pattern, Map dictionary, char marker, char open, char close, boolean allowClassLoading) {
        this.init(pattern, dictionary, marker, open, close, allowClassLoading);
    }

    public SimpleTemplate2(String pattern, char marker, char open, char close, boolean allowClassLoading) {
        this.init(pattern, null, marker, open, close, allowClassLoading);
    }

    public SimpleTemplate2(Map dictionary, boolean allowClassLoading) {
        this.init("", dictionary, '%', '(', ')', allowClassLoading);
    }

    protected void init(String pattern, Map dictionary, char marker, char open, char close, boolean enableClassLoading) {
        this.init(pattern, dictionary, marker, open, close, enableClassLoading, null);
    }

    protected void init(String pattern, Map dictionary, char marker, char open, char close, boolean enableClassLoading, List textAndTemplate) {
        this.allowClassLoading = enableClassLoading;
        this.vdelimiter = new String(new char[]{marker});
        this.openc = open;
        this.openStr = new String(new char[]{open});
        this.closec = close;
        this.closeStr = new String(new char[]{close});
        this.dmapValues = dictionary;
        this.template_string = pattern == null ? "" : pattern;
        if (textAndTemplate != null) {
            this.text_and_token_string_array = new ArrayList(textAndTemplate.size());
            this.text_and_token_string_array.addAll(textAndTemplate);
            this.dirty = false;
        } else {
            this.text_and_token_string_array = new ArrayList();
        }
    }

    private void nowDirty() {
        this.dirty = true;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public void setValueDictionary(Map dictionary) {
        this.dmapValues = dictionary;
        this.clearToStringCache();
    }

    public Map getValueDictionary() {
        return this.dmapValues;
    }

    public boolean getClassLoading() {
        return this.allowClassLoading;
    }

    public void setClassLoading(boolean enable) {
        this.allowClassLoading = enable;
        this.nowDirty();
    }

    public synchronized String getTemplate() {
        return this.template_string;
    }

    public synchronized void setTemplate(String string_val) {
        if (string_val == null) {
            string_val = "";
        }
        if (!string_val.equals(this.template_string)) {
            this.template_string = string_val;
            this.nowDirty();
        }
    }

    public synchronized void setMarker(char marker) {
        char oldMarker = this.getMarker();
        if (oldMarker == marker) {
            return;
        }
        this.vdelimiter = new String(new char[]{marker});
        this.nowDirty();
    }

    public char getMarker() {
        return this.vdelimiter.charAt(0);
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public synchronized void setClose(char close) {
        char oldClose = this.getClose();
        if (oldClose == close) {
            return;
        }
        this.closec = close;
        this.closeStr = new String(new char[]{close});
        this.nowDirty();
    }

    public char getClose() {
        return this.closec;
    }

    public synchronized void setOpen(char open) {
        char oldOpen = this.getOpen();
        if (oldOpen == open) {
            return;
        }
        this.openc = open;
        this.openStr = new String(new char[]{open});
        this.nowDirty();
    }

    public char getOpen() {
        return this.openc;
    }

    public List getTextAndTokens() {
        return (List)this.text_and_token_string_array.clone();
    }

    public synchronized void setTextAndTokens(List textAndTokens) {
        this.text_and_token_string_array.clear();
        this.text_and_token_string_array.addAll(textAndTokens);
        this.dirty = false;
    }

    protected String[] findVarDelimiter(String nstring) {
        String[] subvar = new String[]{null, null, null};
        int[] cpos = Strings.positions(nstring, ',');
        if (cpos.length > 0) {
            for (int i = 0; i < 2; ++i) {
                String[] temp = this.parseFields(nstring);
                switch (i) {
                    case 0: {
                        subvar[0] = temp[0];
                        break;
                    }
                    case 1: {
                        subvar[1] = temp[0];
                        break;
                    }
                    case 3: {
                        subvar[2] = temp[0];
                    }
                }
                if (temp[1] != null) {
                    nstring = temp[1];
                    continue;
                }
                break;
            }
        } else {
            subvar[0] = nstring;
        }
        for (int j = 0; j < 3; ++j) {
            int[] hpos;
            if (subvar[j] == null || (hpos = Strings.positions(subvar[j], '\"')).length < 2) continue;
            subvar[j] = subvar[j].substring(hpos[0] + 1, hpos[hpos.length - 1]);
        }
        return subvar;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String[] parseFields(String mstring) {
        String[] holder = new String[]{null, null};
        int k = 0;
        int[] cpos = Strings.positions(mstring, ',');
        int cposLength = cpos.length;
        if (cposLength <= 0) {
            holder[0] = mstring;
            return holder;
        }
        int mstringLength = mstring.length();
        int j = 0;
        while (j < cposLength) {
            String cstring = mstring.substring(k, cpos[j]);
            int[] qpos = Strings.positions(cstring, '\"');
            if (qpos.length != 1) {
                int cstringLength = cstring.length();
                if (cstringLength > 0) {
                    int[] ppos6;
                    int[] ppos5 = this.positions(cstring, this.openStr);
                    if (ppos5.length == (ppos6 = this.positions(cstring, this.closeStr)).length) {
                        holder[0] = mstring.substring(k, cpos[j]);
                        if (cpos[j] + 1 >= mstringLength) return holder;
                        holder[1] = mstring.substring(cpos[j] + 1);
                        return holder;
                    }
                    holder[0] = mstring;
                } else if (cpos[j] + 1 < mstringLength) {
                    holder[1] = mstring.substring(cpos[j] + 1);
                    return holder;
                }
            }
            ++j;
        }
        return holder;
    }

    protected boolean parseStringTokens(String fstring, List strname) {
        boolean kvalue = false;
        int fstringLength = fstring.length();
        if (fstringLength > 0) {
            boolean flag = true;
            if (fstring.equals(this.vdelimiter)) {
                strname.add(fstring);
                kvalue = true;
            } else {
                for (int i = 1; i < fstringLength; ++i) {
                    char c = fstring.charAt(i);
                    if (i == 1 && Character.isJavaIdentifierStart(c)) {
                        flag = true;
                        continue;
                    }
                    if (i > 1 && Character.isJavaIdentifierPart(c)) {
                        flag = true;
                        continue;
                    }
                    if (c != this.openc) {
                        strname.add(fstring.substring(0, i));
                        strname.add(fstring.substring(i));
                        kvalue = true;
                        flag = false;
                        break;
                    }
                    flag = false;
                    int[] ppos1 = this.positions(fstring, this.openStr);
                    int[] ppos2 = this.positions(fstring, this.closeStr);
                    int ppos1Length = ppos1.length;
                    int ppos2Length = ppos2.length;
                    if (ppos1Length <= 0 || ppos2Length <= 0) break;
                    if (ppos1Length == 1 && ppos2Length == 1) {
                        strname.add(fstring.substring(0, ppos2[0] + 1));
                        if (ppos2[0] + 1 <= fstringLength - 1) {
                            strname.add(fstring.substring(ppos2[0] + 1));
                        }
                        kvalue = true;
                        break;
                    }
                    if (ppos1Length > 1) {
                        if (ppos1[1] > ppos2[0]) {
                            strname.add(fstring.substring(0, ppos2[0] + 1));
                            if (ppos2[0] + 1 <= fstringLength - 1) {
                                strname.add(fstring.substring(ppos2[0] + 1));
                            }
                            kvalue = true;
                            break;
                        }
                        if (ppos1Length != ppos2Length) break;
                        strname.add(fstring.substring(0, ppos2[ppos2Length - 1] + 1));
                        if (ppos2[ppos2Length - 1] + 1 <= fstringLength - 1) {
                            strname.add(fstring.substring(ppos2[ppos2Length - 1] + 1));
                        }
                        kvalue = true;
                        break;
                    }
                    if (ppos1Length >= ppos2Length) break;
                    strname.add(fstring.substring(0, ppos2[0] + 1));
                    if (ppos2[0] + 1 <= fstringLength - 1) {
                        strname.add(fstring.substring(ppos2[0] + 1));
                    }
                    kvalue = true;
                    break;
                }
                if (flag) {
                    strname.add(fstring);
                    kvalue = true;
                }
            }
        }
        return kvalue;
    }

    protected Object getValue(String vstring) {
        Object tempobj = null;
        Map values = this.getValueDictionary();
        if (values != null) {
            tempobj = values.get(vstring);
        }
        return this.checkToStringCache(tempobj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String parseToken(String pstring) {
        String out;
        int i;
        int varStringArraySize;
        StringBuffer hold;
        boolean var1Set = false;
        boolean var2Set = false;
        boolean var3Set = false;
        String resolvedString = null;
        if (!pstring.startsWith(this.vdelimiter)) return this.formatWith(pstring);
        if (pstring.length() <= 1) return this.formatWith(pstring);
        int pos = pstring.indexOf(this.openc);
        String vstring = pos == -1 ? pstring.substring(1) : pstring.substring(1, pos);
        Object tempobj = this.getValue(vstring);
        if (pos == -1) {
            return this.formatWith(tempobj);
        }
        String nstring = pstring.substring(pos + 1);
        int[] mpos = Strings.positions(nstring, this.closec);
        nstring = nstring.substring(0, mpos[mpos.length - 1]);
        if ((nstring = nstring.trim()).length() == 0) {
            return this.formatWith(tempobj);
        }
        String[] var = this.findVarDelimiter(nstring);
        ArrayList var_string_array = null;
        if (var[0] != null) {
            var1Set = true;
            var_string_array = new ArrayList();
            this.tokenizeField(var[0], var_string_array);
            if (var_string_array.isEmpty()) {
                var[0] = "";
            } else {
                hold = new StringBuffer(32);
                varStringArraySize = var_string_array.size();
                for (i = 0; i < varStringArraySize; ++i) {
                    out = this.parseToken((String)var_string_array.get(i));
                    if (out == null) continue;
                    hold.append(out);
                }
                var[0] = hold.toString();
            }
        }
        if (var[1] != null) {
            var2Set = true;
            if (var_string_array == null) {
                var_string_array = new ArrayList();
            } else {
                var_string_array.clear();
            }
            this.tokenizeField(var[1], var_string_array);
            if (var_string_array.isEmpty()) {
                var[1] = "";
            } else {
                hold = new StringBuffer(32);
                varStringArraySize = var_string_array.size();
                for (i = 0; i < varStringArraySize; ++i) {
                    out = this.parseToken((String)var_string_array.get(i));
                    if (out == null) continue;
                    hold.append(out);
                }
                var[1] = hold.toString();
            }
        }
        if (var[2] != null) {
            var3Set = true;
            if (var_string_array == null) {
                var_string_array = new ArrayList();
            } else {
                var_string_array.clear();
            }
            this.tokenizeField(var[2], var_string_array);
            if (var_string_array.isEmpty()) {
                var[2] = "";
            } else {
                hold = new StringBuffer(32);
                varStringArraySize = var_string_array.size();
                for (i = 0; i < varStringArraySize; ++i) {
                    out = this.parseToken((String)var_string_array.get(i));
                    if (out == null) continue;
                    hold.append(out);
                }
                var[2] = hold.toString();
            }
        }
        if (var3Set) {
            return this.formatWith(tempobj, var[0], var[1], var[2]);
        }
        if (var2Set) {
            return this.formatWith(tempobj, var[0], var[1]);
        }
        if (!var1Set) return null;
        return this.formatWith(tempobj, var[0]);
    }

    protected String formatValueObject(Object tObject) {
        String tstring = null;
        if (tObject != null) {
            tstring = tObject.toString();
        }
        return tstring;
    }

    protected String formatWith(Object tObject) {
        return this.formatWith(this.formatValueObject(tObject));
    }

    protected String formatWith(Object tObject, String notNullValue) {
        return this.formatWith(this.formatValueObject(tObject), notNullValue);
    }

    protected String formatWith(Object tObject, String notNullValue, String isNullValue) {
        return this.formatWith(this.formatValueObject(tObject), notNullValue, isNullValue);
    }

    protected String formatWith(Object tObject, String notNullValue, String isNullValue, String formatterClass) {
        return this.formatWith(this.formatValueObject(tObject), notNullValue, isNullValue, formatterClass);
    }

    protected String formatWith(String origValue) {
        return origValue;
    }

    protected String formatWith(String origValue, String notNullValue) {
        if (origValue == null) {
            return null;
        }
        return notNullValue;
    }

    protected String formatWith(String origValue, String notNullValue, String isNullValue) {
        if (origValue == null) {
            return isNullValue;
        }
        return notNullValue;
    }

    protected String formatWith(String origValue, String notNullValue, String isNullValue, String formatterClass) {
        if (this.allowClassLoading) {
            try {
                Format fd = (Format)GlobalInfoTable.loadClass(formatterClass).newInstance();
                String formatted = origValue != null ? fd.format(origValue) : fd.format(isNullValue);
                return formatted;
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return this.formatWith(origValue, notNullValue, isNullValue);
    }

    protected void processText() {
        this.tokenizeTemplate();
        if (this.temp_string_array != null) {
            this.temp_string_array.clear();
        }
        boolean empty = true;
        PrintWriter currentWriter = this.getWriter();
        int temp_string_array_totalstringlength = 0;
        int nsize = this.text_and_token_string_array.size();
        for (int npos = 0; npos < nsize; ++npos) {
            String pstring = (String)this.text_and_token_string_array.get(npos);
            String tmp = this.parseToken(pstring);
            if (tmp == null) continue;
            if (currentWriter != null) {
                empty = false;
                currentWriter.print(tmp);
                continue;
            }
            if (this.temp_string_array == null) {
                this.temp_string_array = new ArrayList(nsize);
            }
            this.temp_string_array.add(tmp);
            temp_string_array_totalstringlength += tmp.length();
        }
        if (currentWriter != null) {
            if (empty) {
                currentWriter.print("");
            }
            return;
        }
        if (this.temp_string_array == null) {
            this.submit_string = "";
            return;
        }
        int tempStringArraySize = this.temp_string_array.size();
        StringBuffer temp_string_buffer = new StringBuffer(temp_string_array_totalstringlength + DELIMITER_REPLACE_PAD_SIZE);
        for (int k = 0; k < tempStringArraySize; ++k) {
            temp_string_buffer.append(this.temp_string_array.get(k));
        }
        this.submit_string = temp_string_buffer.toString();
        this.temp_string_array.clear();
    }

    protected void tokenizeField(String strtemp, List collname) {
        int[] tpos = this.positions(strtemp, this.vdelimiter);
        int tposLength = tpos.length;
        if (tposLength > 0) {
            int k = 0;
            for (int j = 0; j < tposLength; ++j) {
                String fstring = strtemp.substring(k, tpos[j]);
                if (!this.parseStringTokens(fstring, collname)) continue;
                k = tpos[j];
            }
            this.parseStringTokens(strtemp.substring(k, strtemp.length()), collname);
        } else {
            collname.add(strtemp);
        }
    }

    private int[] positions(String source, String delimiter) {
        if (delimiter.length() == 1) {
            return Strings.positions(source, delimiter.charAt(0));
        }
        return Strings.positions(source, 0, -1, delimiter, false);
    }

    protected void tokenizeTemplate() {
        if (!this.dirty) {
            return;
        }
        String doubleDelim = this.vdelimiter + this.vdelimiter;
        String template_string2 = Strings.replace(this.template_string, 0, -1, doubleDelim, this.vdelimiter);
        this.text_and_token_string_array.clear();
        int[] tpos = this.positions(template_string2, this.vdelimiter);
        String tempstring = template_string2;
        int tposLength = tpos.length;
        if (tposLength > 0) {
            int k = 0;
            for (int j = 0; j < tposLength; ++j) {
                String fstring = tempstring.substring(k, tpos[j]);
                if (!this.parseStringTokens(fstring, this.text_and_token_string_array)) continue;
                k = tpos[j];
            }
            boolean bl = this.parseStringTokens(tempstring.substring(k, tempstring.length()), this.text_and_token_string_array);
        } else {
            this.text_and_token_string_array.add(template_string2);
        }
        this.dirty = false;
    }

    public synchronized String format() {
        if (this._toStringCacheClearedOnFormat) {
            this.clearToStringCache();
        }
        this.processText();
        return this.submit_string;
    }

    public String format(Map dictionary) {
        this.setValueDictionary(dictionary);
        return this.format();
    }

    public static String format(String pattern, Map dictionary, char marker, char open, char close) {
        SimpleTemplate2 tmp = new SimpleTemplate2(pattern, dictionary, marker, open, close);
        return tmp.format();
    }

    public static void format(String pattern, Map dictionary, char marker, char open, char close, PrintWriter out) {
        SimpleTemplate2 tmp = new SimpleTemplate2(pattern, dictionary, marker, open, close);
        tmp.setWriter(out);
        tmp.format();
    }

    public static String format(String pattern, Map dictionary) {
        return SimpleTemplate2.format(pattern, dictionary, '%', '(', ')');
    }

    public static void format(String pattern, Map dictionary, PrintWriter out) {
        SimpleTemplate2.format(pattern, dictionary, '%', '(', ')', out);
    }

    public void clearToStringCache() {
        this._toStringCache.clear();
    }

    protected Object checkToStringCache(Object object) {
        if (object == null) {
            return null;
        }
        Object result = object;
        if (this.isToStringCachingEnabled() && !(object instanceof String)) {
            if (this._toStringCache.containsKey(object)) {
                result = this._toStringCache.get(object);
            } else {
                String value = object.toString();
                this._toStringCache.put(object, value);
                result = value;
            }
        }
        return result;
    }

    public boolean isToStringCachingEnabled() {
        return this._toStringCachingEnabled;
    }

    public void setToStringCachingEnabled(boolean enable) {
        this._toStringCachingEnabled = enable;
    }

    public boolean isToStringCacheClearedOnFormat() {
        return this._toStringCacheClearedOnFormat;
    }

    public void setToStringCacheClearedOnFormat(boolean enable) {
        this._toStringCacheClearedOnFormat = enable;
    }
}

