/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.nls.collator.SASCollator;
import com.sas.nls.collator.SASStringComparator;
import com.sas.util.Comparator;
import com.sas.util.Util;
import java.io.Serializable;
import java.text.Collator;

@SASScope(value="ALL")
public class BaseStringComparator
implements Comparator,
Serializable,
java.util.Comparator {
    static final long serialVersionUID = 770854091247656479L;
    private boolean ascending;
    private boolean caseSensitive;
    private int startChar;
    private Collator collator;
    private SASStringComparator stringComparator;
    public static final BaseStringComparator defaultInstance = new BaseStringComparator();

    public BaseStringComparator() {
        this(true, true, 0);
    }

    public BaseStringComparator(Collator collator) {
        this(true, true, 0);
        this.collator = collator;
    }

    @SASScope
    public BaseStringComparator(SASStringComparator comparator) {
        this(true, true, 0);
        this.stringComparator = comparator;
    }

    public BaseStringComparator(boolean ascending) {
        this(ascending, true, 0);
    }

    public BaseStringComparator(boolean ascending, boolean caseSensitive) {
        this(ascending, caseSensitive, 0);
    }

    public BaseStringComparator(boolean ascending, boolean caseSensitive, int startChar) {
        this.setAscending(ascending);
        this.setStartChar(startChar);
        this.setCaseSensitive(caseSensitive);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        if (this.ascending != ascending) {
            this.ascending = ascending;
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        if (this.stringComparator != null) {
            if (this.stringComparator instanceof SASCollator) {
                SASCollator sasCollator = (SASCollator)this.stringComparator;
                sasCollator.setStrength(caseSensitive ? 2 : 0);
            }
        } else if (this.collator != null) {
            this.collator.setStrength(caseSensitive ? 2 : 0);
        }
        if (this.caseSensitive != caseSensitive) {
            this.caseSensitive = caseSensitive;
        }
    }

    public void setCollator(Collator newCollator) {
        if (Util.equal(this.collator, newCollator)) {
            return;
        }
        Collator oldCollator = this.collator;
        this.collator = newCollator;
    }

    public Collator getCollator() {
        return this.collator;
    }

    @SASScope
    public void setSASStringComparator(SASStringComparator newComparator) {
        if (Util.equal(this.stringComparator, newComparator)) {
            return;
        }
        SASStringComparator oldComparator = this.stringComparator;
        this.stringComparator = newComparator;
    }

    @SASScope
    public SASStringComparator getSAStringComparator() {
        return this.stringComparator;
    }

    public int getStartChar() {
        return this.startChar;
    }

    public void setStartChar(int startChar) {
        if (startChar < 0) {
            throw new IllegalArgumentException("startChar < 0");
        }
        if (this.startChar != startChar) {
            Integer oldVal = new Integer(this.startChar);
            Integer newVal = new Integer(startChar);
            this.startChar = startChar;
        }
    }

    @Override
    public int compare(Object first, Object second) {
        int result;
        if (first == second) {
            return 0;
        }
        if (first == null) {
            return this.ascending ? -1 : 1;
        }
        if (second == null) {
            return this.ascending ? 1 : -1;
        }
        if (!(first instanceof String) || !(second instanceof String)) {
            return this.compare(first.toString(), second.toString());
        }
        String a = (String)first;
        String b = (String)second;
        if (this.startChar > 0) {
            if ((a = a.length() < this.startChar ? null : a.substring(this.startChar)) == (b = b.length() < this.startChar ? null : b.substring(this.startChar))) {
                return 0;
            }
            if (a == null) {
                return this.ascending ? -1 : 1;
            }
            if (b == null) {
                return this.ascending ? 1 : -1;
            }
        }
        if ((result = this.stringComparator != null ? this.stringComparator.compare(a, b) : (this.collator != null ? this.collator.compare(a, b) : (this.caseSensitive ? a.compareTo(b) : a.toLowerCase().compareTo(b.toLowerCase())))) < 0) {
            result = this.ascending ? -1 : 1;
        } else if (result > 0) {
            result = this.ascending ? 1 : -1;
        }
        return result;
    }

    public String toString() {
        return "ascending: " + this.ascending + ", caseSensitive:" + this.caseSensitive + ", startChar:" + this.startChar + " StringComparator ";
    }
}

