/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text.util;

import com.sas.text.util.NLS;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class MessageResourceBundle {
    static final Object ASSIGNED = new Object();
    private static final String EXTENSION = ".properties";
    private static String[] nlSuffixes;
    static int SEVERITY_ERROR;
    static int SEVERITY_WARNING;

    private static String[] buildVariants(String root, Locale locale) {
        String nl;
        String string = nl = locale != null ? locale.toString() : Locale.getDefault().toString();
        if (nlSuffixes == null || !nlSuffixes[0].startsWith('_' + nl)) {
            ArrayList<String> result = new ArrayList<String>(4);
            while (true) {
                result.add('_' + nl + EXTENSION);
                int lastSeparator = nl.lastIndexOf(95);
                if (lastSeparator == -1) break;
                nl = nl.substring(0, lastSeparator);
            }
            result.add(EXTENSION);
            nlSuffixes = result.toArray(new String[result.size()]);
        }
        root = root.replace('.', '/');
        String[] variants = new String[nlSuffixes.length];
        for (int i = 0; i < variants.length; ++i) {
            variants[i] = root + nlSuffixes[i];
        }
        return variants;
    }

    private static void makeAccessible(final Field field) {
        if (System.getSecurityManager() == null) {
            field.setAccessible(true);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }
    }

    private static void makeNotAccessible(final Field field) {
        if (System.getSecurityManager() == null) {
            field.setAccessible(false);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    field.setAccessible(false);
                    return null;
                }
            });
        }
    }

    private static void computeMissingMessages(String bundleName, Class clazz, Map fieldMap, Field[] fieldArray, NLS msg) {
        int MOD_EXPECTED = 2;
        int MOD_MASK = 26;
        for (Field field : fieldArray) {
            if ((field.getModifiers() & 0x1A) != 2 || fieldMap.get(field.getName()) == ASSIGNED) continue;
            try {
                String value = "NLS missing message: " + field.getName() + " in: " + bundleName;
                MessageResourceBundle.log(SEVERITY_WARNING, value, null);
                MessageResourceBundle.makeAccessible(field);
                field.set(msg, value);
                MessageResourceBundle.makeNotAccessible(field);
            }
            catch (Exception e) {
                MessageResourceBundle.log(SEVERITY_ERROR, "Error setting the missing message value for: " + field.getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NLS load(String bundleName, Class clazz, Locale locale, NLS msg) {
        Field[] fieldArray = clazz.getDeclaredFields();
        ClassLoader loader = clazz.getClassLoader();
        int len = fieldArray.length;
        HashMap<String, Field> fields = new HashMap<String, Field>(len * 2);
        for (int i = 0; i < len; ++i) {
            fields.put(fieldArray[i].getName(), fieldArray[i]);
        }
        String[] variants = MessageResourceBundle.buildVariants(bundleName, locale);
        for (int i = 0; i < variants.length; ++i) {
            InputStream input = loader.getResourceAsStream(variants[i]);
            if (input == null) continue;
            try {
                MessagesProperties properties = new MessagesProperties(fields, bundleName, msg);
                properties.load(input);
                continue;
            }
            catch (IOException e) {
                MessageResourceBundle.log(SEVERITY_ERROR, "Error loading " + variants[i], e);
                continue;
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        MessageResourceBundle.computeMissingMessages(bundleName, clazz, fields, fieldArray, msg);
        return msg;
    }

    static void log(int severity, String msg, Exception e) {
        System.out.println(msg);
        if (e != null) {
            e.printStackTrace();
        }
    }

    static {
        SEVERITY_ERROR = 4;
        SEVERITY_WARNING = 2;
    }

    private static class MessagesProperties
    extends Properties {
        private static final int MOD_EXPECTED = 2;
        private static final int MOD_MASK = 26;
        private static final long serialVersionUID = 1L;
        private final String bundleName;
        private final Map fields;
        private final Object msg;

        public MessagesProperties(Map fieldMap, String bundleName, Object msg) {
            this.fields = fieldMap;
            this.bundleName = bundleName;
            this.msg = msg;
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            Object fieldObject;
            if (key instanceof String) {
                String k = (String)key;
                if (k.indexOf(".") != -1) {
                    k = k.replace('.', '_');
                }
                key = k;
            }
            if ((fieldObject = this.fields.put(key, ASSIGNED)) == ASSIGNED) {
                return null;
            }
            if (fieldObject == null) {
                String msg = "NLS unused message: " + key + " in: " + this.bundleName;
                MessageResourceBundle.log(SEVERITY_WARNING, msg, null);
                return null;
            }
            Field field = (Field)fieldObject;
            if ((field.getModifiers() & 0x1A) != 2) {
                return null;
            }
            try {
                MessageResourceBundle.makeAccessible(field);
                field.set(this.msg, value);
                MessageResourceBundle.makeNotAccessible(field);
            }
            catch (Exception e) {
                MessageResourceBundle.log(SEVERITY_ERROR, "Exception setting field value.", e);
            }
            return null;
        }
    }
}

