/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.text.DateNameStringValue;
import com.sas.text.MultiEntry;
import com.sas.text.QuarterDate;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormatEntry;
import com.sas.text.SingleEntry;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

class DateValue
extends SASDateTimeFormat {
    private static String[] fnames = new String[]{"WEEKDAY", "MONNAME", "DOWNAME", "MONTH", "NLDATEMN", "NLDATEWN", "WEEKU", "WEEKV", "WEEKW", "YYWEEKU", "YYWEEKV", "YYWEEKW"};
    private static int WEEKDAY = 0;
    private static int MONNAME = 1;
    private static int DOWNAME = 2;
    private static int MONTH = 3;
    private static int WEEKU = 6;
    private static int WEEKV = 7;
    private static int WEEKW = 8;
    private static int YYWEEKU = 9;
    private static int YYWEEKV = 10;
    private static int YYWEEKW = 11;
    private static Object[] dateValueFormats;

    protected DateValue() {
    }

    @Override
    public StringBuffer format(Date value) {
        return this.format(this.javaDateToSASDate(value.getTime(), this.getTimeZone()));
    }

    @Override
    public StringBuffer format(double date) {
        StringBuffer result = this.checkSASDateLimits(date);
        if (null != result) {
            return result;
        }
        String formatName = this.info.getBaseFormat();
        if (formatName.equals(fnames[WEEKDAY])) {
            result = new StringBuffer(32);
            this.date.setTime(this.SASDateToJavaDate(date, this.getTimeZone()));
            Calendar calendar = this.formatter.getCalendar();
            calendar.setTime(this.date);
            result.append(calendar.get(7));
        } else if (formatName.equals("NLDATEYQ") || formatName.equals("NLDATEYQL") || formatName.equals("NLDATEYQM")) {
            result = this.formatValueWithQuarter(this.SASDateToJavaDate(date, this.getTimeZone()), false);
        } else if (this.info.baseFormat.equals("NLDATEYW")) {
            result = this.formatValueWithWeek(this.SASDateToJavaDate(date, this.getTimeZone()));
        } else {
            result = formatName.equals("NLDATEMN") || formatName.equals("NLDATEWN") || formatName.equals("NLDATEW") || formatName.equals("NLDATE") || formatName.equals("NLDATEYM") || formatName.equals("NLDATEMD") || formatName.equals("NLDATEL") || formatName.equals("NLDATEM") || formatName.equals("NLDATEYML") || formatName.equals("NLDATEYMM") || formatName.equals("NLDATEYML") || formatName.equals("NLDATEYMM") || formatName.equals("NLDATEMDL") || formatName.equals("NLDATEMDM") || formatName.equals("NLDATES") || formatName.equals("NLDATEYMS") || formatName.equals("NLDATEMDS") ? this.formatbest(this.SASDateToJavaDate(date, this.getTimeZone())) : (formatName.equals("NLDATEYQS") ? this.qtr_order(this.SASDateToJavaDate(date, this.getTimeZone()), false) : (formatName.endsWith("DFDN") ? this.getDayofWeek(this.SASDateToJavaDate(date, this.getTimeZone())) : this.formatValue(this.SASDateToJavaDate(date, this.getTimeZone()), false)));
            if (result.length() > this.info.getWidth()) {
                if (formatName.equals(fnames[MONNAME]) || formatName.startsWith("NLDAT") || formatName.equals(fnames[DOWNAME]) || formatName.endsWith("DFDN") || formatName.endsWith("DFMN")) {
                    result.setLength(this.info.getWidth());
                } else if (formatName.equals(fnames[MONTH])) {
                    char c = result.charAt(1);
                    result.setLength(0);
                    switch (c) {
                        case '0': {
                            result.append('A');
                            break;
                        }
                        case '1': {
                            result.append('B');
                            break;
                        }
                        case '2': {
                            result.append('C');
                            break;
                        }
                        default: {
                            result.setLength(0);
                            break;
                        }
                    }
                }
            } else if (formatName.equals(fnames[WEEKU]) || formatName.equals(fnames[WEEKV]) || formatName.equals(fnames[WEEKW]) || formatName.equals(fnames[YYWEEKU]) || formatName.equals(fnames[YYWEEKV]) || formatName.equals(fnames[YYWEEKW])) {
                if (formatName.equals(fnames[WEEKU])) {
                    this.getWeekNumber(this.SASDateToJavaDate(date, this.getTimeZone()), true, result, this.info.getWidth(), true);
                }
                if (formatName.equals(fnames[WEEKV])) {
                    this.getISOWeekNumber(this.SASDateToJavaDate(date, this.getTimeZone()), result, this.info.getWidth(), true);
                }
                if (formatName.equals(fnames[WEEKW])) {
                    this.getWeekNumber(this.SASDateToJavaDate(date, this.getTimeZone()), false, result, this.info.getWidth(), true);
                }
                if (formatName.equals(fnames[YYWEEKU])) {
                    this.getWeekNumber(this.SASDateToJavaDate(date, this.getTimeZone()), true, result, this.info.getWidth(), false);
                }
                if (formatName.equals(fnames[YYWEEKV])) {
                    this.getISOWeekNumber(this.SASDateToJavaDate(date, this.getTimeZone()), result, this.info.getWidth(), false);
                }
                if (formatName.equals(fnames[YYWEEKW])) {
                    this.getWeekNumber(this.SASDateToJavaDate(date, this.getTimeZone()), false, result, this.info.getWidth(), false);
                }
            }
        }
        if (formatName.equals("NLDATEYW")) {
            this.insertTrailingWhitespaces(result);
        } else {
            this.insertLeadingBlanks(result);
        }
        return result;
    }

    @Override
    public boolean isDateFormat() {
        return true;
    }

    @Override
    public double convertFromJavaDate(long javaDate) {
        return this.javaDateToSASDate(javaDate, this.getTimeZone());
    }

    @Override
    public long convertToJavaDate(double sasDate) {
        return this.SASDateToJavaDate(sasDate, this.getTimeZone());
    }

    static Object[] getDefinedFormats(Locale locale) {
        Vector<SingleEntry> temp = new Vector<SingleEntry>(200, 5);
        String className = DateValue.class.getName();
        SingleEntry shortEntry = new SingleEntry("UNIFORMw", "");
        shortEntry.setFormatLocale(locale);
        Map shortUniformEntryMap = shortEntry.genNLdatesEntry(0);
        SingleEntry entry = new SingleEntry("DATEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 10, "ddMMMyyyy");
        ((SASFormatEntry)entry).addPattern(11, 11, "dd-MMM-yyyy");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("DAYw", className);
        ((SASFormatEntry)entry).addPattern(2, 32, "d", true);
        temp.addElement(entry);
        entry = new MultiEntry("DDMMYYxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        temp.addElement(entry);
        entry = new SingleEntry("DDMMYYNw", className);
        ((SASFormatEntry)entry).addPattern(8, 8, "ddMMyyyy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 5, "ddMM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        temp.addElement(entry);
        entry = new SingleEntry("DOWNAMEw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("JULDAYw", className);
        ((SASFormatEntry)entry).addPattern(3, 32, "D", true);
        temp.addElement(entry);
        entry = new SingleEntry("JULIANw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "yyDDD", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "yyyyDDD");
        temp.addElement(entry);
        entry = new SingleEntry("JULDATEw", className);
        ((SASFormatEntry)entry).addPattern(7, 32, "yyyyDDD", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "yyDDD");
        temp.addElement(entry);
        entry = new MultiEntry("MMDDYYxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "MM/dd/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "MM");
        ((SASFormatEntry)entry).addPattern(4, 4, "MMdd");
        ((SASFormatEntry)entry).addPattern(5, 5, "MM/dd");
        ((SASFormatEntry)entry).addPattern(6, 7, "MMddyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "MM/dd/yyyy");
        temp.addElement(entry);
        entry = new SingleEntry("MMDDYYNw", className);
        ((SASFormatEntry)entry).addPattern(8, 8, "MMddyyyy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "MM");
        ((SASFormatEntry)entry).addPattern(4, 5, "MMdd");
        ((SASFormatEntry)entry).addPattern(6, 7, "MMddyy");
        temp.addElement(entry);
        entry = new MultiEntry("MMYYxw", className, 'M');
        ((SASFormatEntry)entry).addPattern(7, 32, "MM'M'yyyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "MM'M'yy");
        temp.addElement(entry);
        entry = new SingleEntry("MMYYNw", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "MMyyyy", true);
        ((SASFormatEntry)entry).addPattern(4, 5, "MMyy");
        temp.addElement(entry);
        entry = new SingleEntry("MONNAMEw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("MONTHw", className);
        ((SASFormatEntry)entry).addPattern(2, 32, "M", true);
        ((SASFormatEntry)entry).addPattern(1, 1, "M");
        temp.addElement(entry);
        entry = new SingleEntry("MONYYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("WEEKDATEw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, MMMM d, yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, MMM d, yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, MMM d, yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, MMM d, yyyy");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("WEEKDATXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("WEEKDAYw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("WORDDATEw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "MMMM d, yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "MMM d, yyyy");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("WORDDATXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("YEARw", className);
        ((SASFormatEntry)entry).addPattern(4, 32, "yyyy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "yy");
        temp.addElement(entry);
        entry = new MultiEntry("YYMMxw", className, 'M');
        ((SASFormatEntry)entry).addPattern(7, 32, "yyyy'M'MM", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "yy'M'MM");
        temp.addElement(entry);
        entry = new SingleEntry("YYMMNw", className);
        ((SASFormatEntry)entry).addPattern(6, 32, "yyyyMM", true);
        ((SASFormatEntry)entry).addPattern(4, 5, "yyMM");
        temp.addElement(entry);
        entry = new MultiEntry("YYMMDDxw", className, '-');
        ((SASFormatEntry)entry).addPattern(8, 9, "yy-MM-dd", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "yy");
        ((SASFormatEntry)entry).addPattern(4, 4, "yyMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "yy-MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "yyMMdd");
        ((SASFormatEntry)entry).addPattern(10, 10, "yyyy-MM-dd");
        temp.addElement(entry);
        entry = new SingleEntry("YYMMDDNw", className);
        ((SASFormatEntry)entry).addPattern(8, 8, "yyyyMMdd", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "yy");
        ((SASFormatEntry)entry).addPattern(4, 5, "yyMM");
        ((SASFormatEntry)entry).addPattern(6, 7, "yyMMdd");
        temp.addElement(entry);
        entry = new SingleEntry("YYMONw", className);
        ((SASFormatEntry)entry).addPattern(7, 32, "yyyyMMM", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "yyMMM");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("AFRDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(AFRIKAANS);
        temp.addElement(entry);
        entry = new SingleEntry("CATDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(CATALAN);
        temp.addElement(entry);
        entry = new SingleEntry("CRODFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(CROATIAN);
        temp.addElement(entry);
        entry = new SingleEntry("CSYDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(CZECH);
        temp.addElement(entry);
        entry = new SingleEntry("DANDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(DANISH);
        temp.addElement(entry);
        entry = new SingleEntry("DESDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(GERMAN_SWITZERLAND);
        temp.addElement(entry);
        entry = new SingleEntry("DEUDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(Locale.GERMAN);
        temp.addElement(entry);
        entry = new SingleEntry("ENGDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(Locale.ENGLISH);
        temp.addElement(entry);
        entry = new SingleEntry("ESPDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(SPANISH);
        temp.addElement(entry);
        entry = new SingleEntry("EURDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        temp.addElement(entry);
        entry = new SingleEntry("FINDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(FINNISH);
        temp.addElement(entry);
        entry = new SingleEntry("FRADFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(Locale.FRENCH);
        temp.addElement(entry);
        entry = new SingleEntry("FRSDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(FRENCH_SWITZERLAND);
        temp.addElement(entry);
        entry = new SingleEntry("HUNDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(HUNGARIAN);
        temp.addElement(entry);
        entry = new SingleEntry("ITADFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(Locale.ITALIAN);
        temp.addElement(entry);
        entry = new SingleEntry("MACDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(MACEDONIAN);
        temp.addElement(entry);
        entry = new SingleEntry("NLDDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(DUTCH);
        temp.addElement(entry);
        entry = new SingleEntry("NORDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(NORWEGIAN);
        temp.addElement(entry);
        entry = new SingleEntry("POLDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(POLISH);
        temp.addElement(entry);
        entry = new SingleEntry("PTGDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(PORTUGUESE);
        temp.addElement(entry);
        entry = new SingleEntry("RUSDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(RUSSIAN);
        temp.addElement(entry);
        entry = new SingleEntry("SLODFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(SLOVENIAN);
        temp.addElement(entry);
        entry = new SingleEntry("SVEDFDEw", className);
        ((SASFormatEntry)entry).addPattern(7, 8, "ddMMMyy", true);
        ((SASFormatEntry)entry).addPattern(5, 6, "ddMMM");
        ((SASFormatEntry)entry).addPattern(9, 9, "ddMMMyyyy");
        entry.setFormatLocale(SWEDISH);
        temp.addElement(entry);
        entry = new MultiEntry("AFRDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(AFRIKAANS);
        temp.addElement(entry);
        entry = new MultiEntry("CATDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(CATALAN);
        temp.addElement(entry);
        entry = new MultiEntry("CRODFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(CROATIAN);
        temp.addElement(entry);
        entry = new MultiEntry("CSYDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(CZECH);
        temp.addElement(entry);
        entry = new MultiEntry("DANDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(DANISH);
        temp.addElement(entry);
        entry = new MultiEntry("DESDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(GERMAN_SWITZERLAND);
        temp.addElement(entry);
        entry = new MultiEntry("DEUDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(Locale.GERMAN);
        temp.addElement(entry);
        entry = new MultiEntry("ENGDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(Locale.ENGLISH);
        temp.addElement(entry);
        entry = new MultiEntry("ESPDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(SPANISH);
        temp.addElement(entry);
        entry = new MultiEntry("EURDFDDxw", className, '.');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd.MM.yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd.MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd.MM.yyyy");
        temp.addElement(entry);
        entry = new MultiEntry("FINDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(FINNISH);
        temp.addElement(entry);
        entry = new MultiEntry("FRADFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(Locale.FRENCH);
        temp.addElement(entry);
        entry = new MultiEntry("FRSDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(FRENCH_SWITZERLAND);
        temp.addElement(entry);
        entry = new MultiEntry("HUNDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(HUNGARIAN);
        temp.addElement(entry);
        entry = new MultiEntry("ITADFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(Locale.ITALIAN);
        temp.addElement(entry);
        entry = new MultiEntry("MACDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(MACEDONIAN);
        temp.addElement(entry);
        entry = new MultiEntry("NLDDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(DUTCH);
        temp.addElement(entry);
        entry = new MultiEntry("NORDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(NORWEGIAN);
        temp.addElement(entry);
        entry = new MultiEntry("POLDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(POLISH);
        temp.addElement(entry);
        entry = new MultiEntry("PTGDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(PORTUGUESE);
        temp.addElement(entry);
        entry = new MultiEntry("RUSDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(RUSSIAN);
        temp.addElement(entry);
        entry = new MultiEntry("SLODFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(SLOVENIAN);
        temp.addElement(entry);
        entry = new MultiEntry("SVEDFDDxw", className, '/');
        ((SASFormatEntry)entry).addPattern(8, 9, "dd/MM/yy", true);
        ((SASFormatEntry)entry).addPattern(2, 3, "dd");
        ((SASFormatEntry)entry).addPattern(4, 4, "ddMM");
        ((SASFormatEntry)entry).addPattern(5, 5, "dd/MM");
        ((SASFormatEntry)entry).addPattern(6, 7, "ddMMyy");
        ((SASFormatEntry)entry).addPattern(10, 10, "dd/MM/yyyy");
        entry.setFormatLocale(SWEDISH);
        temp.addElement(entry);
        entry = new SingleEntry("AFRDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(AFRIKAANS);
        temp.addElement(entry);
        entry = new SingleEntry("CATDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(CATALAN);
        temp.addElement(entry);
        entry = new SingleEntry("CRODFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(CROATIAN);
        temp.addElement(entry);
        entry = new SingleEntry("CSYDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(CZECH);
        temp.addElement(entry);
        entry = new SingleEntry("DANDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(DANISH);
        temp.addElement(entry);
        entry = new SingleEntry("DESDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(GERMAN_SWITZERLAND);
        temp.addElement(entry);
        entry = new SingleEntry("DEUDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(Locale.GERMAN);
        temp.addElement(entry);
        entry = new SingleEntry("ENGDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(Locale.ENGLISH);
        temp.addElement(entry);
        entry = new SingleEntry("ESPDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(SPANISH);
        temp.addElement(entry);
        entry = new SingleEntry("EURDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        temp.addElement(entry);
        entry = new SingleEntry("FINDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(FINNISH);
        temp.addElement(entry);
        entry = new SingleEntry("FRADFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(Locale.FRENCH);
        temp.addElement(entry);
        entry = new SingleEntry("FRSDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(FRENCH_SWITZERLAND);
        temp.addElement(entry);
        entry = new SingleEntry("HUNDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(HUNGARIAN);
        temp.addElement(entry);
        entry = new SingleEntry("ITADFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(Locale.ITALIAN);
        temp.addElement(entry);
        entry = new SingleEntry("MACDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(MACEDONIAN);
        temp.addElement(entry);
        entry = new SingleEntry("NLDDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(DUTCH);
        temp.addElement(entry);
        entry = new SingleEntry("NORDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(NORWEGIAN);
        temp.addElement(entry);
        entry = new SingleEntry("POLDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(POLISH);
        temp.addElement(entry);
        entry = new SingleEntry("PTGDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(PORTUGUESE);
        temp.addElement(entry);
        entry = new SingleEntry("RUSDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(RUSSIAN);
        temp.addElement(entry);
        entry = new SingleEntry("SLODFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(SLOVENIAN);
        temp.addElement(entry);
        entry = new SingleEntry("SVEDFDWNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "EEEE");
        entry.setFormatLocale(SWEDISH);
        temp.addElement(entry);
        entry = new SingleEntry("AFRDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("CATDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("CRODFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("CSYDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("DANDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("DESDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("DEUDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("ENGDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("ESPDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("EURDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("FINDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("FRADFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("FRSDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("HUNDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("ITADFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("MACDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("NLDDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("NORDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("POLDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("PTGDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("RUSDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("SLODFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("SVEDFDNw", className);
        ((SASFormatEntry)entry).addPattern(1, 32, null, true);
        temp.addElement(entry);
        entry = new SingleEntry("AFRDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(AFRIKAANS);
        temp.addElement(entry);
        entry = new SingleEntry("CATDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(CATALAN);
        temp.addElement(entry);
        entry = new SingleEntry("CRODFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(CROATIAN);
        temp.addElement(entry);
        entry = new SingleEntry("CSYDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(CZECH);
        temp.addElement(entry);
        entry = new SingleEntry("DANDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(DANISH);
        temp.addElement(entry);
        entry = new SingleEntry("DESDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(GERMAN_SWITZERLAND);
        temp.addElement(entry);
        entry = new SingleEntry("DEUDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(Locale.GERMAN);
        temp.addElement(entry);
        entry = new SingleEntry("ENGDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(Locale.ENGLISH);
        temp.addElement(entry);
        entry = new SingleEntry("ESPDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(SPANISH);
        temp.addElement(entry);
        entry = new SingleEntry("EURDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(locale);
        temp.addElement(entry);
        entry = new SingleEntry("FINDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(FINNISH);
        temp.addElement(entry);
        entry = new SingleEntry("FRADFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(Locale.FRENCH);
        temp.addElement(entry);
        entry = new SingleEntry("FRSDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(FRENCH_SWITZERLAND);
        temp.addElement(entry);
        entry = new SingleEntry("HUNDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(HUNGARIAN);
        temp.addElement(entry);
        entry = new SingleEntry("ITADFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(Locale.ITALIAN);
        temp.addElement(entry);
        entry = new SingleEntry("MACDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(MACEDONIAN);
        temp.addElement(entry);
        entry = new SingleEntry("NLDDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(DUTCH);
        temp.addElement(entry);
        entry = new SingleEntry("NORDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(NORWEGIAN);
        temp.addElement(entry);
        entry = new SingleEntry("POLDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(POLISH);
        temp.addElement(entry);
        entry = new SingleEntry("PTGDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(PORTUGUESE);
        temp.addElement(entry);
        entry = new SingleEntry("RUSDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(RUSSIAN);
        temp.addElement(entry);
        entry = new SingleEntry("SLODFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(SLOVENIAN);
        temp.addElement(entry);
        entry = new SingleEntry("SVEDFMNw", className);
        ((SASFormatEntry)entry).addPattern(9, 32, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 8, "MMMM");
        entry.setFormatLocale(SWEDISH);
        temp.addElement(entry);
        entry = new SingleEntry("AFRDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(AFRIKAANS);
        temp.addElement(entry);
        entry = new SingleEntry("CATDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(CATALAN);
        temp.addElement(entry);
        entry = new SingleEntry("CRODFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(CROATIAN);
        temp.addElement(entry);
        entry = new SingleEntry("CSYDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(CZECH);
        temp.addElement(entry);
        entry = new SingleEntry("DANDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(DANISH);
        temp.addElement(entry);
        entry = new SingleEntry("DESDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(GERMAN_SWITZERLAND);
        temp.addElement(entry);
        entry = new SingleEntry("DEUDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(Locale.GERMAN);
        temp.addElement(entry);
        entry = new SingleEntry("ENGDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(Locale.ENGLISH);
        temp.addElement(entry);
        entry = new SingleEntry("ESPDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(SPANISH);
        temp.addElement(entry);
        entry = new SingleEntry("EURDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        temp.addElement(entry);
        entry = new SingleEntry("FINDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(FINNISH);
        temp.addElement(entry);
        entry = new SingleEntry("FRADFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(Locale.FRENCH);
        temp.addElement(entry);
        entry = new SingleEntry("FRSDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(FRENCH_SWITZERLAND);
        temp.addElement(entry);
        entry = new SingleEntry("HUNDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(HUNGARIAN);
        temp.addElement(entry);
        entry = new SingleEntry("ITADFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(Locale.ITALIAN);
        temp.addElement(entry);
        entry = new SingleEntry("MACDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(MACEDONIAN);
        temp.addElement(entry);
        entry = new SingleEntry("NLDDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(DUTCH);
        temp.addElement(entry);
        entry = new SingleEntry("NORDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(NORWEGIAN);
        temp.addElement(entry);
        entry = new SingleEntry("POLDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(POLISH);
        temp.addElement(entry);
        entry = new SingleEntry("PTGDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(PORTUGUESE);
        temp.addElement(entry);
        entry = new SingleEntry("RUSDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(RUSSIAN);
        temp.addElement(entry);
        entry = new SingleEntry("SLODFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(SLOVENIAN);
        temp.addElement(entry);
        entry = new SingleEntry("SVEDFMYw", className);
        ((SASFormatEntry)entry).addPattern(5, 6, "MMMyy", true);
        ((SASFormatEntry)entry).addPattern(7, 7, "MMMyyyy");
        entry.setFormatLocale(SWEDISH);
        temp.addElement(entry);
        entry = new SingleEntry("AFRDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(AFRIKAANS);
        temp.addElement(entry);
        entry = new SingleEntry("CATDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(CATALAN);
        temp.addElement(entry);
        entry = new SingleEntry("CRODFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(CROATIAN);
        temp.addElement(entry);
        entry = new SingleEntry("CSYDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(CZECH);
        temp.addElement(entry);
        entry = new SingleEntry("DANDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(DANISH);
        temp.addElement(entry);
        entry = new SingleEntry("DESDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(GERMAN_SWITZERLAND);
        temp.addElement(entry);
        entry = new SingleEntry("DEUDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(Locale.GERMAN);
        temp.addElement(entry);
        entry = new SingleEntry("ENGDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(Locale.ENGLISH);
        temp.addElement(entry);
        entry = new SingleEntry("ESPDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(SPANISH);
        temp.addElement(entry);
        entry = new SingleEntry("EURDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        temp.addElement(entry);
        entry = new SingleEntry("FINDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(FINNISH);
        temp.addElement(entry);
        entry = new SingleEntry("FRADFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(Locale.FRENCH);
        temp.addElement(entry);
        entry = new SingleEntry("FRSDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(FRENCH_SWITZERLAND);
        temp.addElement(entry);
        entry = new SingleEntry("HUNDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(HUNGARIAN);
        temp.addElement(entry);
        entry = new SingleEntry("ITADFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(Locale.ITALIAN);
        temp.addElement(entry);
        entry = new SingleEntry("MACDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(MACEDONIAN);
        temp.addElement(entry);
        entry = new SingleEntry("NLDDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(DUTCH);
        temp.addElement(entry);
        entry = new SingleEntry("NORDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(NORWEGIAN);
        temp.addElement(entry);
        entry = new SingleEntry("POLDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(POLISH);
        temp.addElement(entry);
        entry = new SingleEntry("PTGDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(PORTUGUESE);
        temp.addElement(entry);
        entry = new SingleEntry("RUSDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(RUSSIAN);
        temp.addElement(entry);
        entry = new SingleEntry("SLODFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(SLOVENIAN);
        temp.addElement(entry);
        entry = new SingleEntry("SVEDFWDXw", className);
        ((SASFormatEntry)entry).addPattern(18, 32, "d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "MMM");
        ((SASFormatEntry)entry).addPattern(9, 11, "MMMM");
        ((SASFormatEntry)entry).addPattern(12, 17, "d MMM yyyy");
        entry.setFormatLocale(SWEDISH);
        temp.addElement(entry);
        entry = new SingleEntry("AFRDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(AFRIKAANS);
        temp.addElement(entry);
        entry = new SingleEntry("CATDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(CATALAN);
        temp.addElement(entry);
        entry = new SingleEntry("CRODFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(CROATIAN);
        temp.addElement(entry);
        entry = new SingleEntry("CSYDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(CZECH);
        temp.addElement(entry);
        entry = new SingleEntry("DANDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(DANISH);
        temp.addElement(entry);
        entry = new SingleEntry("DESDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(GERMAN_SWITZERLAND);
        temp.addElement(entry);
        entry = new SingleEntry("DEUDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(Locale.GERMAN);
        temp.addElement(entry);
        entry = new SingleEntry("ENGDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(Locale.ENGLISH);
        temp.addElement(entry);
        entry = new SingleEntry("ESPDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(SPANISH);
        temp.addElement(entry);
        entry = new SingleEntry("EURDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        temp.addElement(entry);
        entry = new SingleEntry("FINDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(FINNISH);
        temp.addElement(entry);
        entry = new SingleEntry("FRADFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(Locale.FRENCH);
        temp.addElement(entry);
        entry = new SingleEntry("FRSDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(FRENCH_SWITZERLAND);
        temp.addElement(entry);
        entry = new SingleEntry("HUNDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(HUNGARIAN);
        temp.addElement(entry);
        entry = new SingleEntry("ITADFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(Locale.ITALIAN);
        temp.addElement(entry);
        entry = new SingleEntry("MACDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(MACEDONIAN);
        temp.addElement(entry);
        entry = new SingleEntry("NLDDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(DUTCH);
        temp.addElement(entry);
        entry = new SingleEntry("NORDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(NORWEGIAN);
        temp.addElement(entry);
        entry = new SingleEntry("POLDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(POLISH);
        temp.addElement(entry);
        entry = new SingleEntry("PTGDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(PORTUGUESE);
        temp.addElement(entry);
        entry = new SingleEntry("RUSDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(RUSSIAN);
        temp.addElement(entry);
        entry = new SingleEntry("SLODFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(SLOVENIAN);
        temp.addElement(entry);
        entry = new SingleEntry("SVEDFWKXw", className);
        ((SASFormatEntry)entry).addPattern(29, 37, "EEEE, d MMMM yyyy", true);
        ((SASFormatEntry)entry).addPattern(3, 8, "EE");
        ((SASFormatEntry)entry).addPattern(9, 14, "EEEE");
        ((SASFormatEntry)entry).addPattern(15, 16, "EE, d MMM yy");
        ((SASFormatEntry)entry).addPattern(17, 22, "EE, d MMM yyyy");
        ((SASFormatEntry)entry).addPattern(23, 28, "EEEE, d MMM yyyy");
        entry.setFormatLocale(SWEDISH);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEMNw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        int maxAbMonthWidth = DateValue.checkWidth(locale, "MMM", 2);
        int maxMonthWidth = DateValue.checkWidth(locale, "MMMM", 2);
        if (maxAbMonthWidth == maxMonthWidth) {
            if (maxAbMonthWidth > 4) {
                ((SASFormatEntry)entry).addPattern(4, maxMonthWidth - 1, "MM");
            }
        } else if (maxAbMonthWidth > 4) {
            ((SASFormatEntry)entry).addPattern(4, maxAbMonthWidth - 1, "MM");
            ((SASFormatEntry)entry).addPattern(maxAbMonthWidth, maxMonthWidth - 1, "MMM");
        } else if (maxAbMonthWidth == 4) {
            ((SASFormatEntry)entry).addPattern(maxAbMonthWidth, maxMonthWidth - 1, "MMM");
        } else if (4 < maxMonthWidth) {
            ((SASFormatEntry)entry).addPattern(4, maxMonthWidth - 1, "MMM");
        } else {
            maxMonthWidth = 4;
        }
        ((SASFormatEntry)entry).addPattern(maxMonthWidth, 200, "MMMM");
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEWNw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        int maxAbDayWidth = DateValue.checkWidth(locale, "EEE", 7);
        int maxDayWidth = DateValue.checkWidth(locale, "EEEE", 7);
        if (maxAbDayWidth == maxDayWidth) {
            if (maxAbDayWidth > 4) {
                ((SASFormatEntry)entry).addPattern(4, maxDayWidth - 1, "E");
            }
        } else if (maxAbDayWidth > 4) {
            ((SASFormatEntry)entry).addPattern(4, maxAbDayWidth - 1, "E");
            ((SASFormatEntry)entry).addPattern(maxAbDayWidth, maxDayWidth - 1, "EEE");
        } else if (maxAbDayWidth == 4) {
            ((SASFormatEntry)entry).addPattern(maxAbDayWidth, maxDayWidth - 1, "EEE");
        } else if (4 < maxDayWidth) {
            ((SASFormatEntry)entry).addPattern(4, maxDayWidth - 1, "EEE");
        } else {
            maxDayWidth = 4;
        }
        ((SASFormatEntry)entry).addPattern(maxDayWidth, 200, "EEEE");
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEWw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        maxDayWidth = DateValue.checkWidth(locale, "EEEE", 7);
        String max = entry.getDatetimeString("d_fmt_week_s.w");
        int maxWidth = Integer.parseInt(max) - 1;
        if (maxDayWidth > 10) {
            ((SASFormatEntry)entry).addPattern(10, maxDayWidth - 1, "EEE");
            ((SASFormatEntry)entry).addPattern(maxDayWidth, maxWidth, "EEEE");
        } else {
            ((SASFormatEntry)entry).addPattern(10, maxWidth, "EEEE");
        }
        ((SASFormatEntry)entry).addDatetimeResourceString("d_fmt_week_s.w", "d_fmt_week.w", "d_fmt_week_s", -1, false);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_fmt_week.w", 200, "d_fmt_week", true);
        entry.setMinWidth(10);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEw", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(10, 200, 20, new String[]{"d", "s"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATELw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortUniformEntryMap.get((Object)new Integer((int)1))).patterns, 0, 0);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_fmt_s.w", "d_fmt_m.w", "d_fmt_s", 3, false);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_fmt_m.w", "d_fmt.w", "d_fmt_m", 2, false);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_fmt.w", 200, "d_fmt", true);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEMw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortUniformEntryMap.get((Object)new Integer((int)1))).patterns, 0, 0);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_fmt_s.w", "d_fmt_m.w", "d_fmt_s", 3, false);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_fmt_m.w", 200, "d_fmt_m", true);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATESw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortUniformEntryMap.get((Object)new Integer((int)1))).patterns, 10, 200);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEYMw", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(6, 200, 16, new String[]{"d_ym", "d_ym_s"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEYMLw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortUniformEntryMap.get((Object)new Integer((int)2))).patterns, 0, 0);
        ((SASFormatEntry)entry).addDatetimeResourceString(200, 16, new String[]{"d_fmt_yymm", "d_fmt_yymm_s"});
        entry.setMinWidth(5);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEYMMw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortUniformEntryMap.get((Object)new Integer((int)2))).patterns, 0, 0);
        ((SASFormatEntry)entry).addDatetimeResourceString("d_fmt_yymm_s.w", 200, "d_fmt_yymm_s", true);
        entry.setMinWidth(5);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEYMSw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortUniformEntryMap.get((Object)new Integer((int)2))).patterns, 7, 200);
        entry.setMinWidth(5);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEMDw", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(6, 200, 16, new String[]{"d_md", "d_md_s"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEMDLw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortUniformEntryMap.get((Object)new Integer((int)3))).patterns, 0, 0);
        ((SASFormatEntry)entry).addDatetimeResourceString(200, 16, new String[]{"d_md", "d_fmt_mmdd_s"});
        entry.setMinWidth(5);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEMDMw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortUniformEntryMap.get((Object)new Integer((int)3))).patterns, 0, 0);
        ((SASFormatEntry)entry).addDatetimeResourceString(5, 200, "d_fmt_mmdd_s", true);
        entry.setMinWidth(5);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEMDSw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortUniformEntryMap.get((Object)new Integer((int)3))).patterns, 5, 200);
        entry.setMinWidth(5);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEYRw", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(2, 200, 16, new String[]{"d_y", "d_y_s"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEYQw", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(4, 200, 16, new String[]{"d_yq", "d_yq_s"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEYQLw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        ((SASFormatEntry)entry).addDatetimeResourceString(4, 200, 16, new String[]{"d_fmt_yyqq", "d_fmt_yyqq_s"});
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEYQMw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        ((SASFormatEntry)entry).addDatetimeResourceString(4, 200, "d_fmt_yyqq_s", true);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEYQSw", className);
        entry.setFormatLocale(locale);
        entry.setUniform(true);
        entry.addAllPaterns(((SingleEntry)shortUniformEntryMap.get((Object)new Integer((int)4))).patterns, 6, 200);
        temp.addElement(entry);
        entry = new SingleEntry("NLDATEYWw", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(5, 200, 16, new String[]{"d_yw", "d_yw_s"});
        temp.addElement(entry);
        entry = new SingleEntry("WEEKUw", className);
        ((SASFormatEntry)entry).addPattern(11, 200, "yyyy-'Wxx'-", true);
        ((SASFormatEntry)entry).addPattern(3, 4, "'Wxx'");
        ((SASFormatEntry)entry).addPattern(5, 6, "yy'Wxx'");
        ((SASFormatEntry)entry).addPattern(7, 8, "yy'Wxx'");
        ((SASFormatEntry)entry).addPattern(9, 10, "yyyy'Wxx'");
        temp.addElement(entry);
        entry = new SingleEntry("WEEKVw", className);
        ((SASFormatEntry)entry).addPattern(11, 200, "yyyy-'Wxx'-", true);
        ((SASFormatEntry)entry).addPattern(3, 4, "'Wxx'");
        ((SASFormatEntry)entry).addPattern(5, 6, "yy'Wxx'");
        ((SASFormatEntry)entry).addPattern(7, 8, "yy'Wxx'");
        ((SASFormatEntry)entry).addPattern(9, 10, "yyyy'Wxx'");
        temp.addElement(entry);
        entry = new SingleEntry("WEEKWw", className);
        ((SASFormatEntry)entry).addPattern(11, 200, "yyyy-'Wxx'-", true);
        ((SASFormatEntry)entry).addPattern(3, 4, "'Wxx'");
        ((SASFormatEntry)entry).addPattern(5, 6, "yy'Wxx'");
        ((SASFormatEntry)entry).addPattern(7, 8, "yy'Wxx'");
        ((SASFormatEntry)entry).addPattern(9, 10, "yyyy'Wxx'");
        temp.addElement(entry);
        entry = new SingleEntry("JDATEMDw", className);
        ((SASFormatEntry)entry).addPattern(6, 20, "M\u6708dd\u65e5");
        entry.setFormatLocale(Locale.JAPAN);
        temp.addElement(entry);
        entry = new SingleEntry("JDATEMONw", className);
        ((SASFormatEntry)entry).addPattern(3, 10, "M\u6708");
        entry.setFormatLocale(Locale.JAPAN);
        temp.addElement(entry);
        entry = new SingleEntry("YYWEEKUw", className);
        ((SASFormatEntry)entry).addPattern(7, 200, "yyyy'Wxx'", true);
        ((SASFormatEntry)entry).addPattern(2, 2, "'xx'");
        ((SASFormatEntry)entry).addPattern(3, 4, "'Wxx'");
        ((SASFormatEntry)entry).addPattern(5, 6, "yy'Wxx'");
        temp.addElement(entry);
        entry = new SingleEntry("YYWEEKVw", className);
        ((SASFormatEntry)entry).addPattern(7, 200, "yyyy'Wxx'", true);
        ((SASFormatEntry)entry).addPattern(2, 2, "'xx'");
        ((SASFormatEntry)entry).addPattern(3, 4, "'Wxx'");
        ((SASFormatEntry)entry).addPattern(5, 6, "yy'Wxx'");
        temp.addElement(entry);
        entry = new SingleEntry("YYWEEKWw", className);
        ((SASFormatEntry)entry).addPattern(7, 200, "yyyy'Wxx'", true);
        ((SASFormatEntry)entry).addPattern(2, 2, "'xx'");
        ((SASFormatEntry)entry).addPattern(3, 4, "'Wxx'");
        ((SASFormatEntry)entry).addPattern(5, 6, "yy'Wxx'");
        temp.addElement(entry);
        Object[] q = QuarterDate.getDefinedFormats();
        Object[] ds = DateNameStringValue.getDefinedFormats(locale);
        dateValueFormats = new Object[temp.size() + q.length + ds.length];
        temp.copyInto(dateValueFormats);
        System.arraycopy(q, 0, dateValueFormats, temp.size(), q.length);
        System.arraycopy(ds, 0, dateValueFormats, temp.size() + q.length, ds.length);
        return dateValueFormats;
    }
}

