/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.crypto.jce;

import com.sas.net.crypto.jce.FipsValidator;
import com.sas.util.log.CommonLoggerFactory;
import com.sas.util.log.CommonLoggerInterface;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.List;

public class JsafeFipsValidator
extends FipsValidator {
    private static final CommonLoggerInterface _logger = CommonLoggerFactory.getLogger(JsafeFipsValidator.class);
    private static final String[] _jsafeFipsModeArr = new String[]{"FIPS140_MODE", "FIPS140_SSL_MODE", "FIPS140_ECC_MODE", "FIPS140_SSL_ECC_MODE"};

    @Override
    protected String doGetProviderName() {
        return "JsafeJCE";
    }

    @Override
    protected boolean doValidate(Provider provider) {
        String key = "com.rsa.cryptoj.fips140initialmode";
        String fipsMode = Security.getProperty("com.rsa.cryptoj.fips140initialmode");
        if (_logger.isDebugEnabled()) {
            _logger.debug("com.rsa.cryptoj.fips140initialmode=" + fipsMode);
        }
        List<String> jsafeFipsModeLst = Arrays.asList(_jsafeFipsModeArr);
        return jsafeFipsModeLst.contains(fipsMode);
    }
}

