/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lang;

import com.sas.codepolicy.SASScope;
import com.sas.security.BaseSecuritySupport;
import java.security.PrivilegedAction;

@SASScope
public abstract class NonExclusiveLock {
    public static final int PRIORITY_EXCLUSIVE = 0;
    public static final int PRIORITY_NON_EXCLUSIVE = 1;
    protected int readersWaiting = 0;
    protected int readersExecuting = 0;
    protected int writersWaiting = 0;
    protected int writersExecuting = 0;
    protected int[] lock = new int[0];

    public static NonExclusiveLock getInstance() {
        return NonExclusiveLock.getInstance(0);
    }

    public static NonExclusiveLock getInstance(int priorityVariant) {
        switch (priorityVariant) {
            case 0: {
                return new PriorityExclusive();
            }
            case 1: {
                return new PriorityNonExclusive();
            }
        }
        throw new IllegalArgumentException(Integer.toString(priorityVariant));
    }

    public abstract int getPriority();

    public abstract void executeExclusive(Runnable var1);

    public abstract void executeNonExclusive(Runnable var1);

    protected static void execute(Runnable task, boolean interrupted) {
        if (interrupted) {
            PrivilegedAction action = new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().interrupt();
                    return null;
                }
            };
            BaseSecuritySupport.securitySupport.doThreadPrivileged(action);
        }
        task.run();
    }

    @SASScope
    private static class PriorityExclusive
    extends NonExclusiveLock {
        private PriorityExclusive() {
        }

        @Override
        public int getPriority() {
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeExclusive(Runnable task) {
            boolean interrupted = false;
            int[] nArray = this.lock;
            synchronized (this.lock) {
                ++this.writersWaiting;
                while (this.writersExecuting > 0 || this.readersExecuting > 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                --this.writersWaiting;
                ++this.writersExecuting;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                try {
                    PriorityExclusive.execute(task, interrupted);
                }
                finally {
                    nArray = this.lock;
                    synchronized (this.lock) {
                        --this.writersExecuting;
                        this.lock.notifyAll();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeNonExclusive(Runnable task) {
            boolean interrupted = false;
            int[] nArray = this.lock;
            synchronized (this.lock) {
                ++this.readersWaiting;
                while (this.writersWaiting > 0 || this.writersExecuting > 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                --this.readersWaiting;
                ++this.readersExecuting;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                try {
                    PriorityExclusive.execute(task, interrupted);
                }
                finally {
                    nArray = this.lock;
                    synchronized (this.lock) {
                        --this.readersExecuting;
                        this.lock.notifyAll();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                    }
                }
                return;
            }
        }
    }

    @SASScope
    private static class PriorityNonExclusive
    extends NonExclusiveLock {
        private PriorityNonExclusive() {
        }

        @Override
        public int getPriority() {
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeExclusive(Runnable task) {
            boolean interrupted = false;
            int[] nArray = this.lock;
            synchronized (this.lock) {
                ++this.writersWaiting;
                while (this.writersExecuting > 0 || this.readersExecuting > 0 || this.readersWaiting > 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                --this.writersWaiting;
                ++this.writersExecuting;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                try {
                    PriorityNonExclusive.execute(task, interrupted);
                }
                finally {
                    nArray = this.lock;
                    synchronized (this.lock) {
                        --this.writersExecuting;
                        this.lock.notifyAll();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeNonExclusive(Runnable task) {
            boolean interrupted = false;
            int[] nArray = this.lock;
            synchronized (this.lock) {
                ++this.readersWaiting;
                while (this.writersExecuting > 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                --this.readersWaiting;
                ++this.readersExecuting;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                try {
                    PriorityNonExclusive.execute(task, interrupted);
                }
                finally {
                    nArray = this.lock;
                    synchronized (this.lock) {
                        --this.readersExecuting;
                        this.lock.notifyAll();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                    }
                }
                return;
            }
        }
    }
}

