/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.RB;
import com.sas.models.BaseFontInfo;
import com.sas.models.FontInfoInterface;
import com.sas.text.Message;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@SASScope
public class FontType
extends BaseDataType {
    public static final String RB_KEY = "FontType.";
    public static final FontType DEFAULT_INSTANCE = new FontType();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof FontInfoInterface) {
            return inputValue;
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof String) {
            return this.createFontInfoFromString((String)inputValue, inputLocale);
        }
        throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "fontValueNotValid.ex.txt"), inputValue));
    }

    private FontInfoInterface createFontInfoFromString(String text, Locale locale) {
        BaseFontInfo fontInfo = new BaseFontInfo(text, locale);
        return fontInfo;
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value instanceof FontInfoInterface) {
            return ((FontInfoInterface)value).toString();
        }
        return null;
    }

    @Override
    public Object coerceValueFromPersistedString(String input) throws IllegalArgumentException {
        Object obj = this.coerceValue(input, Locale.US);
        return obj;
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public Object copyValue(Object value, Locale locale) throws IllegalArgumentException {
        Object retVal = this.coerceValue(value, locale);
        if (retVal != null && retVal instanceof FontInfoInterface && retVal == value) {
            FontInfoInterface font = (FontInfoInterface)retVal;
            BaseFontInfo outPut = new BaseFontInfo();
            outPut.setFontFamily(font.getFontFamily());
            outPut.setFontSize(font.getFontSize());
            outPut.setBoldSelected(font.isBold());
            outPut.setItalicSelected(font.isItalic());
            outPut.setUnderlineSelected(font.isUnderline());
            return outPut;
        }
        return retVal;
    }

    @Override
    public int getSQLType() {
        return 2000;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (value == null) {
            return this.getMacroVariablesForNull(macroInfoSource);
        }
        FontInfoInterface fontInfo = (FontInfoInterface)value;
        HashMap<String, String> map = new HashMap<String, String>(5);
        if (fontInfo.getFontFamily(locale) == null) {
            map.put(baseMacroVariableName + "_family", fontInfo.getFontFamily(Locale.US));
        } else {
            map.put(baseMacroVariableName + "_family", fontInfo.getFontFamily(locale));
        }
        map.put(baseMacroVariableName + "_size", Integer.toString(fontInfo.getFontSize()));
        map.put(baseMacroVariableName + "_bold", Boolean.toString(fontInfo.isBold()));
        map.put(baseMacroVariableName + "_italic", Boolean.toString(fontInfo.isItalic()));
        map.put(baseMacroVariableName + "_underline", Boolean.toString(fontInfo.isUnderline()));
        return map;
    }

    @Override
    public Collection getPossibleMacroVariableExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(5);
        extensions.add("_family");
        extensions.add("_size");
        extensions.add("_bold");
        extensions.add("_italic");
        extensions.add("_underline");
        return extensions;
    }
}

