/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.shareddimension;

import com.sas.metadata.logical.shareddimension.SharedDimensionUtilities;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.remote.MdException;
import java.util.List;

public class SharedDimensionNameValidator
implements ImportNameValidatorInterface {
    public boolean validateName(ImportItemInterface importItem, ImportOperationInterface importOperation) throws MdException {
        boolean unique = true;
        String proposedName = importItem.getName();
        if (importItem.getImportState() == 1) {
            List connectionPoints = importItem.getConnectionPoints();
            for (int i = 0; i < connectionPoints.size(); ++i) {
                ConnectionPointInterface pt = (ConnectionPointInterface)connectionPoints.get(i);
                if (pt == null || !"OLAPSchema".equals(pt.getMetadataType())) continue;
                unique = pt.getTargetID() == null ? true : SharedDimensionUtilities.isSharedDimensionNameUniqueToOLAPSchema(proposedName, pt.getTargetID(), importOperation.getMetadataFactory());
            }
        }
        return unique;
    }
}

