/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.olapschema;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidAuthType;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidResourceSpec;
import com.sas.meta.SASOMI.ISecurityPackage.NotTrustedUser;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.services.util.XMLUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;

public class OLAPSchemaNameValidator
implements ImportNameValidatorInterface {
    public boolean validateName(ImportItemInterface importItem, ImportOperationInterface importOperation) throws MdException {
        boolean unique = true;
        String proposedName = importItem.getName();
        try {
            if (importItem.getImportState() == 1) {
                unique = OLAPSchemaNameValidator.isOLAPSchemaNameUnique(proposedName, importOperation.getFoundationRepositoryID());
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
        return unique;
    }

    public static boolean isOLAPSchemaNameUnique(String name, String repositoryID) throws MdException {
        return OLAPSchemaNameValidator.isOLAPSchemaNameUnique(name, repositoryID, Workspace.getMdFactory());
    }

    public static boolean isOLAPSchemaNameUnique(String name, String repositoryID, MdFactory factory) throws MdException {
        boolean unique = true;
        int flags1 = 8588;
        String normalizedName = XMLUtil.normalize((String)name);
        String template = "<GetMetadataObjects><Reposid>" + repositoryID + "</Reposid><Type>OLAPSchema</Type><Objects/><NS>SAS</NS><Flags>" + flags1 + "</Flags><Options><XMLSelect search=\"@Name='" + normalizedName + "'\"/></Options></GetMetadataObjects>";
        if (OLAPSchemaNameValidator.getNumberOfItems(template, factory) > 0) {
            unique = false;
        }
        return unique;
    }

    private static int getNumberOfItems(String template, MdFactory factory) throws MdException {
        int numberOfItems = 0;
        try {
            MdOMRConnection connection = factory.getConnection();
            VariableArray2dOfStringHolder returnAuths = new VariableArray2dOfStringHolder();
            IOMI omiHandle = connection.getCMRHandle();
            ISecurity_1_1 security = connection.MakeISecurityConnection(omiHandle);
            security.GetAuthorizations("getCountNoSecurity", "", template, "", returnAuths);
            numberOfItems = Integer.valueOf(returnAuths.value[0][1]);
            connection.closeISecurityConnection((ISecurity)security);
        }
        catch (RemoteException error) {
            throw new MdException((Throwable)error);
        }
        catch (MdException error) {
            throw new MdException((Throwable)error);
        }
        catch (InvalidAuthType error) {
            throw new MdException((Throwable)error);
        }
        catch (InvalidCredHandle error) {
            throw new MdException((Throwable)error);
        }
        catch (NotTrustedUser error) {
            throw new MdException((Throwable)error);
        }
        catch (GenericError error) {
            throw new MdException((Throwable)error);
        }
        catch (InvalidResourceSpec error) {
            throw new MdException((Throwable)error);
        }
        return numberOfItems;
    }
}

