/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.olapschema;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.olapschema.OLAPSchemaConnectionValidator;
import com.sas.metadata.logical.olapschema.OLAPSchemaImportItem;
import com.sas.metadata.logical.olapschema.OLAPSchemaNameValidator;
import com.sas.metadata.logical.olapschema.RB;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionValidatorInterface;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.util.UsageVersion;
import java.util.Iterator;
import java.util.List;

public class OLAPSchemaImportListener
extends AbstractImportListener {
    protected static final Class[] CONNECTION_TYPES = new Class[]{AppServerConnectionType.class};

    public OLAPSchemaImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public void initialize(ImportOperationInterface operation) {
    }

    public ConnectionValidatorInterface[] getConnectionValidatorInterfaces() {
        ConnectionValidatorInterface[] validators = new ConnectionValidatorInterface[]{new OLAPSchemaConnectionValidator()};
        return validators;
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new OLAPSchemaImportItem(name, id, type);
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        Iterator iterImportItems = objects.iterator();
        while (iterImportItems.hasNext() && iRC == 0) {
            DefaultImportItem olapSchemaImportItem = (DefaultImportItem)iterImportItems.next();
            UsageVersion version = olapSchemaImportItem.getUsageVersion();
            if (version.equals((Object)new UsageVersion(1, 0))) continue;
            iRC = 8;
            String msg = RB.getStringResource("OLAPSchemaExportListener.VersionNotSupported.fmt");
            throw new MetadataPromotionException(UtilMisc.getMessage((String)msg, (Object)olapSchemaImportItem.getName()));
        }
        return iRC;
    }

    public ImportNameValidatorInterface getNameValidatorInterface() {
        return new OLAPSchemaNameValidator();
    }
}

