/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.jobcube;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.cube.CubeExportItem;
import com.sas.metadata.logical.jobcube.JobCubeExportItem;
import com.sas.metadata.logical.jobcube.JobCubeImportListener;
import com.sas.metadata.logical.jobcube.RB;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public class JobCubeExportListener
extends AbstractExportListener {
    public JobCubeExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return JobCubeImportListener.CONNECTION_TYPES;
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new JobCubeExportItem(name, id, type);
    }

    public int analyzeObjectsToExport(ExportOperationInterface operation, List objects) throws MdException {
        int rc = 0;
        String jobCubeNames = new String();
        MdObjectStore mdStore = null;
        try {
            mdStore = operation.getMetadataFactory().createObjectStore(null, "JobCubeExportListener.analyzeobjectsToExport");
            for (int i = 0; i < objects.size(); ++i) {
                UsageVersion usageVersion;
                JobCubeExportItem jobCubeExportItem = (JobCubeExportItem)((Object)objects.get(i));
                SimpleLogicalObject cubeForJob = null;
                try {
                    int iOptions = 284;
                    Job mdJob = (Job)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "Job", jobCubeExportItem.getID(), null, null, "<Templates><Job><Documents/><JobActivities/><Notes/></Job><ClassifierMap><ClassifierSources/><ClassifierTargets/><SourceSpecifications/></ClassifierMap><TransformationActivity><Steps/></TransformationActivity><TransformationStep><Documents/><Notes/><Transformations/></TransformationStep><WorkTable><TablePackage/></WorkTable></Templates>", iOptions);
                    if (mdJob == null) {
                        String msg = RB.getStringResource("JobCubeExportItem.ObjNotFound.fmt");
                        throw new MdException(UtilMisc.getMessage((String)msg, (Object)jobCubeExportItem.getName()));
                    }
                    usageVersion = UsageVersion.decode((double)mdJob.getUsageVersion());
                    AssociationList lActivities = mdJob.getJobActivities();
                    if (!lActivities.isEmpty()) {
                        TransformationActivity mdActivity = (TransformationActivity)lActivities.get(0);
                        AssociationList lSteps = mdActivity.getSteps();
                        for (TransformationStep mdStep : lSteps) {
                            AssociationList lCMs = mdStep.getTransformations();
                            for (Transformation mdTransformation : lCMs) {
                                if (!(mdTransformation instanceof ClassifierMap)) continue;
                                ClassifierMap mdCM = (ClassifierMap)mdTransformation;
                                AssociationList lTargets = mdCM.getClassifierTargets();
                                for (Classifier mdClassifier : lTargets) {
                                    if (!(mdClassifier instanceof Cube)) continue;
                                    TypeInterface ti = Factory.getInstance().getTypeInterface("Cube");
                                    cubeForJob = new SimpleLogicalObject(mdClassifier.getName(), mdClassifier.getFQID(), ti);
                                }
                            }
                        }
                    }
                }
                catch (RemoteException e) {
                    throw new MdException((Throwable)e);
                }
                catch (LogicalTypeException le) {
                    throw new MdException((Throwable)le);
                }
                Map items = operation.getExportItems();
                boolean found = false;
                List cubes = (List)items.get("Cube");
                if (cubes == null) {
                    found = false;
                } else {
                    for (int j = 0; j < cubes.size() && !found; ++j) {
                        CubeExportItem cubeItem = (CubeExportItem)((Object)cubes.get(j));
                        if (cubeForJob == null || !cubeItem.getID().equals(cubeForJob.getID())) continue;
                        found = true;
                    }
                }
                if (!found) {
                    rc = 8;
                    jobCubeNames = jobCubeNames.length() != 0 ? jobCubeNames + " " + jobCubeExportItem.getName() : jobCubeNames + jobCubeExportItem.getName();
                }
                if (usageVersion.equals((Object)new UsageVersion(1, 0))) continue;
                rc = 8;
                String msg = RB.getStringResource("JobCubeExportListener.VersionNotSupported.fmt");
                throw new MdException(UtilMisc.getMessage((String)msg, (Object)jobCubeExportItem.getName()));
            }
            if (rc == 8) {
                String msg = RB.getStringResource("JobCubeExportListener.CubesNotExportedError.fmt");
                throw new MdException(UtilMisc.getMessage((String)msg, (Object)jobCubeNames));
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
        finally {
            try {
                if (mdStore != null) {
                    mdStore.dispose();
                }
            }
            catch (RemoteException e) {
                throw new MdException((Throwable)e);
            }
        }
        return rc;
    }
}

