/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.cube;

import com.sas.metadata.logical.cube.CubeUtilities;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.remote.MdException;
import java.util.List;

public class CubeNameValidator
implements ImportNameValidatorInterface {
    public boolean validateName(ImportItemInterface importItem, ImportOperationInterface importOperation) throws MdException {
        boolean unique = true;
        String proposedCubeName = importItem.getName();
        if (importItem.getImportState() == 1) {
            List connectionPoints = importItem.getConnectionPoints();
            for (int i = 0; i < connectionPoints.size(); ++i) {
                ConnectionPointInterface pt = (ConnectionPointInterface)connectionPoints.get(i);
                if (pt == null || !"OLAPSchema".equals(pt.getMetadataType())) continue;
                unique = pt.getTargetID() == null ? true : CubeUtilities.isCubeNameUniqueToOLAPSchema(proposedCubeName, pt.getTargetID(), importOperation.getMetadataFactory());
            }
        }
        return unique;
    }
}

