/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.cube;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.cube.CubeImportItem;
import com.sas.metadata.logical.cube.RB;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.swing.visuals.TriStateCheckBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;

public class CubeImportOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int iInitialContent;
    private TriStateCheckBox ckbBuildCube = new TriStateCheckBox(RB.getStringResource("CubeImportOptionsPanel.BuildCube.txt"));
    private SimpleLogicalObjectInterface[] aImportItems;

    public CubeImportOptionsPanel() {
        this.ckbBuildCube.setToolTipText(RB.getStringResource("CubeImportOptionsPanel.BuildCube.tip"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.ckbBuildCube, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populateImportOptions(ImportItemInterface[] aItems) {
        boolean allAdd = true;
        for (int i = 0; i < aItems.length; ++i) {
            CubeImportItem cube = (CubeImportItem)aItems[i];
            if (cube.getImportState() != 1) {
                allAdd = false;
                break;
            }
            if (!cube.hasSharedDimensions()) continue;
            allAdd = false;
            break;
        }
        if (allAdd) {
            this.ckbBuildCube.setEnabled(true);
            this.iInitialContent = this.determineCheckBoxState(aItems);
            this.ckbBuildCube.setSelectedValue(this.iInitialContent);
            this.aImportItems = aItems;
        } else {
            this.ckbBuildCube.setEnabled(false);
            this.aImportItems = null;
        }
    }

    public void saveSettings() {
        int iState = this.ckbBuildCube.getSelectedValue();
        if (this.iInitialContent != iState && this.aImportItems != null) {
            for (int i = 0; i < this.aImportItems.length; ++i) {
                CubeImportItem cube = (CubeImportItem)this.aImportItems[i];
                cube.setWillCubeBeRebuilt(this.ckbBuildCube.isSelected());
            }
            this.iInitialContent = iState;
        }
    }

    private int determineCheckBoxState(ImportItemInterface[] aItems) {
        boolean bAllOn = true;
        boolean bAllOff = true;
        for (int i = 0; i < aItems.length; ++i) {
            CubeImportItem it = (CubeImportItem)aItems[i];
            boolean bOn = it.willCubeBeRebuilt();
            bAllOn &= bOn;
            bAllOff &= !bOn;
        }
        if (bAllOn) {
            return 2;
        }
        if (bAllOff) {
            return 0;
        }
        return 1;
    }
}

