/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.cube;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.cube.CubeConnectionValidator;
import com.sas.metadata.logical.cube.CubeImportItem;
import com.sas.metadata.logical.cube.CubeImportOptionsPanel;
import com.sas.metadata.logical.cube.CubeNameValidator;
import com.sas.metadata.logical.cube.RB;
import com.sas.metadata.logical.jobcube.JobCubeImportItem;
import com.sas.metadata.logical.olapschema.OLAPSchemaConnectionType;
import com.sas.metadata.logical.server.DirectoryPathSubstitutionType;
import com.sas.metadata.logical.table.TableConnectionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionValidatorInterface;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.Aggregation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;

public class CubeImportListener
extends AbstractImportListener
implements PromotionOptionsInterface {
    private static final String LOAD_MAP = "Load Map";
    private static final String GENFOLDER = "GENFOLDER";
    private static final String CUBEFOLDER = "CUBEFOLDER";
    private static final String UNDERSCORE_FILE = "_File";
    private static final String NRACKS = "NRACKS";
    private static final String OLAPCUBECONNECTION = "OLAPCubeConnection";
    private static final String EMPTY = "";
    private static final String SLASH = "/";
    protected static final Class[] CONNECTION_TYPES = new Class[]{OLAPSchemaConnectionType.class, TableConnectionType.class};
    protected static final Class[] SUBSTITUTION_TYPES = new Class[]{DirectoryPathSubstitutionType.class};
    private CubeImportOptionsPanel pnlOptions = null;

    public CubeImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new CubeImportItem(name, id, type);
    }

    public Class[] getSubstitutionTypes() {
        return SUBSTITUTION_TYPES;
    }

    public ConnectionValidatorInterface[] getConnectionValidatorInterfaces() {
        ConnectionValidatorInterface[] validators = new ConnectionValidatorInterface[]{new CubeConnectionValidator()};
        return validators;
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        if (operation.isProjectRepository()) {
            iRC = 8;
            throw new MetadataPromotionException(RB.getStringResource("CubeImportListener.ProjectRepos.txt"));
        }
        int index = 1;
        Iterator iterImportItems = objects.iterator();
        while (iterImportItems.hasNext() && iRC == 0) {
            CubeImportItem cubeItem = (CubeImportItem)((Object)iterImportItems.next());
            UsageVersion version = cubeItem.getUsageVersion();
            if (!(version.equals((Object)new UsageVersion(4, 0)) || version.equals((Object)new UsageVersion(4, 1)) || version.equals((Object)new UsageVersion(5, 0)))) {
                iRC = 8;
                String msg = RB.getStringResource("CubeImportListener.VersionNotSupported.fmt");
                throw new MetadataPromotionException(UtilMisc.getMessage((String)msg, (Object)cubeItem.getName()));
            }
            boolean jobFound = false;
            List allObjects = operation.getAllPromotionItems();
            for (int j = 0; j < allObjects.size() && !jobFound; ++j) {
                DefaultImportItem item = (DefaultImportItem)allObjects.get(j);
                if (!(item instanceof JobCubeImportItem)) continue;
                List connectionPoints = item.getConnectionPoints();
                for (int i = 0; i < connectionPoints.size() && !jobFound; ++i) {
                    ConnectionPointInterface conn = (ConnectionPointInterface)connectionPoints.get(i);
                    String publicType = conn.getPublicType();
                    if (publicType == null || !publicType.equals("Cube") || !conn.getName().equals(cubeItem.getOriginalName())) continue;
                    jobFound = true;
                }
            }
            if (!jobFound) {
                String msg = RB.getStringResource("CubeImportListener.JobCubeNotImportedError.fmt");
                throw new MetadataPromotionException(UtilMisc.getMessage((String)msg, (Object)cubeItem.getName()));
            }
            ++index;
        }
        return iRC;
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] aItems, ImportOperationInterface handler) {
        if (this.pnlOptions == null) {
            this.pnlOptions = new CubeImportOptionsPanel();
        }
        this.pnlOptions.populateImportOptions(aItems);
        return this.pnlOptions;
    }

    public JPanel getOptionsPanel(ExportItemInterface[] aItems, ExportOperationInterface handler) {
        return null;
    }

    public void saveSettings() {
        if (this.pnlOptions != null) {
            this.pnlOptions.saveSettings();
        }
    }

    public ImportNameValidatorInterface getNameValidatorInterface() {
        return new CubeNameValidator();
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        boolean cubeHasBeenRenamed = false;
        MdObjectStore mdStore = null;
        try {
            mdStore = operation.getMetadataFactory().createObjectStore(null, "CubeImportListener.updateObjects");
            for (CubeImportItem cubeImportItem : objects) {
                Directory dir;
                String dirName;
                AssociationList directories;
                File cubeFile;
                boolean physicalCubeExists;
                Cube mdCube = this.getCubeMetadatObject(mdStore, (ImportItemInterface)cubeImportItem);
                String newName = cubeImportItem.getName();
                String oldName = cubeImportItem.getOriginalName();
                ClassifierMap loadMap = null;
                if (!newName.equals(oldName)) {
                    cubeHasBeenRenamed = true;
                    AssociationList loadMaps = mdCube.getTargetClassifierMaps();
                    boolean found = false;
                    for (int i = 0; i < loadMaps.size() && !found; ++i) {
                        loadMap = (ClassifierMap)loadMaps.get(i);
                        if (!loadMap.getName().equalsIgnoreCase(LOAD_MAP)) continue;
                        found = true;
                    }
                    Job mdJob = this.getJobWithSingleActivity(loadMap);
                    String jobName = mdJob.getName();
                    if (!newName.equals(jobName)) {
                        boolean dupName = this.duplicateCubeJobExists(operation, mdJob, jobName, newName);
                        if (!dupName) {
                            if (mdJob != null) {
                                mdJob.setName(newName);
                            }
                        } else {
                            iRC = 4;
                        }
                    }
                    this.renameCubeJobMetadata(mdCube, mdJob, loadMap, oldName, newName);
                }
                boolean bl = physicalCubeExists = !cubeImportItem.willCubeBeRebuilt();
                if (physicalCubeExists && cubeHasBeenRenamed) {
                    Log importLogger = operation.getLogger();
                    importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CubeImportListener.RenamedCubeMustBeRebuilt.fmt"), (Object)oldName, (Object)newName));
                    iRC = 4;
                    physicalCubeExists = false;
                }
                if (physicalCubeExists && !cubeHasBeenRenamed) {
                    mdCube.setCubeName(mdCube.getName());
                }
                if (!physicalCubeExists) {
                    mdCube.setCubeName(EMPTY);
                    AssociationList props = mdCube.getProperties();
                    for (int i = 0; i < props.size(); ++i) {
                        Property prop = (Property)props.get(i);
                        if (!prop.getName().equals(GENFOLDER)) continue;
                        prop.setAssociatedObject(null);
                        prop.delete();
                    }
                    AssociationList aggrs = mdCube.getAggregations();
                    for (int i = 0; i < aggrs.size(); ++i) {
                        Aggregation aggr = (Aggregation)aggrs.get(i);
                        props = aggr.getProperties();
                        for (int j = 0; j < props.size(); ++j) {
                            Property prop = (Property)props.get(j);
                            if (!prop.getName().equals(NRACKS)) continue;
                            prop.setAssociatedObject(null);
                            prop.delete();
                        }
                    }
                }
                if (cubeImportItem.getImportState() == 2 && cubeImportItem.willCubeBeRebuilt()) {
                    Log importLogger = operation.getLogger();
                    importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CubeImportListener.OverwrittenCubeMustBeRebuilt.fmt"), (Object)mdCube.getName()));
                    iRC = 4;
                }
                if (!((cubeFile = mdCube.getAssociatedFile()) == null || (directories = cubeFile.getDirectories()) == null || directories.isEmpty() || (dirName = (dir = (Directory)directories.get(0)).getDirectoryName()) != null && Strings.trimmedLength((String)dirName) != 0)) {
                    Log importLogger = operation.getLogger();
                    importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CubeImportListener.DirectoryBlank.fmt"), (Object)mdCube.getName()));
                    iRC = 4;
                }
                mdCube.touch();
            }
            mdStore.updatedMetadataAll();
        }
        catch (MdException mde) {
            throw new MetadataPromotionException((Throwable)mde);
        }
        catch (RemoteException e) {
            throw new MetadataPromotionException((Throwable)e);
        }
        finally {
            try {
                if (mdStore != null) {
                    mdStore.dispose();
                }
            }
            catch (RemoteException e) {
                throw new MetadataPromotionException((Throwable)e);
            }
        }
        return iRC;
    }

    void renameCubeJobMetadata(Cube mdCube, Job mdJob, ClassifierMap loadMap, String oldName, String newName) throws RemoteException, MdException {
        TransformationStep transformationStep;
        AssociationList files;
        Property connection = null;
        AssociationList loadMapProperties = loadMap.getProperties();
        boolean found = false;
        for (int i = 0; i < loadMapProperties.size() && !found; ++i) {
            connection = (Property)loadMapProperties.get(i);
            if (!connection.getPropertyName().equalsIgnoreCase(OLAPCUBECONNECTION)) continue;
            found = true;
        }
        OLAPSchema schema = mdCube.getAssociatedOLAPSchema();
        if (connection != null) {
            String schemaName = EMPTY;
            if (schema != null) {
                schemaName = schema.getName();
            }
            String newSchemaName = newName + SLASH + schemaName;
            connection.setDefaultValue(newSchemaName);
        }
        Property cubeFolder = null;
        AssociationList cubeProperties = mdCube.getProperties();
        found = false;
        for (int i = 0; i < cubeProperties.size() && !found; ++i) {
            cubeFolder = (Property)cubeProperties.get(i);
            if (!cubeFolder.getPropertyName().equalsIgnoreCase(CUBEFOLDER)) continue;
            found = true;
        }
        if (cubeFolder != null) {
            cubeFolder.setDefaultValue(newName);
        }
        if ((files = mdCube.getAssociatedFiles()).size() > 0) {
            File file = (File)files.get(0);
            file.setName(newName + UNDERSCORE_FILE);
            file.setFileName(newName);
        }
        if ((transformationStep = (TransformationStep)loadMap.getSteps().get(0)) != null) {
            transformationStep.setName(newName);
            TransformationActivity transformationActivity = (TransformationActivity)transformationStep.getActivities().get(0);
            transformationActivity.setName(newName);
        }
        mdJob.touch();
    }

    private Cube getCubeMetadatObject(MdObjectStore mdStore, ImportItemInterface cubeImportItem) throws RemoteException, MdException {
        int iOptions = 268;
        return (Cube)mdStore.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "Cube", cubeImportItem.getTargetID(), null, null, null, iOptions);
    }

    private Job getJobWithSingleActivity(ClassifierMap jomaMap) throws MdException, RemoteException {
        TransformationActivity activity;
        AssociationList jobs;
        TransformationStep step;
        AssociationList activities;
        AssociationList steps;
        Job job = null;
        if (!(jomaMap == null || (steps = jomaMap.getSteps(true)).isEmpty() || (activities = (step = (TransformationStep)steps.get(0)).getActivities(true)).isEmpty() || (jobs = (activity = (TransformationActivity)activities.get(0)).getJobs(true)).isEmpty() || (activities = (job = (Job)jobs.get(0)).getJobActivities(true)).size() <= 1)) {
            job = null;
        }
        return job;
    }

    boolean duplicateCubeJobExists(ImportOperationInterface operation, Job mdJob, String oldJobname, String desiredName) throws RemoteException, MdException, MetadataPromotionException {
        boolean duplicateExists = false;
        Log importLogger = operation.getLogger();
        if (mdJob != null) {
            AssociationList trees = mdJob.getTrees();
            Tree inputFolder = null;
            if (!trees.isEmpty()) {
                inputFolder = (Tree)trees.get(0);
            }
            try {
                ServerInterface server = operation.getServer();
                String sFQID = inputFolder.getFQID();
                String sType = inputFolder.getCMetadataType();
                String sKey = sFQID + SLASH + sType;
                FolderInterface folderObject = (FolderInterface)server.fetch(sKey, false);
                boolean hasDuplicate = folderObject.hasDuplicate(desiredName, "Job.CubeBuild");
                if (hasDuplicate) {
                    duplicateExists = true;
                    importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CubeImportListener.DuplicateCubeJob.fmt"), (Object)oldJobname, (Object)desiredName, (Object)folderObject.getName()));
                }
            }
            catch (ServiceException e) {
                throw new MetadataPromotionException((Throwable)e);
            }
        }
        return duplicateExists;
    }

    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) throws MetadataPromotionException {
        try {
            return this.updateColumnAssociations(operation, operation.getMetadataFactory(), operation.getConnectionManager().getConnections(true), connections);
        }
        catch (RemoteException e) {
            throw new MetadataPromotionException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateColumnAssociations(ImportOperationInterface operation, MdFactory factory, List lConnectionPoints, List lUpdatedConnections) throws RemoteException, MetadataPromotionException {
        int iRC = 0;
        boolean tableNotFound = false;
        boolean columnNotFound = false;
        ArrayList<ConnectionPointInterface> lColumnCPs = new ArrayList<ConnectionPointInterface>();
        ArrayList<ConnectionPointInterface> lTableCPs = new ArrayList<ConnectionPointInterface>();
        for (ConnectionPointInterface connPoint : lConnectionPoints) {
            if (connPoint.isActive() && "Column".equals(connPoint.getMetadataType())) {
                lColumnCPs.add(connPoint);
                continue;
            }
            if (!connPoint.isConnectionForImportType("Cube") && !connPoint.isConnectionForImportType("Job.CubeBuild") && !connPoint.isConnectionForImportType("Dimension") || !"PhysicalTable".equals(connPoint.getMetadataType()) && !"TableCollection".equals(connPoint.getMetadataType()) || !this.isCubeBeingImported(connPoint)) continue;
            lTableCPs.add(connPoint);
        }
        HashMap<String, ArrayList<ConnectionPointInterface>> mapColumns = new HashMap<String, ArrayList<ConnectionPointInterface>>();
        for (ConnectionPointInterface cpColumn : lColumnCPs) {
            String sColumnSearch = cpColumn.getSourceSearchString();
            String sTableSearch = "[Table/*";
            int iStartIndex = sColumnSearch.indexOf(sTableSearch) + sTableSearch.length();
            sTableSearch = sColumnSearch.substring(iStartIndex);
            sTableSearch = sTableSearch.replaceFirst("]/", "][");
            sTableSearch = '*' + sTableSearch;
            ArrayList<ConnectionPointInterface> lColumns = (ArrayList<ConnectionPointInterface>)mapColumns.get(sTableSearch);
            if (lColumns != null) {
                lColumns.add(cpColumn);
                continue;
            }
            lColumns = new ArrayList<ConnectionPointInterface>();
            lColumns.add(cpColumn);
            mapColumns.put(sTableSearch, lColumns);
        }
        MdObjectStore mdStore = factory.createObjectStore(null, "CubeImportListener:updateColumnAssociations");
        try {
            String msg;
            for (String sTableSearch : mapColumns.keySet()) {
                DataTable mdTable = null;
                ConnectionPointInterface cpTable2 = null;
                for (ConnectionPointInterface cpTable2 : lTableCPs) {
                    if (!sTableSearch.equals(cpTable2.getSourceSearchString())) continue;
                    if (cpTable2.getTargetID() == null) break;
                    mdTable = (DataTable)factory.createComplexMetadataObject(mdStore, cpTable2.getName(), cpTable2.getMetadataType(), cpTable2.getTargetID());
                    break;
                }
                if (mdTable == null) continue;
                List lSourceColumns = (List)mapColumns.get(sTableSearch);
                ArrayList lTargetColumns = new ArrayList(mdTable.getColumns());
                if (lSourceColumns == null || lSourceColumns.isEmpty() || lTargetColumns == null || lTargetColumns.isEmpty()) continue;
                for (ConnectionPointInterface cpColumn : lSourceColumns) {
                    String sColumnName = cpColumn.getName();
                    boolean targetColumnFound = false;
                    Iterator iterTargetColumns = lTargetColumns.iterator();
                    while (iterTargetColumns.hasNext()) {
                        Column mdColumn = (Column)iterTargetColumns.next();
                        if (!sColumnName.equals(mdColumn.getName())) continue;
                        cpColumn.setTargetID(mdColumn.getFQID());
                        lUpdatedConnections.add(cpColumn);
                        iterTargetColumns.remove();
                        targetColumnFound = true;
                        break;
                    }
                    if (targetColumnFound) continue;
                    String cubeName = this.findCubeName(cpTable2);
                    String msg2 = UtilMisc.getMessage((String)RB.getStringResource("CubeImportListener.ColumnForTableNotFound.fmt"), (Object)mdTable.getName(), (Object)cubeName, (Object)cpColumn.getName());
                    operation.getLogger().warn((Object)msg2);
                    columnNotFound = true;
                    iRC = 4;
                }
            }
            for (ConnectionPointInterface cpTable : lTableCPs) {
                if (cpTable.getTargetID() != null) continue;
                String msg3 = UtilMisc.getMessage((String)RB.getStringResource("CubeImportListener.TableNotFound.fmt"), (Object)cpTable.getName(), (Object)this.findCubeName(cpTable));
                operation.getLogger().warn((Object)msg3);
                tableNotFound = true;
                iRC = 4;
            }
            if (tableNotFound) {
                msg = RB.getStringResource("CubeImportListener.TablesNotFound.txt");
                operation.getLogger().warn((Object)msg);
                iRC = 4;
            }
            if (columnNotFound) {
                msg = RB.getStringResource("CubeImportListener.ColumnsNotFound.txt");
                operation.getLogger().warn((Object)msg);
                iRC = 4;
            }
        }
        catch (MdException mde) {
            operation.getLogger().error((Object)mde.getLocalizedMessage());
            iRC = 8;
        }
        finally {
            mdStore.dispose();
        }
        return iRC;
    }

    private String findCubeName(ConnectionPointInterface cpTable) throws MetadataPromotionException, RemoteException {
        String cubeName;
        block9: {
            TypeInterface ti;
            block11: {
                TypeInterface ti2;
                block10: {
                    cubeName = EMPTY;
                    if (!cpTable.isConnectionForImportType("Cube")) break block10;
                    List assocObjects = cpTable.getAssociatedObjects();
                    for (int i = 0; i < assocObjects.size(); ++i) {
                        PromotionItemInterface item = (PromotionItemInterface)assocObjects.get(i);
                        if (!(item instanceof CubeImportItem)) continue;
                        cubeName = item.getName();
                        break block9;
                    }
                    break block9;
                }
                if (!cpTable.isConnectionForImportType("Job.CubeBuild")) break block11;
                try {
                    ti2 = Factory.getInstance().getTypeInterface("Job.CubeBuild");
                }
                catch (LogicalTypeException e) {
                    throw new MetadataPromotionException((Throwable)e);
                }
                List assocObjects = cpTable.getAssociatedObjects();
                block5: for (int i = 0; i < assocObjects.size(); ++i) {
                    PromotionItemInterface item = (PromotionItemInterface)assocObjects.get(i);
                    if (!ti2.equals((Object)item.getTypeInterface())) continue;
                    List connPoints = item.getConnectionPoints();
                    for (int j = 0; j < connPoints.size(); ++j) {
                        ConnectionPointInterface conn = (ConnectionPointInterface)connPoints.get(j);
                        if (!conn.getMetadataType().equals("Cube")) continue;
                        cubeName = conn.getName();
                        continue block5;
                    }
                }
                break block9;
            }
            if (!cpTable.isConnectionForImportType("Dimension")) break block9;
            try {
                ti = Factory.getInstance().getTypeInterface("Dimension");
            }
            catch (LogicalTypeException e) {
                throw new MetadataPromotionException((Throwable)e);
            }
            List assocObjects = cpTable.getAssociatedObjects();
            block7: for (int i = 0; i < assocObjects.size(); ++i) {
                PromotionItemInterface item = (PromotionItemInterface)assocObjects.get(i);
                if (!ti.equals((Object)item.getTypeInterface())) continue;
                List connPoints = item.getConnectionPoints();
                for (int j = 0; j < connPoints.size(); ++j) {
                    ConnectionPointInterface conn = (ConnectionPointInterface)connPoints.get(j);
                    if (!conn.getMetadataType().equals("Cube")) continue;
                    cubeName = conn.getName();
                    continue block7;
                }
            }
        }
        return cubeName;
    }

    private boolean isCubeBeingImported(ConnectionPointInterface cpTable) throws MetadataPromotionException, RemoteException {
        boolean stateAdd;
        block10: {
            block12: {
                block11: {
                    stateAdd = false;
                    if (!cpTable.isConnectionForImportType("Cube")) break block11;
                    List assocObjects = cpTable.getAssociatedObjects();
                    for (int i = 0; i < assocObjects.size(); ++i) {
                        PromotionItemInterface item = (PromotionItemInterface)assocObjects.get(i);
                        if (!(item instanceof CubeImportItem)) continue;
                        CubeImportItem cube = (CubeImportItem)item;
                        boolean bl = stateAdd = cube.getImportState() != 0;
                        if (!stateAdd) {
                            continue;
                        }
                        break block10;
                    }
                    break block10;
                }
                if (!cpTable.isConnectionForImportType("Job.CubeBuild")) break block12;
                List assocObjects = cpTable.getAssociatedObjects();
                for (int i = 0; i < assocObjects.size(); ++i) {
                    TypeInterface ti;
                    PromotionItemInterface item = (PromotionItemInterface)assocObjects.get(i);
                    try {
                        ti = Factory.getInstance().getTypeInterface("Job.CubeBuild");
                    }
                    catch (LogicalTypeException e) {
                        throw new MetadataPromotionException((Throwable)e);
                    }
                    if (!ti.equals((Object)item.getTypeInterface()) || !(item instanceof ImportItemInterface)) continue;
                    ImportItemInterface jobcube = (ImportItemInterface)item;
                    boolean bl = stateAdd = jobcube.getImportState() != 0;
                    if (!stateAdd) {
                        continue;
                    }
                    break block10;
                }
                break block10;
            }
            if (!cpTable.isConnectionForImportType("Dimension")) break block10;
            List assocObjects = cpTable.getAssociatedObjects();
            for (int i = 0; i < assocObjects.size(); ++i) {
                TypeInterface ti;
                PromotionItemInterface item = (PromotionItemInterface)assocObjects.get(i);
                try {
                    ti = Factory.getInstance().getTypeInterface("Dimension");
                }
                catch (LogicalTypeException e) {
                    throw new MetadataPromotionException((Throwable)e);
                }
                if (!ti.equals((Object)item.getTypeInterface()) || !(item instanceof ImportItemInterface)) continue;
                ImportItemInterface jobcube = (ImportItemInterface)item;
                boolean bl = stateAdd = jobcube.getImportState() != 0;
                if (!stateAdd) {
                    continue;
                }
                break;
            }
        }
        return stateAdd;
    }
}

