/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.cube;

import com.sas.metadata.logical.cube.RB;
import com.sas.metadata.logical.olapschema.OLAPSchemaConnectionType;
import com.sas.metadata.promotion.AbstractFolderMemberConnectionType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionPropertiesInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.SearchCriteria;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CubeConnectionType
extends AbstractFolderMemberConnectionType
implements ConnectionPropertiesInterface {
    private static final String PROPERTY_SCHEMA = "SCHEMA_NAME";
    private static final String TYPE_NAME = "Cube";

    public CubeConnectionType(PromotionInterface promotionOperation) {
        super(TYPE_NAME, promotionOperation);
    }

    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    public String getLocalizedTypeName() {
        return RB.getStringResource("CubeConnectionType.ConnectionType.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.cube.CubeConnectionPanel";
    }

    public SearchCriteria generateSearchCriteria(SourceConnectionInterface sourceConnection, String objectName) throws MetadataPromotionException {
        Map schemaMapping;
        SearchCriteria criteria = new SearchCriteria(sourceConnection);
        criteria.setSearchType(1);
        criteria.setMetadataType(TYPE_NAME);
        String targetSchemaName = null;
        String schema = CubeConnectionType.getSchemaName(sourceConnection);
        ConnectionTypeInterface schemaType = this._operation.getConnectionType(OLAPSchemaConnectionType.getTypeClassName());
        if (schemaType != null && (schemaMapping = schemaType.getConnectionMapping()) != null && schema != null) {
            for (SourceConnectionInterface sc : schemaMapping.keySet()) {
                TargetConnectionInterface tc;
                if (!sc.getDisplayName().equals(schema) || (tc = (TargetConnectionInterface)schemaMapping.get(sc)) == null) continue;
                targetSchemaName = tc.getDisplayName();
                break;
            }
        }
        if (targetSchemaName == null) {
            targetSchemaName = schema;
        }
        if (targetSchemaName != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("*[@Name='");
            sb.append(objectName);
            sb.append("'][AssociatedOLAPSchema/*[@Name='");
            sb.append(targetSchemaName);
            sb.append("']]");
            criteria.setSearchString(sb.toString());
        }
        return criteria;
    }

    public static String getSchemaName(SourceConnectionInterface source) {
        int startIndex;
        ConnectionPointInterface pt;
        String searchAttribute;
        int index;
        List connections = source.getConnectionPoints();
        if (connections.size() > 0 && (index = (searchAttribute = (pt = (ConnectionPointInterface)connections.get(0)).getSourceSearchString()).indexOf("@Name='", startIndex = searchAttribute.indexOf("AssociatedOLAPSchema"))) > -1) {
            return searchAttribute.substring(index + 7, searchAttribute.indexOf(39, index + 7));
        }
        return null;
    }

    public Map getPropertyNames() {
        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>(1);
        propertyMap.put(PROPERTY_SCHEMA, RB.getStringResource("CubeConnectionType.Schema.txt"));
        return propertyMap;
    }

    public Map getSourcePropertyValues(SourceConnectionInterface source) throws MdException, RemoteException {
        LinkedHashMap<String, String> propertyValues = new LinkedHashMap<String, String>(1);
        String schemaName = CubeConnectionType.getSchemaName(source);
        if (schemaName != null) {
            propertyValues.put(PROPERTY_SCHEMA, schemaName);
        }
        return propertyValues;
    }

    public Map getTargetPropertyValues(TargetConnectionInterface target) throws MdException, RemoteException {
        Cube cube;
        AssociationList schemas;
        LinkedHashMap<String, String> propertyValues = new LinkedHashMap<String, String>(1);
        CMetadata meta = target.getMetadataObject();
        if (meta instanceof Cube && (schemas = (cube = (Cube)meta).getAssociatedOLAPSchemas()).size() > 0) {
            String schemaName = ((CMetadata)schemas.get(0)).getName();
            propertyValues.put(PROPERTY_SCHEMA, schemaName);
        }
        return propertyValues;
    }
}

