/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.cube;

import com.sas.editor.LogListHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.cube.CubeUtilities;
import com.sas.metadata.logical.cube.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SharedDimension;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.utilities.SavePanel;
import com.sas.olapadmin.utilities.SaveSasLogActionListener;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.util.Names;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractVersionedObjectManager;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.visuals.WsLogPropertyTab;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Cube
extends LogicalObject {
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(5, 0);
    public static final UsageVersion FAILED_MIGRATION_VERSION = new UsageVersion(3, 0);
    private final String newline = System.getProperty("line.separator");
    private static final String procOlap = "PROC OLAP";
    private static final String cubeEquals = "   CUBE     = ";
    private static final String projectEquals = "   PROJECT  = ";
    private static final String deleteCube = "   DELETE";
    private static final String renameCube = "   RENAME";
    private static final String outCube = "   OUTCUBE  =  ";
    private static final String metasvr = "   METASVR";
    private static final String olapschema = "      OLAP_SCHEMA = ";
    private static final String run = "   RUN;";
    private static final String VALIDVARNAMESYNTAX = "OPTIONS VALIDVARNAME=ANY;";
    private static final String WRITE_METADATA = "WriteMetadata";
    private static final String READ_METADATA = "ReadMetadata";
    private static final String BLANK_STRING = "";
    private static final String SEMICOLON = ";";
    private static final String LOAD_MAP = "Load Map";
    private static final String CUBEFOLDER = "CUBEFOLDER";
    private static final String UNDERSCORE_FILE = "_File";
    private static final String MAX_RETRIES = "   MAX_RETRIES            = ";
    private static final String MAX_RETRY_WAIT = "   MAX_RETRY_WAIT         = ";
    private static final String MIN_RETRY_WAIT = "   MIN_RETRY_WAIT         = ";
    private static final String MAX_RETRY_ATTEMPT_KEY = "ProcOlap.MaxRetry";
    private static final String MAX_RETRY_SECONDS_KEY = "ProcOlap.MaxWait";
    private static final String MIN_RETRY_SECONDS_KEY = "ProcOlap.MinWait";
    int CUBE_MAXNAMELENGTH = 32;

    public Cube(com.sas.metadata.remote.Cube inputCube, TypeInterface type, Factory factory) throws RemoteException {
        super((Root)inputCube, type, factory);
        this.setCompatibility(FAILED_MIGRATION_VERSION, CURRENT_VERSION);
    }

    private boolean isBlank(String value) {
        return value == null || Strings.trimmedLength((String)value) == 0;
    }

    public boolean isCheckOutAllowed() {
        return false;
    }

    public boolean isFetchAllowed() {
        return false;
    }

    private boolean isAllowed(boolean checkSchema) throws LogicalTypeException {
        boolean canDo = false;
        MdObjectStore store = null;
        try {
            store = Workspace.getMdFactory().createObjectStore(null, "Cube.isAllowed");
            com.sas.metadata.remote.Cube jomaCube = this.getJomaCube(null, store);
            if (jomaCube != null) {
                String readTemplate = "<Templates><Cube><Dimensions search=\"SharedDimension\"/></Cube><SharedDimension><Hierarchies/><Levels/></SharedDimension></Templates>";
                int iOptions = 268;
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)jomaCube, null, null, readTemplate, iOptions);
                boolean schemaOK = true;
                if (checkSchema) {
                    OLAPSchema schema = jomaCube.getAssociatedOLAPSchema();
                    boolean bl = schemaOK = schema != null;
                }
                if (schemaOK) {
                    boolean canWriteAllCube = Cube.getPermissions(WRITE_METADATA, (CMetadata)jomaCube);
                    boolean canReadAllCube = Cube.getPermissions(READ_METADATA, (CMetadata)jomaCube);
                    canDo = canWriteAllCube & canReadAllCube;
                }
            }
        }
        catch (MdException mderror) {
            throw new LogicalTypeException((Exception)((Object)mderror));
        }
        catch (RemoteException re) {
            throw new LogicalTypeException((Exception)re);
        }
        finally {
            try {
                if (store != null) {
                    store.dispose();
                }
            }
            catch (RemoteException e) {
                throw new LogicalTypeException((Exception)e);
            }
        }
        return canDo;
    }

    private boolean isUpgradeable() {
        return WsAbstractVersionedObjectManager.isUpgradeable((String)"Cube", (UsageVersion)this.getUsageVersion());
    }

    private boolean isVersionSupported() {
        return WsAbstractVersionedObjectManager.getInstance().isVersionSupported("Cube", this.getUsageVersion());
    }

    public boolean isDeleteAllowed() throws LogicalTypeException, RemoteException {
        boolean versionSupported;
        boolean allowed = super.isDeleteAllowed();
        boolean upgradeable = this.isUpgradeable();
        boolean ret_val = !allowed ? (upgradeable ? upgradeable : allowed) : ((versionSupported = this.isVersionSupported()) ? this.isAllowed(false) : (upgradeable ? upgradeable : false));
        return ret_val;
    }

    public boolean isRenameAllowed() throws LogicalTypeException {
        boolean ret_val;
        boolean allowed = super.isRenameAllowed();
        if (!allowed) {
            ret_val = false;
        } else {
            boolean upgradeable = this.isUpgradeable();
            boolean versionSupported = this.isVersionSupported();
            ret_val = upgradeable ? false : (versionSupported ? this.isAllowed(true) : false);
        }
        return ret_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidName(String name) throws LogicalTypeException, RemoteException {
        if (this.isBlank(name) || name.length() > this.CUBE_MAXNAMELENGTH) {
            MessageUtil.displayMessage((String)RB.getStringResource("CubeServer.Error.Name.txt"), (int)0);
            return false;
        }
        MdObjectStore objectStore = null;
        try {
            Names.validateOMRObjectName((String)name, (boolean)true);
            objectStore = Workspace.getMdFactory().createObjectStore(null, "Cube.isValidName");
            com.sas.metadata.remote.Cube jomaCube = this.getJomaCube(null, objectStore);
            String currentCubeName = jomaCube.getName();
            if (currentCubeName.equalsIgnoreCase(name)) {
                boolean bl = true;
                return bl;
            }
            if (jomaCube != null) {
                OLAPSchema schema = jomaCube.getAssociatedOLAPSchema();
                if (schema == null) {
                    boolean bl = false;
                    return bl;
                }
                if (!CubeUtilities.isCubeNameUniqueToOLAPSchema(name, schema)) {
                    objectStore.dispose();
                    MessageUtil.displayMessage((String)RB.getStringResource("CubeServer.Error.DuplicateName.txt"), (int)0);
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (MdException mdError) {
            throw new LogicalTypeException((Exception)((Object)mdError));
        }
        catch (RemoteException re) {
            throw new LogicalTypeException((Exception)re);
        }
        catch (IllegalArgumentException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            boolean bl = false;
            return bl;
        }
        finally {
            if (objectStore != null) {
                objectStore.dispose();
            }
        }
        return true;
    }

    private StringBuffer generateCodeProcOlapCubeEquals(Tree inputFolder) throws MdException, RemoteException, LogicalTypeException {
        StringBuffer proc = new StringBuffer();
        MdObjectStore objectStore = Workspace.getMdFactory().createObjectStore(null, "Cube.generateCodeProcOlapCubeEquals");
        com.sas.metadata.remote.Cube jomaCube = this.getJomaCube(null, objectStore);
        if (jomaCube != null) {
            CMetadata repository;
            proc.append(procOlap).append(this.newline);
            String pathFolder = null;
            MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
            if (inputFolder != null) {
                pathFolder = mdUtil.getObjectPath((MdObjectStore)inputFolder.getObjectStore(), (PrimaryType)inputFolder, false);
            }
            if (pathFolder != null && pathFolder.length() > 0) {
                proc.append(cubeEquals).append("\"").append(pathFolder).append("/").append(this.getName()).append("\"");
            } else {
                proc.append(cubeEquals).append("\"").append(this.getName()).append("\"");
            }
            if (Workspace.getWorkspace().isChangeManagementOn() && (repository = Workspace.getWorkspace().getProjectRepository()) != null) {
                proc.append(this.newline).append(projectEquals).append("\"").append(repository.getName()).append("\"");
            }
            proc.append(this.getReconnectionString());
        }
        if (objectStore != null) {
            objectStore.dispose();
        }
        return proc;
    }

    private Tree getFolder(com.sas.metadata.remote.Cube inputCube) throws MdException, RemoteException {
        Tree folder = null;
        AssociationList trees = null;
        trees = inputCube.getTrees(false);
        if (!trees.isEmpty()) {
            folder = (Tree)trees.get(0);
        }
        return folder;
    }

    private StringBuffer generateCodeMetasrvStatement(OLAPSchema inputSchema) throws LogicalTypeException {
        StringBuffer procOlapMetasrv = new StringBuffer();
        try {
            String schemaName = inputSchema.getName();
            procOlapMetasrv.append(metasvr).append(this.newline);
            procOlapMetasrv.append(olapschema).append("\"").append(schemaName).append("\"");
            procOlapMetasrv.append(SEMICOLON).append(this.newline);
        }
        catch (RemoteException e) {
            throw new LogicalTypeException((Exception)e);
        }
        return procOlapMetasrv;
    }

    private StringBuffer generateCodeRename(String newCubeName) throws MdException, RemoteException, LogicalTypeException {
        MdObjectStore objectStore = Workspace.getMdFactory().createObjectStore(null, "Cube.generateCodeRename");
        com.sas.metadata.remote.Cube jomaCube = this.getJomaCube(null, objectStore);
        StringBuffer rename = new StringBuffer();
        if (jomaCube != null) {
            String currentName = jomaCube.getName();
            rename.append(VALIDVARNAMESYNTAX).append(this.newline);
            MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
            Tree inputFolder = this.getFolder(jomaCube);
            String pathURL = null;
            if (inputFolder != null) {
                pathURL = mdUtil.getObjectPath((MdObjectStore)inputFolder.getObjectStore(), (PrimaryType)inputFolder, false);
            }
            rename.append(this.newline).append(procOlap).append(renameCube).append(this.newline);
            if (pathURL != null && pathURL.length() > 0) {
                rename.append(cubeEquals).append("\"").append(pathURL).append("/").append(currentName).append("\"");
                rename.append(this.newline).append(outCube).append("\"").append(pathURL).append("/").append(newCubeName).append("\"");
            } else {
                rename.append(cubeEquals).append("\"").append(currentName).append("\"");
                rename.append(this.newline).append(outCube).append("\"").append(newCubeName).append("\"");
            }
            rename.append(this.getReconnectionString());
            rename.append(SEMICOLON).append(this.newline).append(this.newline);
            rename.append(this.generateCodeMetasrvStatement(jomaCube.getAssociatedOLAPSchema()));
            rename.append(this.newline).append(run);
        }
        if (objectStore != null) {
            objectStore.dispose();
        }
        return rename;
    }

    private StringBuffer generateCodeDelete() throws MdException, RemoteException, LogicalTypeException {
        MdObjectStore objectStore = Workspace.getMdFactory().createObjectStore(null, "Cube.generateCodeDelete");
        com.sas.metadata.remote.Cube jomaCube = this.getJomaCube(null, objectStore);
        StringBuffer delete = new StringBuffer();
        if (jomaCube != null) {
            Tree folder = null;
            AssociationList trees = jomaCube.getTrees(false);
            if (!trees.isEmpty()) {
                folder = (Tree)trees.get(0);
            }
            delete.append(VALIDVARNAMESYNTAX).append(this.newline);
            delete.append(this.generateCodeProcOlapCubeEquals(folder)).append(this.newline).append(deleteCube);
            delete.append(SEMICOLON).append(this.newline).append(this.newline);
            delete.append(this.generateCodeMetasrvStatement(jomaCube.getAssociatedOLAPSchema()));
            delete.append(this.newline).append(run);
        }
        if (objectStore != null) {
            objectStore.dispose();
        }
        return delete;
    }

    private com.sas.metadata.remote.Cube getJomaCube(OperationUserInteractionInterface oui, MdObjectStore objectStore) throws LogicalTypeException {
        com.sas.metadata.remote.Cube jomaCube = null;
        ArrayList<String> cubeAssociations = new ArrayList<String>();
        cubeAssociations.add("Trees");
        String template = "<Templates><Tree><Members/></Tree></Templates>";
        try {
            jomaCube = (com.sas.metadata.remote.Cube)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)objectStore, this.getTypeInterface().getMetadataType(), this.getID(), null, cubeAssociations, template, 12);
        }
        catch (MdException e) {
            this.handleException(jomaCube, oui, (Exception)((Object)e));
        }
        catch (RemoteException e) {
            this.handleException(jomaCube, oui, e);
        }
        return jomaCube;
    }

    private void handleException(com.sas.metadata.remote.Cube jomaCube, OperationUserInteractionInterface oui, Exception e) throws LogicalTypeException {
        String folderName = BLANK_STRING;
        try {
            if (jomaCube != null) {
                Tree tree = (Tree)jomaCube.getTrees().get(0);
                folderName = tree.getName();
            }
        }
        catch (RemoteException re) {
            throw new LogicalTypeException((Exception)re);
        }
        catch (Exception e1) {
            throw new LogicalTypeException(e1);
        }
        if (oui != null && oui.continueOperationWithPrompting()) {
            String messageText = UtilMisc.getMessage((String)RB.getStringResource("Cube.DelExcpOccrd.fmt.txt"), (Object)this.getName(), (Object)folderName, (Object)UtilMisc.getExceptionMessageText((Exception)e));
            int choice = oui.displayMessage(RB.getStringResource("CubeError.window.title"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
            OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)oui, (int)choice);
        }
    }

    private ClassifierMap getClassifierMap(com.sas.metadata.remote.Cube jomaCube) throws LogicalTypeException {
        ClassifierMap classifierMap = null;
        try {
            AssociationList maps = jomaCube.getTargetClassifierMaps(true);
            int i = maps.size() - 1;
            while (i >= 0 & classifierMap == null) {
                classifierMap = (ClassifierMap)maps.get(i);
                if (!classifierMap.getName().equals(LOAD_MAP)) {
                    classifierMap = null;
                }
                --i;
            }
        }
        catch (MdException e) {
            classifierMap = null;
            throw new LogicalTypeException((Exception)((Object)e));
        }
        catch (RemoteException e) {
            classifierMap = null;
            throw new LogicalTypeException((Exception)e);
        }
        return classifierMap;
    }

    private Job getJobWithSingleActivity(ClassifierMap jomaMap) throws MdException, RemoteException {
        TransformationActivity activity;
        AssociationList jobs;
        TransformationStep step;
        AssociationList activities;
        AssociationList steps;
        Job job = null;
        if (!(jomaMap == null || (steps = jomaMap.getSteps(true)).isEmpty() || (activities = (step = (TransformationStep)steps.get(0)).getActivities(true)).isEmpty() || (jobs = (activity = (TransformationActivity)activities.get(0)).getJobs(true)).isEmpty() || (activities = (job = (Job)jobs.get(0)).getJobActivities(true)).size() <= 1)) {
            job = null;
        }
        return job;
    }

    private OLAPSchema getValidSchemaFromMetadata(List schemas, com.sas.metadata.remote.Cube jomaCube) throws RemoteException {
        OLAPSchema schema = null;
        for (int i = schemas.size() - 1; i >= 0; --i) {
            schema = (OLAPSchema)schemas.get(i);
            if (CubeUtilities.isCubeNameUniqueToOLAPSchema(jomaCube.getName(), schema)) continue;
            schema = null;
        }
        return schema;
    }

    private OLAPSchema createValidSchema(MdObjectStore objectStore) throws MdException, RemoteException {
        OLAPSchema schema = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        StringBuffer tempName = new StringBuffer(format.format(new Date()));
        tempName.append("TEMPORARY_OLAPSCHEMA_DONOTUSE");
        String shortFQID = Workspace.getMdFactory().getOMIUtil().getFoundationReposID().substring(9, 17);
        schema = (OLAPSchema)Workspace.getMdFactory().createComplexMetadataObject(objectStore, BLANK_STRING, "OLAPSchema", shortFQID);
        schema.setName(tempName.toString());
        schema.touch();
        schema.updateMetadataAll();
        return schema;
    }

    private boolean repairOLAPSchema(com.sas.metadata.remote.Cube jomaCube, MdObjectStore objectStore) throws MdException, RemoteException {
        boolean removeSchema = false;
        OLAPSchema schema = this.getValidSchemaFromMetadata(CubeUtilities.getOLAPSchemas(objectStore), jomaCube);
        if (schema == null) {
            schema = this.createValidSchema(objectStore);
            removeSchema = true;
        }
        if (schema != null) {
            AssociationList schemas = jomaCube.getAssociatedOLAPSchemas(true);
            schemas.clear();
            schemas.add((Object)schema);
            jomaCube.touch();
            jomaCube.updateMetadataAll();
        }
        return removeSchema;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delete(OperationUserInteractionInterface oui) throws LogicalTypeException, RemoteException {
        String progressText = this.getProgressMessageForDelete();
        oui.updateProgress(progressText);
        boolean deleted = true;
        MdObjectStore objectStore = null;
        try {
            objectStore = Workspace.getMdFactory().createObjectStore(null, "Cube.delete");
            com.sas.metadata.remote.Cube jomaCube = this.getJomaCube(oui, objectStore);
            String cubeName = jomaCube.getCubeName();
            ClassifierMap jomaMap = this.getClassifierMap(jomaCube);
            Job jomaJob = this.getJobWithSingleActivity(jomaMap);
            if (this.isBlank(cubeName)) {
                Workspace.getMdFactory().deleteMetadataObject((CMetadata)jomaCube);
                if (jomaJob == null) return deleted;
                Workspace.getMdFactory().deleteMetadataObject((CMetadata)jomaJob);
                return deleted;
            }
            if (!oui.isUserInteractionSupported()) {
                deleted = false;
                Logger logger = LogManager.getLogger((String)"com.sas.metadata.logical.cube");
                logger.error(UtilMisc.getMessage((String)RB.getStringResource("CubeError.NoBatchDelete.fmt"), (Object)jomaCube.getName()));
                return deleted;
            }
            WsAppServer applicationServer = null;
            try {
                applicationServer = WsRunCode.getServer();
                if (applicationServer != null) {
                    boolean removeSchema = false;
                    AssociationList schemas = jomaCube.getAssociatedOLAPSchemas(true);
                    OLAPSchema schema = null;
                    if (!schemas.isEmpty()) {
                        schema = (OLAPSchema)schemas.get(0);
                    }
                    if (schema == null) {
                        removeSchema = this.repairOLAPSchema(jomaCube, objectStore);
                        schemas = jomaCube.getAssociatedOLAPSchemas(true);
                        if (!schemas.isEmpty()) {
                            schema = (OLAPSchema)schemas.get(0);
                        }
                        if (schema == null) {
                            oui.displayMessage(RB.getStringResource("CubeError.window.title"), RB.getStringResource("CubeDelete.Error.txt"), 2, OperationUserInteractionInterface.OK_CHOICE_SET);
                            this.cleanup(objectStore, applicationServer, null);
                            boolean bl = false;
                            return bl;
                        }
                    }
                    applicationServer.openSASCodeSession();
                    applicationServer.submitSASCode(this.generateCodeDelete().toString());
                    if (removeSchema) {
                        Workspace.getMdFactory().deleteMetadataObject((CMetadata)schema);
                    }
                    Workspace.getDefaultLogger().warn((Object)applicationServer.getLogBuffer());
                } else {
                    deleted = false;
                }
            }
            catch (WsAppServerCodeException e) {
                this.displayAppServerLog(objectStore, applicationServer, e);
            }
            catch (Exception ae) {
                String folderName = BLANK_STRING;
                try {
                    if (jomaCube != null) {
                        Tree tree = (Tree)jomaCube.getTrees().get(0);
                        folderName = tree.getName();
                    }
                    String messageText = UtilMisc.getMessage((String)RB.getStringResource("Cube.DelExcpOccrd.fmt.txt"), (Object)this.getName(), (Object)folderName, (Object)UtilMisc.getExceptionMessageText((Exception)ae));
                    int choice = oui.displayMessage(RB.getStringResource("CubeError.window.title"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                    OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)oui, (int)choice);
                }
                catch (Exception e1) {
                    this.cleanup(objectStore, applicationServer, null);
                    throw new LogicalTypeException(e1);
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            MdOMIUtil util = Workspace.getMdFactory().getOMIUtil();
            String xmlselect = "<XMLSELECT search=\"@Id='" + jomaCube.getFQID() + "'\"/>";
            String reposid = "A0000001." + jomaCube.getRepositoryID();
            if (util.doesObjectExist(reposid, "Cube", xmlselect) == 0) {
                map.put(jomaCube.getFQID(), jomaCube.getCMetadataType());
            }
            if (jomaJob != null) {
                xmlselect = "<XMLSELECT search=\"@Id='" + jomaJob.getFQID() + "'\"/>";
                reposid = "A0000001." + jomaJob.getRepositoryID();
                if (util.doesObjectExist(reposid, "Job", xmlselect) == 0) {
                    map.put(jomaJob.getFQID(), jomaJob.getCMetadataType());
                }
            }
            map.put("deletemap", "deletemap");
            this.cleanup(objectStore, applicationServer, map);
            return deleted;
        }
        catch (RemoteException e) {
            throw new LogicalTypeException((Exception)e);
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            if (objectStore != null && !objectStore.isDisposed()) {
                objectStore.dispose();
            }
        }
    }

    private void displayAppServerLog(MdObjectStore objectStore, WsAppServer applicationServer, WsAppServerCodeException e) throws LogicalTypeException {
        WsLogPropertyTab logPropertyTab = new WsLogPropertyTab(1);
        try {
            LogListHolder logData = applicationServer.getLog();
            logPropertyTab.appendText(logData);
            logPropertyTab.scrollToTop();
            SavePanel panel = new SavePanel((WAPanel)logPropertyTab);
            panel.setPreferredSize(new Dimension(400, 350));
            panel.setSaveActionListener((ActionListener)new SaveSasLogActionListener(logData));
            MessageUtil.displayDetailsMessage((String)e.getLocalizedMessage(), (String)RB.getStringResource("CubeError.window.title"), (int)0, (JComponent)panel);
        }
        catch (WsAppServerFailException e3) {
            this.cleanup(objectStore, applicationServer, null);
            throw new LogicalTypeException((Exception)((Object)e3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String cubeName, OperationUserInteractionInterface oui) throws LogicalTypeException {
        block37: {
            String progressText = UtilMisc.getMessage((String)RB.getStringResource("CubeRename.window.title"), (Object)cubeName);
            oui.updateProgress(progressText);
            MdObjectStore objectStore = null;
            try {
                boolean renameCube;
                boolean renameJob;
                Job jomaJob;
                HashMap<String, String> map;
                ClassifierMap loadMap;
                String currentName;
                com.sas.metadata.remote.Cube jomaCube;
                block36: {
                    FolderInterface parentFolder;
                    Object parentObject;
                    MetadataInterface mi = UtilPlatformServices.getSmartObject((SimpleLogicalObjectInterface)this);
                    List parents = mi.getParents();
                    if (parents != null && parents.size() == 1 && (parentObject = parents.get(0)) instanceof FolderInterface && (parentFolder = (FolderInterface)parentObject).hasDuplicate(cubeName, this.getTypeInterface().getPublicType())) {
                        LogicalTypeException loe = new LogicalTypeException(UtilMisc.getMessage((String)RB.getStringResource("Cube.DuplicateObjectFound.fmt"), (Object)cubeName));
                        throw loe;
                    }
                    Names.validateOMRObjectName((String)cubeName, (boolean)true);
                    objectStore = Workspace.getMdFactory().createObjectStore(null, "Cube.rename");
                    jomaCube = this.getJomaCube(oui, objectStore);
                    currentName = jomaCube.getName();
                    loadMap = null;
                    map = null;
                    jomaJob = null;
                    renameJob = false;
                    renameCube = true;
                    try {
                        String originalJobName;
                        AssociationList loadMaps = jomaCube.getTargetClassifierMaps(true);
                        for (int i = loadMaps.size() - 1; i >= 0 && loadMap == null; --i) {
                            loadMap = (ClassifierMap)loadMaps.get(i);
                            if (loadMap.getName().equalsIgnoreCase(LOAD_MAP)) continue;
                            loadMap = null;
                        }
                        jomaJob = this.getJobWithSingleActivity(loadMap);
                        if (jomaJob == null || !(originalJobName = jomaJob.getName()).equals(currentName) || currentName.equalsIgnoreCase(cubeName)) break block36;
                        AssociationList trees = jomaCube.getTrees(false);
                        Tree inputFolder = null;
                        if (!trees.isEmpty()) {
                            inputFolder = (Tree)trees.get(0);
                        }
                        try {
                            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                            String sFQID = inputFolder.getFQID();
                            String sType = inputFolder.getCMetadataType();
                            String sKey = sFQID + "/" + sType;
                            FolderInterface folderObject = (FolderInterface)server.fetch(sKey, false);
                            boolean hasDuplicate = folderObject.hasDuplicate(cubeName, "Job.CubeBuild");
                            if (hasDuplicate) {
                                renameCube = false;
                                oui.displayMessage(RB.getStringResource("CubeError.window.title"), UtilMisc.getMessage((String)RB.getStringResource("Cube.RenameError.fmt"), (Object)cubeName), 2, OperationUserInteractionInterface.OK_CHOICE_SET);
                            } else {
                                renameJob = true;
                            }
                        }
                        catch (ServiceException e) {
                            throw new LogicalTypeException((Exception)((Object)e));
                        }
                    }
                    catch (MdException e) {
                        throw new LogicalTypeException((Exception)((Object)e));
                    }
                }
                if (!renameCube || currentName.equalsIgnoreCase(cubeName)) break block37;
                String existName = jomaCube.getCubeName();
                if (this.isBlank(existName)) {
                    this.renameCubeNotPhyiscallyExist(cubeName, oui, objectStore, jomaCube, currentName, loadMap, jomaJob, renameJob);
                    break block37;
                }
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
                WsAppServer applicationServer = null;
                try {
                    applicationServer = WsRunCode.getServer();
                    if (applicationServer != null) {
                        applicationServer.openSASCodeSession();
                        applicationServer.submitSASCode(this.generateCodeRename(cubeName).toString());
                        if (map == null) {
                            map = new HashMap<String, String>();
                        }
                        map.put(jomaCube.getFQID(), jomaCube.getCMetadataType());
                        if (jomaJob != null) {
                            map.put(jomaJob.getFQID(), jomaJob.getCMetadataType());
                        }
                        map.put("renamemap", "renamemap");
                        Workspace.getDefaultLogger().debug((Object)applicationServer.getLogBuffer());
                    } else {
                        oui.displayMessage(RB.getStringResource("CubeError.window.title"), RB.getStringResource("CubeServer.Error.NoConnect.txt"), 2, OperationUserInteractionInterface.OK_CHOICE_SET);
                    }
                }
                catch (WsAppServerCodeException e) {
                    this.displayAppServerLog(objectStore, applicationServer, e);
                }
                catch (Exception e) {
                    oui.displayMessage(RB.getStringResource("CubeError.window.title"), e.getLocalizedMessage(), 2, OperationUserInteractionInterface.OK_CHOICE_SET);
                }
                finally {
                    this.cleanup(objectStore, applicationServer, map);
                    Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (RemoteException e) {
                throw new LogicalTypeException((Exception)e);
            }
            catch (IllegalArgumentException e) {
                oui.displayMessage(RB.getStringResource("CubeError.window.title"), e.getLocalizedMessage(), 2, OperationUserInteractionInterface.OK_CHOICE_SET);
            }
            catch (ServiceException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
            finally {
                try {
                    if (objectStore != null && !objectStore.isDisposed()) {
                        objectStore.dispose();
                    }
                }
                catch (RemoteException re) {
                    throw new LogicalTypeException((Exception)re);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameCubeNotPhyiscallyExist(String cubeName, OperationUserInteractionInterface oui, MdObjectStore objectStore, com.sas.metadata.remote.Cube jomaCube, String currentName, ClassifierMap loadMap, Job jomaJob, boolean renameJob) throws RemoteException {
        try {
            jomaCube.setName(cubeName);
            if (loadMap != null) {
                if (jomaJob != null && renameJob) {
                    jomaJob.setName(cubeName);
                }
                Property connection = null;
                AssociationList loadMapProperties = loadMap.getProperties(true);
                for (int i = loadMapProperties.size() - 1; i >= 0; --i) {
                    connection = (Property)loadMapProperties.get(i);
                    if (connection.getPropertyName().equalsIgnoreCase("OLAPCubeConnection")) continue;
                    connection = null;
                }
                OLAPSchema schema = jomaCube.getAssociatedOLAPSchema();
                if (connection != null) {
                    String schemaName = BLANK_STRING;
                    if (schema == null) {
                        String defaultValue = connection.getDefaultValue();
                        int index = defaultValue.indexOf("/") + 1;
                        schemaName = defaultValue.substring(index);
                    } else {
                        schemaName = schema.getName();
                    }
                    StringBuffer name = new StringBuffer();
                    name.append(cubeName).append("/").append(schemaName);
                    connection.setDefaultValue(name.toString());
                }
            }
            Property cubeFolder = null;
            AssociationList cubeProperties = jomaCube.getProperties(true);
            for (int i = cubeProperties.size() - 1; i >= 0; --i) {
                cubeFolder = (Property)cubeProperties.get(i);
                if (cubeFolder.getPropertyName().equalsIgnoreCase(CUBEFOLDER)) continue;
                cubeFolder = null;
            }
            if (cubeFolder != null) {
                cubeFolder.setDefaultValue(cubeName);
            }
            AssociationList files = jomaCube.getAssociatedFiles(true);
            File file = null;
            if (files.size() > 0) {
                file = (File)files.elementAt(0);
            }
            file.setName(cubeName + UNDERSCORE_FILE);
            file.setFileName(cubeName);
            TransformationStep transformationStep = (TransformationStep)loadMap.getSteps(true).get(0);
            transformationStep.setName(cubeName);
            TransformationActivity transformationActivity = (TransformationActivity)transformationStep.getActivities(true).get(0);
            if (transformationActivity.getName().equalsIgnoreCase(currentName)) {
                transformationActivity.setName(cubeName);
            }
            jomaCube.touch();
            jomaJob.touch();
            jomaCube.updateMetadataAll();
        }
        catch (MdException mdError) {
            oui.displayMessage(RB.getStringResource("CubeError.window.title"), mdError.getLocalizedMessage(), 2, OperationUserInteractionInterface.OK_CHOICE_SET);
        }
        catch (RemoteException re) {
            oui.displayMessage(RB.getStringResource("CubeError.window.title"), re.getLocalizedMessage(), 2, OperationUserInteractionInterface.OK_CHOICE_SET);
        }
        finally {
            objectStore.dispose();
        }
    }

    public int getPort(DeployedComponent server) throws MdException, RemoteException {
        AssociationList listOfSourceConnections;
        int portNumber = 0;
        if (server != null && !(listOfSourceConnections = server.getSourceConnections(true)).isEmpty()) {
            TCPIPConnection sourceConnection = (TCPIPConnection)listOfSourceConnections.get(0);
            portNumber = sourceConnection.getPort();
        }
        return portNumber;
    }

    private String getReconnectionString() {
        WorkspaceFile m_appDefaultsFile;
        StringBuffer code = new StringBuffer();
        Workspace workspace = Workspace.getWorkspace();
        if (workspace != null && (m_appDefaultsFile = Workspace.getWorkspace().getAppDefaultsFile()) != null) {
            String retries = m_appDefaultsFile.getPropertyString(MAX_RETRY_ATTEMPT_KEY, "3");
            code.append(this.newline).append(MAX_RETRIES).append(retries);
            String max = m_appDefaultsFile.getPropertyString(MAX_RETRY_SECONDS_KEY, "60");
            code.append(this.newline).append(MAX_RETRY_WAIT).append(max);
            String min = m_appDefaultsFile.getPropertyString(MIN_RETRY_SECONDS_KEY, "30");
            code.append(this.newline).append(MIN_RETRY_WAIT).append(min);
        }
        return code.toString();
    }

    private void cleanup(MdObjectStore inObjectStore, WsAppServer inApplication, Map refreshMap) throws LogicalTypeException {
        try {
            if (inObjectStore != null) {
                inObjectStore.dispose();
            }
            inObjectStore = null;
            if (inApplication != null) {
                inApplication.closeSASCodeSession();
            }
            inApplication = null;
            if (refreshMap != null) {
                boolean deletedObjects = refreshMap.containsKey("deletemap");
                boolean renamedObjects = refreshMap.containsKey("renamemap");
                refreshMap.remove("deletemap");
                refreshMap.remove("renamemap");
                if (deletedObjects) {
                    Workspace.getMdFactory().getOMIUtil().deleteMetadataObjects(refreshMap);
                    Workspace.getMdFactory().fireMdObjectsDeleted(new MdFactoryEvent(Workspace.getMdFactory().getInstance(), refreshMap));
                }
                if (renamedObjects) {
                    MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                    Workspace.getMdFactory().fireMdObjectsModified(new MdFactoryEvent(factory, refreshMap));
                }
            }
        }
        catch (RemoteException e) {
            throw new LogicalTypeException((Exception)e);
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
    }

    private static boolean getPermissions(String permission, CMetadata inputCube) throws LogicalTypeException {
        boolean hasAllPermissions = true;
        StringBuffer resource = new StringBuffer();
        resource.append("OMSOBJ:Cube/");
        ArrayList<String> hierNames = new ArrayList<String>();
        ArrayList<String> levNames = new ArrayList<String>();
        try {
            resource.append(inputCube.getFQID());
            com.sas.metadata.remote.Cube cube = (com.sas.metadata.remote.Cube)inputCube;
            AssociationList dims = cube.getDimensions();
            for (int i = 0; i < dims.size(); ++i) {
                com.sas.metadata.remote.Dimension dim = (com.sas.metadata.remote.Dimension)dims.get(i);
                if (!(dim instanceof SharedDimension)) continue;
                AssociationList hiers = dim.getHierarchies();
                for (int hierNum = 0; hierNum < hiers.size(); ++hierNum) {
                    Hierarchy hier = (Hierarchy)hiers.get(hierNum);
                    hierNames.add(hier.getName());
                }
                AssociationList levels = dim.getLevels();
                for (int levNum = 0; levNum < levels.size(); ++levNum) {
                    Level lev = (Level)levels.get(levNum);
                    levNames.add(lev.getName());
                }
            }
        }
        catch (RemoteException e) {
            throw new LogicalTypeException((Exception)e);
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        VariableArray2dOfStringHolder returnAuths = new VariableArray2dOfStringHolder();
        IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
        try {
            ISecurity_1_1 security = Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle);
            security.GetAuthorizations("Cube", BLANK_STRING, resource.toString(), permission, returnAuths);
            String[][] auths = returnAuths.value;
            for (int i = auths.length - 1; i >= 0 && hasAllPermissions; --i) {
                String[] cubeObject = auths[i];
                String subObjectType = cubeObject[0];
                String name = cubeObject[1];
                String authorization = cubeObject[2];
                if (permission.equalsIgnoreCase(WRITE_METADATA) && (subObjectType.equalsIgnoreCase("SharedDimension") || subObjectType.equalsIgnoreCase("Level") && levNames.contains(name) || subObjectType.equalsIgnoreCase("Hierarchy") && hierNames.contains(name))) continue;
                hasAllPermissions = authorization.equalsIgnoreCase("Y");
            }
        }
        catch (Exception error) {
            hasAllPermissions = false;
        }
        return hasAllPermissions;
    }
}

