/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.localsvc;

import com.sas.batch.localsvc.LocalServicesDeployment;
import com.sas.batch.localsvc.RB;
import com.sas.services.ServiceException;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.deployment.Environment;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.security.ConnectionProfile;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import java.rmi.RemoteException;

public class LocalServicesDeploymentDelegate
implements LocalServicesDeployment {
    private InformationServiceInterface informationService;
    private UserContextInterface userContext;
    private SessionContextInterface sessionContext;

    public void deployPlatformServices(ConnectionProfile connectionProfile) throws ServiceException, RemoteException {
        this.deployPlatformServices(connectionProfile, null);
    }

    public void deployPlatformServices(ConnectionProfile connectionProfile, String applicationName) throws ServiceException, RemoteException {
        CorePlatformServices.setEnvironment((Environment)connectionProfile.getEnvironment());
        CorePlatformServices.setDefaultServicesConfigurationWithMinimumLogging();
        CorePlatformServices.startLocalServices();
        this.informationService = CorePlatformServices.getInformationService();
        if (this.informationService != null) {
            this.informationService.setIsolated();
        }
        UserServiceInterface userService = CorePlatformServices.getUserService();
        userService.setGroupLoginEnabled(true);
        this.userContext = null;
        try {
            String userName = connectionProfile.getProperty("userid");
            if (userName == null || userName.length() == 0) {
                this.userContext = userService.newUser(null, applicationName);
            } else {
                String domain = connectionProfile.getDomain();
                this.userContext = userService.newUser(connectionProfile.getProperty("userid"), connectionProfile.getProperty("password"), domain, null, applicationName);
            }
        }
        catch (UserInitializationException e) {
            this.userContext = e.getUser();
        }
        if (this.userContext == null) {
            throw new ServiceException(RB.getStringResource("LocalServicesBatchUtility.InitError.NoUser.txt"));
        }
        this.sessionContext = CorePlatformServices.getSessionService().newSessionContext(this.userContext);
    }

    public void terminate() throws ServiceException, RemoteException {
        if (this.sessionContext != null) {
            try {
                UserServiceInterface userService = CorePlatformServices.getUserService();
                if (userService != null) {
                    userService.removeUser(this.sessionContext.getUserContext());
                }
                this.sessionContext.destroy();
            }
            finally {
                this.sessionContext = null;
                this.userContext = null;
                this.informationService = null;
            }
        }
        CorePlatformServices.terminateServices();
    }

    @Override
    public InformationServiceInterface getInformationService() {
        return this.informationService;
    }

    @Override
    public UserContextInterface getUserContext() {
        return this.userContext;
    }

    @Override
    public SessionContextInterface getSessionContext() {
        return this.sessionContext;
    }
}

